/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.clientinitiated.paging;

import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.ws.rs.core.UriInfo;
import org.eclipse.persistence.jpa.rs.features.FeatureRequestValidatorImpl;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;

public class PagingRequestValidator
extends FeatureRequestValidatorImpl {
    private String offset = null;
    private String limit = null;
    public static String DB_QUERY = "dbQuery";
    public static String QUERY = "query";

    @Override
    public boolean isRequestValid(UriInfo uri, Map<String, Object> additionalParams) {
        block10: {
            block11: {
                int intLimit;
                int intOffset;
                ReadQuery dbQuery;
                block12: {
                    Query query = null;
                    dbQuery = null;
                    if (additionalParams != null && !additionalParams.isEmpty()) {
                        dbQuery = (ReadQuery)additionalParams.get(DB_QUERY);
                        query = (Query)additionalParams.get(QUERY);
                        if (dbQuery != null && query != null && (dbQuery instanceof ObjectLevelReadQuery || dbQuery instanceof ReadAllQuery)) {
                            List orderBy = null;
                            if (dbQuery instanceof ReadAllQuery) {
                                orderBy = ((ReadAllQuery)dbQuery).getOrderByExpressions();
                            } else if (dbQuery instanceof ObjectLevelReadQuery) {
                                orderBy = ((ObjectLevelReadQuery)dbQuery).getOrderByExpressions();
                            }
                            if (orderBy == null || orderBy.isEmpty()) {
                                JPARSLogger.warning("no_orderby_clause_for_paging", new Object[]{query.toString()});
                            }
                        }
                    }
                    Map<String, Object> queryParameters = this.getQueryParameters(uri);
                    String paramLimit = (String)queryParameters.get("limit");
                    String paramOffset = (String)queryParameters.get("offset");
                    if (paramLimit == null && paramOffset == null) {
                        return false;
                    }
                    this.offset = paramOffset != null ? paramOffset : Integer.toString(0);
                    this.limit = paramLimit != null ? paramLimit : Integer.toString(20);
                    try {
                        if (this.offset == null || this.limit == null) break block10;
                        intOffset = Integer.parseInt(this.offset);
                        intLimit = Integer.parseInt(this.limit);
                        if (intOffset < 0 || intLimit <= 0) break block11;
                        if (query == null) break block12;
                        this.setOfsetAndLimit(query, intOffset, intLimit);
                        return true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (dbQuery == null) break block11;
                this.setOfsetAndLimit(dbQuery, intOffset, intLimit);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isRequested(UriInfo uri, Map<String, Object> additionalParams) {
        Map<String, Object> queryParameters = this.getQueryParameters(uri);
        String paramLimit = (String)queryParameters.get("limit");
        String paramOffset = (String)queryParameters.get("offset");
        return paramLimit != null || paramOffset != null;
    }

    private void setOfsetAndLimit(Query query, int offset, int limit) {
        query.setFirstResult(offset);
        query.setMaxResults(limit);
    }

    private void setOfsetAndLimit(ReadQuery query, int offset, int limit) {
        query.setFirstResult(offset);
        int maxRows = limit + (offset >= 0 ? offset : 0);
        query.setMaxRows(maxRows);
    }
}

