/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.features.core.selflinks;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkV2;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilderImpl;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.list.PageableCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReadAllQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultListItem;

public class SelfLinksResponseBuilder
extends FeatureResponseBuilderImpl {
    @Override
    public Object buildReadAllQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object> items, UriInfo uriInfo) {
        return this.response(context, items, uriInfo);
    }

    @Override
    public Object buildReportQueryResponse(PersistenceContext context, Map<String, Object> queryParams, List<Object[]> results, List<ReportItem> items, UriInfo uriInfo) {
        return this.populateReportQueryResultList(results, items, uriInfo);
    }

    @Override
    public Object buildAttributeResponse(PersistenceContext context, Map<String, Object> queryParams, String attribute, Object item, UriInfo uriInfo) {
        if (item instanceof Collection) {
            return this.response(context, (List)item, uriInfo);
        }
        return item;
    }

    @Override
    public Object buildSingleEntityResponse(PersistenceContext context, Map<String, Object> queryParams, Object result, UriInfo uriInfo) {
        if (result instanceof PersistenceWeavedRest) {
            ItemLinks itemLinks = new ItemLinks();
            ClassDescriptor descriptor = context.getJAXBDescriptorForClass(result.getClass());
            PersistenceWeavedRest entity = (PersistenceWeavedRest)result;
            String href = context.getBaseURI() + context.getVersion() + "/" + context.getName() + "/entity/" + descriptor.getAlias() + "/" + IdHelper.stringifyId(result, descriptor.getAlias(), context);
            itemLinks.addItem(new LinkV2("self", href));
            entity._persistence_setLinks(itemLinks);
        }
        return result;
    }

    private Object response(PersistenceContext context, List<Object> results, UriInfo uriInfo) {
        if (results != null && !results.isEmpty()) {
            return this.populateReadAllQueryResultList(context, results, uriInfo);
        }
        return results;
    }

    private PageableCollection populateReportQueryResultList(List<Object[]> results, List<ReportItem> reportItems, UriInfo uriInfo) {
        ReportQueryResultCollection response = new ReportQueryResultCollection();
        for (Object[] result : results) {
            ReportQueryResultListItem queryResultListItem = new ReportQueryResultListItem();
            List<JAXBElement> jaxbFields = this.createShellJAXBElementList(reportItems, result);
            if (jaxbFields == null) {
                return null;
            }
            queryResultListItem.setFields(jaxbFields);
            response.addItem(queryResultListItem);
        }
        response.addLink(new LinkV2("self", uriInfo.getRequestUri().toString()));
        return response;
    }

    private PageableCollection populateReadAllQueryResultList(PersistenceContext context, List<Object> items, UriInfo uriInfo) {
        ReadAllQueryResultCollection response = new ReadAllQueryResultCollection();
        for (Object item : items) {
            response.addItem(this.populateReadAllQueryResultListItemLinks(context, item));
        }
        response.addLink(new LinkV2("self", uriInfo.getRequestUri().toString()));
        return response;
    }

    private Object populateReadAllQueryResultListItemLinks(PersistenceContext context, Object result) {
        ItemLinks itemLinks = new ItemLinks();
        ClassDescriptor descriptor = context.getJAXBDescriptorForClass(result.getClass());
        if (result instanceof PersistenceWeavedRest && descriptor != null && context != null) {
            PersistenceWeavedRest entity = (PersistenceWeavedRest)result;
            String entityId = IdHelper.stringifyId(result, descriptor.getAlias(), context);
            String href = context.getBaseURI() + context.getVersion() + "/" + context.getName() + "/entity/" + descriptor.getAlias() + "/" + entityId;
            itemLinks.addItem(new LinkV2("self", href));
            entity._persistence_setLinks(itemLinks);
            return entity;
        }
        return result;
    }
}

