/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.FeatureRequestValidator;
import org.eclipse.persistence.jpa.rs.features.FeatureResponseBuilder;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.features.clientinitiated.paging.PagingRequestValidator;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;

public abstract class AbstractQueryResource
extends AbstractResource {
    private static final String CLASS_NAME = AbstractQueryResource.class.getName();

    protected Response namedQueryUpdateInternal(String version, String persistenceUnit, String queryName, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "namedQueryUpdateInternal", new Object[]{"POST", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        try {
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            int result = context.queryExecuteUpdate(AbstractQueryResource.getMatrixParameters(uriInfo, persistenceUnit), queryName, AbstractQueryResource.getMatrixParameters(uriInfo, queryName), AbstractQueryResource.getQueryParameters(uriInfo));
            JAXBElement jaxbElement = new JAXBElement(new QName("result"), Integer.class, (Object)result);
            return Response.ok((Object)new StreamingOutputMarshaller(context, (Object)jaxbElement, headers.getAcceptableMediaTypes())).build();
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    protected Response namedQueryInternal(String version, String persistenceUnit, String queryName, HttpHeaders headers, UriInfo uriInfo) {
        JPARSLogger.entering(CLASS_NAME, "namedQueryInternal", new Object[]{"GET", version, persistenceUnit, queryName, uriInfo.getRequestUri().toASCIIString()});
        try {
            FeatureRequestValidator requestValidator;
            PersistenceContext context = this.getPersistenceContext(persistenceUnit, null, uriInfo.getBaseUri(), version, null);
            Query query = context.buildQuery(AbstractQueryResource.getMatrixParameters(uriInfo, persistenceUnit), queryName, AbstractQueryResource.getMatrixParameters(uriInfo, queryName), AbstractQueryResource.getQueryParameters(uriInfo));
            DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
            FeatureSet featureSet = context.getSupportedFeatureSet();
            if (featureSet.isSupported(FeatureSet.Feature.PAGING) && (requestValidator = featureSet.getRequestValidator(FeatureSet.Feature.PAGING)).isRequested(uriInfo, null)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(PagingRequestValidator.DB_QUERY, dbQuery);
                map.put(PagingRequestValidator.QUERY, query);
                if (!requestValidator.isRequestValid(uriInfo, map)) {
                    throw JPARSException.invalidPagingRequest();
                }
                return this.namedQueryResponse(context, queryName, dbQuery, query, headers, uriInfo, featureSet.getResponseBuilder(FeatureSet.Feature.PAGING));
            }
            return this.namedQueryResponse(context, queryName, dbQuery, query, headers, uriInfo, featureSet.getResponseBuilder(FeatureSet.Feature.NO_PAGING));
        }
        catch (Exception ex) {
            throw JPARSException.exceptionOccurred(ex);
        }
    }

    private Response namedQueryResponse(PersistenceContext context, String queryName, DatabaseQuery dbQuery, Query query, HttpHeaders headers, UriInfo uriInfo, FeatureResponseBuilder responseBuilder) {
        Map<String, Object> queryParams = AbstractQueryResource.getQueryParameters(uriInfo);
        if (dbQuery instanceof ReportQuery) {
            List reportItems = ((ReportQuery)dbQuery).getItems();
            List queryResults = query.getResultList();
            if (queryResults != null && !queryResults.isEmpty()) {
                Object list = responseBuilder.buildReportQueryResponse(context, queryParams, queryResults, reportItems, uriInfo);
                if (list != null) {
                    return Response.ok((Object)new StreamingOutputMarshaller(context, list, headers.getAcceptableMediaTypes())).build();
                }
                throw JPARSException.responseCouldNotBeBuiltForNamedQueryRequest(queryName, context.getName());
            }
            return Response.ok((Object)new StreamingOutputMarshaller(context, (Object)queryResults, headers.getAcceptableMediaTypes())).build();
        }
        List results = query.getResultList();
        if (results != null && !results.isEmpty()) {
            Object list = responseBuilder.buildReadAllQueryResponse(context, queryParams, results, uriInfo);
            return Response.ok((Object)new StreamingOutputMarshaller(context, list, headers.getAcceptableMediaTypes())).build();
        }
        return Response.ok((Object)new StreamingOutputMarshaller(context, (Object)results, headers.getAcceptableMediaTypes())).build();
    }
}

