/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.MultiActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectAllAction;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingMessages;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackagesProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackageViewerWrapper;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewFlatContentProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewHierarchicalContentProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewTableViewer;
import org.eclipse.wst.jsdt.internal.ui.browsing.PackagesViewTreeViewer;
import org.eclipse.wst.jsdt.internal.ui.filters.NonJavaElementFilter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.LibraryFilter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ResourceToItemsMapper;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class PackagesView
extends JavaBrowsingPart {
    private static final String TAG_VIEW_STATE = ".viewState";
    private static final int LIST_VIEW_STATE = 0;
    private static final int TREE_VIEW_STATE = 1;
    private SelectAllAction fSelectAllAction;
    private int fCurrViewState;
    private PackageViewerWrapper fWrappedViewer;
    private MultiActionGroup fSwitchActionGroup;
    private boolean fLastInputWasProject;

    @Override
    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)this.createNonJavaElementFilter());
        this.getViewer().addFilter((ViewerFilter)new LibraryFilter());
    }

    protected NonJavaElementFilter createNonJavaElementFilter() {
        return new NonJavaElementFilter(){

            @Override
            public boolean select(Viewer viewer, Object parent, Object element) {
                return element instanceof IJavaScriptElement || element instanceof LogicalPackage || element instanceof IFolder;
            }
        };
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fWrappedViewer = new PackageViewerWrapper();
        this.restoreLayoutState(memento);
    }

    private void restoreLayoutState(IMemento memento) {
        if (memento == null) {
            IPreferenceStore store = JavaScriptPlugin.getDefault().getPreferenceStore();
            this.fCurrViewState = store.getInt(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE);
        } else {
            Integer integer = memento.getInteger(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE);
            this.fCurrViewState = integer == null || !this.isValidState(integer) ? 0 : integer;
        }
    }

    private boolean isValidState(int state) {
        return state == 0 || state == 1;
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE, this.fCurrViewState);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        ResourceToItemsMapper.IContentViewerAccessor viewer = this.isInListState() ? this.createTableViewer(parent) : this.createTreeViewer(parent);
        this.fWrappedViewer.setViewer((StructuredViewer)viewer);
        return this.fWrappedViewer;
    }

    @Override
    public Object getAdapter(Class key) {
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    protected boolean isInListState() {
        return this.fCurrViewState == 0;
    }

    private ProblemTableViewer createTableViewer(Composite parent) {
        return new PackagesViewTableViewer(parent, 2);
    }

    private ProblemTreeViewer createTreeViewer(Composite parent) {
        return new PackagesViewTreeViewer(parent, 2);
    }

    @Override
    protected IContentProvider createContentProvider() {
        if (this.isInListState()) {
            return new PackagesViewFlatContentProvider(this.fWrappedViewer.getViewer());
        }
        return new PackagesViewHierarchicalContentProvider(this.fWrappedViewer.getViewer());
    }

    @Override
    protected JavaUILabelProvider createLabelProvider() {
        if (this.isInListState()) {
            return this.createListLabelProvider();
        }
        return this.createTreeLabelProvider();
    }

    private JavaUILabelProvider createTreeLabelProvider() {
        return new PackagesViewLabelProvider(0);
    }

    private JavaUILabelProvider createListLabelProvider() {
        return new PackagesViewLabelProvider(1);
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.packages_browsing_view_context";
    }

    @Override
    protected String getLinkToEditorKey() {
        return "org.eclipse.wst.jsdt.ui.browsing.packagestoeditor";
    }

    @Override
    protected boolean isValidInput(Object element) {
        if (element instanceof IJavaScriptProject || element instanceof IPackageFragmentRoot && ((IJavaScriptElement)element).getElementName() != "") {
            try {
                IJavaScriptProject jProject = ((IJavaScriptElement)element).getJavaScriptProject();
                if (jProject != null) {
                    return jProject.getProject().hasNature("org.eclipse.wst.jsdt.core.jsNature");
                }
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected boolean isValidElement(Object element) {
        IJavaScriptElement parent;
        if (element instanceof IPackageFragment && (parent = ((IPackageFragment)element).getParent()) != null) {
            return super.isValidElement(parent) || super.isValidElement(parent.getJavaScriptProject());
        }
        return false;
    }

    @Override
    protected IJavaScriptElement findElementToSelect(IJavaScriptElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 4: {
                return je;
            }
            case 5: {
                return ((IJavaScriptUnit)je).getParent();
            }
            case 6: {
                return ((IClassFile)je).getParent();
            }
            case 7: {
                return ((IType)je).getPackageFragment();
            }
        }
        return this.findElementToSelect(je.getParent());
    }

    @Override
    protected void setInput(Object input) {
        this.setViewerWrapperInput(input);
        super.updateTitle();
    }

    private void setViewerWrapperInput(Object input) {
        this.fWrappedViewer.setViewerInput(input);
    }

    @Override
    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.fSwitchActionGroup.fillActionBars(actionBars);
    }

    private void setUpViewer(StructuredViewer viewer) {
        Assert.isTrue((viewer != null ? 1 : 0) != 0);
        JavaUILabelProvider labelProvider = this.createLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.createDecoratingLabelProvider(labelProvider));
        viewer.setComparator((ViewerComparator)this.createJavaElementComparator());
        viewer.setUseHashlookup(true);
        this.createContextMenu();
        this.addKeyListener();
        this.hookViewerListeners();
        viewer.setContentProvider(this.createContentProvider());
        this.initDragAndDrop();
    }

    @Override
    protected JavaScriptElementComparator createJavaElementComparator() {
        return new JavaScriptElementComparator(){

            @Override
            public int category(Object element) {
                if (element instanceof LogicalPackage) {
                    LogicalPackage cp = (LogicalPackage)((Object)element);
                    return super.category(cp.getFragments()[0]);
                }
                return super.category(element);
            }

            @Override
            public int compare(Viewer viewer, Object e1, Object e2) {
                LogicalPackage cp;
                if (e1 instanceof LogicalPackage) {
                    cp = (LogicalPackage)((Object)e1);
                    e1 = cp.getFragments()[0];
                }
                if (e2 instanceof LogicalPackage) {
                    cp = (LogicalPackage)((Object)e2);
                    e2 = cp.getFragments()[0];
                }
                return super.compare(viewer, e1, e2);
            }
        };
    }

    @Override
    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager slManager) {
        return new StatusBarUpdater4LogicalPackage(slManager);
    }

    protected void setSiteSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.fWrappedViewer);
    }

    @Override
    void adjustInputAndSetSelection(Object o) {
        if (!(o instanceof LogicalPackage)) {
            super.adjustInputAndSetSelection(o);
            return;
        }
        LogicalPackage lp = (LogicalPackage)((Object)o);
        if (!lp.getJavaProject().equals(this.getInput())) {
            this.setInput(lp.getJavaProject());
        }
        this.setSelection((ISelection)new StructuredSelection((Object)lp), true);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.createSelectAllAction();
        this.fSwitchActionGroup = this.createSwitchActionGroup();
    }

    private MultiActionGroup createSwitchActionGroup() {
        LayoutAction switchToFlatViewAction = new LayoutAction(JavaBrowsingMessages.PackagesView_flatLayoutAction_label, 0);
        LayoutAction switchToHierarchicalViewAction = new LayoutAction(JavaBrowsingMessages.PackagesView_HierarchicalLayoutAction_label, 1);
        JavaPluginImages.setLocalImageDescriptors((IAction)switchToFlatViewAction, "flatLayout.gif");
        JavaPluginImages.setLocalImageDescriptors((IAction)switchToHierarchicalViewAction, "hierarchicalLayout.gif");
        return new LayoutActionGroup(new IAction[]{switchToFlatViewAction, switchToHierarchicalViewAction}, this.fCurrViewState);
    }

    private void switchViewer(int state) {
        if (this.fCurrViewState == state) {
            return;
        }
        this.fCurrViewState = state;
        IPreferenceStore store = JavaScriptPlugin.getDefault().getPreferenceStore();
        store.setValue(String.valueOf(this.getViewSite().getId()) + TAG_VIEW_STATE, state);
        StructuredViewer viewer = this.fWrappedViewer.getViewer();
        Object object = viewer.getInput();
        ISelection selection = viewer.getSelection();
        Control control = this.createViewer(this.fWrappedViewer.getControl().getParent()).getControl();
        this.setUpViewer(this.fWrappedViewer);
        this.createSelectAllAction();
        this.fWrappedViewer.setViewerInput(object);
        this.fWrappedViewer.getControl().setFocus();
        this.fWrappedViewer.setSelection(selection, true);
        viewer.getContentProvider().dispose();
        viewer.getControl().dispose();
        if (control != null && !control.isDisposed()) {
            control.setVisible(true);
            control.getParent().layout(true);
        }
    }

    private void createSelectAllAction() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (this.isInListState()) {
            this.fSelectAllAction = new SelectAllAction((TableViewer)this.fWrappedViewer.getViewer());
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        } else {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
            this.fSelectAllAction = null;
        }
        actionBars.updateActionBars();
    }

    @Override
    protected IJavaScriptElement findInputForJavaElement(IJavaScriptElement je) {
        if (je == null) {
            return null;
        }
        if (je.getElementType() == 3 || je.getElementType() == 2) {
            return this.findInputForJavaElement(je, true);
        }
        return this.findInputForJavaElement(je, false);
    }

    protected IJavaScriptElement findInputForJavaElement(IJavaScriptElement je, boolean canChangeInputType) {
        IPackageFragmentRoot packageFragmentRoot;
        if (je == null || !je.exists()) {
            return null;
        }
        if (this.isValidInput(je)) {
            if (canChangeInputType) {
                this.fLastInputWasProject = je.getElementType() == 2;
            }
            return je;
        }
        if (this.fLastInputWasProject && !(packageFragmentRoot = (IPackageFragmentRoot)je.getAncestor(3)).isExternal()) {
            return je.getJavaScriptProject();
        }
        return this.findInputForJavaElement(je.getParent(), canChangeInputType);
    }

    @Override
    protected DecoratingJavaLabelProvider createDecoratingLabelProvider(JavaUILabelProvider provider) {
        return new DecoratingJavaLabelProvider(provider, false, this.isInListState()){

            public String getText(Object element) {
                if (element instanceof LogicalPackage) {
                    LogicalPackage el = (LogicalPackage)((Object)element);
                    return super.getText((Object)el.getFragments()[0]);
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof LogicalPackage) {
                    LogicalPackage el = (LogicalPackage)((Object)element);
                    ILabelDecorator decorator = this.getLabelDecorator();
                    IPackageFragment[] fragments = el.getFragments();
                    Image image = super.getImage((Object)el);
                    int i = 0;
                    while (i < fragments.length) {
                        IPackageFragment fragment = fragments[i];
                        Image decoratedImage = decorator.decorateImage(image, (Object)fragment);
                        if (decoratedImage != null) {
                            image = decoratedImage;
                        }
                        ++i;
                    }
                    return image;
                }
                return super.getImage(element);
            }
        };
    }

    void adjustInputAndSetSelection(IJavaScriptElement je) {
        IPackageFragment pkgFragment;
        IJavaScriptElement jElementToSelect = this.findElementToSelect(je);
        LogicalPackagesProvider p = (LogicalPackagesProvider)this.fWrappedViewer.getContentProvider();
        Object elementToSelect = jElementToSelect;
        if (jElementToSelect != null && jElementToSelect.getElementType() == 4 && (elementToSelect = p.findLogicalPackage(pkgFragment = (IPackageFragment)jElementToSelect)) == null) {
            elementToSelect = pkgFragment;
        }
        IJavaScriptElement newInput = this.findInputForJavaElement(je);
        if (elementToSelect == null && !this.isValidInput(newInput)) {
            this.setInput(null);
        } else if (elementToSelect == null || this.getViewer().testFindItem(elementToSelect) == null) {
            IPackageFragment pkgFragment2;
            Object input = this.getViewer().getInput();
            if (elementToSelect != null && newInput != null) {
                if (newInput.equals(input)) {
                    this.getViewer().reveal(elementToSelect);
                } else {
                    this.setInput(newInput);
                    this.getViewer().reveal(elementToSelect);
                }
            } else {
                this.setInput(newInput);
            }
            if (elementToSelect instanceof IPackageFragment && (elementToSelect = p.findLogicalPackage(pkgFragment2 = (IPackageFragment)elementToSelect)) == null) {
                elementToSelect = pkgFragment2;
            }
        }
        StructuredSelection selection = elementToSelect != null ? new StructuredSelection(elementToSelect) : StructuredSelection.EMPTY;
        this.setSelection((ISelection)selection, true);
    }

    private class LayoutAction
    extends Action {
        private int fState;

        public LayoutAction(String text, int state) {
            super(text, 8);
            this.fState = state;
            if (state == 0) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.layout_flat_action");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.layout_hierarchical_action");
            }
        }

        public int getState() {
            return this.fState;
        }

        public void setRunnable(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
        }

        public void run() {
            PackagesView.this.switchViewer(this.fState);
        }
    }

    private static class LayoutActionGroup
    extends MultiActionGroup {
        LayoutActionGroup(IAction[] actions, int index) {
            super(actions, index);
        }

        public void fillActionBars(IActionBars actionBars) {
            IMenuManager manager = actionBars.getMenuManager();
            GroupMarker groupMarker = new GroupMarker("layout");
            manager.add((IContributionItem)groupMarker);
            MenuManager newManager = new MenuManager(JavaBrowsingMessages.PackagesView_LayoutActionGroup_layout_label);
            manager.appendToGroup("layout", (IContributionItem)newManager);
            super.addActions((IMenuManager)newManager);
        }
    }

    private static class StatusBarUpdater4LogicalPackage
    extends StatusBarUpdater {
        private StatusBarUpdater4LogicalPackage(IStatusLineManager statusLineManager) {
            super(statusLineManager);
        }

        @Override
        protected String formatMessage(ISelection sel) {
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)sel;
                int nElements = selection.size();
                Object elem = selection.getFirstElement();
                if (nElements == 1 && elem instanceof LogicalPackage) {
                    return this.formatLogicalPackageMessage((LogicalPackage)((Object)elem));
                }
            }
            return super.formatMessage(sel);
        }

        private String formatLogicalPackageMessage(LogicalPackage logicalPackage) {
            IPackageFragment[] fragments = logicalPackage.getFragments();
            StringBuffer buf = new StringBuffer(logicalPackage.getElementName());
            buf.append(JavaScriptElementLabels.CONCAT_STRING);
            String message = "";
            boolean firstTime = true;
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                IJavaScriptElement element = fragment.getParent();
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                    String label = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)root, JavaScriptElementLabels.DEFAULT_QUALIFIED | 0x20000000000L);
                    if (firstTime) {
                        buf.append(label);
                        firstTime = false;
                    } else {
                        message = Messages.format(JavaBrowsingMessages.StatusBar_concat, new String[]{message, label});
                    }
                }
                ++i;
            }
            buf.append(message);
            return buf.toString();
        }
    }
}

