/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.xsl.internal.debug.ui.AbstractTableBlock;
import org.eclipse.wst.xsl.internal.debug.ui.XSLDebugUIPlugin;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.Messages;
import org.eclipse.wst.xsl.jaxp.debug.ui.internal.tabs.processor.OutputPropertyDialog;
import org.eclipse.wst.xsl.jaxp.launching.IOutputProperty;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;
import org.eclipse.wst.xsl.jaxp.launching.LaunchProperties;

public class OutputPropertiesBlock
extends AbstractTableBlock {
    private Table table;
    private TableViewer tViewer;
    private LaunchProperties properties;
    private Button removeButton;
    private Map<String, IOutputProperty> propertyUris = new HashMap<String, IOutputProperty>();

    public OutputPropertiesBlock() {
        IProcessorType[] iProcessorTypeArray = JAXPRuntime.getProcessorTypes();
        int n = iProcessorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorType type = iProcessorTypeArray[n2];
            IOutputProperty[] iOutputPropertyArray = type.getOutputProperties();
            int n3 = iOutputPropertyArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IOutputProperty property = iOutputPropertyArray[n4];
                this.propertyUris.put(property.getURI(), property);
                ++n4;
            }
            ++n2;
        }
    }

    protected IDialogSettings getDialogSettings() {
        return XSLDebugUIPlugin.getDefault().getDialogSettings();
    }

    protected String getQualifier() {
        return "org.eclipse.wst.xsl.jaxp.debug.ui." + ((Object)((Object)this)).getClass().getCanonicalName();
    }

    protected Table getTable() {
        return this.table;
    }

    public void createControl(Composite parent) {
        TabItem item = new TabItem((TabFolder)parent, 0);
        item.setText(Messages.getString("OutputPropertiesBlock_0"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        item.setControl((Control)composite);
        this.table = new Table(composite, 68098);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    OutputPropertiesBlock.this.performRemove();
                }
            }
        });
        TableColumn tc1 = new TableColumn(this.table, 0);
        tc1.setText(Messages.getString("OutputPropertiesBlock_1"));
        tc1.setWidth(350);
        tc1.setResizable(true);
        TableColumn tc2 = new TableColumn(this.table, 0);
        tc2.setText(Messages.getString("OutputPropertiesBlock_2"));
        tc2.setWidth(50);
        tc2.setResizable(true);
        Composite buttonComp = new Composite(composite, 4);
        buttonComp.setLayoutData((Object)new GridData(4, 128, false, false));
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        buttonComp.setLayout((Layout)gl);
        Button addButton = new Button(buttonComp, 8);
        addButton.setText(Messages.getString("OutputPropertiesBlock_3"));
        addButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OutputPropertyDialog dialog = new OutputPropertyDialog(OutputPropertiesBlock.this.getShell(), OutputPropertiesBlock.this.properties);
                if (dialog.open() == 0) {
                    List<IOutputProperty> newProperties = dialog.getOutpuProperties();
                    String first = null;
                    for (IOutputProperty property : newProperties) {
                        String att = property.getURI();
                        if (first == null) {
                            first = att;
                        }
                        OutputPropertiesBlock.this.properties.setProperty(property.getURI(), null);
                    }
                    if (newProperties.size() > 0) {
                        OutputPropertiesBlock.this.tViewer.refresh();
                        OutputPropertiesBlock.this.tViewer.setSelection((ISelection)new StructuredSelection((Object)first), true);
                        OutputPropertiesBlock.this.tViewer.editElement((Object)first, 1);
                        OutputPropertiesBlock.this.updateLaunchConfigurationDialog();
                    }
                }
            }
        });
        this.removeButton = new Button(buttonComp, 8);
        this.removeButton.setText(Messages.getString("OutputPropertiesBlock_4"));
        this.removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OutputPropertiesBlock.this.performRemove();
            }
        });
        this.setControl((Control)this.table);
        this.tViewer = new TableViewer(this.table);
        this.tViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return OutputPropertiesBlock.this.properties.getProperties().keySet().toArray(new String[0]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tViewer.setSorter(new ViewerSorter());
        this.tViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OutputPropertiesBlock.this.updateRemoveButton();
            }
        });
        TableViewerColumn tvc1 = new TableViewerColumn(this.tViewer, tc1);
        tvc1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String tv = (String)cell.getElement();
                cell.setText(tv);
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }

            public String getToolTipText(Object element) {
                String tv = (String)element;
                return ((IOutputProperty)OutputPropertiesBlock.this.propertyUris.get(tv)).getDescription();
            }
        });
        TableViewerColumn tvc2 = new TableViewerColumn(this.tViewer, tc2);
        tvc2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                String tv = (String)cell.getElement();
                String val = OutputPropertiesBlock.this.properties.getProperty(tv);
                cell.setText(val == null ? "" : val);
            }
        });
        tvc2.setEditingSupport(new EditingSupport((ColumnViewer)this.tViewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)OutputPropertiesBlock.this.table);
            }

            protected Object getValue(Object element) {
                String tv = (String)element;
                String val = OutputPropertiesBlock.this.properties.getProperty(tv);
                return val == null ? "" : val;
            }

            protected void setValue(Object element, Object value) {
                String tv = (String)element;
                OutputPropertiesBlock.this.properties.setProperty(tv, (String)value);
                OutputPropertiesBlock.this.updateLaunchConfigurationDialog();
                OutputPropertiesBlock.this.tViewer.update((Object)tv, null);
            }
        });
        this.restoreColumnSettings();
    }

    protected void updateRemoveButton() {
        this.removeButton.setEnabled(!this.tViewer.getSelection().isEmpty());
    }

    public String getName() {
        return Messages.getString("AttributesBlock.16");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void initializePropertiesFromStorage(ILaunchConfiguration configuration) throws CoreException {
        String s = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_OUTPUT_PROPERTIES", null);
        this.properties = s != null && s.length() > 0 ? LaunchProperties.fromXML((InputStream)new ByteArrayInputStream(s.getBytes())) : new LaunchProperties();
        this.tViewer.setInput((Object)this.properties);
        this.updateRemoveButton();
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.initializePropertiesFromStorage(configuration);
        }
        catch (CoreException e) {
            XSLDebugUIPlugin.log((CoreException)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String xml = this.properties.toXML();
            configuration.setAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_OUTPUT_PROPERTIES", xml);
        }
        catch (ParserConfigurationException e) {
            XSLDebugUIPlugin.log((Exception)e);
        }
        catch (IOException e) {
            XSLDebugUIPlugin.log((Exception)e);
        }
        catch (TransformerException e) {
            XSLDebugUIPlugin.log((Exception)e);
        }
    }

    private void performRemove() {
        IStructuredSelection sel = (IStructuredSelection)this.tViewer.getSelection();
        for (String att : sel) {
            this.properties.removeProperty(att);
        }
        this.tViewer.refresh();
        this.updateLaunchConfigurationDialog();
    }
}

