/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class ProposalInfoTest_Edited
extends TestCase {
    private static final String TEST_NAME = "Test Edited JavaScript Content Assist Proposal Info";
    private static TestProjectSetup fTestProjectSetup;

    public ProposalInfoTest_Edited() {
        super(TEST_NAME);
    }

    public ProposalInfoTest_Edited(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(ProposalInfoTest_Edited.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false){

            @Override
            public void additionalSetUp() throws Exception {
                ProposalInfoTest_Edited.editFile_TestProposalInfo_0();
            }
        };
        return fTestProjectSetup;
    }

    public void testProposalInfo_OtherFile_AfterEdit_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello Earth", "NC"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 0, 0, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_OtherFile_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City)  - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello Earth", "Wake"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 2, 3, expectedProposals, expectedInfo);
    }

    public void _testProposalInfo_OtherFile_AfterEdit_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"nodeOne : String - Global"}};
        String[][] expectedInfo = new String[][]{{"nodeOne = Edit"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_1.js", 4, 3, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_ThisFile_AfterEdit_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello Earth", "NC"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_0.js", 0, 0, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_ThisFile_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello Earth", "NC"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_0.js", 15, 3, expectedProposals, expectedInfo);
    }

    public void _testProposalInfo_ThisFile_AfterEdit_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"nodeOne : String - Global"}};
        String[][] expectedInfo = new String[][]{{"nodeOne = Edit"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "TestProposalInfo_0.js", 22, 3, expectedProposals, expectedInfo);
    }

    private static void editFile_TestProposalInfo_0() throws Exception {
        fTestProjectSetup.editFile("TestProposalInfo_0.js", 1, 9, 5, "Earth");
        fTestProjectSetup.editFile("TestProposalInfo_0.js", 8, 10, 5, "NC");
        fTestProjectSetup.editFile("TestProposalInfo_0.js", 18, 13, 4, "Edit");
    }
}

