/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import org.eclipse.wst.jsdt.core.tests.compiler.parser.SourceField;
import org.eclipse.wst.jsdt.core.tests.compiler.parser.SourceMethod;

public final class SourceUnit {
    private int modifiers;
    private int declarationStart;
    private int declarationEnd;
    private char[] fileName;
    private char[] name;
    private int nameSourceStart;
    private int nameSourceEnd;
    private char[] superclassName;
    private SourceMethod[] methods;
    private int numberOfMethods;
    private SourceField[] fields;
    private int numberOfFields;
    private char[] source;
    SourceUnit parent;
    private char[] qualifiedName;
    private String defaultConstructor;

    protected void addField(SourceField sourceField) {
        if (this.fields == null) {
            this.fields = new SourceField[4];
        }
        if (this.numberOfFields == this.fields.length) {
            this.fields = new SourceField[this.numberOfFields * 2];
            System.arraycopy(this.fields, 0, this.fields, 0, this.numberOfFields);
        }
        this.fields[this.numberOfFields++] = sourceField;
    }

    protected void addMethod(SourceMethod sourceMethod) {
        if (this.methods == null) {
            this.methods = new SourceMethod[4];
        }
        if (this.numberOfMethods == this.methods.length) {
            this.methods = new SourceMethod[this.numberOfMethods * 2];
            System.arraycopy(this.methods, 0, this.methods, 0, this.numberOfMethods);
        }
        this.methods[this.numberOfMethods++] = sourceMethod;
    }

    public String displayModifiers() {
        StringBuffer buffer = new StringBuffer();
        if (this.modifiers == 0) {
            return null;
        }
        if ((this.modifiers & 1) != 0) {
            buffer.append("public ");
        }
        if ((this.modifiers & 4) != 0) {
            buffer.append("protected ");
        }
        if ((this.modifiers & 2) != 0) {
            buffer.append("private ");
        }
        if ((this.modifiers & 0x10) != 0) {
            buffer.append("final ");
        }
        if ((this.modifiers & 8) != 0) {
            buffer.append("static ");
        }
        if ((this.modifiers & 0x400) != 0) {
            buffer.append("abstract ");
        }
        if ((this.modifiers & 0x100) != 0) {
            buffer.append("native ");
        }
        return buffer.toString().trim();
    }

    public String getActualName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.source, this.nameSourceStart, this.nameSourceEnd - this.nameSourceStart + 1);
        return buffer.toString();
    }

    public int getDeclarationSourceEnd() {
        return this.declarationEnd;
    }

    public int getDeclarationSourceStart() {
        return this.declarationStart;
    }

    public SourceField[] getFields() {
        if (this.fields != null && this.fields.length != this.numberOfFields) {
            this.fields = new SourceField[this.numberOfFields];
            System.arraycopy(this.fields, 0, this.fields, 0, this.numberOfFields);
        }
        return this.fields;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public SourceMethod[] getMethods() {
        if (this.methods != null && this.methods.length != this.numberOfMethods) {
            this.methods = new SourceMethod[this.numberOfMethods];
            System.arraycopy(this.methods, 0, this.methods, 0, this.numberOfMethods);
        }
        return this.methods;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameSourceEnd() {
        return this.nameSourceEnd;
    }

    public int getNameSourceStart() {
        return this.nameSourceStart;
    }

    public char[] getQualifiedName() {
        if (this.qualifiedName == null) {
            StringBuffer temp = new StringBuffer();
            temp.append(this.name);
            this.qualifiedName = temp.toString().toCharArray();
        }
        return this.qualifiedName;
    }

    public char[] getSuperclassName() {
        return this.superclassName;
    }

    public boolean isBinaryType() {
        return false;
    }

    public boolean isClass() {
        return true;
    }

    public void setDeclarationSourceEnd(int position) {
        this.declarationEnd = position;
    }

    public void setDefaultConstructor(String s) {
        this.defaultConstructor = s;
    }

    public void setSuperclass(char[] superclassName) {
        this.superclassName = superclassName;
    }

    public String tabString(int tab) {
        String s = "";
        int i = tab;
        while (i > 0) {
            s = String.valueOf(s) + "\t";
            --i;
        }
        return s;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int tab) {
        int max;
        int i;
        StringBuffer buffer = new StringBuffer();
        if (this.fields != null) {
            i = 0;
            max = this.numberOfFields;
            while (i < max) {
                buffer.append(this.fields[i].toString(tab + 1)).append("\n");
                ++i;
            }
        }
        if (this.methods != null) {
            i = 0;
            max = this.numberOfMethods;
            while (i < max) {
                buffer.append(this.methods[i].toString(tab + 1)).append("\n");
                ++i;
            }
        }
        return buffer.toString();
    }
}

