/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestForClass;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestForConstructor;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestForField;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestForMethod;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestMixed;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.JavadocTestOptions;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.RegressionTestSetup;
import org.eclipse.wst.jsdt.core.tests.junit.extension.TestCase;
import org.eclipse.wst.jsdt.core.tests.util.Util;

public abstract class JavadocTest
extends AbstractRegressionTest {
    boolean useLibrary = false;
    static String ZIP_FILE = "/TestJavadocVisibility.zip";
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static ArrayList ALL_CLASSES = null;
    static final String DOC_COMMENT_SUPPORT = System.getProperty("doc.support");
    static boolean debug = false;
    protected static final String JAVADOC_NAME = File.pathSeparatorChar == ':' ? "javadoc" : "javadoc.exe";
    protected static String javadocCommandLineHeader;
    static String[] referencedClasses;

    static {
        ALL_CLASSES = new ArrayList();
        ALL_CLASSES.add(JavadocTestForMethod.class);
        ALL_CLASSES.add(JavadocTestMixed.class);
        ALL_CLASSES.add(JavadocTestForClass.class);
        ALL_CLASSES.add(JavadocTestForConstructor.class);
        ALL_CLASSES.add(JavadocTestForField.class);
        ALL_CLASSES.add(JavadocTestOptions.class);
        referencedClasses = null;
        referencedClasses = new String[]{"test/AbstractVisibility.java", "package test;\npublic abstract class AbstractVisibility {\n\tprivate class AvcPrivate {\n\t\tprivate int avf_private = 10;\n\t\tpublic int avf_public = avf_private;\n\t\tprivate int avm_private() {\n\t\t\tavf_private = (new AvcPrivate()).avf_private;\n\t\t\treturn avf_private;\n\t\t}\n\t\tpublic int avm_public() {\n\t\t\treturn avm_private();\n\t\t}\n\t}\n\tpublic class AvcPublic {\n\t\tprivate int avf_private = 10;\n\t\tpublic int avf_public = avf_private;\n\t\tprivate int avm_private() {\n\t\t\tavf_private = (new AvcPrivate()).avf_private;\n\t\t\treturn avf_private;\n\t\t}\n\t\tpublic int avm_public() {\n\t\t\treturn avm_private();\n\t\t}\n\t}\n\tprivate int avf_private = 100;\n\tpublic int avf_public = avf_private;\n\t\n\tprivate int avm_private() {\n\t\tavf_private = (new AvcPrivate()).avf_private;\n\t\treturn avf_private;\n\t}\n\tpublic int avm_public() {\n\t\treturn avm_private();\n\t}\n}\n", "test/Visibility.java", "package test;\npublic class Visibility extends AbstractVisibility {\n\tprivate class VcPrivate {\n\t\tprivate int vf_private = 10;\n\t\tpublic int vf_public = vf_private;\n\t\tprivate int vm_private() {\n\t\t\tvf_private = (new VcPrivate()).vf_private;\n\t\t\tavf_private = vf_private;\n\t\t\treturn vf_private+avf_private;\n\t\t}\n\t\tpublic int vm_public() {\n\t\t\treturn vm_private();\n\t\t}\n\t};\n\tpublic class VcPublic {\n\t\tprivate int vf_private = 10;\n\t\tpublic int vf_public = vf_private;\n\t\tprivate int vm_private() {\n\t\t\tvf_private = (new VcPrivate()).vf_private;\n\t\t\tavf_private = vf_private;\n\t\t\treturn vf_private+avf_private;\n\t\t}\n\t\tpublic int vm_public() {\n\t\t\treturn vm_private();\n\t\t}\n\t};\n\tprivate int vf_private = 100;\n\tprivate int avf_private = 100;\n\tpublic int vf_public = vf_private;\n\tpublic int avf_public = vf_private;\n\t\n\tprivate int vm_private() {\n\t\tvf_private = (new VcPrivate()).vf_private;\n\t\tavf_private = vf_private;\n\t\treturn vf_private+avf_private;\n\t}\n\tpublic int vm_public() {\n\t\treturn vm_private();\n\t}\n}\n", "test/copy/VisibilityPackage.java", "package test.copy;\nclass VisibilityPackage {\n\tprivate class VpPrivate {\n\t\tprivate int vf_private = 10;\n\t\tpublic int vf_public = vf_private;\n\t\tprivate int vm_private() {\n\t\t\tvf_private = (new VpPrivate()).vf_private;\n\t\t\treturn vf_private;\n\t\t}\n\t\tpublic int vm_public() {\n\t\t\treturn vm_private();\n\t\t}\n\t}\n\tpublic class VpPublic {\n\t\tprivate int vf_private = 10;\n\t\tpublic int vf_public = vf_private;\n\t\tprivate int vm_private() {\n\t\t\tvf_private = (new VpPrivate()).vf_private;\n\t\t\treturn vf_private;\n\t\t}\n\t\tpublic int vm_public() {\n\t\t\treturn vm_private();\n\t\t}\n\t}\n\tprivate int vf_private = 100;\n\tpublic int vf_public = vf_private;\n\t\n\tprivate int vm_private() {\n\t\tvf_private = (new VpPrivate()).vf_private;\n\t\treturn vf_private;\n\t}\n\tpublic int vm_public() {\n\t\treturn vm_private();\n\t}\n}\n", "test/copy/VisibilityPublic.java", "package test.copy;\npublic class VisibilityPublic {\n\tprivate class VpPrivate {\n\t\tprivate int vf_private = 10;\n\t\tpublic int vf_public = vf_private;\n\t\tprivate int vm_private() {\n\t\t\tvf_private = (new VpPrivate()).vf_private;\n\t\t\treturn vf_private;\n\t\t}\n\t\tpublic int vm_public() {\n\t\t\treturn vm_private();\n\t\t}\n\t}\n\tpublic class VpPublic {\n\t\tprivate int vf_private = 10;\n\t\tpublic int vf_public = vf_private;\n\t\tprivate int vm_private() {\n\t\t\tvf_private = (new VpPrivate()).vf_private;\n\t\t\treturn vf_private;\n\t\t}\n\t\tpublic int vm_public() {\n\t\t\treturn vm_private();\n\t\t}\n\t}\n\tprivate int vf_private = 100;\n\tpublic int vf_public = vf_private;\n\t\n\tprivate int vm_private() {\n\t\tvf_private = (new VpPrivate()).vf_private;\n\t\treturn vf_private;\n\t}\n\tpublic int vm_public() {\n\t\treturn vm_private();\n\t}\n}\n"};
    }

    public static void addTest(TestSuite suite, Class testClass) {
        TestSuite innerSuite = new TestSuite(testClass);
        suite.addTest((Test)innerSuite);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(JavadocTest.class.getName());
        TestCase.TESTS_PREFIX = null;
        TestCase.TESTS_NAMES = null;
        TestCase.TESTS_NUMBERS = null;
        TestCase.TESTS_RANGE = null;
        TestCase.RUN_ONLY_ID = null;
        int i = 0;
        int size = ALL_CLASSES.size();
        while (i < size) {
            Class testClass = (Class)ALL_CLASSES.get(i);
            Test suite = JavadocTest.buildAllCompliancesTestSuite(testClass);
            testSuite.addTest(suite);
            ++i;
        }
        return testSuite;
    }

    public static Test suiteForComplianceLevel(String level, Class testClass) {
        Test suite = JavadocTest.buildAllCompliancesTestSuite(testClass);
        return new RegressionTestSetup(suite, level);
    }

    public JavadocTest(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
        options.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "enabled");
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
        return options;
    }

    @Override
    protected String[] getDefaultClassPaths() {
        if (this.useLibrary) {
            String[] classLibs = super.getDefaultClassPaths();
            int length = classLibs.length;
            String[] newClassPaths = new String[length + 1];
            System.arraycopy(classLibs, 0, newClassPaths, 0, length);
            newClassPaths[length] = this.getClass().getResource(ZIP_FILE).getPath();
            return newClassPaths;
        }
        return super.getDefaultClassPaths();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (RUN_JAVAC) {
            javadocCommandLineHeader = jdkRootDirPath.append("bin").append(JAVADOC_NAME).toString();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void runConformReferenceTest(String[] testFiles) {
        String[] completedFiles = testFiles;
        if (!this.useLibrary) {
            completedFiles = new String[testFiles.length + referencedClasses.length];
            System.arraycopy(referencedClasses, 0, completedFiles, 0, referencedClasses.length);
            System.arraycopy(testFiles, 0, completedFiles, referencedClasses.length, testFiles.length);
        }
        this.runConformTest(completedFiles);
    }

    protected void runNegativeReferenceTest(String[] testFiles, String expected) {
        String[] completedFiles = testFiles;
        if (!this.useLibrary) {
            completedFiles = new String[testFiles.length + referencedClasses.length];
            System.arraycopy(referencedClasses, 0, completedFiles, 0, referencedClasses.length);
            System.arraycopy(testFiles, 0, completedFiles, referencedClasses.length, testFiles.length);
        }
        this.runNegativeTest(completedFiles, expected);
    }

    @Override
    protected void writeFiles(String[] testFiles) {
        String classDirName = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        String testName = this.getName();
        int idx = testName.indexOf(" - ");
        if (idx > 0) {
            testName = testName.substring(idx + 3);
        }
        this.createOutputTestDirectory(classDirName);
        this.createOutputTestDirectory(String.valueOf(Character.toUpperCase(testName.charAt(0))) + testName.substring(1));
        System.out.println("Write test file to " + this.outputTestDirectory.getPath() + "...");
        int i = 0;
        int length = testFiles.length;
        while (i < length) {
            String contents = testFiles[i + 1];
            String fileName = testFiles[i++];
            String dirFileName = this.outputTestDirectory.getPath();
            if (fileName.indexOf("Visibility") <= 0) {
                int index = fileName.lastIndexOf(47);
                if (index > 0) {
                    String subdirs = fileName.substring(0, index);
                    String packName = subdirs.replace('/', '.');
                    contents = "package " + packName + ";" + contents.substring(contents.indexOf(59) + 1);
                    File dir = new File(dirFileName, subdirs);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (RUN_JAVAC) {
                        Util.writeToFile(contents, String.valueOf(dirFileName) + "/" + fileName);
                    }
                    fileName = fileName.substring(index + 1);
                }
                Util.writeToFile(contents, String.valueOf(dirFileName) + "/" + fileName);
            }
            ++i;
        }
    }

    @Override
    protected void runJavac(String[] testFiles, String expectedProblemLog, String expectedSuccessOutputString, boolean shouldFlushOutputDirectory) {
        String testName = null;
        Process compileProcess = null;
        Process execProcess = null;
        try {
            try {
                testName = this.testName();
                File javacOutputDirectory = new File(JAVAC_OUTPUT_DIR);
                if (shouldFlushOutputDirectory) {
                    Util.delete(javacOutputDirectory);
                }
                this.writeFiles(testFiles);
                StringBuffer cmdLine = new StringBuffer(javadocCommandLineHeader);
                String[] classpath = Util.concatWithClassLibs(JAVAC_OUTPUT_DIR, false);
                StringBuffer cp = new StringBuffer(" -classpath ");
                int length = classpath.length;
                int i = 0;
                while (i < length) {
                    if (i > 0) {
                        cp.append(File.pathSeparatorChar);
                    }
                    if (classpath[i].indexOf(" ") != -1) {
                        cp.append("\"" + classpath[i] + "\"");
                    } else {
                        cp.append(classpath[i]);
                    }
                    ++i;
                }
                cmdLine.append(cp);
                i = 0;
                while (i < testFiles.length) {
                    cmdLine.append(' ');
                    cmdLine.append(testFiles[i]);
                    i += 2;
                }
                compileProcess = Runtime.getRuntime().exec(cmdLine.toString(), null, this.outputTestDirectory);
                AbstractRegressionTest.Logger errorLogger = new AbstractRegressionTest.Logger(compileProcess.getErrorStream(), "ERROR");
                AbstractRegressionTest.Logger outputLogger = new AbstractRegressionTest.Logger(compileProcess.getInputStream(), "OUTPUT");
                errorLogger.start();
                outputLogger.start();
                int exitValue = compileProcess.waitFor();
                errorLogger.join();
                outputLogger.join();
                if (!testName.equals(javacTestName)) {
                    javacTestName = testName;
                    javacTestErrorFlag = false;
                    javacFullLog.println("-----------------------------------------------------------------");
                    javacFullLog.println(String.valueOf(CURRENT_CLASS_NAME) + " " + testName);
                }
                if (exitValue != 0) {
                    javacTestErrorFlag = true;
                }
                if (errorLogger.buffer.length() > 0) {
                    javacFullLog.println("--- javac err: ---");
                    javacFullLog.println(errorLogger.buffer.toString());
                }
                if (outputLogger.buffer.length() > 0) {
                    javacFullLog.println("--- javac out: ---");
                    javacFullLog.println(outputLogger.buffer.toString());
                }
                if (expectedProblemLog == null || expectedProblemLog.length() == 0) {
                    if (exitValue != 0) {
                        System.out.println("----------------------------------------");
                        System.out.println(String.valueOf(testName) + " - Javadoc has found error(s) but Eclipse expects conform result:\n");
                        javacFullLog.println("JAVAC_MISMATCH: Javadoc has found error(s) but Eclipse expects conform result");
                        System.out.println(errorLogger.buffer.toString());
                        this.printFiles(testFiles);
                        DIFF_COUNTERS[0] = DIFF_COUNTERS[0] + 1;
                    } else if (errorLogger.buffer.length() > 0) {
                        System.out.println("----------------------------------------");
                        System.out.println(String.valueOf(testName) + " - Javadoc has found warning(s) but Eclipse expects conform result:\n");
                        javacFullLog.println("JAVAC_MISMATCH: Javadoc has found warning(s) but Eclipse expects conform result");
                        System.out.println(errorLogger.buffer.toString());
                        this.printFiles(testFiles);
                        DIFF_COUNTERS[0] = DIFF_COUNTERS[0] + 1;
                    }
                } else if (errorLogger.buffer.length() == 0) {
                    System.out.println("----------------------------------------");
                    System.out.println(String.valueOf(testName) + " - Eclipse has found error(s)/warning(s) but Javadoc did not find any:");
                    javacFullLog.println("JAVAC_MISMATCH: Eclipse has found error(s)/warning(s) but Javadoc did not find any");
                    this.dualPrintln("eclipse:");
                    this.dualPrintln(expectedProblemLog);
                    this.printFiles(testFiles);
                    DIFF_COUNTERS[1] = DIFF_COUNTERS[1] + 1;
                } else if (expectedProblemLog.indexOf("ERROR") > 0 && exitValue == 0) {
                    System.out.println("----------------------------------------");
                    System.out.println(String.valueOf(testName) + " - Eclipse has found error(s) but Javadoc only found warning(s):");
                    javacFullLog.println("JAVAC_MISMATCH: Eclipse has found error(s) but Javadoc only found warning(s)");
                    this.dualPrintln("eclipse:");
                    this.dualPrintln(expectedProblemLog);
                    System.out.println("javadoc:");
                    System.out.println(errorLogger.buffer.toString());
                    this.printFiles(testFiles);
                    DIFF_COUNTERS[1] = DIFF_COUNTERS[1] + 1;
                }
            }
            catch (InterruptedException e1) {
                if (compileProcess != null) {
                    compileProcess.destroy();
                }
                if (execProcess != null) {
                    execProcess.destroy();
                }
                System.out.println(String.valueOf(testName) + ": Sun javadoc compilation was aborted!");
                javacFullLog.println("JAVAC_WARNING: Sun javadoc compilation was aborted!");
                e1.printStackTrace(javacFullLog);
                Util.delete(this.outputTestDirectory);
            }
            catch (Throwable e) {
                System.out.println(String.valueOf(testName) + ": could not launch Sun javadoc compilation!");
                e.printStackTrace();
                javacFullLog.println("JAVAC_ERROR: could not launch Sun javac compilation!");
                e.printStackTrace(javacFullLog);
                Util.delete(this.outputTestDirectory);
            }
        }
        finally {
            Util.delete(this.outputTestDirectory);
        }
    }

    @Override
    protected void printJavacResultsSummary() {
        if (RUN_JAVAC) {
            Integer count = (Integer)TESTS_COUNTERS.get(CURRENT_CLASS_NAME);
            if (count != null) {
                int newCount = count - 1;
                TESTS_COUNTERS.put(CURRENT_CLASS_NAME, new Integer(newCount));
                if (newCount == 0) {
                    if (DIFF_COUNTERS[0] != 0 || DIFF_COUNTERS[1] != 0 || DIFF_COUNTERS[2] != 0) {
                        this.dualPrintln("===========================================================================");
                        this.dualPrintln("Results summary:");
                    }
                    if (DIFF_COUNTERS[0] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[0] + " test(s) where Javadoc found errors/warnings but Eclipse did not");
                    }
                    if (DIFF_COUNTERS[1] != 0) {
                        this.dualPrintln("\t- " + DIFF_COUNTERS[1] + " test(s) where Eclipse found errors/warnings but Javadoc did not");
                    }
                    System.out.println("\n");
                }
            }
            javacFullLog.flush();
        }
    }
}

