/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.util.ArrayList;
import java.util.Comparator;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.tests.model.DefaultJavaElementComparator;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.core.util.JavaScriptUnitSorter;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;

public class SortCompilationUnitElementsTests
extends ModifyingResourceTests {
    private static final boolean DEBUG = true;

    public SortCompilationUnitElementsTests(String name) {
        super(name);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.createJavaProject("P", new String[]{"src"}, new String[]{this.getSystemJsPathString()}, "bin", "1.5");
        this.createFolder("/P/src/p");
    }

    private void sortUnit(IJavaScriptUnit unit, String expectedResult) throws CoreException {
        this.sortUnit(2, unit, expectedResult, true);
    }

    private void sortUnit(int apiLevel, IJavaScriptUnit unit, String expectedResult) throws CoreException {
        this.sortUnit(apiLevel, unit, expectedResult, true);
    }

    private void sortUnit(IJavaScriptUnit unit, String expectedResult, boolean testPositions) throws CoreException {
        this.sortUnit(2, unit, expectedResult, testPositions);
    }

    private void sortUnit(int apiLevel, IJavaScriptUnit unit, String expectedResult, boolean testPositions) throws CoreException {
        this.sortUnit(apiLevel, unit, expectedResult, testPositions, new DefaultJavaElementComparator(1, 2, 3, 4, 5, 6, 7, 8, 9));
    }

    private void sortUnit(int apiLevel, IJavaScriptUnit unit, String expectedResult, boolean testPositions, Comparator comparator) throws CoreException {
        String initialSource = unit.getSource();
        int[] positions = null;
        int[] initialPositions = null;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (testPositions) {
            int i = 0;
            while (i < initialSource.length()) {
                if (!Character.isWhitespace(initialSource.charAt(i))) {
                    arrayList.add(new Integer(i));
                }
                ++i;
            }
            int length = arrayList.size();
            positions = new int[length];
            int i2 = 0;
            while (i2 < length) {
                positions[i2] = (Integer)arrayList.get(i2);
                ++i2;
            }
            initialPositions = new int[length];
            System.arraycopy(positions, 0, initialPositions, 0, length);
        }
        IJavaScriptUnit copy = unit.getWorkingCopy(null);
        JavaScriptUnitSorter.sort((int)apiLevel, (IJavaScriptUnit)copy, (int[])positions, (Comparator)comparator, (int)0, (IProgressMonitor)new NullProgressMonitor());
        String sortedSource = copy.getBuffer().getContents();
        SortCompilationUnitElementsTests.assertEquals((String)"Different output", (String)expectedResult, (String)sortedSource);
        int expectedResultLength = expectedResult.length();
        if (testPositions) {
            int i = 0;
            int max = positions.length;
            while (i < max) {
                char mappedChar = ' ';
                char initial = initialSource.charAt(initialPositions[i]);
                try {
                    mappedChar = expectedResult.charAt(positions[i]);
                    if (mappedChar != initial) {
                        System.out.println("wrong mapped positions: " + initialPositions[i] + " <-> " + positions[i] + ": expected " + initial + " but was " + mappedChar);
                        SortCompilationUnitElementsTests.assertEquals((String)("wrong mapped positions: " + initialPositions[i] + " <-> " + positions[i]), (char)initial, (char)mappedChar);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    System.out.println("Out of bounds : (length = " + expectedResultLength + ") " + positions[i]);
                }
                ++i;
            }
        }
    }

    void debug(IJavaScriptUnit unit, String id) throws JavaScriptModelException {
        String source = unit.getBuffer().getContents();
        System.out.println("========================== " + id + " ==============================");
        System.out.println(source);
        System.out.println("========================== " + id + " ==============================");
    }

    public static Test suite() {
        return SortCompilationUnitElementsTests.buildModelTestSuite(SortCompilationUnitElementsTests.class);
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    public void test001() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "/**\n *\n */\npackage p;\npublic class X {\n\tstatic class D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tstatic int i, j = 3, /*     */ k = 4;\n\tvoid bar(int i) {\n\t}\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tvoid bar7() {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t\tvoid bar2() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar6() {}\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t}\n\t}\n\tObject b1 = null, a1 = new Object() {\n\t\tvoid bar2() {\n\t\t}\n\t\tvoid bar() {\n\t\t}\n\t\tvoid bar4() {\n\t\t\tSystem.out.println();\n\t\t}\n\t\tvoid bar3() {\n\t\t}\n\t}, c1 = null;\n}\n");
            String expectedResult = "/**\n *\n */\npackage p;\npublic class X {\n\tstatic class D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tstatic int i, j = 3, /*     */ k = 4;\n\tObject b1 = null, a1 = new Object() {\n\t\tvoid bar() {\n\t\t}\n\t\tvoid bar2() {\n\t\t}\n\t\tvoid bar3() {\n\t\t}\n\t\tvoid bar4() {\n\t\t\tSystem.out.println();\n\t\t}\n\t}, c1 = null;\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tvoid bar2() {}\n\t\t\tvoid bar7() {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar6() {}\n\t\t}\n\t}\n\tvoid bar(int i) {\n\t}\n}\n";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test002() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n\t\n\tclass D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tint i, j, k;\n\tObject bar() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {    };\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar6() {}\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t}\n\t\treturn new C();\n\t}\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {        };\n\t\tSystem.out.println(o);\n\t\treturn o;\n\t}\n\tObject a1 = new Object() { }, o1 = null;\n}");
            String expectedSource = "package p;\npublic class X {\n\t\n\tclass D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tObject a1 = new Object() { }, o1 = null;\n\tint i, j, k;\n\tObject bar() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {    };\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar6() {}\n\t\t}\n\t\treturn new C();\n\t}\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {        };\n\t\tSystem.out.println(o);\n\t\treturn o;\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedSource);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test003() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "/**\n *\n */\npackage p;\npublic class X extends java.lang.Object implements java.util.Cloneable {\n\tclass D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tint i, j = 3, /*     */ k = 4;\n\tvoid bar(final int i[]) {\n\t}\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tvoid bar7() {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t\tvoid bar2() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar6() {}\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t}\n\t}\n\tObject b1[] = null, a1 = new Object() {\n\t\tvoid bar2(int[] j) {\n\t\t}\n\t\tvoid bar() {\n\t\t}\n\t\tvoid bar4() {\n\t\t\tSystem.out.println();\n\t\t}\n\t\tvoid bar3() {\n\t\t}\n\t}, c1 = null;\n}\n");
            String expectedResult = "/**\n *\n */\npackage p;\npublic class X extends java.lang.Object implements java.util.Cloneable {\n\tclass D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tObject b1[] = null, a1 = new Object() {\n\t\tvoid bar() {\n\t\t}\n\t\tvoid bar2(int[] j) {\n\t\t}\n\t\tvoid bar3() {\n\t\t}\n\t\tvoid bar4() {\n\t\t\tSystem.out.println();\n\t\t}\n\t}, c1 = null;\n\tint i, j = 3, /*     */ k = 4;\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tvoid bar2() {}\n\t\t\tvoid bar7() {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar6() {}\n\t\t}\n\t}\n\tvoid bar(final int i[]) {\n\t}\n}\n";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test004() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "/**\n *\n */\npackage p;\npublic class X extends java.lang.Object implements java.util.Cloneable {\n\t\n\tclass D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tvoid bar(final int i[]) {\n\t}\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tObject bar7() {\n\t\t\t\treturn new Object() {\n\t\t\t\t\tvoid bar9() {}\n\t\t\t\t\tvoid bar2() {}\n\t\t\t\t};\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t\tvoid bar2() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar6() {}\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t}\n\t}\n\n}\n");
            String expectedResult = "/**\n *\n */\npackage p;\npublic class X extends java.lang.Object implements java.util.Cloneable {\n\t\n\tclass D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tvoid bar2() {}\n\t\t\tObject bar7() {\n\t\t\t\treturn new Object() {\n\t\t\t\t\tvoid bar2() {}\n\t\t\t\t\tvoid bar9() {}\n\t\t\t\t};\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar6() {}\n\t\t}\n\t}\n\tvoid bar(final int i[]) {\n\t}\n\n}\n";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test005() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {        };\n\t\tSystem.out.println(o);\n\t\treturn o;\n\t}\n}");
            String expectedResult = "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {        };\n\t\tSystem.out.println(o);\n\t\treturn o;\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test006() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\treturn new Object() {\n\t\t\tpublic void bar6() {}\n\t\t\tvoid bar4() throws IOException, Exception, NullPointerException {}\n\t\t\tvoid bar5() {}\n       };\n\t}\n}");
            String expectedResult = "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\treturn new Object() {\n\t\t\tvoid bar4() throws IOException, Exception, NullPointerException {}\n\t\t\tvoid bar5() {}\n\t\t\tpublic void bar6() {}\n       };\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test007() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\treturn new Object() {\n\t\t\tpublic static void bar6() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar4() throws IOException, Exception, NullPointerException {}\n       };\n\t}\n}");
            String expectedResult = "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\treturn new Object() {\n\t\t\tpublic static void bar6() {}\n\t\t\tvoid bar4() throws IOException, Exception, NullPointerException {}\n\t\t\tvoid bar5() {}\n       };\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test008() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\treturn new Object() {\n\t\t\tpublic static void bar6() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar4() throws IOException, Exception, NullPointerException {}\n       };\n\t}\n}");
            String expectedResult = "package p;\npublic class X {\n\tObject bar3() {\n\t\tSystem.out.println();\n\t\treturn new Object() {\n\t\t\tpublic static void bar6() {}\n\t\t\tvoid bar4() throws IOException, Exception, NullPointerException {}\n\t\t\tvoid bar5() {}\n       };\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test009() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "/**\n *\n */\npackage p;\npublic class X {\n\t\n\tstatic class D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tstatic int i, j = 3, /*     */ k = 4;\n\tvoid bar(int i) {\n\t}\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tvoid bar7() {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t\tvoid bar2() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar6() {}\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t}\n\t}\n\n\tObject b1 = null, a1 = new Object() {\n\t\tvoid bar2() {\n\t\t}\n\t\tvoid bar() {\n\t\t}\n\t\tvoid bar4() {\n\t\t\tSystem.out.println();\n\t\t}\n\t\tvoid bar3() {\n\t\t}\n\t}, c1 = null;\n}\n");
            String expectedResult = "/**\n *\n */\npackage p;\npublic class X {\n\t\n\tstatic class D {\n\t\tString toString() {\n\t\t\treturn \"HELLO\";\n\t\t}\n\t}\n\tstatic int i, j = 3, /*     */ k = 4;\n\tObject b1 = null, a1 = new Object() {\n\t\tvoid bar() {\n\t\t}\n\t\tvoid bar2() {\n\t\t}\n\t\tvoid bar3() {\n\t\t}\n\t\tvoid bar4() {\n\t\t\tSystem.out.println();\n\t\t}\n\t}, c1 = null;\n\tvoid bar() {\n\t\t\n\n\t\tclass E {\n\t\t\tvoid bar2() {}\n\t\t\tvoid bar7() {\n\t\t\t\tSystem.out.println();\n\t\t\t}\n\t\t\tvoid bar9() {}\n\t\t}\n\t\tObject o = new E();\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar6() {}\n\t\t}\n\t}\n\n\tvoid bar(int i) {\n\t}\n}\n";
            IJavaScriptUnit unit = this.getCompilationUnit("/P/src/p/X.js");
            this.sortUnit(unit, expectedResult, false);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test010() throws CoreException {
        try {
            this.createFile("/P/src/SuperReference.js", "public class SuperReference extends ThisReference {\r\npublic SuperReference(int sourceStart, int sourceEnd) {\r\n\tsuper(sourceStart, sourceEnd);\r\n}\r\npublic static ExplicitConstructorCall implicitSuperConstructorCall() {\r\n\treturn new ExplicitConstructorCall(ExplicitConstructorCall.ImplicitSuper);\r\n}\r\npublic boolean isImplicitThis() {\r\n\t\r\n\treturn false;\r\n}\r\npublic boolean isSuper() {\r\n\t\r\n\treturn true;\r\n}\r\npublic boolean isThis() {\r\n\t\r\n\treturn false ;\r\n}\r\npublic TypeBinding resolveType(BlockScope scope) {\r\n\tconstant = NotAConstant;\r\n\tif (!checkAccess(scope.methodScope()))\r\n\t\treturn null;\r\n\tSourceTypeBinding enclosingTb = scope.enclosingSourceType();\r\n\tif (scope.isJavaLangObject(enclosingTb)) {\r\n\t\tscope.problemReporter().cannotUseSuperInJavaLangObject(this);\r\n\t\treturn null;\r\n\t}\r\n\treturn this.resolvedType = enclosingTb.superclass;\r\n}\r\npublic String toStringExpression(){\r\n\r\n\treturn \"super\"; //$NON-NLS-1$\r\n\t\r\n}\r\npublic void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {\r\n\tvisitor.visit(this, blockScope);\r\n\tvisitor.endVisit(this, blockScope);\r\n}\r\n}");
            String expectedResult = "public class SuperReference extends ThisReference {\r\npublic static ExplicitConstructorCall implicitSuperConstructorCall() {\r\n\treturn new ExplicitConstructorCall(ExplicitConstructorCall.ImplicitSuper);\r\n}\r\npublic SuperReference(int sourceStart, int sourceEnd) {\r\n\tsuper(sourceStart, sourceEnd);\r\n}\r\npublic boolean isImplicitThis() {\r\n\t\r\n\treturn false;\r\n}\r\npublic boolean isSuper() {\r\n\t\r\n\treturn true;\r\n}\r\npublic boolean isThis() {\r\n\t\r\n\treturn false ;\r\n}\r\npublic TypeBinding resolveType(BlockScope scope) {\r\n\tconstant = NotAConstant;\r\n\tif (!checkAccess(scope.methodScope()))\r\n\t\treturn null;\r\n\tSourceTypeBinding enclosingTb = scope.enclosingSourceType();\r\n\tif (scope.isJavaLangObject(enclosingTb)) {\r\n\t\tscope.problemReporter().cannotUseSuperInJavaLangObject(this);\r\n\t\treturn null;\r\n\t}\r\n\treturn this.resolvedType = enclosingTb.superclass;\r\n}\r\npublic String toStringExpression(){\r\n\r\n\treturn \"super\"; //$NON-NLS-1$\r\n\t\r\n}\r\npublic void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {\r\n\tvisitor.visit(this, blockScope);\r\n\tvisitor.endVisit(this, blockScope);\r\n}\r\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/SuperReference.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/SuperReference.js");
        }
    }

    public void test011() throws CoreException {
        try {
            this.createFile("/P/src/p/BaseTypes.js", "/*******************************************************************************\r\n * Copyright (c) 2000, 2001, 2002 International Business Machines Corp. and others.\r\n * All rights reserved. This program and the accompanying materials \r\n * are made available under the terms of the Common Public License v0.5 \r\n * which accompanies this distribution, and is available at\r\n * http://www.eclipse.org/legal/cpl-v05.html\r\n * \r\n * Contributors:\r\n *     IBM Corporation - initial API and implementation\r\n ******************************************************************************/\r\npackage p;\r\n\r\npublic interface BaseTypes {\r\n\tfinal BaseTypeBinding IntBinding = new BaseTypeBinding(TypeIds.T_int, \"int\".toCharArray(), new char[] {'I'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding ByteBinding = new BaseTypeBinding(TypeIds.T_byte, \"byte\".toCharArray(), new char[] {'B'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding ShortBinding = new BaseTypeBinding(TypeIds.T_short, \"short\".toCharArray(), new char[] {'S'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding CharBinding = new BaseTypeBinding(TypeIds.T_char, \"char\".toCharArray(), new char[] {'C'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding LongBinding = new BaseTypeBinding(TypeIds.T_long, \"long\".toCharArray(), new char[] {'J'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding FloatBinding = new BaseTypeBinding(TypeIds.T_float, \"float\".toCharArray(), new char[] {'F'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding DoubleBinding = new BaseTypeBinding(TypeIds.T_double, \"double\".toCharArray(), new char[] {'D'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding BooleanBinding = new BaseTypeBinding(TypeIds.T_boolean, \"boolean\".toCharArray(), new char[] {'Z'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding NullBinding = new BaseTypeBinding(TypeIds.T_null, \"null\".toCharArray(), new char[] {'N'}); //N stands for null even if it is never internally used //$NON-NLS-1$\r\n\tfinal BaseTypeBinding VoidBinding = new BaseTypeBinding(TypeIds.T_void, \"void\".toCharArray(), new char[] {'V'}); //$NON-NLS-1$\r\n}\r\n");
            String expectedResult = "/*******************************************************************************\r\n * Copyright (c) 2000, 2001, 2002 International Business Machines Corp. and others.\r\n * All rights reserved. This program and the accompanying materials \r\n * are made available under the terms of the Common Public License v0.5 \r\n * which accompanies this distribution, and is available at\r\n * http://www.eclipse.org/legal/cpl-v05.html\r\n * \r\n * Contributors:\r\n *     IBM Corporation - initial API and implementation\r\n ******************************************************************************/\r\npackage p;\r\n\r\npublic interface BaseTypes {\r\n\tfinal BaseTypeBinding BooleanBinding = new BaseTypeBinding(TypeIds.T_boolean, \"boolean\".toCharArray(), new char[] {'Z'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding ByteBinding = new BaseTypeBinding(TypeIds.T_byte, \"byte\".toCharArray(), new char[] {'B'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding CharBinding = new BaseTypeBinding(TypeIds.T_char, \"char\".toCharArray(), new char[] {'C'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding DoubleBinding = new BaseTypeBinding(TypeIds.T_double, \"double\".toCharArray(), new char[] {'D'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding FloatBinding = new BaseTypeBinding(TypeIds.T_float, \"float\".toCharArray(), new char[] {'F'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding IntBinding = new BaseTypeBinding(TypeIds.T_int, \"int\".toCharArray(), new char[] {'I'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding LongBinding = new BaseTypeBinding(TypeIds.T_long, \"long\".toCharArray(), new char[] {'J'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding NullBinding = new BaseTypeBinding(TypeIds.T_null, \"null\".toCharArray(), new char[] {'N'}); //N stands for null even if it is never internally used //$NON-NLS-1$\r\n\tfinal BaseTypeBinding ShortBinding = new BaseTypeBinding(TypeIds.T_short, \"short\".toCharArray(), new char[] {'S'}); //$NON-NLS-1$\r\n\tfinal BaseTypeBinding VoidBinding = new BaseTypeBinding(TypeIds.T_void, \"void\".toCharArray(), new char[] {'V'}); //$NON-NLS-1$\r\n}\r\n";
            this.sortUnit(this.getCompilationUnit("/P/src/p/BaseTypes.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/p/BaseTypes.js");
        }
    }

    public void test012() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n\t\n\tObject bar3() {\n\t\treturn null;\n\t}\n\tbar() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {    };\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar6() {}\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t}\n\t\treturn new C();\n\t}\n}");
            String expectedSource = "package p;\npublic class X {\n\t\n\tObject bar3() {\n\t\treturn null;\n\t}\n\tbar() {\n\t\tSystem.out.println();\n\t\tObject o = new Object() {    };\n\t\tSystem.out.println(o);\n\t\tclass C {\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar6() {}\n\t\t}\n\t\treturn new C();\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedSource);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test013() throws CoreException {
        try {
            this.createFile("/P/src/p/X.js", "package p;\npublic class X {\n\tX bar() {\n\t\t// comment\n\t\treturn new X() {\n\t\t\tvoid bar6() {}\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t};\n\t}\n}");
            String expectedSource = "package p;\npublic class X {\n\tX bar() {\n\t\t// comment\n\t\treturn new X() {\n\t\t\tvoid bar4() {}\n\t\t\tvoid bar5() {}\n\t\t\tvoid bar6() {}\n\t\t};\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/p/X.js"), expectedSource);
        }
        finally {
            this.deleteFile("/P/src/p/X.js");
        }
    }

    public void test014() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int j;\n  \n  // start of static field declaration\n  static int i; // end of static field declaration\n}");
            String expectedResult = "public class X {\n  // start of static field declaration\n  static int i; // end of static field declaration\n  \n  int j;\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test015() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n  int j;\n  \n  /** some Java doc */\n  \n  // start of static field declaration\n  static int i; // end of static field declaration\n}");
            String expectedResult = "public class X {\n  /** some Java doc */\n  \n  // start of static field declaration\n  static int i; // end of static field declaration\n  \n  int j;\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test016() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n   \n   public void c() {\n      \n   }\n   \n   public void b() {\n      \n   }\n   \n   public void a() {\n      class E {\n         // this is the line that breaks the Sort Members.\n         // comment this fix the problem.\n         int x, y;\n      }\n      \n      \n      new Object() {\n         // it breaks in an anonymous class also.\n         // comment this fix the problem.\n         int x, y;\n      }; \n      \n      \n      class D {\n         // this appears to break also.\n      }\n   }\n   \n   private class F {\n      // but this works fine\n      int x, y;\n   }\n}");
            String expectedResult = "public class X {\n   \n   private class F {\n      // but this works fine\n      int x, y;\n   }\n   \n   public void a() {\n      class E {\n         // this is the line that breaks the Sort Members.\n         // comment this fix the problem.\n         int x, y;\n      }\n      \n      \n      new Object() {\n         // it breaks in an anonymous class also.\n         // comment this fix the problem.\n         int x, y;\n      }; \n      \n      \n      class D {\n         // this appears to break also.\n      }\n   }\n   \n   public void b() {\n      \n   }\n   \n   public void c() {\n      \n   }\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test017() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n   \n   public void c() {\n      \n   }\n   \n   public void b() {\n      \n   }\n   \n   public void a() {\n      class E {\n         // this is the line that breaks the Sort Members.\n         // comment this fix the problem.\n         int x, y; // my comment\n      }\n      \n      \n      new Object() {\n         // it breaks in an anonymous class also.\n         // comment this fix the problem.\n         int x, y; // my comment\n      }; \n      \n      \n      class D {\n         // this appears to break also.\n      }\n   }\n   \n   private class F {\n      // but this works fine\n      int x, y;\n   }\n}");
            String expectedResult = "public class X {\n   \n   private class F {\n      // but this works fine\n      int x, y;\n   }\n   \n   public void a() {\n      class E {\n         // this is the line that breaks the Sort Members.\n         // comment this fix the problem.\n         int x, y; // my comment\n      }\n      \n      \n      new Object() {\n         // it breaks in an anonymous class also.\n         // comment this fix the problem.\n         int x, y; // my comment\n      }; \n      \n      \n      class D {\n         // this appears to break also.\n      }\n   }\n   \n   public void b() {\n      \n   }\n   \n   public void c() {\n      \n   }\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test018() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n   public void c() {\n   }\n   \n   public void b() {\n   }\n}");
            String expectedResult = "public class X {\n   public void b() {\n   }\n   \n   public void c() {\n   }\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test019() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public enum X {\n\tZ, A, C, B;\n}");
            String expectedResult = "public enum X {\n\tA, B, C, Z;\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test020() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public enum X {\n\tA , B, C;\n\t\n\tvoid foo() {\n\t\t\n\t}\n\t\n\tpublic Object field;\n}");
            String expectedResult = "public enum X {\n\tA , B, C;\n\t\n\tpublic Object field;\n\t\n\tvoid foo() {\n\t\t\n\t}\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test021() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n\n\tpublic enum Suit {\n\t\tSPADES, CLUBS, HEARTS, DIAMONDS\n\t}\n\n\tpublic enum Card {\n\t\tKING, QUEEN, JACK, ACE\n\t}\n\t\n\tprivate String string;\n\tprivate int integer;\n\t\n\tpublic void method1() { }\n\t\n\tpublic void method2() { }\n}");
            String expectedResult = "public class X {\n\n\tpublic enum Card {\n\t\tACE, JACK, KING, QUEEN\n\t}\n\n\tpublic enum Suit {\n\t\tCLUBS, DIAMONDS, HEARTS, SPADES\n\t}\n\t\n\tprivate int integer;\n\tprivate String string;\n\t\n\tpublic void method1() { }\n\t\n\tpublic void method2() { }\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test022() throws CoreException {
        try {
            this.createFile("/P/src/BuildUtilities.js", "/******************************************************************************* * Copyright (c) 2000, 2006 IBM Corporation and others. * All rights reserved. This program and the accompanying materials * are made available under the terms of the Eclipse Public License v1.0 * which accompanies this distribution, and is available at * http://www.eclipse.org/legal/epl-v10.html * * Contributors: *     IBM Corporation - initial API and implementation *******************************************************************************/import java.util.HashSet;\nimport org.eclipse.core.resources.ICommand;\nimport org.eclipse.core.resources.IProject;\nimport org.eclipse.core.resources.IProjectDescription;\nimport org.eclipse.core.resources.IResource;\nimport org.eclipse.core.resources.IncrementalProjectBuilder;\nimport org.eclipse.core.resources.ResourcesPlugin;\nimport org.eclipse.core.runtime.CoreException;\nimport org.eclipse.core.runtime.IAdaptable;\nimport org.eclipse.jface.viewers.ISelection;\nimport org.eclipse.jface.viewers.IStructuredSelection;\nimport org.eclipse.ui.IEditorInput;\nimport org.eclipse.ui.IEditorPart;\nimport org.eclipse.ui.IFileEditorInput;\nimport org.eclipse.ui.IWorkbenchPart;\nimport org.eclipse.ui.IWorkbenchWindow;\n\n/**\n * This class contains convenience methods used by the various build commands\n * to determine enablement.  These utilities cannot be factored into a common\n * class because some build actions are API and some are not.\n * \n * @since 3.1\n */\npublic class BuildUtilities {\n\t/**\n\t * Extracts the selected projects from a selection.\n\t * \n\t * @param selection The selection to analyze\n\t * @return The selected projects\n\t */\n\tpublic static IProject[] extractProjects(Object[] selection) {\n\t\tHashSet projects = new HashSet();\n\t\tfor (int i = 0; i < selection.length; i++) {\n\t\t\tif (selection[i] instanceof IResource) {\n\t\t\t\tprojects.add(((IResource) selection[i]).getProject());\n\t\t\t} else if (selection[i] instanceof IAdaptable) {\n\t\t\t\tIAdaptable adaptable = (IAdaptable) selection[i];\n\t\t\t\tIResource resource = (IResource) adaptable.getAdapter(IResource.class);\n\t\t\t\tif (resource != null)\n\t\t\t\t\tprojects.add(resource.getProject());\n\t\t\t}\n\t\t}\n\t\treturn (IProject[]) projects.toArray(new IProject[projects.size()]);\n\t}\n\n\t/**\n\t * Finds and returns the selected projects in the given window\n\t * \n\t * @param window The window to find the selection in\n\t * @return The selected projects, or an empty array if no selection could be found.\n\t */\n\tpublic static IProject[] findSelectedProjects(IWorkbenchWindow window) {\n\t\tif (window == null)\n\t\t\treturn new IProject[0];\n\t\tISelection selection = window.getSelectionService().getSelection();\n\t\tIProject[] selected = null;\n\t\tif (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {\n\t\t\tselected = extractProjects(((IStructuredSelection) selection).toArray());\n\t\t} else {\n\t\t\t//see if we can extract a selected project from the active editor\n\t\t\tIWorkbenchPart part = window.getPartService().getActivePart();\n\t\t\tif (part instanceof IEditorPart) {\n\t\t\t\tIEditorInput input = ((IEditorPart) part).getEditorInput();\n\t\t\t\tif (input instanceof IFileEditorInput)\n\t\t\t\t\tselected = new IProject[] {((IFileEditorInput) input).getFile().getProject()};\n\t\t\t}\n\t\t}\n\t\tif (selected == null)\n\t\t\tselected = new IProject[0];\n\t\treturn selected;\n\t}\n\n\t/**\n\t * Returns whether the workspace has a builder installed that responds\n\t * to the given trigger.\n\t */\n\tstatic boolean hasBuilder(int trigger) {\n\t\tIProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();\n\t\tboolean builderFound = false;\n\t\tfor (int i = 0; i < projects.length; i++) {\n\t\t\tif (!projects[i].isAccessible())\n\t\t\t\tcontinue;\n\t\t\ttry {\n\t\t\t\tIProjectDescription description = projects[i].getDescription();\n\t\t\t\tICommand[] buildSpec = description.getBuildSpec();\n\t\t\t\tfor (int j = 0; j < buildSpec.length; j++) {\n\t\t\t\t\tbuilderFound = true;\n\t\t\t\t\tif (!buildSpec[j].isBuilding(trigger))\n\t\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t} catch (CoreException e) {\n\t\t\t\t//ignore projects that are not available\n\t\t\t}\n\t\t}\n\t\t//enable building if there are any accessible projects with builders\n\t\treturn builderFound;\n\n\t}\n\n\t/**\n\t * Returns whether the selection of projects is being managed by autobuild.\n\t * \n\t * @param projects The projects to examine\n\t * @return <code>true</code> if the projects are being managed by\n\t * autobuild, and <code>false</code> otherwise.\n\t */\n\tpublic static boolean isAutoBuilding(IProject[] projects) {\n\t\tif (!ResourcesPlugin.getWorkspace().isAutoBuilding())\n\t\t\treturn false;\n\t\t\n\t/**\n\t * Returns whether one of the projects has a builder whose trigger setting\n\t * for the given trigger matches the given value.\n\t * \n\t * @param projects The projects to check\n\t * @param trigger The trigger to look for\n\t * @param value The trigger value to look for\n\t * @return <code>true</code> if one of the projects has a builder whose\n\t * trigger activation matches the provided value, and <code>false</code> otherwise.\n\t */\n\tprivate static boolean matchingTrigger(IProject[] projects, int trigger, boolean value) {\n\t\tfor (int i = 0; i < projects.length; i++) {\n\t\t\tif (!projects[i].isAccessible())\n\t\t\t\tcontinue;\n\t\t\ttry {\n\t\t\t\tIProjectDescription description = projects[i].getDescription();\n\t\t\t\tICommand[] buildSpec = description.getBuildSpec();\n\t\t\t\tfor (int j = 0; j < buildSpec.length; j++) {\n\t\t\t\t\tif (buildSpec[j].isBuilding(trigger) == value)\n\t\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t} catch (CoreException e) {\n\t\t\t\t//ignore projects that are not available\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Returns whether a build command with the given trigger should\n\t * be enabled for the given selection.\n\t * @param projects The projects to use to determine enablement\n\t * @param trigger The build trigger (<code>IncrementalProjectBuilder.*_BUILD</code> constants).\n\t * @return <code>true</code> if the action should be enabled, and\n\t * <code>false</code> otherwise.\n\t */\n\tpublic static boolean isEnabled(IProject[] projects, int trigger) {\n\t\treturn true;\n\t}\n\n\t/**\n\t * Doesn't need to be instantiated\n\t */\n\tprivate BuildUtilities() {\n\t}\n}");
            String expectedResult = "/******************************************************************************* * Copyright (c) 2000, 2006 IBM Corporation and others. * All rights reserved. This program and the accompanying materials * are made available under the terms of the Eclipse Public License v1.0 * which accompanies this distribution, and is available at * http://www.eclipse.org/legal/epl-v10.html * * Contributors: *     IBM Corporation - initial API and implementation *******************************************************************************/import java.util.HashSet;\nimport org.eclipse.core.resources.ICommand;\nimport org.eclipse.core.resources.IProject;\nimport org.eclipse.core.resources.IProjectDescription;\nimport org.eclipse.core.resources.IResource;\nimport org.eclipse.core.resources.IncrementalProjectBuilder;\nimport org.eclipse.core.resources.ResourcesPlugin;\nimport org.eclipse.core.runtime.CoreException;\nimport org.eclipse.core.runtime.IAdaptable;\nimport org.eclipse.jface.viewers.ISelection;\nimport org.eclipse.jface.viewers.IStructuredSelection;\nimport org.eclipse.ui.IEditorInput;\nimport org.eclipse.ui.IEditorPart;\nimport org.eclipse.ui.IFileEditorInput;\nimport org.eclipse.ui.IWorkbenchPart;\nimport org.eclipse.ui.IWorkbenchWindow;\n\n/**\n * This class contains convenience methods used by the various build commands\n * to determine enablement.  These utilities cannot be factored into a common\n * class because some build actions are API and some are not.\n * \n * @since 3.1\n */\npublic class BuildUtilities {\n\t/**\n\t * Extracts the selected projects from a selection.\n\t * \n\t * @param selection The selection to analyze\n\t * @return The selected projects\n\t */\n\tpublic static IProject[] extractProjects(Object[] selection) {\n\t\tHashSet projects = new HashSet();\n\t\tfor (int i = 0; i < selection.length; i++) {\n\t\t\tif (selection[i] instanceof IResource) {\n\t\t\t\tprojects.add(((IResource) selection[i]).getProject());\n\t\t\t} else if (selection[i] instanceof IAdaptable) {\n\t\t\t\tIAdaptable adaptable = (IAdaptable) selection[i];\n\t\t\t\tIResource resource = (IResource) adaptable.getAdapter(IResource.class);\n\t\t\t\tif (resource != null)\n\t\t\t\t\tprojects.add(resource.getProject());\n\t\t\t}\n\t\t}\n\t\treturn (IProject[]) projects.toArray(new IProject[projects.size()]);\n\t}\n\n\t/**\n\t * Finds and returns the selected projects in the given window\n\t * \n\t * @param window The window to find the selection in\n\t * @return The selected projects, or an empty array if no selection could be found.\n\t */\n\tpublic static IProject[] findSelectedProjects(IWorkbenchWindow window) {\n\t\tif (window == null)\n\t\t\treturn new IProject[0];\n\t\tISelection selection = window.getSelectionService().getSelection();\n\t\tIProject[] selected = null;\n\t\tif (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {\n\t\t\tselected = extractProjects(((IStructuredSelection) selection).toArray());\n\t\t} else {\n\t\t\t//see if we can extract a selected project from the active editor\n\t\t\tIWorkbenchPart part = window.getPartService().getActivePart();\n\t\t\tif (part instanceof IEditorPart) {\n\t\t\t\tIEditorInput input = ((IEditorPart) part).getEditorInput();\n\t\t\t\tif (input instanceof IFileEditorInput)\n\t\t\t\t\tselected = new IProject[] {((IFileEditorInput) input).getFile().getProject()};\n\t\t\t}\n\t\t}\n\t\tif (selected == null)\n\t\t\tselected = new IProject[0];\n\t\treturn selected;\n\t}\n\n\t/**\n\t * Returns whether the workspace has a builder installed that responds\n\t * to the given trigger.\n\t */\n\tstatic boolean hasBuilder(int trigger) {\n\t\tIProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();\n\t\tboolean builderFound = false;\n\t\tfor (int i = 0; i < projects.length; i++) {\n\t\t\tif (!projects[i].isAccessible())\n\t\t\t\tcontinue;\n\t\t\ttry {\n\t\t\t\tIProjectDescription description = projects[i].getDescription();\n\t\t\t\tICommand[] buildSpec = description.getBuildSpec();\n\t\t\t\tfor (int j = 0; j < buildSpec.length; j++) {\n\t\t\t\t\tbuilderFound = true;\n\t\t\t\t\tif (!buildSpec[j].isBuilding(trigger))\n\t\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t} catch (CoreException e) {\n\t\t\t\t//ignore projects that are not available\n\t\t\t}\n\t\t}\n\t\t//enable building if there are any accessible projects with builders\n\t\treturn builderFound;\n\n\t}\n\n\t/**\n\t * Returns whether the selection of projects is being managed by autobuild.\n\t * \n\t * @param projects The projects to examine\n\t * @return <code>true</code> if the projects are being managed by\n\t * autobuild, and <code>false</code> otherwise.\n\t */\n\tpublic static boolean isAutoBuilding(IProject[] projects) {\n\t\tif (!ResourcesPlugin.getWorkspace().isAutoBuilding())\n\t\t\treturn false;\n\t\t\n\t/**\n\t * Returns whether a build command with the given trigger should\n\t * be enabled for the given selection.\n\t * @param projects The projects to use to determine enablement\n\t * @param trigger The build trigger (<code>IncrementalProjectBuilder.*_BUILD</code> constants).\n\t * @return <code>true</code> if the action should be enabled, and\n\t * <code>false</code> otherwise.\n\t */\n\tpublic static boolean isEnabled(IProject[] projects, int trigger) {\n\t\treturn true;\n\t}\n\n\t/**\n\t * Returns whether one of the projects has a builder whose trigger setting\n\t * for the given trigger matches the given value.\n\t * \n\t * @param projects The projects to check\n\t * @param trigger The trigger to look for\n\t * @param value The trigger value to look for\n\t * @return <code>true</code> if one of the projects has a builder whose\n\t * trigger activation matches the provided value, and <code>false</code> otherwise.\n\t */\n\tprivate static boolean matchingTrigger(IProject[] projects, int trigger, boolean value) {\n\t\tfor (int i = 0; i < projects.length; i++) {\n\t\t\tif (!projects[i].isAccessible())\n\t\t\t\tcontinue;\n\t\t\ttry {\n\t\t\t\tIProjectDescription description = projects[i].getDescription();\n\t\t\t\tICommand[] buildSpec = description.getBuildSpec();\n\t\t\t\tfor (int j = 0; j < buildSpec.length; j++) {\n\t\t\t\t\tif (buildSpec[j].isBuilding(trigger) == value)\n\t\t\t\t\t\treturn true;\n\t\t\t\t}\n\t\t\t} catch (CoreException e) {\n\t\t\t\t//ignore projects that are not available\n\t\t\t}\n\t\t}\n\t\treturn false;\n\t}\n\n\t/**\n\t * Doesn't need to be instantiated\n\t */\n\tprivate BuildUtilities() {\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/BuildUtilities.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/BuildUtilities.js");
        }
    }

    public void test023() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public @interface X {\n\tString name();\n\tint id() default 0;\n\tString value;\n\tstatic int GlobalID;\n}\nclass A {}");
            String expectedResult = "class A {}\npublic @interface X {\n\tstatic int GlobalID;\n\tString value;\n\tint id() default 0;\n\tString name();\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test024() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n\tvoid foo() {\n\t\tclass Local {\n\t\t\tstatic enum E {\n\t\t\t\tC, B;\n\t\t\t}\n\t\t}\n\t}\n\tvoid bar() {\n\t}\n}");
            String expectedResult = "public class X {\n\tvoid bar() {\n\t}\n\tvoid foo() {\n\t\tclass Local {\n\t\t\tstatic enum E {\n\t\t\t\tB, C;\n\t\t\t}\n\t\t}\n\t}\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test025() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "interface Jpf {\n\t@interface Action {\n\t\tValidatableProperty[] validatableProperties();\n\t}\n\t@interface ValidatableProperty {\n\t\tString propertyName();\n\t\tValidationLocaleRules[] localeRules();\n\t}\n\t@interface ValidateMinLength {\n\t\tString chars();\n\t}\n\t@interface ValidationLocaleRules {\n\t\tValidateMinLength validateMinLength();\n\t}\npublic class X {\n\t@Jpf.Action(validatableProperties = { @Jpf.ValidatableProperty(propertyName = \"fooField\", localeRules = { @Jpf.ValidationLocaleRules(validateMinLength = @Jpf.ValidateMinLength(chars = \"12\")) }) })\n\tpublic String actionForValidationRuleTest() {\n\t\treturn null;\n\t}\n}");
            String expectedResult = "interface Jpf {\n\t@interface Action {\n\t\tValidatableProperty[] validatableProperties();\n\t}\n\t@interface ValidatableProperty {\n\t\tValidationLocaleRules[] localeRules();\n\t\tString propertyName();\n\t}\n\t@interface ValidateMinLength {\n\t\tString chars();\n\t}\n\t@interface ValidationLocaleRules {\n\t\tValidateMinLength validateMinLength();\n\t}\npublic class X {\n\t@Jpf.Action(validatableProperties = { @Jpf.ValidatableProperty(propertyName = \"fooField\", localeRules = { @Jpf.ValidationLocaleRules(validateMinLength = @Jpf.ValidateMinLength(chars = \"12\")) }) })\n\tpublic String actionForValidationRuleTest() {\n\t\treturn null;\n\t}\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test026() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public class X {\n\tvoid z() {\n\t}\n\tvoid b() {\n\t\tSystem.out.println(\"b1\");\n\t}\n\tvoid b() {\n\t\tSystem.out.println(\"b2\");\n\t}\n\tvoid a() {\n\t}\n}");
            String expectedResult = "public class X {\n\tvoid a() {\n\t}\n\tvoid b() {\n\t\tSystem.out.println(\"b1\");\n\t}\n\tvoid b() {\n\t\tSystem.out.println(\"b2\");\n\t}\n\tvoid z() {\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test027() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public final class X\n{\n\tstatic\n\t{\n\n\t}\n\n\tpublic static void main(String[] args)\n\t{\n\t}\n\n\tstatic\n\t{\n\n\t}\n}");
            String expectedResult = "public final class X\n{\n\tstatic\n\t{\n\n\t}\n\n\tstatic\n\t{\n\n\t}\n\n\tpublic static void main(String[] args)\n\t{\n\t}\n}";
            this.sortUnit(this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test029() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "public enum X {\n\tZ, A, C, B;\n}");
            String expectedResult = "public enum X {\n\tZ, A, C, B;\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult, false, new Comparator(){

                public int compare(Object o1, Object o2) {
                    BodyDeclaration bodyDeclaration1 = (BodyDeclaration)o1;
                    BodyDeclaration bodyDeclaration2 = (BodyDeclaration)o2;
                    int sourceStart1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
                    int sourceStart2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
                    return sourceStart1 - sourceStart2;
                }
            });
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test030() throws CoreException {
        try {
            this.createFile("/P/src/I.js", "public interface I<T> {\n\tpublic I<T> foo(A<T> A);\n\tpublic <S> I<S> foo2(C<T,S> c);\n\tpublic <S> I<S> foo3(C<T,I<S>> c);\n\tpublic <K> J<T> bar(C<T,K> c);\n\tpublic <K> J<T> bar2(C<T,K> c);\n\tpublic <K> I<K<K,T> bar3(C<T,K> c);\n\tpublic <K,E> I<K<K,E> bar3(C<T,K> c, C<T,E> c2);\n}");
            String expectedResult = "public interface I<T> {\n\tpublic I<T> foo(A<T> A);\n\tpublic <S> I<S> foo2(C<T,S> c);\n\tpublic <S> I<S> foo3(C<T,I<S>> c);\n\tpublic <K> J<T> bar(C<T,K> c);\n\tpublic <K> J<T> bar2(C<T,K> c);\n\tpublic <K> I<K<K,T> bar3(C<T,K> c);\n\tpublic <K,E> I<K<K,E> bar3(C<T,K> c, C<T,E> c2);\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/I.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/I.js");
        }
    }

    public void test031() throws CoreException {
        try {
            this.createFile("/P/src/I.js", "public interface I<T> {\n\tpublic I<T> foo(A<T> A);\n\tpublic <S> I<S> foo2(C<T,S> c);\n\tpublic <S> I<S> foo3(C<T,I<S>> c);\n\tpublic <K> J<T> bar(C<T,K> c);\n\tpublic <K> J<T> bar2(C<T,K> c);\n\tpublic <K> I<K<K,T>> bar3(C<T,K> c);\n\tpublic <K,E> I<K<K,E>> bar3(C<T,K> c, C<T,E> c2);\n}");
            String expectedResult = "public interface I<T> {\n\tpublic <K> J<T> bar2(C<T,K> c);\n\tpublic <K> I<K<K,T>> bar3(C<T,K> c);\n\tpublic <K,E> I<K<K,E>> bar3(C<T,K> c, C<T,E> c2);\n\tpublic <K> J<T> bar(C<T,K> c);\n\tpublic <S> I<S> foo2(C<T,S> c);\n\tpublic <S> I<S> foo3(C<T,I<S>> c);\n\tpublic I<T> foo(A<T> A);\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/I.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/I.js");
        }
    }

    public void test032() throws CoreException {
        try {
            this.createFile("/P/src/X.js", "import java.util.*;\npublic interface X<T> {\n\t<K> List<Map<K,T> foo(Map<T,K> m);\n\t<K,E> List<Map<K,E> bar(Map<T,K> m, Map<T,E> e);\n}");
            String expectedResult = "import java.util.*;\npublic interface X<T> {\n\t<K> List<Map<K,T> foo(Map<T,K> m);\n\t<K,E> List<Map<K,E> bar(Map<T,K> m, Map<T,E> e);\n}";
            this.sortUnit(3, this.getCompilationUnit("/P/src/X.js"), expectedResult);
        }
        finally {
            this.deleteFile("/P/src/X.js");
        }
    }

    public void test033() throws CoreException {
        IJavaScriptUnit unit = null;
        try {
            this.createFile("/P/src/X.js", "public enum X {\n\tZ, A, C, B;\n}");
            String expectedResult = "public enum X {\n\tA, B, C, Z;\n}";
            unit = this.getCompilationUnit("/P/src/X.js");
            unit.becomeWorkingCopy(null);
            String source = unit.getSource();
            Document document = new Document(source);
            CompilerOptions options = new CompilerOptions(unit.getJavaScriptProject().getOptions(true));
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setCompilerOptions(options.getMap());
            parser.setSource(unit);
            parser.setKind(8);
            parser.setResolveBindings(true);
            JavaScriptUnit ast = (JavaScriptUnit)parser.createAST(null);
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    BodyDeclaration bodyDeclaration1 = (BodyDeclaration)o1;
                    BodyDeclaration bodyDeclaration2 = (BodyDeclaration)o2;
                    int sourceStart1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
                    int sourceStart2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
                    return sourceStart1 - sourceStart2;
                }
            };
            TextEdit edit = JavaScriptUnitSorter.sort((JavaScriptUnit)ast, (Comparator)comparator, (int)0, null, (IProgressMonitor)new NullProgressMonitor());
            try {
                edit.apply((IDocument)document);
            }
            catch (MalformedTreeException malformedTreeException) {
                SortCompilationUnitElementsTests.assertTrue((String)"Should not happen", (boolean)false);
            }
            catch (BadLocationException badLocationException) {
                SortCompilationUnitElementsTests.assertTrue((String)"Should not happen", (boolean)false);
            }
            SortCompilationUnitElementsTests.assertEquals((String)"Different output", (String)expectedResult, (String)document.get());
        }
        finally {
            this.deleteFile("/P/src/X.js");
            if (unit != null) {
                unit.discardWorkingCopy();
            }
        }
    }

    public void test034() throws CoreException {
        IJavaScriptUnit unit = null;
        try {
            this.createFile("/P/src/X.js", "public enum X {\n\tZ, A, C, B;\n}");
            unit = this.getCompilationUnit("/P/src/X.js");
            unit.becomeWorkingCopy(null);
            CompilerOptions options = new CompilerOptions(unit.getJavaScriptProject().getOptions(true));
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setCompilerOptions(options.getMap());
            parser.setSource(unit);
            parser.setKind(8);
            parser.setResolveBindings(false);
            JavaScriptUnit ast = (JavaScriptUnit)parser.createAST(null);
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    BodyDeclaration bodyDeclaration1 = (BodyDeclaration)o1;
                    BodyDeclaration bodyDeclaration2 = (BodyDeclaration)o2;
                    int sourceStart1 = (Integer)bodyDeclaration1.getProperty("relativeOrder");
                    int sourceStart2 = (Integer)bodyDeclaration2.getProperty("relativeOrder");
                    return sourceStart1 - sourceStart2;
                }
            };
            TextEdit edit = JavaScriptUnitSorter.sort((JavaScriptUnit)ast, (Comparator)comparator, (int)0, null, (IProgressMonitor)new NullProgressMonitor());
            SortCompilationUnitElementsTests.assertNull((String)"Should be null", (Object)edit);
        }
        finally {
            this.deleteFile("/P/src/X.js");
            if (unit != null) {
                unit.discardWorkingCopy();
            }
        }
    }
}

