/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingExpressionsTest
extends ASTRewritingTest {
    private static final Class THIS = ASTRewritingExpressionsTest.class;

    public ASTRewritingExpressionsTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingExpressionsTest.allTests();
    }

    public void testArrayAccess() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo(o) {\n");
        buf.append("\to[3 /* comment*/ - 1]= this.o[3 - 1];\n");
        buf.append("}\n");
        buf.append("");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        ArrayAccess left = (ArrayAccess)assignment.getLeftHandSide();
        ArrayAccess right = (ArrayAccess)assignment.getRightHandSide();
        NumberLiteral name = ast.newNumberLiteral("1");
        rewrite.replace((ASTNode)left.getIndex(), (ASTNode)name, null);
        ASTNode placeHolder = rewrite.createCopyTarget((ASTNode)left.getIndex());
        rewrite.replace((ASTNode)right.getIndex(), placeHolder, null);
        SimpleName newName = ast.newSimpleName("o");
        rewrite.replace((ASTNode)right.getArray(), (ASTNode)newName, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo(o) {\n");
        buf.append("\to[1]= o[3 /* comment*/ - 1];\n");
        buf.append("}\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testAssignment() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    var i, j;\n");
        buf.append("    i= 0;\n");
        buf.append("    i-= j= 3;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 3", (statements.size() == 3 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(1);
        Assignment assignment = (Assignment)stmt.getExpression();
        SimpleName name = ast.newSimpleName("j");
        rewrite.replace((ASTNode)assignment.getLeftHandSide(), (ASTNode)name, null);
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("goo"));
        invocation.setExpression((Expression)ast.newSimpleName("other"));
        rewrite.replace((ASTNode)assignment.getRightHandSide(), (ASTNode)invocation, null);
        stmt = (ExpressionStatement)statements.get(2);
        assignment = (Assignment)stmt.getExpression();
        rewrite.set((ASTNode)assignment, (StructuralPropertyDescriptor)Assignment.OPERATOR_PROPERTY, (Object)Assignment.Operator.DIVIDE_ASSIGN, null);
        Assignment inner = (Assignment)assignment.getRightHandSide();
        rewrite.set((ASTNode)inner, (StructuralPropertyDescriptor)Assignment.OPERATOR_PROPERTY, (Object)Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    var i, j;\n");
        buf.append("    j= other.goo();\n");
        buf.append("    i/= j>>>= 3;\n");
        buf.append("}\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testCatchClause() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    try {\n");
        buf.append("    } catch (e) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 3", (statements.size() == 1 ? 1 : 0) != 0);
        List catchClauses = ((TryStatement)statements.get(0)).catchClauses();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of catchClauses not 1", (catchClauses.size() == 1 ? 1 : 0) != 0);
        CatchClause clause = (CatchClause)catchClauses.get(0);
        SingleVariableDeclaration exception = clause.getException();
        SingleVariableDeclaration newException = ast.newSingleVariableDeclaration();
        newException.setName(ast.newSimpleName("ex"));
        rewrite.replace((ASTNode)exception, (ASTNode)newException, null);
        clause = (CatchClause)catchClauses.get(0);
        Block body = clause.getBody();
        Block newBody = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        newBody.statements().add(returnStatement);
        rewrite.replace((ASTNode)body, (ASTNode)newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    try {\n");
        buf.append("    } catch (ex) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testConditionalExpression() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= (k == 0) ? 1 : 2;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        ConditionalExpression condExpression = (ConditionalExpression)assignment.getRightHandSide();
        BooleanLiteral literal = ast.newBooleanLiteral(true);
        rewrite.replace((ASTNode)condExpression.getExpression(), (ASTNode)literal, null);
        SimpleName newThenExpre = ast.newSimpleName("x");
        rewrite.replace((ASTNode)condExpression.getThenExpression(), (ASTNode)newThenExpre, null);
        InfixExpression infixExpression = ast.newInfixExpression();
        infixExpression.setLeftOperand((Expression)ast.newNumberLiteral("1"));
        infixExpression.setRightOperand((Expression)ast.newNumberLiteral("2"));
        infixExpression.setOperator(InfixExpression.Operator.PLUS);
        rewrite.replace((ASTNode)condExpression.getElseExpression(), (ASTNode)infixExpression, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= true ? x : 1 + 2;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testFieldAccess() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        foo().i= goo().i;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        FieldAccess leftFieldAccess = (FieldAccess)assignment.getLeftHandSide();
        FieldAccess rightFieldAccess = (FieldAccess)assignment.getRightHandSide();
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("xoo"));
        rewrite.replace((ASTNode)leftFieldAccess.getExpression(), (ASTNode)invocation, null);
        SimpleName newName = ast.newSimpleName("x");
        rewrite.replace((ASTNode)leftFieldAccess.getName(), (ASTNode)newName, null);
        SimpleName rightHand = ast.newSimpleName("b");
        rewrite.replace((ASTNode)rightFieldAccess.getExpression(), (ASTNode)rightHand, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        xoo().x= b.i;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testInfixExpression() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= 1 + 2;\n");
        buf.append("        j= 1 + 2 + 3 + 4 + 5;\n");
        buf.append("        k= 1 + 2 + 3 + 4 + 5;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 3", (statements.size() == 3 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        InfixExpression expr = (InfixExpression)assignment.getRightHandSide();
        SimpleName leftOp = ast.newSimpleName("k");
        rewrite.replace((ASTNode)expr.getLeftOperand(), (ASTNode)leftOp, null);
        SimpleName rightOp = ast.newSimpleName("j");
        rewrite.replace((ASTNode)expr.getRightOperand(), (ASTNode)rightOp, null);
        rewrite.set((ASTNode)expr, (StructuralPropertyDescriptor)InfixExpression.OPERATOR_PROPERTY, (Object)InfixExpression.Operator.MINUS, null);
        stmt = (ExpressionStatement)statements.get(1);
        assignment = (Assignment)stmt.getExpression();
        expr = (InfixExpression)assignment.getRightHandSide();
        List extendedOperands = expr.extendedOperands();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of extendedOperands not 3", (extendedOperands.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)extendedOperands.get(0), null);
        SimpleName newOp1 = ast.newSimpleName("k");
        rewrite.replace((ASTNode)extendedOperands.get(1), (ASTNode)newOp1, null);
        SimpleName newOp2 = ast.newSimpleName("n");
        rewrite.getListRewrite((ASTNode)expr, InfixExpression.EXTENDED_OPERANDS_PROPERTY).insertLast((ASTNode)newOp2, null);
        stmt = (ExpressionStatement)statements.get(2);
        assignment = (Assignment)stmt.getExpression();
        expr = (InfixExpression)assignment.getRightHandSide();
        rewrite.set((ASTNode)expr, (StructuralPropertyDescriptor)InfixExpression.OPERATOR_PROPERTY, (Object)InfixExpression.Operator.TIMES, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= k - j;\n");
        buf.append("        j= 1 + 2 + k + 5 + n;\n");
        buf.append("        k= 1 * 2 * 3 * 4 * 5;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodInvocation() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        foo(1, 2).goo();\n");
        buf.append("        foo(1, 2).goo();\n");
        buf.append("        foo(1, 2).goo();\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 3", (statements.size() == 3 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        FunctionInvocation invocation = (FunctionInvocation)stmt.getExpression();
        rewrite.remove((ASTNode)invocation.getExpression(), null);
        SimpleName name = ast.newSimpleName("x");
        rewrite.replace((ASTNode)invocation.getName(), (ASTNode)name, null);
        NumberLiteral arg = ast.newNumberLiteral("1");
        rewrite.getListRewrite((ASTNode)invocation, FunctionInvocation.ARGUMENTS_PROPERTY).insertLast((ASTNode)arg, null);
        stmt = (ExpressionStatement)statements.get(1);
        invocation = (FunctionInvocation)stmt.getExpression();
        FunctionInvocation leftInvocation = (FunctionInvocation)invocation.getExpression();
        SimpleName newExpression = ast.newSimpleName("x");
        rewrite.set((ASTNode)leftInvocation, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, (Object)newExpression, null);
        List args = leftInvocation.arguments();
        rewrite.remove((ASTNode)args.get(0), null);
        rewrite.remove((ASTNode)args.get(1), null);
        stmt = (ExpressionStatement)statements.get(2);
        invocation = (FunctionInvocation)stmt.getExpression();
        ASTNode placeHolder = rewrite.createCopyTarget((ASTNode)invocation.getExpression());
        rewrite.set((ASTNode)invocation, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, null, null);
        rewrite.getListRewrite((ASTNode)invocation, FunctionInvocation.ARGUMENTS_PROPERTY).insertLast(placeHolder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        x(1);\n");
        buf.append("        x.foo().goo();\n");
        buf.append("        goo(foo(1, 2));\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testMethodParamsRenameReorder() throws Exception {
    }

    public void testMethodInvocation1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        foo(foo(1, 2), 3);\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        FunctionInvocation invocation = (FunctionInvocation)stmt.getExpression();
        List arguments = invocation.arguments();
        FunctionInvocation first = (FunctionInvocation)arguments.get(0);
        ASTNode second = (ASTNode)arguments.get(1);
        ASTNode placeholder1 = rewrite.createCopyTarget((ASTNode)first);
        ASTNode placeholder2 = rewrite.createCopyTarget(second);
        rewrite.replace((ASTNode)first, placeholder2, null);
        rewrite.replace(second, placeholder1, null);
        List innerArguments = first.arguments();
        ASTNode innerFirst = (ASTNode)innerArguments.get(0);
        ASTNode innerSecond = (ASTNode)innerArguments.get(1);
        ASTNode innerPlaceholder1 = rewrite.createCopyTarget(innerFirst);
        ASTNode innerPlaceholder2 = rewrite.createCopyTarget(innerSecond);
        rewrite.replace(innerFirst, innerPlaceholder2, null);
        rewrite.replace(innerSecond, innerPlaceholder1, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        foo(3, foo(2, 1));\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testParenthesizedExpression() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= (1 + 2) * 3;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        InfixExpression multiplication = (InfixExpression)assignment.getRightHandSide();
        ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)multiplication.getLeftOperand();
        SimpleName name = ast.newSimpleName("x");
        rewrite.replace((ASTNode)parenthesizedExpression.getExpression(), (ASTNode)name, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= (x) * 3;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testPrefixExpression() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= --x;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        PrefixExpression preExpression = (PrefixExpression)assignment.getRightHandSide();
        NumberLiteral newOperation = ast.newNumberLiteral("10");
        rewrite.replace((ASTNode)preExpression.getOperand(), (ASTNode)newOperation, null);
        rewrite.set((ASTNode)preExpression, (StructuralPropertyDescriptor)PrefixExpression.OPERATOR_PROPERTY, (Object)PrefixExpression.Operator.COMPLEMENT, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= ~10;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testPostfixExpression() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= x--;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        PostfixExpression postExpression = (PostfixExpression)assignment.getRightHandSide();
        NumberLiteral newOperation = ast.newNumberLiteral("10");
        rewrite.replace((ASTNode)postExpression.getOperand(), (ASTNode)newOperation, null);
        rewrite.set((ASTNode)postExpression, (StructuralPropertyDescriptor)PostfixExpression.OPERATOR_PROPERTY, (Object)PostfixExpression.Operator.INCREMENT, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        i= 10++;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void XtestThisExpression() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    return this;\n");
        buf.append("    return Outer.this;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 2", (statements.size() == 2 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        ThisExpression thisExpression = (ThisExpression)returnStatement.getExpression();
        SimpleName newExpression = ast.newSimpleName("X");
        rewrite.set((ASTNode)thisExpression, (StructuralPropertyDescriptor)ThisExpression.QUALIFIER_PROPERTY, (Object)newExpression, null);
        returnStatement = (ReturnStatement)statements.get(1);
        thisExpression = (ThisExpression)returnStatement.getExpression();
        rewrite.remove((ASTNode)thisExpression.getQualifier(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return X.this;\n");
        buf.append("        return this;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testSimpleName() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo(hello) {\n");
        buf.append("        return hello;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        SimpleName simpleName = (SimpleName)returnStatement.getExpression();
        rewrite.set((ASTNode)simpleName, (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)"changed", null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo(hello) {\n");
        buf.append("        return changed;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testNumberLiteral() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return 1;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        NumberLiteral literal = (NumberLiteral)returnStatement.getExpression();
        rewrite.set((ASTNode)literal, (StructuralPropertyDescriptor)NumberLiteral.TOKEN_PROPERTY, (Object)"11", null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return 11;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testBooleanLiteral() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return true;\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        BooleanLiteral literal = (BooleanLiteral)returnStatement.getExpression();
        rewrite.set((ASTNode)literal, (StructuralPropertyDescriptor)BooleanLiteral.BOOLEAN_VALUE_PROPERTY, (Object)Boolean.FALSE, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return false;\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testStringLiteral() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return \"Hello\";\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        StringLiteral literal = (StringLiteral)returnStatement.getExpression();
        rewrite.set((ASTNode)literal, (StructuralPropertyDescriptor)StringLiteral.ESCAPED_VALUE_PROPERTY, (Object)"\"Eclipse\"", null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return \"Eclipse\";\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }

    public void testCharacterLiteral() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return 'x';\n");
        buf.append("    }\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingExpressionsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = ASTRewritingExpressionsTest.findMethodDeclaration(astRoot, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingExpressionsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        StringLiteral literal = (StringLiteral)returnStatement.getExpression();
        rewrite.set((ASTNode)literal, (StructuralPropertyDescriptor)StringLiteral.ESCAPED_VALUE_PROPERTY, (Object)"'y'", null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("    function foo() {\n");
        buf.append("        return 'y';\n");
        buf.append("    }\n");
        ASTRewritingExpressionsTest.assertEqualString(preview, buf.toString());
    }
}

