/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkReadOnly;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaEntityTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndCustomizerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("    @Customizer(Foo.class");
            }
        });
    }

    private ICompilationUnit createTestEntityWithChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("    @ChangeTracking").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithReadOnly() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.ReadOnly"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@ReadOnly").append(CR);
            }
        });
    }

    public EclipseLinkJavaEntityTests(String name) {
        super(name);
    }

    public void testAttributeMappingKeyAllowed() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        Entity entity = (Entity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basic"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("id"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embedded"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("embeddedId"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("version"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transient"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToOne"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToOne"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("oneToMany"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("manyToMany"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basicCollection"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("basicMap"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("transformation"));
        EclipseLinkJavaEntityTests.assertTrue((boolean)entity.attributeMappingKeyAllowed("variableOneToOne"));
    }

    public void testGetCustomizerClass() throws Exception {
        this.createTestEntityWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkEntity)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEntityTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testSetCustomizerClass() throws Exception {
        this.createTestEntityWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkEntity)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEntityTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
        customizer.setSpecifiedCustomizerClass(null);
        EclipseLinkJavaEntityTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals(null, (Object)customizerAnnotation);
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
    }

    public void testGetCustomizerClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity entity = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkCustomizer customizer = entity.getCustomizer();
        EclipseLinkJavaEntityTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        customizerAnnotation.setValue("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation.setValue("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals((String)"FooBar", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testGetChangeTracking() throws Exception {
        this.createTestEntityWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity entity = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = entity.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.ATTRIBUTE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.OBJECT);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.DEFERRED);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.AUTO);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEntityTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetChangeTracking() throws Exception {
        this.createTestEntityWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity entity = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = entity.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        EclipseLinkJavaEntityTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.OBJECT);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.DEFERRED);
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(null);
        EclipseLinkJavaEntityTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking"));
        EclipseLinkJavaEntityTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEntityTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEntityTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
    }

    public void testGetReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
    }

    public void testGetSpecifiedReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }

    public void testGetDefaultReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
    }

    public void testSetSpecifiedReadOnly() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((boolean)true, (boolean)readOnly.isReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.FALSE);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLinkJavaEntityTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaEntityTests.assertNull((Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(Boolean.TRUE);
        EclipseLinkJavaEntityTests.assertNotNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        readOnly.setSpecifiedReadOnly(null);
        EclipseLinkJavaEntityTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ReadOnly"));
        EclipseLinkJavaEntityTests.assertNull((Object)readOnly.getSpecifiedReadOnly());
    }

    public void testSpecifiedReadOnlyUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithReadOnly();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntity mappedSuperclass = (EclipseLinkEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkReadOnly readOnly = mappedSuperclass.getReadOnly();
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertNull((Object)readOnly.getSpecifiedReadOnly());
        EclipseLinkJavaEntityTests.assertEquals((boolean)false, (boolean)readOnly.isDefaultReadOnly());
        resourceType.addAnnotation("org.eclipse.persistence.annotations.ReadOnly");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEntityTests.assertEquals((Object)Boolean.TRUE, (Object)readOnly.getSpecifiedReadOnly());
    }
}

