/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCustomization;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCustomizationEntity;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationValueModelTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkCustomization customization;
    private ModifiablePropertyValueModel<Boolean> throwExceptionsHolder;
    private PropertyChangeListener throwExceptionsListener;
    private PropertyChangeEvent throwExceptionsEvent;
    public static final String ENTITY_NAME_TEST_VALUE = "Employee";
    public static final Boolean THROW_EXCEPTIONS_TEST_VALUE = Boolean.FALSE;
    public static final String CUSTOMIZER_TEST_VALUE = "acme.sessions.Customizer";

    public CustomizationValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.customization = this.subject.getCustomization();
        SimplePropertyValueModel customizationHolder = new SimplePropertyValueModel((Object)this.customization);
        this.throwExceptionsHolder = this.buildThrowExceptionsAA((PropertyValueModel<EclipseLinkCustomization>)customizationHolder);
        this.throwExceptionsListener = this.buildThrowExceptionsChangeListener();
        this.throwExceptionsHolder.addPropertyChangeListener("value", this.throwExceptionsListener);
        this.throwExceptionsEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectCustomization = (AbstractModel)this.customization;
        PropertyAspectAdapter throwExceptionsAA = (PropertyAspectAdapter)this.throwExceptionsHolder;
        CustomizationValueModelTests.assertTrue((boolean)throwExceptionsAA.hasAnyPropertyChangeListeners("value"));
        CustomizationValueModelTests.assertTrue((boolean)subjectCustomization.hasAnyPropertyChangeListeners("throwExceptions"));
        throwExceptionsAA.removePropertyChangeListener("value", this.throwExceptionsListener);
        CustomizationValueModelTests.assertFalse((boolean)subjectCustomization.hasAnyPropertyChangeListeners("throwExceptions"));
        CustomizationValueModelTests.assertFalse((boolean)throwExceptionsAA.hasAnyPropertyChangeListeners("value"));
    }

    protected void populatePu() {
        this.persistenceUnitSetProperty("eclipselink.orm.throw.exceptions", THROW_EXCEPTIONS_TEST_VALUE);
    }

    protected PersistenceUnitProperties getModel() {
        return this.customization;
    }

    private ModifiablePropertyValueModel<Boolean> buildThrowExceptionsAA(PropertyValueModel<EclipseLinkCustomization> subjectHolder) {
        return new PropertyAspectAdapter<EclipseLinkCustomization, Boolean>(subjectHolder, new String[]{"throwExceptions"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkCustomization)this.subject).getThrowExceptions();
            }

            protected void setValue_(Boolean enumValue) {
                ((EclipseLinkCustomization)this.subject).setThrowExceptions(enumValue);
            }
        };
    }

    private PropertyChangeListener buildThrowExceptionsChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                CustomizationValueModelTests.this.throwExceptionsEvent = e;
            }
        };
    }

    public void testClone() {
        EclipseLinkCustomizationEntity entity = this.buildEntity("TestEntity", CUSTOMIZER_TEST_VALUE);
        this.verifyClone(entity, entity.clone());
    }

    public void testEquals() {
        EclipseLinkCustomizationEntity entity1 = this.buildEntity("TestEntityA", CUSTOMIZER_TEST_VALUE);
        EclipseLinkCustomizationEntity entity2 = this.buildEntity("TestEntityB", CUSTOMIZER_TEST_VALUE);
        CustomizationValueModelTests.assertEquals((Object)entity1, (Object)entity2);
        EclipseLinkCustomizationEntity entity3 = this.buildEntity("TestEntityC", CUSTOMIZER_TEST_VALUE);
        CustomizationValueModelTests.assertEquals((Object)entity1, (Object)entity3);
        CustomizationValueModelTests.assertEquals((Object)entity2, (Object)entity3);
    }

    public void testIsEmpty() {
        EclipseLinkCustomizationEntity entity = this.buildEntity("TestEntity");
        CustomizationValueModelTests.assertTrue((boolean)entity.isEmpty());
        this.customization.setDescriptorCustomizerOf(entity.getName(), CUSTOMIZER_TEST_VALUE);
        CustomizationValueModelTests.assertFalse((boolean)entity.isEmpty());
    }

    private void verifyClone(EclipseLinkCustomizationEntity original, EclipseLinkCustomizationEntity clone) {
        CustomizationValueModelTests.assertNotSame((Object)original, (Object)clone);
        CustomizationValueModelTests.assertEquals((Object)original, (Object)original);
        CustomizationValueModelTests.assertEquals((Object)original, (Object)clone);
    }

    private EclipseLinkCustomizationEntity buildEntity(String name) {
        return this.customization.addEntity(name);
    }

    private EclipseLinkCustomizationEntity buildEntity(String name, String aClassName) {
        EclipseLinkCustomizationEntity entity = this.customization.addEntity(name);
        this.customization.setDescriptorCustomizerOf(entity.getName(), aClassName);
        return entity;
    }

    public void testValue() {
        this.verifyThrowExceptionsAAValue(THROW_EXCEPTIONS_TEST_VALUE);
        CustomizationValueModelTests.assertEquals((Object)EclipseLinkCustomization.DEFAULT_THROW_EXCEPTIONS, (Object)this.customization.getDefaultThrowExceptions());
    }

    public void testSetValue() throws Exception {
        this.throwExceptionsEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.throwExceptionsHolder, "value");
        Boolean newThrowExceptions = THROW_EXCEPTIONS_TEST_VALUE == false;
        this.throwExceptionsHolder.setValue((Object)newThrowExceptions);
        this.verifyThrowExceptionsAAValue(newThrowExceptions);
        CustomizationValueModelTests.assertNotNull((Object)this.throwExceptionsEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.throwExceptionsEvent = null;
        this.throwExceptionsHolder.setValue(null);
        this.verifyThrowExceptionsAAValue(null);
        CustomizationValueModelTests.assertNotNull((Object)this.throwExceptionsEvent);
        this.verifyPuHasNotProperty("eclipselink.orm.throw.exceptions", notDeleted);
    }

    protected void verifyThrowExceptionsAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.customization.getThrowExceptions(), (PropertyValueModel)this.throwExceptionsHolder, "eclipselink.orm.throw.exceptions");
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

