/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIterableTests
extends TestCase {
    Collection<GraphNode> nodes = new ArrayList<GraphNode>();
    private static final Transformer<GraphNode, Iterable<? extends GraphNode>> CHILDREN_TRANSFORMER = new ChildrenTransformer();

    public GraphIterableTests(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testNeighbors() {
        for (GraphNode gn : this.buildGraphIterable()) {
            GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
        }
    }

    private Iterable<GraphNode> buildGraphIterable() {
        return IterableTools.graphIterable((Object)this.buildGraphRoot(), CHILDREN_TRANSFORMER);
    }

    public void testNeighbors_roots() {
        for (GraphNode gn : this.buildGraphIterable_roots()) {
            GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
        }
    }

    private Iterable<GraphNode> buildGraphIterable_roots() {
        return IterableTools.graphIterable((Object[])new GraphNode[]{this.buildGraphRoot()}, CHILDREN_TRANSFORMER);
    }

    public void testToString() {
        GraphIterableTests.assertNotNull((Object)this.buildGraphIterable().toString());
    }

    public void testBogusTransformer() {
        boolean exCaught = false;
        try {
            for (GraphNode gn : IterableTools.graphIterable((Object)this.buildGraphRoot(), (Transformer)DisabledTransformer.instance())) {
                GraphIterableTests.assertTrue((boolean)this.nodes.contains(gn));
            }
            GraphIterableTests.fail();
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        GraphIterableTests.assertTrue((boolean)exCaught);
    }

    private GraphNode buildGraphRoot() {
        GraphNode ncNode = new GraphNode("North Carolina");
        GraphNode vaNode = new GraphNode("Virginia");
        GraphNode scNode = new GraphNode("South Carolina");
        GraphNode gaNode = new GraphNode("Georgia");
        GraphNode flNode = new GraphNode("Florida");
        GraphNode alNode = new GraphNode("Alabama");
        GraphNode msNode = new GraphNode("Mississippi");
        GraphNode tnNode = new GraphNode("Tennessee");
        ncNode.setNeighbors(new GraphNode[]{vaNode, scNode, gaNode, tnNode});
        vaNode.setNeighbors(new GraphNode[]{ncNode, tnNode});
        scNode.setNeighbors(new GraphNode[]{ncNode, gaNode});
        gaNode.setNeighbors(new GraphNode[]{ncNode, scNode, flNode, alNode, tnNode});
        flNode.setNeighbors(new GraphNode[]{gaNode});
        alNode.setNeighbors(new GraphNode[]{gaNode, msNode, tnNode});
        msNode.setNeighbors(new GraphNode[]{alNode, tnNode});
        tnNode.setNeighbors(new GraphNode[]{vaNode, ncNode, gaNode, alNode, msNode});
        return ncNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChildrenTransformer
    extends TransformerAdapter<GraphNode, Iterable<? extends GraphNode>> {
        ChildrenTransformer() {
        }

        public Iterable<GraphNode> transform(GraphNode node) {
            return node.getNeighbors();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GraphNode {
        private String name;
        private Collection<GraphNode> neighbors = new ArrayList<GraphNode>();

        public GraphNode(String name) {
            GraphIterableTests.this.nodes.add(this);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        void setNeighbors(GraphNode[] neighbors) {
            this.neighbors = ListTools.list((Object[])neighbors);
        }

        public Iterable<GraphNode> getNeighbors() {
            return this.neighbors;
        }

        public int neighborsSize() {
            return this.neighbors.size();
        }

        public String toString() {
            return "GraphNode(" + this.name + ")";
        }
    }
}

