/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ClassNameTools;
import org.eclipse.jpt.common.utility.internal.Classpath;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.swing.FilteringListPanel;
import org.eclipse.jpt.common.utility.internal.swing.SimpleListCellRenderer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringListPanelUITest {
    private Type[] completeList1;
    private Type[] completeList2;
    private FilteringListPanel<Type> filteringListPanel;
    private Font font;
    private static final Transformer<String, Type> TYPE_STRING_TRANSFORMER = new TypeStringTransformer();
    private static final Transformer<Type, String> TYPE_NAME_TRANSFORMER = new TypeNameTransformer();

    public static void main(String[] args) {
        new FilteringListPanelUITest().exec(args);
    }

    private FilteringListPanelUITest() {
        this.initialize();
    }

    private void initialize() {
        this.font = this.buildFont();
    }

    private Font buildFont() {
        return new Font("Dialog", 0, 12);
    }

    private void exec(String[] args) {
        this.completeList1 = this.buildTypeList(args);
        this.completeList2 = this.buildCompleteList2();
        JFrame frame = new JFrame(this.getClass().getSimpleName());
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(this.buildWindowListener());
        frame.getContentPane().add((Component)this.buildMainPanel(), "Center");
        frame.setLocation(300, 300);
        frame.setSize(400, 400);
        frame.setVisible(true);
    }

    private Type[] buildTypeList(String[] args) {
        return (Type[])ArrayTools.sort((Object[])((Type[])ArrayTools.array(this.buildTypes(args), Type.class)));
    }

    private Type[] buildCompleteList2() {
        String classpathEntry = Classpath.locationFor(this.getClass());
        return (Type[])ArrayTools.sort((Object[])((Type[])ArrayTools.array(this.buildTypes(new String[]{classpathEntry}), Type.class)));
    }

    private Iterable<Type> buildTypes(String[] args) {
        return new TransformationIterable(this.buildClassNames(args), TYPE_STRING_TRANSFORMER);
    }

    private Iterable<String> buildClassNames(String[] args) {
        return args == null || args.length == 0 ? Classpath.bootClasspath().getClassNames() : new Classpath(new String[]{args[0]}).getClassNames();
    }

    private WindowListener buildWindowListener() {
        return new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                System.exit(0);
            }
        };
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.filteringListPanel = this.buildFilteringListPanel();
        panel.add((Component)this.filteringListPanel, "Center");
        panel.add((Component)this.buildControlPanel(), "South");
        return panel;
    }

    private FilteringListPanel<Type> buildFilteringListPanel() {
        Type initialSelection = this.getTypeNamed(this.completeList1, "java.lang.Object");
        FilteringListPanel panel = new FilteringListPanel((Object[])this.completeList1, (Object)initialSelection, TYPE_NAME_TRANSFORMER);
        panel.setTextFieldLabelText("Choose a Type (? = any char, * = any string):");
        panel.setListBoxLabelText("Matching Types:");
        panel.setComponentsFont(this.font);
        panel.setListBoxCellRenderer((ListCellRenderer)((Object)new TypeCellRenderer()));
        return panel;
    }

    private JPanel buildControlPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 0));
        panel.add(this.buildSwapButton());
        panel.add(this.buildStringButton());
        panel.add(this.buildNullButton());
        panel.add(this.buildMax10Button());
        panel.add(this.buildPrintButton());
        return panel;
    }

    private JButton buildSwapButton() {
        JButton button = new JButton(this.buildSwapAction());
        button.setFont(this.font);
        return button;
    }

    private Action buildSwapAction() {
        return new AbstractAction("swap"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent event) {
                FilteringListPanelUITest.this.swap();
            }
        };
    }

    void swap() {
        if (this.filteringListPanel.getCompleteList() == this.completeList1) {
            this.filteringListPanel.setCompleteList((Object[])this.completeList2);
        } else {
            this.filteringListPanel.setCompleteList((Object[])this.completeList1);
        }
    }

    private JButton buildStringButton() {
        JButton button = new JButton(this.buildStringAction());
        button.setFont(this.font);
        return button;
    }

    private Action buildStringAction() {
        return new AbstractAction("String"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent event) {
                FilteringListPanelUITest.this.selectStringType();
            }
        };
    }

    void selectStringType() {
        this.filteringListPanel.setSelection((Object)this.typeNamed("java.lang.String"));
    }

    private Type typeNamed(String name) {
        return this.getTypeNamed((Type[])this.filteringListPanel.getCompleteList(), name);
    }

    private Type getTypeNamed(Type[] types, String name) {
        int i = types.length;
        while (i-- > 0) {
            Type type = types[i];
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    private JButton buildNullButton() {
        JButton button = new JButton(this.buildNullAction());
        button.setFont(this.font);
        return button;
    }

    private Action buildNullAction() {
        return new AbstractAction("null"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent event) {
                FilteringListPanelUITest.this.selectNull();
            }
        };
    }

    void selectNull() {
        this.filteringListPanel.setSelection(null);
    }

    private JButton buildMax10Button() {
        JButton button = new JButton(this.buildMax10Action());
        button.setFont(this.font);
        return button;
    }

    private Action buildMax10Action() {
        return new AbstractAction("max = 10"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent event) {
                FilteringListPanelUITest.this.setMax10();
            }
        };
    }

    void setMax10() {
        if (this.filteringListPanel.getMaxListSize() == 10) {
            this.filteringListPanel.setMaxListSize(-1);
        } else {
            this.filteringListPanel.setMaxListSize(10);
        }
    }

    private JButton buildPrintButton() {
        JButton button = new JButton(this.buildPrintAction());
        button.setFont(this.font);
        return button;
    }

    private Action buildPrintAction() {
        return new AbstractAction("print"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent event) {
                FilteringListPanelUITest.this.printType();
            }
        };
    }

    void printType() {
        System.out.println("selected item: " + this.filteringListPanel.getSelection());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Type
    implements Comparable<Type> {
        private String name;

        Type(String name) {
            this.name = name;
        }

        public String shortName() {
            return ClassNameTools.simpleName((String)this.name);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "Type: " + this.name;
        }

        @Override
        public int compareTo(Type type) {
            return this.name.compareTo(type.name);
        }
    }

    class TypeCellRenderer
    extends SimpleListCellRenderer {
        private static final long serialVersionUID = 1L;

        TypeCellRenderer() {
        }

        protected Icon buildIcon(Object value) {
            return UIManager.getIcon("Tree.leafIcon");
        }

        protected String buildText(Object value) {
            return ((Type)value).getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeNameTransformer
    extends TransformerAdapter<Type, String> {
        TypeNameTransformer() {
        }

        public String transform(Type type) {
            return type == null ? "" : type.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeStringTransformer
    extends TransformerAdapter<String, Type> {
        TypeStringTransformer() {
        }

        public Type transform(String string) {
            return new Type(string);
        }
    }
}

