/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.persistence;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXmlEnumValue;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceUnitTestCase
extends ContextModelTestCase {
    protected PropertyChangeEvent propertyChangedEvent;
    protected int propertyChangedEventCount;
    protected int propertiesTotal;
    protected int modelPropertiesSizeOriginal;
    protected int modelPropertiesSize;

    protected PersistenceUnitTestCase(String name) {
        super(name);
    }

    protected abstract PersistenceUnitProperties getModel();

    protected abstract void populatePu();

    protected abstract Object getProperty(String var1) throws Exception;

    protected abstract void setProperty(String var1, Object var2) throws Exception;

    protected String getPropertyStringValueOf(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PersistenceXmlEnumValue) {
            return ((PersistenceXmlEnumValue)value).getPropertyValue();
        }
        return value.toString();
    }

    protected <E> E getFirstElement(Iterator<E> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    protected void persistenceUnitSetProperty(String key, Object value) {
        this.persistenceUnitSetProperty(key, value, false);
    }

    protected void persistenceUnitSetProperty(String key, Object value, boolean allowDuplicates) {
        if (key == null) {
            throw new IllegalArgumentException("PersistenceUnit property key cannot be null");
        }
        if (value == null) {
            this.setNullProperty(key);
        } else {
            this.putProperty_(key, value, allowDuplicates);
        }
    }

    private void putProperty_(String puKey, Object value, boolean allowDuplicates) {
        this.clearEvent();
        this.getPersistenceUnit().setProperty(puKey, this.getPropertyStringValueOf(value), allowDuplicates);
    }

    protected void setNullProperty(String puKey) {
        this.clearEvent();
        this.getPersistenceUnit().setProperty(puKey, null, false);
    }

    protected void clearEvent() {
        this.propertyChangedEvent = null;
        this.propertyChangedEventCount = 0;
    }

    protected void throwMissingDefinition(String methodName, String propertyName) throws NoSuchFieldException {
        throw new NoSuchFieldException("Missing Definition for: " + methodName + "( " + propertyName + ")");
    }

    public void throwUnsupportedOperationException(ListEvent e) {
        throw new UnsupportedOperationException(e.getListName());
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PersistenceUnitTestCase.this.propertyChangedEvent = event;
                ++PersistenceUnitTestCase.this.propertyChangedEventCount;
            }

            public String toString() {
                return "PersistenceUnit listener";
            }
        };
    }

    protected boolean propertyExists(String puPropertyName) {
        return this.getPersistenceUnit().getProperty(puPropertyName) != null;
    }

    protected boolean propertyValueEquals(String puPropertyName, String propertyValue) {
        return this.getPersistenceUnit().getProperty(puPropertyName).getValue().equals(propertyValue);
    }

    protected void verifyAAValue(Boolean expectedValue, Boolean subjectValue, PropertyValueModel<Boolean> aa, String persistenceXmlKey) {
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)subjectValue);
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)aa.getValue());
        if (expectedValue != null) {
            PersistenceUnitTestCase.assertTrue((String)"PersistenceUnit property value not equals", (boolean)this.propertyValueEquals(persistenceXmlKey, expectedValue.toString()));
        }
    }

    protected <T extends Enum<T>> void verifyAAValue(T expectedValue, T subjectValue, PropertyValueModel<? extends Enum<T>> aa, String puKey) {
        PersistenceUnitTestCase.assertEquals(expectedValue, subjectValue);
        PersistenceUnitTestCase.assertEquals(expectedValue, (Object)aa.getValue());
        if (expectedValue != null) {
            PersistenceUnitTestCase.assertTrue((String)"PersistenceUnit property value not equals", (boolean)this.propertyValueEquals(puKey, this.getPropertyStringValueOf(expectedValue)));
        }
    }

    protected void verifyInitialState(String propertyName, String puKey, ListValueModel<PersistenceUnit.Property> propertyListAdapter) throws Exception {
        PersistenceUnitTestCase.assertEquals((String)"Total not updated in populatePu(): ", (int)propertyListAdapter.size(), (int)this.propertiesTotal);
        this.verifyPuHasProperty(puKey, "Property not added to populatePu()");
        this.verifyHasListeners(propertyListAdapter);
        this.verifyHasListeners(this.getModel(), propertyName);
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(puKey);
        PersistenceUnitTestCase.assertTrue((String)"model.itemIsProperty() is false: ", (boolean)this.getModel().itemIsProperty(property));
        PersistenceUnitTestCase.assertEquals((String)"propertyIdFor() not updated: ", (String)propertyName, (String)this.getModel().propertyIdOf(property));
    }

    protected void verifyModelInitialized(String puKey, Object expectedValue) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(puKey);
        PersistenceUnitTestCase.assertTrue((String)"model.itemIsProperty() is false: ", (boolean)this.getModel().itemIsProperty(property));
        PersistenceUnitTestCase.assertTrue((String)"PersistenceUnit not populated - populatedPu()", (boolean)this.propertyValueEquals(puKey, this.getPropertyStringValueOf(expectedValue)));
        String propertyName = this.getModel().propertyIdOf(property);
        Object modelValue = this.getProperty(propertyName);
        PersistenceUnitTestCase.assertEquals((String)("Model not initialized - model.initializeProperties() - modelValue = " + modelValue), (Object)expectedValue, (Object)modelValue);
    }

    protected void verifySetProperty(String puKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(puKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.persistenceUnitSetProperty(puKey, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
        this.clearEvent();
        this.setProperty(propertyName, testValue1);
        this.verifyPutProperty(propertyName, testValue1);
    }

    protected void verifyAddRemoveProperty(String puKey, Object testValue1, Object testValue2) throws Exception {
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty(puKey);
        String propertyName = this.getModel().propertyIdOf(property);
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.verifyPuHasProperty(puKey, "persistenceUnit.properties doesn't contains: ");
        this.getPersistenceUnit().removeProperty(puKey);
        PersistenceUnitTestCase.assertNull((Object)this.getPersistenceUnit().getProperty(puKey));
        PersistenceUnitTestCase.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        this.verifyPutProperty(propertyName, null);
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(puKey, testValue1);
        this.verifyPutProperty(propertyName, testValue1);
        this.persistenceUnitSetProperty(puKey, testValue2);
        this.verifyPutProperty(propertyName, testValue2);
    }

    protected void verifyPutProperty(String propertyName, Object expectedValue) throws Exception {
        this.verifyPutEvent(propertyName, this.getProperty(propertyName), expectedValue);
    }

    protected void verifyPutEvent(String propertyName, Object propertyValue, Object expectedValue) {
        this.verifyEvent(propertyName);
        this.verifyEventValue(propertyValue, expectedValue);
    }

    protected void verifyEventValue(Object value, Object expectedValue) {
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)this.propertyChangedEvent.getNewValue());
        PersistenceUnitTestCase.assertEquals((Object)expectedValue, (Object)value);
    }

    protected void verifyEvent(String propertyName) {
        PersistenceUnitTestCase.assertNotNull((String)"No Event Fired.", (Object)this.propertyChangedEvent);
        PersistenceUnitTestCase.assertEquals((String)"Wrong Event.", (String)this.propertyChangedEvent.getPropertyName(), (String)propertyName);
        PersistenceUnitTestCase.assertTrue((String)"No Event Received.", (this.propertyChangedEventCount > 0 ? 1 : 0) != 0);
        PersistenceUnitTestCase.assertTrue((String)("Multiple Event Received (" + this.propertyChangedEventCount + ")"), (this.propertyChangedEventCount < 2 ? 1 : 0) != 0);
    }

    protected void verifyHasNoListeners(ListValueModel<?> listValueModel) throws Exception {
        PersistenceUnitTestCase.assertTrue((boolean)((AbstractModel)listValueModel).hasNoListChangeListeners("list values"));
    }

    protected void verifyHasListeners(ListValueModel<?> listValueModel) throws Exception {
        PersistenceUnitTestCase.assertTrue((boolean)((AbstractModel)listValueModel).hasAnyListChangeListeners("list values"));
    }

    protected void verifyHasListeners(PersistenceUnitProperties model, String propertyName) throws Exception {
        PersistenceUnitTestCase.assertTrue((String)("Listener not added in setUp() - " + propertyName), (boolean)((AbstractModel)model).hasAnyPropertyChangeListeners(propertyName));
    }

    protected void verifyHasListeners(PropertyValueModel<?> pvm, String propertyName) throws Exception {
        PersistenceUnitTestCase.assertTrue((boolean)((AbstractModel)pvm).hasAnyPropertyChangeListeners(propertyName));
    }

    protected void verifyPuHasProperty(String puPropertyName, String msg) {
        PersistenceUnitTestCase.assertTrue((String)(String.valueOf(msg) + " - " + puPropertyName), (boolean)this.propertyExists(puPropertyName));
    }

    protected void verifyPuHasNotProperty(String puPropertyName, String msg) {
        PersistenceUnitTestCase.assertFalse((String)(String.valueOf(msg) + " - " + puPropertyName), (boolean)this.propertyExists(puPropertyName));
    }
}

