/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.QueryHint;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.jpa2_1.context.NamedStoredProcedureQuery2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.QueryContainer2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.StoredProcedureParameter2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.resource.java.NamedStoredProcedureQueryAnnotation2_1;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.Generic2_1ContextModelTestCase;

public class GenericJavaNamedStoredProcedureQuery2_1Tests
extends Generic2_1ContextModelTestCase {
    private static final String QUERY_NAME = "QUERY_NAME";
    private static final String PROCEDURE_NAME = "MY_PROCEDURE";

    public GenericJavaNamedStoredProcedureQuery2_1Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithNamedStoredProcedureQuery() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedStoredProcedureQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedStoredProcedureQuery(name=\"QUERY_NAME\", procedureName=\"MY_PROCEDURE\")");
            }
        });
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)QUERY_NAME, (String)procedureQueryAnnotation.getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)QUERY_NAME, (String)procedureQuery.getName());
        procedureQueryAnnotation.setName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryAnnotation.getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQuery.getName());
        procedureQueryAnnotation.setName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryAnnotation.getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQuery.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)QUERY_NAME, (String)procedureQueryAnnotation.getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)QUERY_NAME, (String)procedureQuery.getName());
        procedureQuery.setName(null);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryAnnotation.getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQuery.getName());
        procedureQuery.setName("foo");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryAnnotation.getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQuery.getName());
    }

    public void testUpdateProcedureName() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)PROCEDURE_NAME, (String)procedureQueryAnnotation.getProcedureName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)PROCEDURE_NAME, (String)procedureQuery.getProcedureName());
        procedureQueryAnnotation.setProcedureName(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryAnnotation.getProcedureName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQuery.getProcedureName());
        procedureQueryAnnotation.setProcedureName("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryAnnotation.getProcedureName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQuery.getProcedureName());
    }

    public void testModifyProcedureName() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)PROCEDURE_NAME, (String)procedureQueryAnnotation.getProcedureName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)PROCEDURE_NAME, (String)procedureQuery.getProcedureName());
        procedureQuery.setProcedureName(null);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryAnnotation.getProcedureName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQuery.getProcedureName());
        procedureQuery.setProcedureName("foo");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryAnnotation.getProcedureName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQuery.getProcedureName());
    }

    public void testAddParameter() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        StoredProcedureParameter2_1 parameter1 = procedureQuery.addParameter(0);
        parameter1.setName("FOO");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.parameterAt(0).getName());
        StoredProcedureParameter2_1 parameter2 = procedureQuery.addParameter(0);
        parameter2.setName("BAR");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.parameterAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.parameterAt(1).getName());
        StoredProcedureParameter2_1 parameter3 = procedureQuery.addParameter(1);
        parameter3.setName("BAZ");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.parameterAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.parameterAt(1).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.parameterAt(2).getName());
        ListIterator parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((Object)parameter2, parameters.next());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((Object)parameter3, parameters.next());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((Object)parameter1, parameters.next());
        parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
    }

    public void testRemoveParameter() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addParameter(0).setName("FOO");
        procedureQuery.addParameter(1).setName("BAR");
        procedureQuery.addParameter(2).setName("BAZ");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getParametersSize());
        procedureQuery.removeParameter(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryAnnotation.getParametersSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.parameterAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.parameterAt(1).getName());
        procedureQuery.removeParameter(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryAnnotation.getParametersSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.parameterAt(0).getName());
        procedureQuery.removeParameter(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryAnnotation.getParametersSize());
    }

    public void testMoveParameter() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addParameter(0).setName("FOO");
        procedureQuery.addParameter(1).setName("BAR");
        procedureQuery.addParameter(2).setName("BAZ");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getParametersSize());
        procedureQuery.moveParameter(2, 0);
        ListIterator parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.parameterAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.parameterAt(1).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.parameterAt(2).getName());
        procedureQuery.moveParameter(0, 1);
        parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.parameterAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.parameterAt(1).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.parameterAt(2).getName());
    }

    public void testUpdateParameters() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQueryAnnotation.addParameter(0).setName("FOO");
        procedureQueryAnnotation.addParameter(1).setName("BAR");
        procedureQueryAnnotation.addParameter(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryAnnotation.moveParameter(2, 0);
        this.getJpaProject().synchronizeContextModel();
        parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryAnnotation.moveParameter(0, 1);
        this.getJpaProject().synchronizeContextModel();
        parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryAnnotation.removeParameter(1);
        this.getJpaProject().synchronizeContextModel();
        parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryAnnotation.removeParameter(1);
        this.getJpaProject().synchronizeContextModel();
        parameters = procedureQuery.getParameters().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((StoredProcedureParameter2_1)parameters.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryAnnotation.removeParameter(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)procedureQuery.getParameters().iterator().hasNext());
    }

    public void testParametersSize() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getParametersSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQueryAnnotation.addParameter(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQuery.getParametersSize());
        procedureQueryAnnotation.addParameter(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQuery.getParametersSize());
        procedureQueryAnnotation.removeParameter(0);
        procedureQueryAnnotation.removeParameter(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getParametersSize());
    }

    public void testAddResultClass() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultClass("Employee");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultClassAt(0));
        procedureQuery.addResultClass("Address");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultClassAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultClassAt(1));
        procedureQuery.addResultClass(1, "Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultClassAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultClassAt(1));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultClassAt(2));
        ListIterator resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
    }

    public void testRemoveResultClass() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultClass("Employee");
        procedureQuery.addResultClass("Address");
        procedureQuery.addResultClass("Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getResultClassesSize());
        procedureQuery.removeResultClass(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryAnnotation.getResultClassesSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultClassAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultClassAt(1));
        procedureQuery.removeResultClass("Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryAnnotation.getResultClassesSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultClassAt(0));
        procedureQuery.removeResultClass(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryAnnotation.getResultClassesSize());
    }

    public void testMoveResultClass() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultClass("Employee");
        procedureQuery.addResultClass("Address");
        procedureQuery.addResultClass("Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getResultClassesSize());
        procedureQuery.moveResultClass(2, 0);
        ListIterator resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultClassAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultClassAt(1));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultClassAt(2));
        procedureQuery.moveResultClass(0, 1);
        resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultClassAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultClassAt(1));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultClassAt(2));
    }

    public void testUpdateResultClass() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultClass("Employee");
        procedureQuery.addResultClass("Address");
        procedureQuery.addResultClass("Project");
        this.getJpaProject().synchronizeContextModel();
        ListIterator resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryAnnotation.moveResultClass(2, 0);
        this.getJpaProject().synchronizeContextModel();
        resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryAnnotation.moveResultClass(0, 1);
        this.getJpaProject().synchronizeContextModel();
        resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryAnnotation.removeResultClass(1);
        this.getJpaProject().synchronizeContextModel();
        resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryAnnotation.removeResultClass(1);
        this.getJpaProject().synchronizeContextModel();
        resultClasses = procedureQuery.getResultClasses().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryAnnotation.removeResultClass(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)procedureQuery.getResultClasses().iterator().hasNext());
    }

    public void testResultClassesSize() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getResultClassesSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQueryAnnotation.addResultClass("Employee");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQuery.getResultClassesSize());
        procedureQueryAnnotation.addResultClass(0, "Address");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQuery.getResultClassesSize());
        procedureQueryAnnotation.removeResultClass(0);
        procedureQueryAnnotation.removeResultClass(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getResultClassesSize());
    }

    public void testAddResultSetMapping() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultSetMapping("Employee");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultSetMappingAt(0));
        procedureQuery.addResultSetMapping("Address");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultSetMappingAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultSetMappingAt(1));
        procedureQuery.addResultSetMapping(1, "Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultSetMappingAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultSetMappingAt(1));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultSetMappingAt(2));
        ListIterator resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMapping.next()));
    }

    public void testRemoveResultSetMapping() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultSetMapping("Employee");
        procedureQuery.addResultSetMapping("Address");
        procedureQuery.addResultSetMapping("Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getResultSetMappingsSize());
        procedureQuery.removeResultSetMapping(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryAnnotation.getResultSetMappingsSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultSetMappingAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultSetMappingAt(1));
        procedureQuery.removeResultSetMapping("Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryAnnotation.getResultSetMappingsSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultSetMappingAt(0));
        procedureQuery.removeResultSetMapping(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryAnnotation.getResultSetMappingsSize());
    }

    public void testMoveResultSetMapping() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultSetMapping("Employee");
        procedureQuery.addResultSetMapping("Address");
        procedureQuery.addResultSetMapping("Project");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getResultSetMappingsSize());
        procedureQuery.moveResultSetMapping(2, 0);
        ListIterator resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultSetMappingAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultSetMappingAt(1));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultSetMappingAt(2));
        procedureQuery.moveResultSetMapping(0, 1);
        resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)procedureQueryAnnotation.resultSetMappingAt(0));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)procedureQueryAnnotation.resultSetMappingAt(1));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)procedureQueryAnnotation.resultSetMappingAt(2));
    }

    public void testUpdateResultSetMapping() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addResultSetMapping("Employee");
        procedureQuery.addResultSetMapping("Address");
        procedureQuery.addResultSetMapping("Project");
        this.getJpaProject().synchronizeContextModel();
        ListIterator resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMapping.hasNext());
        procedureQueryAnnotation.moveResultSetMapping(2, 0);
        this.getJpaProject().synchronizeContextModel();
        resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMapping.hasNext());
        procedureQueryAnnotation.moveResultSetMapping(0, 1);
        this.getJpaProject().synchronizeContextModel();
        resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMapping.hasNext());
        procedureQueryAnnotation.removeResultSetMapping(1);
        this.getJpaProject().synchronizeContextModel();
        resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMapping.hasNext());
        procedureQueryAnnotation.removeResultSetMapping(1);
        this.getJpaProject().synchronizeContextModel();
        resultSetMapping = procedureQuery.getResultSetMappings().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMapping.next()));
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMapping.hasNext());
        procedureQueryAnnotation.removeResultSetMapping(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)procedureQuery.getResultSetMappings().iterator().hasNext());
    }

    public void testResultSetMappingsSize() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getResultSetMappingsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQueryAnnotation.addResultSetMapping("Employee");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQuery.getResultSetMappingsSize());
        procedureQueryAnnotation.addResultSetMapping(0, "Address");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQuery.getResultSetMappingsSize());
        procedureQueryAnnotation.removeResultSetMapping(0);
        procedureQueryAnnotation.removeResultSetMapping(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getResultSetMappingsSize());
    }

    public void testAddHint() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        QueryHint queryHint = procedureQuery.addHint(0);
        queryHint.setName("FOO");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.hintAt(0).getName());
        QueryHint queryHint2 = procedureQuery.addHint(0);
        queryHint2.setName("BAR");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.hintAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.hintAt(1).getName());
        QueryHint queryHint3 = procedureQuery.addHint(1);
        queryHint3.setName("BAZ");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.hintAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.hintAt(1).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.hintAt(2).getName());
        ListIterator hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((Object)queryHint2, hints.next());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((Object)queryHint3, hints.next());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((Object)queryHint, hints.next());
        hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
    }

    public void testRemoveHint() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addHint(0).setName("FOO");
        procedureQuery.addHint(1).setName("BAR");
        procedureQuery.addHint(2).setName("BAZ");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getHintsSize());
        procedureQuery.removeHint(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryAnnotation.getHintsSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.hintAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.hintAt(1).getName());
        procedureQuery.removeHint(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryAnnotation.getHintsSize());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.hintAt(0).getName());
        procedureQuery.removeHint(0);
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryAnnotation.getHintsSize());
    }

    public void testMoveHint() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQuery.addHint(0).setName("FOO");
        procedureQuery.addHint(1).setName("BAR");
        procedureQuery.addHint(2).setName("BAZ");
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryAnnotation.getHintsSize());
        procedureQuery.moveHint(2, 0);
        ListIterator hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.hintAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.hintAt(1).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.hintAt(2).getName());
        procedureQuery.moveHint(0, 1);
        hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)procedureQueryAnnotation.hintAt(0).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)procedureQueryAnnotation.hintAt(1).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)procedureQueryAnnotation.hintAt(2).getName());
    }

    public void testUpdateHints() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQueryAnnotation.addHint(0).setName("FOO");
        procedureQueryAnnotation.addHint(1).setName("BAR");
        procedureQueryAnnotation.addHint(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryAnnotation.moveHint(2, 0);
        this.getJpaProject().synchronizeContextModel();
        hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryAnnotation.moveHint(0, 1);
        this.getJpaProject().synchronizeContextModel();
        hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryAnnotation.removeHint(1);
        this.getJpaProject().synchronizeContextModel();
        hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryAnnotation.removeHint(1);
        this.getJpaProject().synchronizeContextModel();
        hints = procedureQuery.getHints().iterator();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((QueryHint)hints.next()).getName());
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryAnnotation.removeHint(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)procedureQuery.getHints().iterator().hasNext());
    }

    public void testHintsSize() throws Exception {
        this.createTestEntityWithNamedStoredProcedureQuery();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        NamedStoredProcedureQuery2_1 procedureQuery = (NamedStoredProcedureQuery2_1)((QueryContainer2_1)entity.getQueryContainer()).getNamedStoredProcedureQueries().iterator().next();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getHintsSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        NamedStoredProcedureQueryAnnotation2_1 procedureQueryAnnotation = (NamedStoredProcedureQueryAnnotation2_1)resourceType.getAnnotation(0, "javax.persistence.NamedStoredProcedureQuery");
        procedureQueryAnnotation.addHint(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQuery.getHintsSize());
        procedureQueryAnnotation.addHint(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQuery.getHintsSize());
        procedureQueryAnnotation.removeHint(0);
        procedureQueryAnnotation.removeHint(0);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQuery.getHintsSize());
    }
}

