/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.platform;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpa.core.tests.extension.resource.JavaTestAttributeMapping;
import org.eclipse.jpt.jpa.core.tests.extension.resource.JavaTestAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.tests.extension.resource.JavaTestTypeMapping;
import org.eclipse.jpt.jpa.core.tests.extension.resource.JavaTestTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.tests.extension.resource.TestExtensionPlugin;
import org.eclipse.jpt.jpa.core.tests.extension.resource.TestJavaBasicMapping;
import org.eclipse.jpt.jpa.core.tests.extension.resource.TestJavaEntity;
import org.eclipse.jpt.jpa.core.tests.extension.resource.TestJpaFactory;
import org.eclipse.jpt.jpa.core.tests.extension.resource.TestJpaPlatformProvider;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.jpa.core.tests.internal.platform.JpaPlatformExtensionTests;
import org.eclipse.jpt.jpa.core.tests.internal.projects.JpaProjectTestHarness;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaPlatformTests
extends ContextModelTestCase {
    protected JpaProjectTestHarness jpaProjectTestHarness;
    public static final String TEST_PLUGIN_CLASS = TestExtensionPlugin.class.getName();
    public static final String TEST_PLUGIN_ID = "org.eclipse.jpt.jpa.core.tests.extension.resource";
    public static final String TEST_PLATFORM_CLASS_NAME = TestJpaPlatformProvider.class.getName();
    public static final String TEST_PLATFORM_LABEL = "Test Jpa Platform";
    public static final String TEST_JPA_FACTORY = TestJpaFactory.class.getName();
    public static final String TEST_TYPE_MAPPING_PROVIDER_CLASS = JavaTestTypeMappingDefinition.class.getName();
    public static final String TEST_ATTRIBUTE_MAPPING_PROVIDER_CLASS = JavaTestAttributeMappingDefinition.class.getName();

    public JpaPlatformTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JpaPlatformExtensionTests.verifyExtensionTestProjectExists();
    }

    protected JavaProjectTestHarness buildJavaProjectTestHarness(boolean autoBuild) throws Exception {
        return super.buildJpaProjectTestHarness("AnnotationTestProject", autoBuild, this.buildConfig());
    }

    protected IDataModel buildConfig() throws Exception {
        JpaFacetInstallDataModelProvider configFactory = new JpaFacetInstallDataModelProvider();
        IDataModel config = (IDataModel)configFactory.create();
        config.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.0");
        config.setProperty("JpaFacetDataModelProperties.PLATFORM", (Object)this.getJpaPlatformManager().getJpaPlatform("core.testJpaPlatform"));
        return config;
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    protected JpaPlatform jpaPlatform() {
        return this.getJpaProject().getJpaPlatform();
    }

    public void testJpaFactory() {
        JpaPlatformTests.assertTrue((boolean)this.jpaPlatform().getJpaFactory().getClass().getName().equals(TEST_JPA_FACTORY));
    }

    public void testBuildJavaTypeMappingFromMappingKey() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaPersistentType().setMappingKey("test");
        JavaTypeMapping mapping = this.getJavaPersistentType().getMapping();
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof JavaTestTypeMapping));
        this.getJavaPersistentType().setMappingKey("entity");
        mapping = this.getJavaPersistentType().getMapping();
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof TestJavaEntity));
    }

    public void testBuildJavaAttributeMappingFromMappingKey() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute javaAttribute = this.getJavaPersistentType().getAttributeNamed("name");
        javaAttribute.setMappingKey("testAttribute");
        JavaAttributeMapping mapping = javaAttribute.getMapping();
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof JavaTestAttributeMapping));
        javaAttribute.setMappingKey("basic");
        mapping = javaAttribute.getMapping();
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof TestJavaBasicMapping));
    }
}

