/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.projects;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaProjectTestHarness
extends JavaProjectTestHarness {
    public static final String JPA_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.jpa.jar";
    public static final String ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.eclipselink.jar";

    public JpaProjectTestHarness(String projectName) throws CoreException {
        this(projectName, false);
    }

    public JpaProjectTestHarness(String projectName, boolean autoBuild) throws CoreException {
        this(projectName, autoBuild, null);
    }

    public JpaProjectTestHarness(String projectName, boolean autoBuild, IDataModel jpaConfig) throws CoreException {
        super(projectName, autoBuild);
        String jpaFacetVersion = "1.0";
        if (jpaConfig != null) {
            jpaFacetVersion = jpaConfig.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
        }
        this.installFacet("jst.utility", "1.0");
        this.installFacet("jpt.jpa", jpaFacetVersion, jpaConfig);
        this.addJar(JpaProjectTestHarness.jpaJarName());
        if (JpaProjectTestHarness.eclipseLinkJarName() != null) {
            this.addJar(JpaProjectTestHarness.eclipseLinkJarName());
        }
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
    }

    public static String jpaJarName() {
        return JpaProjectTestHarness.getSystemProperty(JPA_JAR_NAME_SYSTEM_PROPERTY);
    }

    public static String eclipseLinkJarName() {
        return JpaProjectTestHarness.getSystemProperty(ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY);
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public JpaProject getJpaProject() {
        try {
            return this.getJpaProject_();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private JpaProject getJpaProject_() throws InterruptedException {
        return this.getJpaProjectReference().getValue();
    }

    private JpaProject.Reference getJpaProjectReference() {
        return (JpaProject.Reference)this.getProject().getAdapter(JpaProject.Reference.class);
    }
}

