/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.db.ColumnCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.DatabaseObjectCombo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnComposite
extends Pane<Column> {
    static final Collection<String> COLUMN_PICK_LIST_PROPERTIES = Arrays.asList("defaultTable", "specifiedTableName");

    public ColumnComposite(Pane<?> parentPane, PropertyValueModel<? extends Column> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    private ColumnCombo<Column> addColumnCombo(Composite container) {
        return new ColumnCombo<Column>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.addAll(COLUMN_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (COLUMN_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((Column)this.getSubject()).getDefaultName();
            }

            protected void setValue(String value) {
                ((SpecifiedColumn)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                Column column = (Column)this.getSubject();
                return column == null ? null : column.getDbTable();
            }

            protected String getValue() {
                return ((Column)this.getSubject()).getSpecifiedName();
            }

            protected String buildNullDefaultValueEntry() {
                return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)JptCommonUiMessages.NONE_SELECTED);
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN;
            }

            public String toString() {
                return "ColumnComposite.columnCombo";
            }
        };
    }

    ModifiablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<Column, String>(this.getSubjectHolder(), new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((Column)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((SpecifiedColumn)this.subject).setColumnDefinition(value);
            }
        };
    }

    ModifiablePropertyValueModel<Boolean> buildInsertableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedInsertable();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedInsertable(value);
            }
        };
    }

    PropertyValueModel<String> buildInsertableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultInsertableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_INSERTABLE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_INSERTABLE;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultInsertableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable", "defaultInsertable"}){

            protected Boolean buildValue_() {
                if (((Column)this.subject).getSpecifiedInsertable() != null) {
                    return null;
                }
                return ((Column)this.subject).isDefaultInsertable();
            }
        };
    }

    ModifiablePropertyValueModel<Boolean> buildNullableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedNullable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedNullable();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedNullable(value);
            }
        };
    }

    PropertyValueModel<String> buildNullableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultNullableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NULLABLE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NULLABLE;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultNullableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedNullable", "defaultNullable"}){

            protected Boolean buildValue_() {
                if (((Column)this.subject).getSpecifiedNullable() != null) {
                    return null;
                }
                return ((Column)this.subject).isDefaultNullable();
            }
        };
    }

    private Pane<Column> addTableCombo(Composite container) {
        return new DatabaseObjectCombo<Column>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTableName");
            }

            protected String getDefaultValue() {
                return ((Column)this.getSubject()).getDefaultTableName();
            }

            protected void setValue(String value) {
                ((SpecifiedColumn)this.getSubject()).setSpecifiedTableName(value);
            }

            protected String getValue() {
                return ((Column)this.getSubject()).getSpecifiedTableName();
            }

            @Override
            protected Iterable<String> getValues_() {
                Column column = (Column)this.getSubject();
                return column != null ? column.getCandidateTableNames() : EmptyIterable.instance();
            }

            protected String buildNullDefaultValueEntry() {
                return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)JptCommonUiMessages.NONE_SELECTED);
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_TABLE;
            }

            public String toString() {
                return "ColumnComposite.tableCombo";
            }
        };
    }

    ModifiablePropertyValueModel<Boolean> buildUniqueHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUnique"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUnique();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedUnique(value);
            }
        };
    }

    PropertyValueModel<String> buildUniqueStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultUniqueHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UNIQUE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UNIQUE;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultUniqueHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUnique", "defaultUnique"}){

            protected Boolean buildValue_() {
                if (((Column)this.subject).getSpecifiedUnique() != null) {
                    return null;
                }
                return ((Column)this.subject).isDefaultUnique();
            }
        };
    }

    ModifiablePropertyValueModel<Boolean> buildUpdatableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"defaultUpdatable", "specifiedUpdatable"}){

            protected Boolean buildValue_() {
                return ((Column)this.subject).getSpecifiedUpdatable();
            }

            protected void setValue_(Boolean value) {
                ((SpecifiedColumn)this.subject).setSpecifiedUpdatable(value);
            }
        };
    }

    PropertyValueModel<String> buildUpdatableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultUpdatableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UPDATABLE_WITH_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UPDATABLE;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultUpdatableHolder() {
        return new PropertyAspectAdapter<Column, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUpdatable", "defaultUpdatable"}){

            protected Boolean buildValue_() {
                if (((Column)this.subject).getSpecifiedUpdatable() != null) {
                    return null;
                }
                return ((Column)this.subject).isDefaultUpdatable();
            }
        };
    }

    protected Composite addComposite(Composite parent) {
        return this.addTitledGroup(parent, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_COLUMN_SECTION, 2, null);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NAME);
        this.addColumnCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_TABLE);
        this.addTableCombo(container);
        final Section detailsSection = this.getWidgetFactory().createSection(container, 18);
        detailsSection.setLayoutData((Object)new GridData(768));
        detailsSection.setText(JptJpaUiDetailsMessages.COLUMN_COMPOSITE_DETAILS);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        detailsSection.setLayoutData((Object)gridData);
        detailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState() && detailsSection.getClient() == null) {
                    detailsSection.setClient((Control)ColumnComposite.this.initializeDetailsSection((Composite)detailsSection));
                }
            }
        });
    }

    protected Composite initializeDetailsSection(Composite container) {
        Composite detailsClient = this.addSubPane(container, 2, 0, 0, 0, 0);
        TriStateCheckBox insertableCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_INSERTABLE, this.buildInsertableHolder(), this.buildInsertableStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_INSERTABLE);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        insertableCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox updatableCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UPDATABLE, this.buildUpdatableHolder(), this.buildUpdatableStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_UPDATABLE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        updatableCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox uniqueCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_UNIQUE, this.buildUniqueHolder(), this.buildUniqueStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_UNIQUE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        uniqueCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox nullableCheckBox = this.addTriStateCheckBoxWithDefault(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_NULLABLE, this.buildNullableHolder(), this.buildNullableStringHolder(), JpaHelpContextIds.MAPPING_COLUMN_NULLABLE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        nullableCheckBox.getCheckBox().setLayoutData((Object)gridData);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_LENGTH);
        this.addLengthCombo(detailsClient);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_PRECISION);
        this.addPrecisionCombo(detailsClient);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_SCALE);
        this.addScaleCombo(detailsClient);
        this.addLabel(detailsClient, JptJpaUiDetailsMessages.COLUMN_COMPOSITE_COLUMN_DEFINITION);
        this.addText(detailsClient, this.buildColumnDefinitionHolder());
        return detailsClient;
    }

    private void addLengthCombo(Composite container) {
        new IntegerCombo<Column>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_LENGTH;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultLength"}){

                    protected Integer buildValue_() {
                        return ((Column)this.subject).getDefaultLength();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedLength"}){

                    protected Integer buildValue_() {
                        return ((Column)this.subject).getSpecifiedLength();
                    }

                    protected void setValue_(Integer value) {
                        ((SpecifiedColumn)this.subject).setSpecifiedLength(value);
                    }
                };
            }
        };
    }

    private void addPrecisionCombo(Composite container) {
        new IntegerCombo<Column>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_PRECISION;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultPrecision"}){

                    protected Integer buildValue_() {
                        return ((Column)this.subject).getDefaultPrecision();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedPrecision"}){

                    protected Integer buildValue_() {
                        return ((Column)this.subject).getSpecifiedPrecision();
                    }

                    protected void setValue_(Integer value) {
                        ((SpecifiedColumn)this.subject).setSpecifiedPrecision(value);
                    }
                };
            }
        };
    }

    private void addScaleCombo(Composite container) {
        new IntegerCombo<Column>((Pane)this, container){

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_COLUMN_SCALE;
            }

            protected PropertyValueModel<Integer> buildDefaultHolder() {
                return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"defaultScale"}){

                    protected Integer buildValue_() {
                        return ((Column)this.subject).getDefaultScale();
                    }
                };
            }

            protected ModifiablePropertyValueModel<Integer> buildSelectedItemHolder() {
                return new PropertyAspectAdapter<Column, Integer>(this.getSubjectHolder(), new String[]{"specifiedScale"}){

                    protected Integer buildValue_() {
                        return ((Column)this.subject).getSpecifiedScale();
                    }

                    protected void setValue_(Integer value) {
                        ((SpecifiedColumn)this.subject).setSpecifiedScale(value);
                    }
                };
            }
        };
    }
}

