/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.ui.internal.utility.SynchronousUiCommandContext;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.context.JpaContextRoot;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaSourceFileDefinition;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmXmlDefinition;
import org.eclipse.jpt.jpa.core.resource.ResourceMappingFile;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.jface.XmlMappingFileViewerFilter;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.SelectMappingFileDialog;
import org.eclipse.jpt.jpa.ui.internal.wizards.orm.EmbeddedMappingFileWizard;
import org.eclipse.jpt.jpa.ui.wizards.entity.JptJpaUiWizardsEntityMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaMakePersistentWizardPage
extends WizardPage {
    private TableViewer classTableViewer;
    private final String helpContextId;
    private final TypeConfig[] selectedTypes;
    final JpaProject jpaProject;
    private JptResourceType jptResourceType;
    private final ModifiablePropertyValueModel<Boolean> annotateInJavaModel;
    private boolean isFirstCheck = true;
    private final ModifiablePropertyValueModel<String> mappingFileModel;
    private final ModifiablePropertyValueModel<Boolean> listInPersistenceXmlModel;
    final ResourceManager resourceManager;
    private static final int TABLE_HEIGHT = 250;
    private static final int TABLE_WIDTH = 300;
    private static String MAKE_PERSISTENT_PAGE_NAME = "MakePersistent";

    protected JpaMakePersistentWizardPage(JpaProject jpaProject, Set<IType> selectedJdtTypes, ResourceManager resourceManager, String helpContextId) {
        super(MAKE_PERSISTENT_PAGE_NAME);
        this.jpaProject = jpaProject;
        this.selectedTypes = this.buildSelectedTypes(selectedJdtTypes);
        this.resourceManager = resourceManager;
        this.jptResourceType = JavaSourceFileDefinition.instance().getResourceType();
        this.helpContextId = helpContextId;
        this.annotateInJavaModel = new SimplePropertyValueModel((Object)Boolean.TRUE);
        this.mappingFileModel = new SimplePropertyValueModel();
        this.listInPersistenceXmlModel = new SimplePropertyValueModel((Object)(!this.jpaProject.discoversAnnotatedClasses() ? 1 : 0));
        this.setTitle(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_TITLE);
        this.setMessage(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_MESSAGE);
    }

    protected TypeConfig[] buildSelectedTypes(Set<IType> selectedJdtTypes) {
        return (TypeConfig[])ArrayTools.array(this.buildSelectedTypesIterable(selectedJdtTypes), TypeConfig.class);
    }

    protected Iterable<TypeConfig> buildSelectedTypesIterable(Set<IType> selectedJdtTypes) {
        return new TransformationIterable(this.filterNonPersistentJdtTypes(selectedJdtTypes), (Transformer)new JdtTypeTransformer());
    }

    protected Iterable<IType> filterNonPersistentJdtTypes(Set<IType> selectedJdtTypes) {
        return IterableTools.filter(selectedJdtTypes, (Predicate)new JdtTypeIsNonPersistent());
    }

    protected JpaPlatformUi getJpaPlatformUi() {
        return (JpaPlatformUi)this.jpaProject.getJpaPlatform().getAdapter(JpaPlatformUi.class);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 1;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        Button javaAnnotationButton = new Button(composite, 16);
        javaAnnotationButton.setText(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_ANNOTATE_IN_JAVA_RADIO_BUTTON);
        javaAnnotationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.annotateInJavaModel.setValue((Object)Boolean.TRUE);
                JpaMakePersistentWizardPage.this.jptResourceType = JavaSourceFileDefinition.instance().getResourceType();
                JpaMakePersistentWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button mappingFileButton = new Button(composite, 16);
        mappingFileButton.setText(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_MAPPING_FILE_RADIO_BUTTON);
        Composite mappingFileComposite = this.createMappingFileControl(composite);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        mappingFileComposite.setLayoutData((Object)data);
        mappingFileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.annotateInJavaModel.setValue((Object)Boolean.FALSE);
                if (JpaMakePersistentWizardPage.this.isFirstCheck) {
                    JpaMakePersistentWizardPage.this.mappingFileModel.setValue((Object)"META-INF/orm.xml");
                    JpaMakePersistentWizardPage.this.isFirstCheck = false;
                }
                JpaMakePersistentWizardPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.classTableViewer = new TableViewer(composite, 68352);
        this.classTableViewer.getTable().setLinesVisible(true);
        this.classTableViewer.getTable().setHeaderVisible(true);
        this.classTableViewer.setContentProvider((IContentProvider)new TypeContentProvider());
        this.classTableViewer.setComparator((ViewerComparator)new TypeComparator());
        this.createTypeTableColumn();
        this.createMappingTableColumn();
        this.classTableViewer.setInput((Object)this.selectedTypes);
        data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.classTableViewer.getTable().setLayoutData((Object)data);
        Button persistenceXmlCheckBox = new Button(composite, 32);
        persistenceXmlCheckBox.setText(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_LIST_IN_PERSISTENCE_XML_CHECK_BOX);
        SWTBindingTools.bind(this.listInPersistenceXmlModel, (Button)persistenceXmlCheckBox);
        SWTBindingTools.bindVisibleState(this.annotateInJavaModel, (Control[])new Control[]{persistenceXmlCheckBox});
        this.setControl((Control)composite);
    }

    private Composite createMappingFileControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginLeft = 10;
        composite.setLayout((Layout)layout);
        Link mappingFileLink = new Link(composite, 16384);
        mappingFileLink.setText(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_MAPPING_FILE_LINK);
        mappingFileLink.setLayoutData((Object)new GridData(32));
        mappingFileLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.openNewMappingFileWizard();
            }
        });
        Text mappingFileText = this.createText(composite, 1);
        SWTBindingTools.bind(this.mappingFileModel, (Text)mappingFileText);
        this.mappingFileModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                JptXmlResource ormXmlResource = JpaMakePersistentWizardPage.this.getOrmXmlResource();
                if (ormXmlResource == null) {
                    JpaMakePersistentWizardPage.this.jptResourceType = GenericOrmXmlDefinition.instance().getResourceType();
                } else {
                    JpaMakePersistentWizardPage.this.jptResourceType = ormXmlResource.getResourceType();
                }
                JpaMakePersistentWizardPage.this.validate();
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_MAPPING_FILE_BROWSE_BUTTON);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JpaMakePersistentWizardPage.this.mappingFileBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SWTBindingTools.bindEnabledState((PropertyValueModel)new ListInOrmMappingFileModel((PropertyValueModel<Boolean>)this.annotateInJavaModel), (Control[])new Control[]{mappingFileLink, mappingFileText, browseButton});
        return composite;
    }

    private Text createText(Composite container, int span) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gd);
        return text;
    }

    private void mappingFileBrowseButtonPressed() {
        ViewerFilter filter = this.buildMappingFileDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        SelectMappingFileDialog dialog = new SelectMappingFileDialog(this.getShell(), this.jpaProject.getProject(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(JptJpaUiWizardsEntityMessages.MAPPING_XML_TITLE);
        dialog.setMessage(JptJpaUiWizardsEntityMessages.CHOOSE_MAPPING_XML_MESSAGE);
        dialog.addFilter(filter);
        JptXmlResource resource = this.jpaProject.getMappingFileXmlResource((IPath)new Path(this.getMappingFileLocation()));
        IFile initialSelection = resource != null ? resource.getFile() : null;
        dialog.setInput(this.jpaProject.getProject());
        if (initialSelection != null) {
            dialog.setInitialSelection(initialSelection);
        }
        if (dialog.open() == 0) {
            this.mappingFileModel.setValue((Object)dialog.getChosenName());
            this.validate();
        }
    }

    protected ViewerFilter buildMappingFileDialogViewerFilter() {
        return new XmlMappingFileViewerFilter(this.jpaProject, ResourceMappingFile.Root.CONTENT_TYPE);
    }

    private void openNewMappingFileWizard() {
        IPath path = EmbeddedMappingFileWizard.createNewMappingFile((IStructuredSelection)new StructuredSelection((Object)this.jpaProject.getProject()), this.getMappingFileName());
        if (path != null) {
            this.mappingFileModel.setValue((Object)path.toString());
            this.validate();
        }
    }

    protected void createTypeTableColumn() {
        TableViewerColumn column = new TableViewerColumn(this.classTableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_TYPE_TABLE_COLUMN);
        column.setLabelProvider((CellLabelProvider)this.buildTypeColumnLabelProvider());
    }

    protected ColumnLabelProvider buildTypeColumnLabelProvider() {
        return new TypeColumnLabelProvider();
    }

    protected void createMappingTableColumn() {
        TableViewerColumn column = new TableViewerColumn(this.classTableViewer, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_MAPPING_TABLE_COLUMN);
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.classTableViewer){

            protected Object getValue(Object element) {
                return JpaMakePersistentWizardPage.this.getMappingUiDefinition(((TypeConfig)element).mappingKey);
            }

            protected void setValue(Object element, Object value) {
                ((TypeConfig)element).setMappingKey(((MappingUiDefinition)value).getKey());
                this.getViewer().update(element, null);
            }

            protected CellEditor getCellEditor(Object element) {
                ComboBoxViewerCellEditor comboCellEditor = new ComboBoxViewerCellEditor((Composite)JpaMakePersistentWizardPage.this.classTableViewer.getControl());
                comboCellEditor.setLabelProvider((IBaseLabelProvider)JpaMakePersistentWizardPage.this.buildMappingComboCellEditorLabelProvider());
                comboCellEditor.setContentProvider(JpaMakePersistentWizardPage.this.buildMappingComboCellEditorContentProvider());
                comboCellEditor.setInput(element);
                return comboCellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        column.setLabelProvider((CellLabelProvider)this.buildMappingColumnLabelProvider());
    }

    protected ColumnLabelProvider buildMappingComboCellEditorLabelProvider() {
        return new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((MappingUiDefinition)element).getLabel();
            }
        };
    }

    protected IStructuredContentProvider buildMappingComboCellEditorContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ArrayTools.array(((TypeConfig)inputElement).getTypeMappingUiDefinitions());
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    protected ColumnLabelProvider buildMappingColumnLabelProvider() {
        return new MappingColumnLabelProvider();
    }

    protected MappingUiDefinition getMappingUiDefinition(String mappingKey) {
        JpaPlatformUi ui = this.getJpaPlatformUi();
        return ui == null ? null : ui.getTypeMappingUiDefinition(this.jptResourceType, mappingKey);
    }

    protected Iterable<String> typeMappingKeys(Iterable<? extends MappingUiDefinition> mappingUiDefinitions) {
        return IterableTools.transform(mappingUiDefinitions, MappingUiDefinition.KEY_TRANSFORMER);
    }

    protected void validate() {
        String errorMessage = null;
        if (this.selectedTypes.length == 0) {
            errorMessage = JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_SELECTED_TYPES_PERSISTENT_ERROR;
        } else if (this.isAddToOrmMappingFile()) {
            JptXmlResource ormXmlResource = this.getOrmXmlResource();
            if (ormXmlResource == null) {
                errorMessage = JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_MAPPING_FILE_DOES_NOT_EXIST_ERROR;
            } else if (this.jpaProject.getJpaFile(ormXmlResource.getFile()).getRootStructureNodesSize() == 0) {
                errorMessage = JptJpaUiMessages.JPA_MAKE_PERSISTENT_WIZARD_PAGE_MAPPING_FILE_NOT_LISTED_IN_PERSISTENCE_XML_ERROR;
            }
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public final void performHelp() {
        WorkbenchTools.displayHelp((String)this.helpContextId);
    }

    protected void performFinish() throws InvocationTargetException {
        if (this.isAddToOrmMappingFile()) {
            this.performAddToOrmXml();
        } else {
            this.performAnnotateInJava();
        }
    }

    private void performAddToOrmXml() throws InvocationTargetException {
        this.perform(new AddToOrmXmlRunnable(this.jpaProject, this.getOrmXmlResource(), this.selectedTypes));
        try {
            this.openEditor(this.getOrmXmlResource().getFile());
        }
        catch (Exception cantOpen) {
            throw new InvocationTargetException(cantOpen);
        }
    }

    private void performAnnotateInJava() {
        this.perform(new AnnotateInJavaRunnable(this.jpaProject, this.selectedTypes, this.isListInPersistenceXml()));
    }

    private void perform(IRunnableWithProgress runnable) {
        try {
            this.buildProgressMonitorDialog().run(true, true, runnable);
        }
        catch (InvocationTargetException ex) {
            JptJpaUiPlugin.instance().logError(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            JptJpaUiPlugin.instance().logError(ex);
        }
    }

    private ProgressMonitorDialog buildProgressMonitorDialog() {
        return new ProgressMonitorDialog(null);
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = WorkbenchTools.getActivePage();
                        if (page != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                    }
                    catch (PartInitException e) {
                        JptJpaUiPlugin.instance().logError(e);
                    }
                }
            });
        }
    }

    protected JptXmlResource getOrmXmlResource() {
        return this.jpaProject.getMappingFileXmlResource((IPath)new Path(this.getMappingFileLocation()));
    }

    protected boolean isListInPersistenceXml() {
        return (Boolean)this.listInPersistenceXmlModel.getValue();
    }

    protected boolean isAnnotateInJavaModel() {
        return (Boolean)this.annotateInJavaModel.getValue();
    }

    protected boolean isAddToOrmMappingFile() {
        return !this.isAnnotateInJavaModel();
    }

    protected String getMappingFileLocation() {
        return (String)this.mappingFileModel.getValue();
    }

    protected String getMappingFileName() {
        return new File(this.getMappingFileLocation()).getName();
    }

    static class AddToOrmXmlCommand
    implements Command {
        private final EntityMappings entityMappings;
        private final PersistentType.Config[] selectedTypeConfigs;
        private final IProgressMonitor monitor;

        AddToOrmXmlCommand(EntityMappings entityMappings, PersistentType.Config[] selectedTypeConfigs, IProgressMonitor monitor) {
            this.entityMappings = entityMappings;
            this.selectedTypeConfigs = selectedTypeConfigs;
            this.monitor = monitor;
        }

        public void execute() {
            this.entityMappings.addPersistentTypes(this.selectedTypeConfigs, this.monitor);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object[])this.selectedTypeConfigs);
        }
    }

    static class AddToOrmXmlRunnable
    implements IRunnableWithProgress {
        private final JpaProject jpaProject;
        private final JptXmlResource ormXmlResource;
        private final PersistentType.Config[] selectedTypeConfigs;

        AddToOrmXmlRunnable(JpaProject jpaProject, JptXmlResource ormXmlResource, PersistentType.Config[] selectedTypeConfigs) {
            this.jpaProject = jpaProject;
            this.ormXmlResource = ormXmlResource;
            this.selectedTypeConfigs = selectedTypeConfigs;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.run_(monitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private void run_(IProgressMonitor monitor) throws CoreException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)this.ormXmlResource.getFile());
            workspace.run((IWorkspaceRunnable)new AddToOrmXmlWorkspaceRunnable(this.jpaProject, this.ormXmlResource, this.selectedTypeConfigs), rule, 1, monitor);
        }
    }

    static class AddToOrmXmlWorkspaceRunnable
    implements IWorkspaceRunnable {
        private final JpaProject jpaProject;
        private final JptXmlResource ormXmlResource;
        private final PersistentType.Config[] selectedTypeConfigs;

        AddToOrmXmlWorkspaceRunnable(JpaProject jpaProject, JptXmlResource ormXmlResource, PersistentType.Config[] selectedTypeConfigs) {
            this.jpaProject = jpaProject;
            this.ormXmlResource = ormXmlResource;
            this.selectedTypeConfigs = selectedTypeConfigs;
        }

        public void run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return;
            }
            JpaProjectManager jpaProjectManager = this.getJpaProjectManager();
            if (jpaProjectManager == null) {
                return;
            }
            AddToOrmXmlCommand addToOrmXmlCommand = new AddToOrmXmlCommand(this.getEntityMappings(), this.selectedTypeConfigs, monitor);
            try {
                jpaProjectManager.execute((Command)addToOrmXmlCommand, SynchronousUiCommandContext.instance());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
            this.ormXmlResource.save();
        }

        protected EntityMappings getEntityMappings() {
            return (EntityMappings)this.jpaProject.getJpaFile(this.ormXmlResource.getFile()).getRootStructureNodes().iterator().next();
        }

        private JpaProjectManager getJpaProjectManager() {
            return (JpaProjectManager)this.getWorkspace().getAdapter(JpaProjectManager.class);
        }

        private IProject getProject() {
            return this.jpaProject.getProject();
        }

        private IWorkspace getWorkspace() {
            return this.getProject().getWorkspace();
        }
    }

    static class AnnotateInJavaCommand
    implements Command {
        private final PersistenceUnit persistenceUnit;
        private final PersistentType.Config[] selectedTypeConfigs;
        private final boolean listInPersistenceXml;
        private final IProgressMonitor monitor;

        AnnotateInJavaCommand(PersistenceUnit persistenceUnit, PersistentType.Config[] selectedTypeConfigs, boolean listInPersistenceXml, IProgressMonitor monitor) {
            this.persistenceUnit = persistenceUnit;
            this.selectedTypeConfigs = selectedTypeConfigs;
            this.listInPersistenceXml = listInPersistenceXml;
            this.monitor = monitor;
        }

        public void execute() {
            this.persistenceUnit.addPersistentTypes(this.selectedTypeConfigs, this.listInPersistenceXml, this.monitor);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object[])this.selectedTypeConfigs);
        }
    }

    static class AnnotateInJavaRunnable
    implements IRunnableWithProgress {
        private final JpaProject jpaProject;
        private final PersistentType.Config[] selectedTypeConfigs;
        private final boolean listInPersistenceXml;

        AnnotateInJavaRunnable(JpaProject jpaProject, PersistentType.Config[] selectedTypeConfigs, boolean listInPersistenceXml) {
            this.jpaProject = jpaProject;
            this.selectedTypeConfigs = selectedTypeConfigs;
            this.listInPersistenceXml = listInPersistenceXml;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.run_(monitor);
            }
            catch (CoreException ex) {
                throw new InvocationTargetException(ex);
            }
        }

        private void run_(IProgressMonitor monitor) throws CoreException {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)this.jpaProject.getProject());
            workspace.run((IWorkspaceRunnable)new AnnotateInJavaWorkspaceRunnable(this.jpaProject, this.selectedTypeConfigs, this.listInPersistenceXml), rule, 1, monitor);
        }
    }

    static class AnnotateInJavaWorkspaceRunnable
    implements IWorkspaceRunnable {
        private final JpaProject jpaProject;
        private final PersistentType.Config[] selectedTypeConfigs;
        private final boolean listInPersistenceXml;

        AnnotateInJavaWorkspaceRunnable(JpaProject jpaProject, PersistentType.Config[] selectedTypeConfigs, boolean listInPersistenceXml) {
            this.jpaProject = jpaProject;
            this.selectedTypeConfigs = selectedTypeConfigs;
            this.listInPersistenceXml = listInPersistenceXml;
        }

        public void run(IProgressMonitor monitor) {
            JptXmlResource persistenceXmlResource;
            if (monitor.isCanceled()) {
                return;
            }
            PersistenceUnit persistenceUnit = this.getPersistenceUnit();
            if (persistenceUnit == null) {
                return;
            }
            JpaProjectManager jpaProjectManager = this.getJpaProjectManager();
            if (jpaProjectManager == null) {
                return;
            }
            AnnotateInJavaCommand annotateInJavaCommand = new AnnotateInJavaCommand(persistenceUnit, this.selectedTypeConfigs, this.listInPersistenceXml, monitor);
            try {
                jpaProjectManager.execute((Command)annotateInJavaCommand, SynchronousUiCommandContext.instance());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
            if (this.listInPersistenceXml && (persistenceXmlResource = this.jpaProject.getPersistenceXmlResource()) != null) {
                persistenceXmlResource.save();
            }
        }

        protected PersistenceUnit getPersistenceUnit() {
            Persistence p = this.getPersistence();
            if (p == null) {
                return null;
            }
            ListIterator units = p.getPersistenceUnits().iterator();
            return units.hasNext() ? (PersistenceUnit)units.next() : null;
        }

        protected Persistence getPersistence() {
            PersistenceXml pxml = this.getPersistenceXml();
            return pxml == null ? null : pxml.getRoot();
        }

        protected PersistenceXml getPersistenceXml() {
            JpaContextRoot root = this.jpaProject.getContextRoot();
            return root == null ? null : root.getPersistenceXml();
        }

        private JpaProjectManager getJpaProjectManager() {
            return (JpaProjectManager)this.getWorkspace().getAdapter(JpaProjectManager.class);
        }

        private IProject getProject() {
            return this.jpaProject.getProject();
        }

        private IWorkspace getWorkspace() {
            return this.getProject().getWorkspace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JdtTypeIsNonPersistent
    extends PredicateAdapter<IType> {
        JdtTypeIsNonPersistent() {
        }

        public boolean evaluate(IType jdtType) {
            return this.getJpaFile(jdtType).getRootStructureNodesSize() == 0;
        }

        private JpaFile getJpaFile(IType jdtType) {
            return this.getJpaProject().getJpaFile((IFile)jdtType.getResource());
        }

        private JpaProject getJpaProject() {
            return JpaMakePersistentWizardPage.this.jpaProject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JdtTypeTransformer
    extends TransformerAdapter<IType, TypeConfig> {
        JdtTypeTransformer() {
        }

        public TypeConfig transform(IType jdtType) {
            return new TypeConfig(jdtType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListInOrmMappingFileModel
    extends AspectPropertyValueModelAdapter<Boolean, Boolean> {
        ListInOrmMappingFileModel(PropertyValueModel<Boolean> annotateInJavaModel) {
            super(annotateInJavaModel);
        }

        protected Boolean buildValue_() {
            return (Boolean)this.subject == false;
        }

        protected void engageSubject_() {
        }

        protected void disengageSubject_() {
        }
    }

    class MappingColumnLabelProvider
    extends ColumnLabelProvider {
        MappingColumnLabelProvider() {
        }

        public String getText(Object element) {
            MappingUiDefinition def = this.getMappingUiDefinition(element);
            return def == null ? null : def.getLabel();
        }

        public Image getImage(Object element) {
            ImageDescriptor descriptor = this.getImageDescriptor(element);
            return descriptor == null ? null : this.getResourceManager().createImage(descriptor);
        }

        private ImageDescriptor getImageDescriptor(Object element) {
            MappingUiDefinition def = this.getMappingUiDefinition(element);
            return def == null ? null : def.getImageDescriptor();
        }

        private MappingUiDefinition getMappingUiDefinition(Object element) {
            return JpaMakePersistentWizardPage.this.getMappingUiDefinition(((TypeConfig)element).mappingKey);
        }

        private ResourceManager getResourceManager() {
            return JpaMakePersistentWizardPage.this.resourceManager;
        }
    }

    private final class TypeColumnLabelProvider
    extends ColumnLabelProvider {
        private final JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(2320);

        private TypeColumnLabelProvider() {
        }

        public String getText(Object element) {
            return this.javaElementLabelProvider.getText((Object)((TypeConfig)element).jdtType);
        }

        public Image getImage(Object element) {
            return this.javaElementLabelProvider.getImage((Object)((TypeConfig)element).jdtType);
        }
    }

    private final class TypeComparator
    extends ViewerComparator {
        private final JavaElementComparator javaElementComparator = new JavaElementComparator();

        private TypeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.javaElementComparator.compare(viewer, (Object)((TypeConfig)e1).jdtType, (Object)((TypeConfig)e2).jdtType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TypeConfig
    implements PersistentType.Config {
        private final IType jdtType;
        String mappingKey;

        public TypeConfig(IType jdtType) {
            this.jdtType = jdtType;
            this.mappingKey = "entity";
        }

        public String getName() {
            return this.jdtType.getFullyQualifiedName();
        }

        public String getMappingKey() {
            return this.mappingKey;
        }

        protected void setMappingKey(String mappingKey) {
            this.mappingKey = mappingKey;
        }

        protected Iterable<MappingUiDefinition> getTypeMappingUiDefinitions() {
            JpaPlatformUi ui = JpaMakePersistentWizardPage.this.getJpaPlatformUi();
            return ui != null ? ui.getTypeMappingUiDefinitions(JpaMakePersistentWizardPage.this.jptResourceType) : IterableTools.emptyIterable();
        }
    }

    private final class TypeContentProvider
    implements IStructuredContentProvider {
        private TypeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (TypeConfig[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

