/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.provider;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.impl.CreateContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.palette.IPaletteCompartmentEntry;
import org.eclipse.graphiti.palette.IToolEntry;
import org.eclipse.graphiti.palette.impl.ConnectionCreationToolEntry;
import org.eclipse.graphiti.palette.impl.PaletteCompartmentEntry;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.ContextEntryHelper;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.facade.EclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickAddAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickAddElementCollectionButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickRemoveAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CollapseAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CollapseCompartmentShapeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CollapseEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateInheritedEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateIsARelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToOneBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToOneUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DeleteJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.DiscardAndRemoveAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.EmbedCollectionOfObjectsFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.EmbedSingleObjectFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ExpandAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ExpandCompartmentShapeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ExpandEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.MoveEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.OpenJPADetailsViewFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.OpenMiniatureViewFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RefactorAttributeTypeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveAndSaveEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveJPAEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RenameEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RestoreEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.SaveAndRemoveAllEntitiesFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.SaveEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.ui.PartInitException;

public class JPAEditorToolBehaviorProvider
extends DefaultToolBehaviorProvider {
    private IEclipseFacade facade;

    public JPAEditorToolBehaviorProvider(IDiagramTypeProvider dtp) {
        this(dtp, EclipseFacade.INSTANCE);
    }

    public JPAEditorToolBehaviorProvider(IDiagramTypeProvider dtp, IEclipseFacade eclipseFacade) {
        super(dtp);
        this.facade = eclipseFacade;
    }

    public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
        IContextButtonEntry button2;
        IContextButtonPadData data = super.getContextButtonPad(context);
        ContainerShape cs = null;
        PictogramElement pe = ((PictogramElementContext)context).getPictogramElement();
        Object ob = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (ob == null) {
            return null;
        }
        if (pe instanceof ContainerShape) {
            EList gas;
            cs = (ContainerShape)pe;
            GraphicsAlgorithm ga = cs.getGraphicsAlgorithm();
            if (ga instanceof Rectangle && (gas = ((Rectangle)ga).getGraphicsAlgorithmChildren()).size() > 0 && gas.get(0) instanceof Text) {
                this.setGenericContextButtons(data, pe, 0);
                ClickRemoveAttributeButtonFeature feat = this.getConcreteFeatureProvider().getClickRemoveAttributeButtonFeature();
                DeleteContext delCtx = new DeleteContext((PictogramElement)cs);
                ContextButtonEntry btn = new ContextButtonEntry((IFeature)feat, (IContext)delCtx);
                btn.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_deleteAttributeButtonlabel);
                btn.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_deleteAttributeButtonDescription);
                btn.setIconId("org.eclipse.graphiti.edit.delete");
                data.getDomainSpecificContextButtons().add(btn);
                return data;
            }
        } else {
            return data;
        }
        this.setGenericContextButtons(data, pe, CONTEXT_BUTTON_DELETE | CONTEXT_BUTTON_REMOVE);
        List buttons = data.getGenericContextButtons();
        for (IContextButtonEntry button2 : buttons) {
            if (button2.getFeature() instanceof RemoveJPAEntityFeature) {
                button2.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeEntityFromDiagramButtonLabel);
                button2.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeEntityFromDiagramButtonDescription);
                continue;
            }
            if (!(button2.getFeature() instanceof DeleteJPAEntityFeature)) continue;
            button2.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_deleteEntityFromModelButtonLabel);
            button2.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_deleteEntityFromModelButtonDescription);
        }
        button2 = null;
        if (context instanceof PictogramElementContext) {
            ClickAddAttributeButtonFeature feature = this.getConcreteFeatureProvider().getClickAddAttributeButtonFeature();
            CreateContext createCtx = new CreateContext();
            createCtx.setTargetContainer(cs);
            button2 = new ContextButtonEntry((IFeature)feature, (IContext)createCtx);
            button2.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_createAttributeButtonlabel);
            button2.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_createAttributeButtonDescription);
            button2.setIconId("org.eclipse.jpt.jpadiagrameditor.ui.add_attribute");
            data.getDomainSpecificContextButtons().add(button2);
            if (!JPAEditorUtil.checkJPAFacetVersion(this.getTargetJPAProject(), "1.0")) {
                ClickAddElementCollectionButtonFeature addCollectionfeature = this.getConcreteFeatureProvider().getClickAddElementCollectionButtonFeature();
                createCtx = new CreateContext();
                createCtx.setTargetContainer(cs);
                button2 = new ContextButtonEntry((IFeature)addCollectionfeature, (IContext)createCtx);
                button2.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_CreateElementCollectionAttributeButtonLabel);
                button2.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_CreateElementCollectionAttributeButtonDescription);
                button2.setIconId("org.eclipse.jpt.jpadiagrameditor.ui.add_element-collection.gif");
                data.getDomainSpecificContextButtons().add(button2);
            }
            PictogramElementContext c = (PictogramElementContext)context;
            RemoveAndSaveEntityFeature ft2 = new RemoveAndSaveEntityFeature(this.getFeatureProvider());
            RemoveContext remCtx = new RemoveContext(c.getPictogramElement());
            button2 = new ContextButtonEntry((IFeature)ft2, (IContext)remCtx);
            button2.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAndSaveButtonText);
            button2.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAndSaveButtonDescription);
            button2.setIconId("org.eclipse.jpt.jpadiagrameditor.ui.save_and_remove");
            data.getDomainSpecificContextButtons().add(button2);
            SaveEntityFeature ft = new SaveEntityFeature(this.getConcreteFeatureProvider());
            CustomContext ctx = new CustomContext();
            ctx.setPictogramElements(new PictogramElement[]{c.getPictogramElement()});
            button2 = new ContextButtonEntry((IFeature)ft, (IContext)ctx);
            button2.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_saveButtonText);
            button2.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_saveButtonDescription);
            button2.setIconId("org.eclipse.jpt.jpadiagrameditor.ui.save");
            data.getDomainSpecificContextButtons().add(button2);
            RestoreEntityFeature ft1 = new RestoreEntityFeature(this.getConcreteFeatureProvider());
            ctx = new CustomContext();
            ctx.setPictogramElements(new PictogramElement[]{c.getPictogramElement()});
            button2 = new ContextButtonEntry((IFeature)ft1, (IContext)ctx);
            button2.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_restoreButtonText);
            button2.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_restoreButtonDescription);
            button2.setIconId("org.eclipse.jpt.jpadiagrameditor.ui.restore");
            data.getDomainSpecificContextButtons().add(button2);
            ctx = new CustomContext(new PictogramElement[]{pe});
            IFeatureProvider featureProvider = this.getFeatureProvider();
            ICustomFeature[] customFeatures = featureProvider.getCustomFeatures((ICustomContext)ctx);
            int featureCount = customFeatures.length;
            int i = 0;
            while (i < featureCount) {
                ICustomFeature customFeature = customFeatures[i];
                if (customFeature.isAvailable((IContext)ctx)) {
                    IContextButtonEntry contextButton;
                    if (customFeature instanceof CollapseEntityFeature) {
                        contextButton = ContextEntryHelper.createCollapseContextButton((boolean)true, (IFeature)customFeature, (IContext)ctx);
                        data.setCollapseContextButton(contextButton);
                    } else if (customFeature instanceof ExpandEntityFeature) {
                        contextButton = ContextEntryHelper.createCollapseContextButton((boolean)false, (IFeature)customFeature, (IContext)ctx);
                        data.setCollapseContextButton(contextButton);
                    }
                }
                ++i;
            }
        }
        return data;
    }

    public IPaletteCompartmentEntry[] getPalette() {
        ArrayList<IPaletteCompartmentEntry> ret = new ArrayList<IPaletteCompartmentEntry>();
        IPaletteCompartmentEntry[] superCompartments = super.getPalette();
        int i = 0;
        while (i < superCompartments.length) {
            String newLabel = superCompartments[i].getLabel().equals("Objects") ? JPAEditorMessages.PaletteCompartment_Objects : JPAEditorMessages.PaletteCompartment_Connections;
            PaletteCompartmentEntry entry = new PaletteCompartmentEntry(newLabel, superCompartments[i].getIconId());
            List lst = superCompartments[i].getToolEntries();
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                entry.addToolEntry((IToolEntry)it.next());
            }
            ret.add((IPaletteCompartmentEntry)entry);
            ++i;
        }
        IPaletteCompartmentEntry en = (IPaletteCompartmentEntry)ret.get(0);
        ret.set(0, (IPaletteCompartmentEntry)ret.get(1));
        ret.set(1, en);
        this.createInheritancePaletteSection(ret, superCompartments);
        if (!JPAEditorUtil.checkJPAFacetVersion(this.getTargetJPAProject(), "1.0")) {
            this.createDerivedIdentifiersPalleteSection(ret, superCompartments);
        }
        this.createCompositionPaletteSection(ret, superCompartments);
        return ret.toArray(new IPaletteCompartmentEntry[ret.size()]);
    }

    private void createDerivedIdentifiersPalleteSection(List<IPaletteCompartmentEntry> ret, IPaletteCompartmentEntry[] superCompartments) {
        PaletteCompartmentEntry compositionEnt = new PaletteCompartmentEntry(JPAEditorMessages.JPAEditorToolBehaviorProvider_DerivedIdentifiersPalleteTitle, superCompartments[1].getIconId());
        CreateOneToOneUniDirRelationFeature oneToOneUniDirPkFt = new CreateOneToOneUniDirRelationFeature((IJPAEditorFeatureProvider)this.getFeatureProvider(), true);
        ConnectionCreationToolEntry oneToOneUniDirPkToolEntry = new ConnectionCreationToolEntry(oneToOneUniDirPkFt.getCreateName(), oneToOneUniDirPkFt.getCreateDescription(), oneToOneUniDirPkFt.getCreateImageId(), oneToOneUniDirPkFt.getCreateLargeImageId());
        oneToOneUniDirPkToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)oneToOneUniDirPkFt);
        compositionEnt.addToolEntry((IToolEntry)oneToOneUniDirPkToolEntry);
        CreateOneToOneBiDirRelationFeature oneToOneBiDirPkFt = new CreateOneToOneBiDirRelationFeature((IJPAEditorFeatureProvider)this.getFeatureProvider(), true);
        ConnectionCreationToolEntry oneToOneBiDirPkToolEntry = new ConnectionCreationToolEntry(oneToOneBiDirPkFt.getCreateName(), oneToOneBiDirPkFt.getCreateDescription(), oneToOneBiDirPkFt.getCreateImageId(), oneToOneBiDirPkFt.getCreateLargeImageId());
        oneToOneBiDirPkToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)oneToOneBiDirPkFt);
        compositionEnt.addToolEntry((IToolEntry)oneToOneBiDirPkToolEntry);
        CreateManyToOneUniDirRelationFeature manyToOneUniDirPkFt = new CreateManyToOneUniDirRelationFeature((IJPAEditorFeatureProvider)this.getFeatureProvider(), true);
        ConnectionCreationToolEntry manyToOneUniDirPkToolEntry = new ConnectionCreationToolEntry(manyToOneUniDirPkFt.getCreateName(), manyToOneUniDirPkFt.getCreateDescription(), manyToOneUniDirPkFt.getCreateImageId(), manyToOneUniDirPkFt.getCreateLargeImageId());
        manyToOneUniDirPkToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)manyToOneUniDirPkFt);
        compositionEnt.addToolEntry((IToolEntry)manyToOneUniDirPkToolEntry);
        CreateManyToOneBiDirRelationFeature manyToOneBiDirPkFt = new CreateManyToOneBiDirRelationFeature((IJPAEditorFeatureProvider)this.getFeatureProvider(), true);
        ConnectionCreationToolEntry manyToOneBiDirPkToolEntry = new ConnectionCreationToolEntry(manyToOneBiDirPkFt.getCreateName(), manyToOneBiDirPkFt.getCreateDescription(), manyToOneBiDirPkFt.getCreateImageId(), manyToOneBiDirPkFt.getCreateLargeImageId());
        manyToOneBiDirPkToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)manyToOneBiDirPkFt);
        compositionEnt.addToolEntry((IToolEntry)manyToOneBiDirPkToolEntry);
        ret.add(2, (IPaletteCompartmentEntry)compositionEnt);
    }

    private void createCompositionPaletteSection(List<IPaletteCompartmentEntry> ret, IPaletteCompartmentEntry[] superCompartments) {
        boolean isJPA10Project = JPAEditorUtil.checkJPAFacetVersion(this.getTargetJPAProject(), "1.0");
        int index = isJPA10Project ? 2 : 3;
        PaletteCompartmentEntry compositionEnt = new PaletteCompartmentEntry(JPAEditorMessages.JPAEditorToolBehaviorProvider_CompositionPaletteName, superCompartments[1].getIconId());
        EmbedSingleObjectFeature embedObjectFt = new EmbedSingleObjectFeature(this.getFeatureProvider());
        ConnectionCreationToolEntry isEmbeddedObjectToolEntry = new ConnectionCreationToolEntry(embedObjectFt.getCreateName(), embedObjectFt.getCreateDescription(), embedObjectFt.getCreateImageId(), embedObjectFt.getCreateLargeImageId());
        isEmbeddedObjectToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)embedObjectFt);
        compositionEnt.addToolEntry((IToolEntry)isEmbeddedObjectToolEntry);
        if (!isJPA10Project) {
            EmbedCollectionOfObjectsFeature embedCollectionFt = new EmbedCollectionOfObjectsFeature(this.getFeatureProvider());
            ConnectionCreationToolEntry isEmbeddedCollectionToolEntry = new ConnectionCreationToolEntry(embedCollectionFt.getCreateName(), embedCollectionFt.getCreateDescription(), embedCollectionFt.getCreateImageId(), embedCollectionFt.getCreateLargeImageId());
            isEmbeddedCollectionToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)embedCollectionFt);
            compositionEnt.addToolEntry((IToolEntry)isEmbeddedCollectionToolEntry);
        }
        ret.add(index, (IPaletteCompartmentEntry)compositionEnt);
    }

    private JpaProject getTargetJPAProject() {
        return ModelIntegrationUtil.getProjectByDiagram(this.getDiagramTypeProvider().getDiagram().getName());
    }

    private void createInheritancePaletteSection(List<IPaletteCompartmentEntry> ret, IPaletteCompartmentEntry[] superCompartments) {
        PaletteCompartmentEntry ent = new PaletteCompartmentEntry(JPAEditorMessages.JPAEditorToolBehaviorProvider_InheritanceCompartmentTitle, superCompartments[1].getIconId());
        CreateInheritedEntityFeature ft = new CreateInheritedEntityFeature(this.getFeatureProvider());
        ConnectionCreationToolEntry isARelToolEntry = new ConnectionCreationToolEntry(ft.getCreateName(), ft.getCreateDescription(), ft.getCreateImageId(), ft.getCreateLargeImageId());
        isARelToolEntry.addCreateConnectionFeature((ICreateConnectionFeature)ft);
        ent.addToolEntry((IToolEntry)isARelToolEntry);
        CreateIsARelationFeature ft1 = new CreateIsARelationFeature(this.getFeatureProvider());
        ConnectionCreationToolEntry isARelToolEntry1 = new ConnectionCreationToolEntry(ft1.getCreateName(), ft1.getCreateDescription(), ft1.getCreateImageId(), ft1.getCreateLargeImageId());
        isARelToolEntry1.addCreateConnectionFeature((ICreateConnectionFeature)ft1);
        ent.addToolEntry((IToolEntry)isARelToolEntry1);
        ret.add(1, (IPaletteCompartmentEntry)ent);
    }

    public IDecorator[] getDecorators(PictogramElement pe) {
        IFeatureProvider featureProvider = this.getFeatureProvider();
        Object bo = featureProvider.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof PersistentType) {
            PersistentType persistentType = (PersistentType)bo;
            IFile file = (IFile)persistentType.getResource();
            if (!file.exists()) {
                return new IDecorator[0];
            }
            IMarker[] markers = new IMarker[]{};
            try {
                markers = file.findMarkers(null, true, 2);
                IDecorator[] result = new IDecorator[1];
                if (markers.length == 0) {
                    return super.getDecorators(pe);
                }
                IMarker marker = this.getHighestPrioMarker(markers);
                ImageDecorator imageRenderingDecorator = this.createDecoratorFromMarker(marker);
                if (imageRenderingDecorator != null) {
                    imageRenderingDecorator.setX(5 * (pe.getGraphicsAlgorithm().getWidth() / 6));
                    imageRenderingDecorator.setY(5 * (pe.getGraphicsAlgorithm().getHeight() / 6));
                    result[0] = imageRenderingDecorator;
                }
                if (result[0] != null) {
                    return result;
                }
            }
            catch (CoreException e) {
                JPADiagramEditorPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
        return super.getDecorators(pe);
    }

    private IMarker getHighestPrioMarker(IMarker[] markers) {
        IMarker result = markers[0];
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            try {
                Integer resultSeverity = (Integer)result.getAttribute("severity");
                if (resultSeverity != null) {
                    if (2 == resultSeverity) break;
                    Integer markerSeverity = (Integer)marker.getAttribute("severity");
                    if (markerSeverity != null && markerSeverity > resultSeverity) {
                        result = marker;
                    }
                }
            }
            catch (CoreException e) {
                JPADiagramEditorPlugin.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
        return result;
    }

    private ImageDecorator createDecoratorFromMarker(IMarker marker) {
        try {
            Integer severity = (Integer)marker.getAttribute("severity");
            String decoratorType = "org.eclipse.graphiti.eclipse.information.tsk";
            if (severity != null) {
                switch (severity) {
                    case 0: {
                        decoratorType = "org.eclipse.graphiti.eclipse.information.tsk";
                    }
                    case 1: {
                        decoratorType = "org.eclipse.graphiti.eclipse.warning.tsk";
                        break;
                    }
                    case 2: {
                        decoratorType = "org.eclipse.graphiti.eclipse.error.tsk";
                    }
                }
                ImageDecorator imageRenderingDecorator = new ImageDecorator(decoratorType);
                imageRenderingDecorator.setMessage((String)marker.getAttribute("message"));
                return imageRenderingDecorator;
            }
            return null;
        }
        catch (CoreException e) {
            JPADiagramEditorPlugin.getDefault().getLog().log(e.getStatus());
            return null;
        }
    }

    public String getToolTip(GraphicsAlgorithm ga) {
        PictogramElement pe = ga.getPictogramElement();
        if (!(ga instanceof Rectangle)) {
            return null;
        }
        EList ch = ga.getGraphicsAlgorithmChildren();
        if (ch == null || ch.size() == 0) {
            return null;
        }
        ga = (GraphicsAlgorithm)ch.get(0);
        if (!(ga instanceof Text)) {
            return null;
        }
        Font f = ((Text)ga).getFont();
        if (f == null) {
            return "";
        }
        if (f.isItalic()) {
            return this.getToolTipForCompartmentShape(ga);
        }
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo != null) {
            if (bo instanceof PersistentType) {
                String superPersistentTypeName = null;
                if (((PersistentType)bo).getSuperPersistentType() != null) {
                    superPersistentTypeName = ((PersistentType)bo).getSuperPersistentType().getName();
                }
                return JPAEditorUtil.getTooltipText((PersistentType)bo, superPersistentTypeName);
            }
            if (bo instanceof PersistentAttribute) {
                return JPAEditorUtil.getTooltipText((PersistentAttribute)bo);
            }
        }
        if (!(pe instanceof Shape)) {
            return null;
        }
        Shape sh = (Shape)pe;
        ContainerShape csh = sh.getContainer();
        if (csh == null) {
            return null;
        }
        bo = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)csh);
        if (bo instanceof PersistentType) {
            String superPersistentTypeName = null;
            if (((PersistentType)bo).getSuperPersistentType() != null) {
                superPersistentTypeName = ((PersistentType)bo).getSuperPersistentType().getName();
            }
            return JPAEditorUtil.getTooltipText((PersistentType)bo, superPersistentTypeName);
        }
        return null;
    }

    private String getToolTipForCompartmentShape(GraphicsAlgorithm ga) {
        Text txt = (Text)ga;
        ContainerShape shape = (ContainerShape)Graphiti.getPeService().getActiveContainerPe(ga);
        if (GraphicsUpdater.isCollapsed(shape)) {
            return MessageFormat.format(JPAEditorMessages.JPAEditorToolBehaviorProvider_expandCompartToolTip, txt.getValue());
        }
        return MessageFormat.format(JPAEditorMessages.JPAEditorToolBehaviorProvider_collapseCompartToolTip, txt.getValue());
    }

    protected JPAEditorFeatureProvider getConcreteFeatureProvider() {
        return (JPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public IContextMenuEntry[] getContextMenu(ICustomContext context) {
        ICustomContext customContext = context;
        PictogramElement[] pictEls = customContext.getPictogramElements();
        SaveEntityFeature saveEntityFeature = new SaveEntityFeature(this.getFeatureProvider());
        ContextMenuEntry saveEntityMenuItem = new ContextMenuEntry((IFeature)saveEntityFeature, (IContext)context);
        saveEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_saveMenuItem);
        saveEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_saveMenuItemDescr);
        saveEntityMenuItem.setSubmenu(false);
        RestoreEntityFeature restoreEntityFeature = new RestoreEntityFeature(this.getFeatureProvider());
        ContextMenuEntry restoreEntityMenuItem = new ContextMenuEntry((IFeature)restoreEntityFeature, (IContext)context);
        restoreEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_discardChangesMenuItem);
        restoreEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_discardChangesMenuItemDescr);
        restoreEntityMenuItem.setSubmenu(false);
        CollapseEntityFeature collapseFeature = new CollapseEntityFeature(this.getFeatureProvider());
        ContextMenuEntry collapseEntityMenuItem = new ContextMenuEntry((IFeature)collapseFeature, (IContext)context);
        collapseEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_collapseEntityMenuItem);
        collapseEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_collapseEntityMenuItemDescr);
        collapseEntityMenuItem.setSubmenu(false);
        CollapseAllEntitiesFeature collapseAllFeature = new CollapseAllEntitiesFeature(this.getFeatureProvider());
        ContextMenuEntry collapseAllMenuItem = new ContextMenuEntry((IFeature)collapseAllFeature, (IContext)context);
        collapseAllMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_collapseAllEntitiesMenuItem);
        collapseAllMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_collapseAllEntitiesMenuItemDescr);
        collapseAllMenuItem.setSubmenu(false);
        ExpandEntityFeature expandFeature = new ExpandEntityFeature(this.getFeatureProvider());
        ContextMenuEntry expandEntityMenuItem = new ContextMenuEntry((IFeature)expandFeature, (IContext)context);
        expandEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_expandEntityMenuItem);
        expandEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_expandEntitymenuItemDescr);
        expandEntityMenuItem.setSubmenu(false);
        ExpandAllEntitiesFeature expandAllFeature = new ExpandAllEntitiesFeature(this.getFeatureProvider());
        ContextMenuEntry expandAllMenuItem = new ContextMenuEntry((IFeature)expandAllFeature, (IContext)context);
        expandAllMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_expandAllEntitiesMenuItem);
        expandAllMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_expandAllEntitiesMenuItemDescr);
        expandAllMenuItem.setSubmenu(false);
        OpenJPADetailsViewFeature openJPADetailsViewFeature = new OpenJPADetailsViewFeature(this.getFeatureProvider());
        ContextMenuEntry openJPADetailsViewMenuItem = new ContextMenuEntry((IFeature)openJPADetailsViewFeature, (IContext)context);
        openJPADetailsViewMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_openJPADetailsView);
        openJPADetailsViewMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_openJPADetailsViewDesc);
        openJPADetailsViewMenuItem.setSubmenu(false);
        OpenMiniatureViewFeature openMiniatureViewFeature = new OpenMiniatureViewFeature(this.getFeatureProvider());
        ContextMenuEntry openMiniatureViewMenuItem = new ContextMenuEntry((IFeature)openMiniatureViewFeature, (IContext)context);
        openMiniatureViewMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_openMiniatureView);
        openMiniatureViewMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_openMiniatureViewDesc);
        openMiniatureViewMenuItem.setSubmenu(false);
        boolean isEmpty = true;
        ContextMenuEntry removeAllEntitiesSubmenu = null;
        if (this.getDiagramTypeProvider().getDiagram().getChildren().size() != 0) {
            isEmpty = false;
            removeAllEntitiesSubmenu = new ContextMenuEntry(null, null);
            removeAllEntitiesSubmenu.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAllEntitiesMenu);
            removeAllEntitiesSubmenu.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAllEntitiesMenu);
            removeAllEntitiesSubmenu.setSubmenu(true);
            RemoveAllEntitiesFeature customFeature = new SaveAndRemoveAllEntitiesFeature(this.getFeatureProvider());
            ContextMenuEntry saveAndRemovEntityMenuItem = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
            saveAndRemovEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAndSaveAllEntitiesAction);
            saveAndRemovEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAndSaveAllEntitiesAction);
            saveAndRemovEntityMenuItem.setSubmenu(false);
            customFeature = new DiscardAndRemoveAllEntitiesFeature(this.getFeatureProvider());
            ContextMenuEntry discardAndRemovEntityMenuItem = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
            discardAndRemovEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAndDiscardAllEntitiesAction);
            discardAndRemovEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_removeAndDiscardAllEntitiesAction);
            discardAndRemovEntityMenuItem.setSubmenu(false);
            removeAllEntitiesSubmenu.add((IContextMenuEntry)saveAndRemovEntityMenuItem);
            removeAllEntitiesSubmenu.add((IContextMenuEntry)discardAndRemovEntityMenuItem);
        }
        if (pictEls == null || pictEls.length == 0) {
            return new IContextMenuEntry[]{openJPADetailsViewMenuItem};
        }
        if (pictEls[0] instanceof ContainerShape) {
            Object ob = this.getFeatureProvider().getBusinessObjectForPictogramElement(pictEls[0]);
            if (pictEls[0] instanceof Diagram) {
                AddAllEntitiesFeature customFeature = new AddAllEntitiesFeature(this.getFeatureProvider());
                ContextMenuEntry showAllEntsMenuItem = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
                showAllEntsMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_showAllTheEntities);
                showAllEntsMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_showAllTheEntitiesDesc);
                showAllEntsMenuItem.setSubmenu(false);
                if (isEmpty) {
                    return new IContextMenuEntry[]{showAllEntsMenuItem, collapseAllMenuItem, expandAllMenuItem, openJPADetailsViewMenuItem, openMiniatureViewMenuItem};
                }
                return new IContextMenuEntry[]{showAllEntsMenuItem, removeAllEntitiesSubmenu, collapseAllMenuItem, expandAllMenuItem, openJPADetailsViewMenuItem, openMiniatureViewMenuItem};
            }
            if (ob == null && pictEls[0].getGraphicsAlgorithm() instanceof Rectangle) {
                CollapseCompartmentShapeFeature collapseCompartmentFeature = new CollapseCompartmentShapeFeature(this.getFeatureProvider());
                ContextMenuEntry collapseCompartmentMenuItem = new ContextMenuEntry((IFeature)collapseCompartmentFeature, (IContext)context);
                collapseCompartmentMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_collapseAttrGroupMenuItem);
                collapseCompartmentMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_collapseAttrGroupMenuItemDescr);
                collapseCompartmentMenuItem.setSubmenu(false);
                ExpandCompartmentShapeFeature expandCompartmentFeature = new ExpandCompartmentShapeFeature(this.getFeatureProvider());
                ContextMenuEntry expandCompartmentMenuItem = new ContextMenuEntry((IFeature)expandCompartmentFeature, (IContext)context);
                expandCompartmentMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_expandAttrMenuItem);
                expandCompartmentMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_expandAttrMenuItemDescr);
                expandCompartmentMenuItem.setSubmenu(false);
                return new IContextMenuEntry[]{collapseCompartmentMenuItem, expandCompartmentMenuItem};
            }
            ContextMenuEntry refactorClassSubmenu = new ContextMenuEntry(null, null);
            refactorClassSubmenu.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_refactorSubMenu);
            refactorClassSubmenu.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_refactorSubMenu);
            refactorClassSubmenu.setSubmenu(true);
            AbstractCustomFeature customFeature = new RenameEntityFeature(this.getFeatureProvider());
            ContextMenuEntry renameEntityMenuItem = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
            renameEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_renameEntityClass);
            renameEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_renameEntityClass);
            renameEntityMenuItem.setSubmenu(false);
            customFeature = new MoveEntityFeature(this.getFeatureProvider());
            ContextMenuEntry moveEntityMenuItem = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
            moveEntityMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_moveEntityClass);
            moveEntityMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_moveEntityClass);
            moveEntityMenuItem.setSubmenu(false);
            refactorClassSubmenu.add((IContextMenuEntry)renameEntityMenuItem);
            refactorClassSubmenu.add((IContextMenuEntry)moveEntityMenuItem);
            String shapeType = Graphiti.getPeService().getPropertyValue((PropertyContainer)pictEls[0], JPAEditorConstants.PROP_SHAPE_TYPE);
            if (shapeType == null || !shapeType.equals(JPAEditorConstants.ShapeType.ATTRIBUTE.toString())) {
                return new IContextMenuEntry[]{saveEntityMenuItem, refactorClassSubmenu, collapseEntityMenuItem, collapseAllMenuItem, expandEntityMenuItem, expandAllMenuItem, restoreEntityMenuItem, removeAllEntitiesSubmenu, openJPADetailsViewMenuItem, openMiniatureViewMenuItem};
            }
            customFeature = new RefactorAttributeTypeFeature(this.getFeatureProvider());
            ContextMenuEntry refactorAttributeTypeMenuItem = new ContextMenuEntry((IFeature)customFeature, (IContext)context);
            refactorAttributeTypeMenuItem.setText(JPAEditorMessages.JPAEditorToolBehaviorProvider_refactorAttributeType);
            refactorAttributeTypeMenuItem.setDescription(JPAEditorMessages.JPAEditorToolBehaviorProvider_refactorAttributeTypeDesc);
            refactorAttributeTypeMenuItem.setSubmenu(false);
            return new IContextMenuEntry[]{refactorClassSubmenu, refactorAttributeTypeMenuItem, collapseAllMenuItem, expandAllMenuItem, openJPADetailsViewMenuItem, openMiniatureViewMenuItem};
        }
        return new IContextMenuEntry[]{removeAllEntitiesSubmenu, collapseAllMenuItem, expandAllMenuItem, openJPADetailsViewMenuItem, openMiniatureViewMenuItem};
    }

    public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
        PictogramElement pe = context.getPictogramElements()[0];
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo != null) {
            IFile file = this.getResourceTobeOpened(bo);
            try {
                file.setSessionProperty(new QualifiedName(null, "DOUBLE_CLICK"), (Object)"true");
                this.facade.getIDE().openEditor(file);
            }
            catch (PartInitException e) {
                JPADiagramEditorPlugin.logError("Cannot open editor", e);
            }
            catch (CoreException e) {
                JPADiagramEditorPlugin.logError("Cannot open editor", e);
            }
        }
        if (bo == null && pe.getGraphicsAlgorithm() instanceof Rectangle) {
            CustomContext cont = new CustomContext(new PictogramElement[]{pe});
            ContainerShape containerShape = (ContainerShape)pe;
            if (GraphicsUpdater.isCollapsed(containerShape)) {
                ExpandCompartmentShapeFeature feature = new ExpandCompartmentShapeFeature(this.getFeatureProvider());
                feature.execute((ICustomContext)cont);
            } else {
                CollapseCompartmentShapeFeature feature = new CollapseCompartmentShapeFeature(this.getFeatureProvider());
                feature.execute((ICustomContext)cont);
            }
        }
        return super.getDoubleClickFeature(context);
    }

    public IFile getResourceTobeOpened(Object bo) {
        IFile file = null;
        if (bo instanceof PersistentAttribute) {
            PersistentAttribute jpa = (PersistentAttribute)bo;
            file = (IFile)jpa.getJavaPersistentAttribute().getResource();
        } else if (bo instanceof PersistentType) {
            PersistentType jpt = (PersistentType)bo;
            file = (IFile)jpt.getResource();
        }
        return file;
    }
}

