/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public abstract class ColorPalette {
    public final Color getBasicColor(String cssText) {
        return (Color)this.getBasicColorMap().get(cssText.toLowerCase());
    }

    public final Color getExtendedColor(String cssText) {
        Set keys = this.getExtendedColorMap().keySet();
        for (String key : keys) {
            if (!key.equalsIgnoreCase(cssText)) continue;
            return (Color)this.getExtendedColorMap().get(key);
        }
        return null;
    }

    public abstract Map getBasicColorMap();

    public abstract Map getExtendedColorMap();

    public final RGB getExtendedColorRGB(String textColor) {
        if (textColor == null || textColor.length() == 0) {
            return null;
        }
        Color color = this.getExtendedColor(textColor);
        if (color != null) {
            return color.getRGB();
        }
        if (textColor.charAt(0) == '#' && textColor.length() == 4) {
            char[] rgbChars = textColor.toCharArray();
            char[] fullChars = new char[]{rgbChars[0], rgbChars[1], rgbChars[1], rgbChars[2], rgbChars[2], rgbChars[3], rgbChars[3]};
            textColor = String.valueOf(fullChars);
        }
        if (textColor.charAt(0) == '#' && textColor.length() == 7) {
            int intColor;
            block7: {
                try {
                    intColor = Integer.decode(textColor);
                    if (intColor <= 0xFFFFFF && intColor >= 0) break block7;
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            int r = intColor >> 16;
            int g = intColor >> 8 & 0xFF;
            int b = intColor & 0xFF;
            return new RGB(r, g, b);
        }
        return null;
    }

    public static String getStringColor(RGB rgb) {
        if (rgb == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer("#");
        int[] intRGBs = new int[]{rgb.red, rgb.green, rgb.blue};
        int i = 0;
        while (i < 3) {
            if (intRGBs[i] < 16) {
                buffer.append("0");
            }
            buffer.append(Integer.toHexString(intRGBs[i]).toUpperCase());
            ++i;
        }
        return buffer.toString();
    }
}

