/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.regex.Pattern;
import org.eclipse.persistence.jpa.jpql.WordParser;

public final class ExpressionTools {
    public static Pattern DOUBLE_REGEXP = Pattern.compile("^[-+]?[0-9]*(\\.[0-9]+)?([dD]|([eE][-+]?[0-9]+))?$");
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final String EMPTY_STRING = "";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static Pattern FLOAT_REGEXP = Pattern.compile("^[-+]?[0-9]*(\\.[0-9]+)?[fF]$");
    public static Pattern INTEGER_REGEXP = Pattern.compile("^[-+]?[0-9]+$");
    public static Pattern LONG_REGEXP = Pattern.compile("^[-+]?[0-9]+[lL]?$");

    private ExpressionTools() {
        throw new IllegalAccessError("ExpressionTools cannot be instantiated");
    }

    public static String escape(CharSequence value, int[] position) {
        StringBuilder sb = new StringBuilder(value.length());
        int originalPosition = position[0];
        int index = 0;
        int count = value.length();
        while (index < count) {
            char character = value.charAt(index);
            switch (character) {
                case '\b': {
                    sb.append("\\b");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0000': {
                    sb.append("\\0");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0001': {
                    sb.append("\\1");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0002': {
                    sb.append("\\2");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0003': {
                    sb.append("\\3");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0004': {
                    sb.append("\\4");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0005': {
                    sb.append("\\5");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0006': {
                    sb.append("\\6");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                case '\u0007': {
                    sb.append("\\7");
                    if (index >= originalPosition) break;
                    position[0] = position[0] + 1;
                    break;
                }
                default: {
                    sb.append(character);
                }
            }
            ++index;
        }
        return sb.toString();
    }

    public static boolean isFunctionExpression(WordParser wordParser, String identifier) {
        int count = identifier.length();
        wordParser.moveForward(identifier);
        int whitespace = wordParser.skipLeadingWhitespace();
        boolean function = wordParser.startsWith('(');
        wordParser.moveBackward(count + whitespace);
        return function;
    }

    public static boolean isJavaEscapedCharacter(char character) {
        switch (character) {
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case '\"': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameter(char character) {
        return character == ':' || character == '?';
    }

    public static boolean isQuote(char character) {
        return character == '\'' || character == '\"';
    }

    public static String quote(String text) {
        text = text.replace("'", "''");
        text = "'" + text + "'";
        return text;
    }

    public static void reposition(CharSequence query1, int[] positions, CharSequence query2) {
        int queryLength2;
        if (positions[0] <= 0 && positions.length == 1) {
            return;
        }
        int queryLength1 = query1.length();
        if (queryLength1 == (queryLength2 = query2.length())) {
            return;
        }
        int index1 = 0;
        int index2 = 0;
        boolean position1Done = false;
        boolean position2Done = false;
        while (!(index1 >= queryLength1 || index2 >= queryLength2 || position1Done && position2Done)) {
            char character1 = Character.toUpperCase(query1.charAt(index1));
            char character2 = Character.toUpperCase(query2.charAt(index2));
            boolean whitespace1 = Character.isWhitespace(character1);
            boolean whitespace2 = Character.isWhitespace(character2);
            if (character1 != character2) {
                if (whitespace1 && !whitespace2) {
                    ++index1;
                    if (!position1Done) {
                        positions[0] = positions[0] - 1;
                    }
                    if (!position2Done && positions.length > 1) {
                        positions[1] = positions[1] - 1;
                    }
                } else if (!whitespace1 && whitespace2) {
                    ++index2;
                    if (!position1Done) {
                        positions[0] = positions[0] + 1;
                    }
                    if (!position2Done && positions.length > 1) {
                        positions[1] = positions[1] + 1;
                    }
                } else {
                    ++index1;
                    ++index2;
                }
            } else {
                ++index1;
                ++index2;
            }
            if ((whitespace1 || whitespace2) && queryLength1 <= queryLength2) continue;
            if (positions[0] <= index2) {
                position1Done = true;
            }
            if (positions.length <= 1 || positions[1] > index2) continue;
            position2Done = true;
        }
        positions[0] = Math.min(positions[0], queryLength2);
        positions[0] = Math.max(positions[0], 0);
        if (positions.length > 1) {
            positions[1] = Math.min(positions[1], queryLength2);
            positions[1] = Math.max(positions[1], 0);
        }
    }

    public static int repositionCursor(CharSequence query1, int position1, CharSequence query2) {
        int[] positions = new int[]{position1, position1};
        ExpressionTools.reposition(query1, positions, query2);
        return positions[0];
    }

    public static void repositionJava(CharSequence query, int[] positions) {
        if (query == null || query.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(query);
        int index = 0;
        int count = sb.length();
        while (index < count) {
            char character = sb.charAt(index);
            if (ExpressionTools.isJavaEscapedCharacter(character)) {
                if (index < positions[0]) {
                    positions[0] = positions[0] + 1;
                    positions[1] = positions[1] + 1;
                } else if (index < positions[1]) {
                    positions[1] = positions[1] + 1;
                }
            }
            ++index;
        }
    }

    public static boolean startWithIgnoreCase(String string, String prefix) {
        if (ExpressionTools.stringIsEmpty(prefix)) {
            return true;
        }
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean stringIsEmpty(CharSequence text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        int i = text.length();
        while (i-- > 0) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean stringIsNotEmpty(CharSequence text) {
        return !ExpressionTools.stringIsEmpty(text);
    }

    public static boolean stringsAreDifferentIgnoreCase(CharSequence value1, CharSequence value2) {
        return !ExpressionTools.stringsAreEqualIgnoreCase(value1, value2);
    }

    public static boolean stringsAreEqualIgnoreCase(CharSequence value1, CharSequence value2) {
        if (value1 == value2 || value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.toString().equalsIgnoreCase(value2.toString());
    }

    public static String unescape(CharSequence value, int[] position) {
        StringBuilder sb = new StringBuilder(value.length());
        int originalPosition = position[0];
        int index = 0;
        int count = value.length();
        while (index < count) {
            block38: {
                char character;
                block37: {
                    character = value.charAt(index);
                    if (character != '\\' || index + 1 >= count) break block37;
                    character = value.charAt(++index);
                    switch (character) {
                        case 'b': {
                            sb.append("\b");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case 't': {
                            sb.append("\t");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case 'n': {
                            sb.append("\n");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case 'f': {
                            sb.append("\f");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case 'r': {
                            sb.append("\r");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '\"': {
                            sb.append("\"");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '\\': {
                            sb.append("\\");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '0': {
                            sb.append("\u0000");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '1': {
                            sb.append("\u0001");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '2': {
                            sb.append("\u0002");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '3': {
                            sb.append("\u0003");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '4': {
                            sb.append("\u0004");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '5': {
                            sb.append("\u0005");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '6': {
                            sb.append("\u0006");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case '7': {
                            sb.append("\u0007");
                            if (index <= originalPosition) {
                                position[0] = position[0] - 1;
                                break;
                            }
                            break block38;
                        }
                        case 'u': {
                            String hexadecimals = value.subSequence(index + 1, index + 5).toString();
                            char unicode = (char)Integer.parseInt(hexadecimals, 16);
                            sb.append(unicode);
                            if (originalPosition > index - 1 && originalPosition <= index + 5) {
                                position[0] = position[0] - (originalPosition - index + 1);
                            } else if (index <= originalPosition) {
                                position[0] = position[0] - 5;
                            }
                            index += 4;
                            break;
                        }
                        default: {
                            sb.append(character);
                            break;
                        }
                    }
                    break block38;
                }
                sb.append(character);
            }
            ++index;
        }
        return sb.toString();
    }

    public static String unquote(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int startIndex = 0;
        int endIndex = text.length();
        if (ExpressionTools.isQuote(text.charAt(0))) {
            startIndex = 1;
        }
        if (endIndex - 1 >= startIndex && ExpressionTools.isQuote(text.charAt(endIndex - 1))) {
            --endIndex;
        }
        text = text.substring(startIndex, endIndex);
        text = text.replace("''", "'");
        return text;
    }

    public static boolean valuesAreDifferent(Object value1, Object value2) {
        return !ExpressionTools.valuesAreEqual(value1, value2);
    }

    public static boolean valuesAreEqual(Object value1, Object value2) {
        if (value1 == value2 || value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }
}

