/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.NamingConventions;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.formatter.IndentManipulation;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.wst.jsdt.ui.CodeStyleConfiguration;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class StubUtility {
    private static final String[] EMPTY = new String[0];
    private static final Set VALID_TYPE_BODY_TEMPLATES = new HashSet();
    public static final int STATIC_FIELD = 1;
    public static final int INSTANCE_FIELD = 2;
    public static final int CONSTANT_FIELD = 3;
    public static final int PARAMETER = 4;
    public static final int LOCAL = 5;
    private static final String[] KNOWN_METHOD_NAME_PREFIXES;
    private static final List BASE_TYPES;

    static {
        VALID_TYPE_BODY_TEMPLATES.add("org.eclipse.wst.jsdt.ui.text.codetemplates.classbody");
        KNOWN_METHOD_NAME_PREFIXES = new String[]{"get", "is", "to"};
        BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
    }

    public static String getMethodBodyContent(boolean isConstructor, IJavaScriptProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "org.eclipse.wst.jsdt.ui.text.codetemplates.constructorbody" : "org.eclipse.wst.jsdt.ui.text.codetemplates.methodbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        String str = StubUtility.evaluateTemplate(context, template, new String[]{"body_statement"});
        if (str == null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getGetterMethodBodyContent(IJavaScriptProject project, String destTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.getterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterMethodBodyContent(IJavaScriptProject project, String destTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.setterbody";
        Template template = StubUtility.getCodeTemplate(templateName, project);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCatchBodyContent(IJavaScriptUnit cu, String exceptionType, String variableName, ASTNode locationInAST, String lineDelimiter) throws CoreException {
        String enclosingType = "";
        String enclosingMethod = "";
        if (locationInAST != null) {
            ASTNode parentType;
            FunctionDeclaration parentMethod = ASTResolving.findParentMethodDeclaration(locationInAST);
            if (parentMethod != null) {
                enclosingMethod = parentMethod.getName().getIdentifier();
                locationInAST = parentMethod;
            }
            if ((parentType = ASTResolving.findParentType(locationInAST)) instanceof AbstractTypeDeclaration) {
                enclosingType = ((AbstractTypeDeclaration)parentType).getName().getIdentifier();
            }
        }
        return StubUtility.getCatchBodyContent(cu, exceptionType, variableName, enclosingType, enclosingMethod, lineDelimiter);
    }

    public static String getCatchBodyContent(IJavaScriptUnit cu, String exceptionType, String variableName, String enclosingType, String enclosingMethod, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.catchblock", cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelimiter);
        context.setVariable("enclosing_type", enclosingType);
        context.setVariable("enclosing_method", enclosingMethod);
        context.setVariable("exception_type", exceptionType);
        context.setVariable("exception_var", variableName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCompilationUnitContent(IJavaScriptUnit cu, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String packDecl = pack.isDefaultPackage() ? "" : "package " + pack.getElementName() + ';';
        return StubUtility.getCompilationUnitContent(cu, packDecl, fileComment, typeComment, typeContent, lineDelimiter);
    }

    public static String getCompilationUnitContent(IJavaScriptUnit cu, String packDecl, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.newtype", cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        IJavaScriptProject project = cu.getJavaScriptProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("package_declaration", packDecl);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("filecomment", fileComment != null ? fileComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", JavaScriptCore.removeJavaScriptLikeExtension((String)cu.getElementName()));
        String[] fullLine = new String[]{"package_declaration", "filecomment", "typecomment"};
        return StubUtility.evaluateTemplate(context, template, fullLine);
    }

    public static String getFileComment(IJavaScriptUnit cu, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.filecomment", cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        IJavaScriptProject project = cu.getJavaScriptProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("type_name", JavaScriptCore.removeJavaScriptLikeExtension((String)cu.getElementName()));
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getTypeComment(IJavaScriptUnit cu, String typeQualifiedName, String lineDelim) throws CoreException {
        TemplateBuffer buffer;
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.typecomment", cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", Signature.getQualifier((String)typeQualifiedName));
        context.setVariable("type_name", Signature.getSimpleName((String)typeQualifiedName));
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        int[] tagOffsets = position.getOffsets();
        int i = tagOffsets.length - 1;
        while (i >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i], position.getLength(), EMPTY, EMPTY, null, false, lineDelim);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i;
        }
        return document.get();
    }

    public static String[] getParameterTypeNamesForSeeTag(IFunctionBinding binding) {
        ITypeBinding[] typeBindings = binding.getParameterTypes();
        String[] result = new String[typeBindings.length];
        int i = 0;
        while (i < result.length) {
            ITypeBinding curr = typeBindings[i];
            curr = curr.getTypeDeclaration();
            result[i] = curr.getQualifiedName();
            ++i;
        }
        return result;
    }

    private static String[] getParameterTypeNamesForSeeTag(IFunction overridden) {
        try {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setProject(overridden.getJavaScriptProject());
            IBinding[] bindings = parser.createBindings(new IJavaScriptElement[]{overridden}, null);
            if (bindings.length == 1 && bindings[0] instanceof IFunctionBinding) {
                return StubUtility.getParameterTypeNamesForSeeTag((IFunctionBinding)bindings[0]);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        String[] paramTypes = overridden.getParameterTypes();
        String[] paramTypeNames = new String[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypeNames[i] = Signature.toString((String)paramTypes[i]);
            ++i;
        }
        return paramTypeNames;
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < parameterTypesQualifiedNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameterTypesQualifiedNames[i]);
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static String getTypeBody(String templateID, IJavaScriptUnit cu, String typeName, String lineDelim) throws CoreException {
        if (!VALID_TYPE_BODY_TEMPLATES.contains(templateID)) {
            throw new IllegalArgumentException("Invalid code template ID: " + templateID);
        }
        Template template = StubUtility.getCodeTemplate(templateID, cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("type_name", typeName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getMethodComment(IJavaScriptUnit cu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, IFunction target, boolean delegate, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.methodcomment";
        if (retTypeSig == null) {
            templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.constructorcomment";
        } else if (target != null) {
            templateName = delegate ? "org.eclipse.wst.jsdt.ui.text.codetemplates.delegatecomment" : "org.eclipse.wst.jsdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", Signature.toString((String)retTypeSig));
        }
        if (target != null && target.getDeclaringType() != null) {
            String targetTypeName = target.getDeclaringType().getFullyQualifiedName('.');
            String[] targetParamTypeNames = StubUtility.getParameterTypeNamesForSeeTag(target);
            if (delegate) {
                context.setVariable("see_to_target", StubUtility.getSeeTag(targetTypeName, methodName, targetParamTypeNames));
            } else {
                context.setVariable("see_to_overridden", StubUtility.getSeeTag(targetTypeName, methodName, targetParamTypeNames));
            }
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document document = new Document(str);
        String[] exceptionNames = new String[excTypeSig.length];
        int i = 0;
        while (i < excTypeSig.length) {
            exceptionNames[i] = Signature.toString((String)excTypeSig[i]);
            ++i;
        }
        String returnType = retTypeSig != null ? Signature.toString((String)retTypeSig) : null;
        int[] tagOffsets = position.getOffsets();
        int i2 = tagOffsets.length - 1;
        while (i2 >= 0) {
            try {
                StubUtility.insertTag((IDocument)document, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, false, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i2;
        }
        return document.get();
    }

    private static String fixEmptyVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null && position.getLength() <= 0) {
                int[] offsets = position.getOffsets();
                int k = 0;
                while (k < offsets.length) {
                    int line = doc.getLineOfOffset(offsets[k]);
                    IRegion lineInfo = doc.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String str = doc.get(offset, lineInfo.getLength());
                    if (Strings.containsOnlyWhitespaces(str) && nLines > line + 1 && removedLines.add(new Integer(line))) {
                        int nextStart = doc.getLineOffset(line + 1);
                        edit.addChild((TextEdit)new DeleteEdit(offset, nextStart - offset));
                    }
                    ++k;
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    public static String getFieldComment(IJavaScriptUnit cu, String typeName, String fieldName, String lineDelimiter) throws CoreException {
        Template template = StubUtility.getCodeTemplate("org.eclipse.wst.jsdt.ui.text.codetemplates.fieldcomment", cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("field_type", typeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterComment(IJavaScriptUnit cu, String typeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.settercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getGetterComment(IJavaScriptUnit cu, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.gettercomment";
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = StubUtility.fixEmptyVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces(str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static String getMethodComment(IJavaScriptUnit cu, String typeName, FunctionDeclaration decl, boolean isDeprecated, String targetName, String targetMethodDeclaringTypeName, String[] targetMethodParameterTypeNames, boolean delegate, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        if (typeName == null) {
            typeName = "";
        }
        boolean needsTarget = targetMethodDeclaringTypeName != null && targetMethodParameterTypeNames != null;
        String templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.methodcomment";
        if (decl.isConstructor()) {
            templateName = "org.eclipse.wst.jsdt.ui.text.codetemplates.constructorcomment";
        } else if (needsTarget) {
            templateName = delegate ? "org.eclipse.wst.jsdt.ui.text.codetemplates.delegatecomment" : "org.eclipse.wst.jsdt.ui.text.codetemplates.overridecomment";
        }
        Template template = StubUtility.getCodeTemplate(templateName, cu.getJavaScriptProject());
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaScriptProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", decl.getName().getIdentifier());
        if (!decl.isConstructor() && StubUtility.getReturnType(decl) != null) {
            context.setVariable("return_type", ASTNodes.asString(StubUtility.getReturnType(decl)));
        }
        if (needsTarget) {
            if (delegate) {
                context.setVariable("see_to_target", StubUtility.getSeeTag(targetMethodDeclaringTypeName, targetName, targetMethodParameterTypeNames));
            } else {
                context.setVariable("see_to_overridden", StubUtility.getSeeTag(targetMethodDeclaringTypeName, targetName, targetMethodParameterTypeNames));
            }
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findVariable(buffer, "tags");
        if (position == null) {
            return str;
        }
        Document textBuffer = new Document(str);
        List params = decl.parameters();
        String[] paramNames = new String[params.size()];
        int i = 0;
        while (i < paramNames.length) {
            SingleVariableDeclaration elem = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = elem.getName().getIdentifier();
            ++i;
        }
        List exceptions = decl.thrownExceptions();
        String[] exceptionNames = new String[exceptions.size()];
        int i2 = 0;
        while (i2 < exceptionNames.length) {
            exceptionNames[i2] = ASTNodes.getSimpleNameIdentifier((Name)exceptions.get(i2));
            ++i2;
        }
        String returnType = null;
        if (!decl.isConstructor()) {
            returnType = ASTNodes.asString(StubUtility.getReturnType(decl));
        }
        int[] tagOffsets = position.getOffsets();
        int i3 = tagOffsets.length - 1;
        while (i3 >= 0) {
            try {
                StubUtility.insertTag((IDocument)textBuffer, tagOffsets[i3], position.getLength(), paramNames, exceptionNames, returnType, isDeprecated, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
            --i3;
        }
        return textBuffer.get();
    }

    private static ASTNode getReturnType(FunctionDeclaration decl) {
        return decl.getAST().apiLevel() == 2 ? decl.getReturnType() : decl.getReturnType2();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        int prevLine;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param ").append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@returns");
            if (!returnType.equals("any")) {
                buf.append(" {" + returnType + "}");
            }
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@throws ").append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@deprecated");
        }
        if (buf.length() == 0 && StubUtility.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isAllCommentWhitespace(String lineStart) {
        int i = 0;
        while (i < lineStart.length()) {
            char ch = lineStart.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getLineDelimiterUsed(IJavaScriptProject project) {
        return StubUtility.getProjectLineDelimiter(project);
    }

    private static String getProjectLineDelimiter(IJavaScriptProject javaProject) {
        String lineDelimiter;
        IProject project = null;
        if (javaProject != null) {
            project = javaProject.getProject();
        }
        if ((lineDelimiter = StubUtility.getLineDelimiterPreference(project)) != null) {
            return lineDelimiter;
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterPreference(IProject project) {
        IScopeContext[] scopeContext;
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineDelimiter != null) {
                return lineDelimiter;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        String platformDefault = System.getProperty("line.separator", "\n");
        return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefault, scopeContext);
    }

    public static String getLineDelimiterUsed(IJavaScriptElement elem) {
        while (elem != null && !(elem instanceof IOpenable)) {
            elem = elem.getParent();
        }
        if (elem != null) {
            try {
                return ((IOpenable)elem).findRecommendedLineSeparator();
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return StubUtility.getProjectLineDelimiter(null);
    }

    public static int getIndentUsed(IJavaScriptElement elem) throws JavaScriptModelException {
        IJavaScriptUnit cu;
        if (elem instanceof ISourceReference && (cu = (IJavaScriptUnit)elem.getAncestor(5)) != null) {
            int offset;
            IBuffer buf = cu.getBuffer();
            int i = offset = ((ISourceReference)elem).getSourceRange().getOffset();
            while (i > 0 && !IndentManipulation.isLineDelimiterChar((char)buf.getChar(i - 1))) {
                --i;
            }
            return Strings.computeIndentUnits(buf.getText(i, offset - i), elem.getJavaScriptProject());
        }
        return 0;
    }

    public static IJavaScriptElement findNextSibling(IJavaScriptElement member) throws JavaScriptModelException {
        IJavaScriptElement parent = member.getParent();
        if (parent instanceof IParent) {
            IJavaScriptElement[] elements = ((IParent)parent).getChildren();
            int i = elements.length - 2;
            while (i >= 0) {
                if (member.equals(elements[i])) {
                    return elements[i + 1];
                }
                --i;
            }
        }
        return null;
    }

    public static String getTodoTaskTag(IJavaScriptProject project) {
        String markers = null;
        markers = project == null ? JavaScriptCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.taskTags") : project.getOption("org.eclipse.wst.jsdt.core.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    private static String removeTypeArguments(String baseName) {
        int idx = baseName.indexOf(60);
        if (idx != -1) {
            return baseName.substring(0, idx);
        }
        return baseName;
    }

    public static String[] getVariableNameSuggestions(int variableKind, IJavaScriptProject project, ITypeBinding expectedType, Expression assignedExpression, Collection excluded) {
        String nameFromParent;
        String nameFromExpression;
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if (assignedExpression != null && (nameFromExpression = StubUtility.getBaseNameFromExpression(project, assignedExpression, variableKind)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromExpression, 0, excluded, false), res);
        }
        if (expectedType != null && (expectedType = Bindings.normalizeTypeBinding(expectedType)) != null) {
            String typeName;
            int dim = 0;
            if (expectedType.isArray()) {
                dim = expectedType.getDimensions();
                expectedType = expectedType.getElementType();
            }
            if ((typeName = expectedType.getQualifiedName()).length() > 0) {
                String[] names = StubUtility.getVariableNameSuggestions(variableKind, project, typeName, dim, excluded, false);
                int i = 0;
                while (i < names.length) {
                    res.add(names[i]);
                    ++i;
                }
            }
        }
        if (assignedExpression != null && (nameFromParent = StubUtility.getBaseNameFromLocationInParent(project, assignedExpression)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromParent, 0, excluded, false), res);
        }
        if (res.isEmpty()) {
            return StubUtility.getDefaultVariableNameSuggestions(variableKind, excluded);
        }
        return res.toArray(new String[res.size()]);
    }

    public static String[] getVariableNameSuggestions(int variableKind, IJavaScriptProject project, Type expectedType, Expression assignedExpression, Collection excluded) {
        String nameFromParent;
        String nameFromExpression;
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        if (assignedExpression != null && (nameFromExpression = StubUtility.getBaseNameFromExpression(project, assignedExpression, variableKind)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromExpression, 0, excluded, false), res);
        }
        if (expectedType != null) {
            String typeName;
            int dim = 0;
            if (expectedType.isArrayType()) {
                ArrayType arrayType = (ArrayType)expectedType;
                dim = arrayType.getDimensions();
                expectedType = arrayType.getElementType();
            }
            if ((typeName = ASTNodes.asString((ASTNode)expectedType)).length() > 0) {
                String[] names = StubUtility.getVariableNameSuggestions(variableKind, project, typeName, dim, excluded, false);
                int i = 0;
                while (i < names.length) {
                    res.add(names[i]);
                    ++i;
                }
            }
        }
        if (assignedExpression != null && (nameFromParent = StubUtility.getBaseNameFromLocationInParent(project, assignedExpression)) != null) {
            StubUtility.add(StubUtility.getVariableNameSuggestions(variableKind, project, nameFromParent, 0, excluded, false), res);
        }
        if (res.isEmpty()) {
            return StubUtility.getDefaultVariableNameSuggestions(variableKind, excluded);
        }
        return res.toArray(new String[res.size()]);
    }

    private static String[] getDefaultVariableNameSuggestions(int variableKind, Collection excluded) {
        String prop;
        String name = prop = variableKind == 3 ? "X" : "x";
        int i = 1;
        while (excluded.contains(name)) {
            name = String.valueOf(prop) + i++;
        }
        return new String[]{name};
    }

    public static String[] getVariableNameSuggestions(int variableKind, IJavaScriptProject project, String baseName, int dimensions, Collection excluded, boolean evaluateDefault) {
        String name = StubUtility.workaround38111(baseName);
        name = StubUtility.removeTypeArguments(name);
        String packageName = new String();
        String[] result = null;
        switch (variableKind) {
            case 3: {
                result = StubUtility.getConstantSuggestions(project, packageName, name, dimensions, excluded);
                break;
            }
            case 1: {
                result = StubUtility.sortByLength(NamingConventions.suggestFieldNames((IJavaScriptProject)project, (String)packageName, (String)name, (int)dimensions, (int)8, (String[])StubUtility.getExcludedArray(excluded)));
                break;
            }
            case 2: {
                result = StubUtility.sortByLength(NamingConventions.suggestFieldNames((IJavaScriptProject)project, (String)packageName, (String)name, (int)dimensions, (int)0, (String[])StubUtility.getExcludedArray(excluded)));
                break;
            }
            case 4: {
                result = StubUtility.sortByLength(NamingConventions.suggestArgumentNames((IJavaScriptProject)project, (String)packageName, (String)name, (int)dimensions, (String[])StubUtility.getExcludedArray(excluded)));
                break;
            }
            case 5: {
                result = StubUtility.sortByLength(NamingConventions.suggestLocalVariableNames((IJavaScriptProject)project, (String)packageName, (String)name, (int)dimensions, (String[])StubUtility.getExcludedArray(excluded)));
            }
        }
        if (evaluateDefault) {
            if (result.length == 0) {
                result = StubUtility.getDefaultVariableNameSuggestions(variableKind, excluded);
            }
        } else if (variableKind != 3) {
            String defaultValue = "NAME";
            if (!name.toUpperCase().endsWith(defaultValue) && result[0].toUpperCase().endsWith(defaultValue)) {
                return new String[0];
            }
        }
        return result;
    }

    private static String[] getExcludedArray(Collection excluded) {
        if (excluded == null) {
            return null;
        }
        if (excluded instanceof ExcludedCollection) {
            return ((ExcludedCollection)excluded).getExcludedArray();
        }
        return excluded.toArray(new String[excluded.size()]);
    }

    private static void add(String[] names, Set result) {
        int i = 0;
        while (i < names.length) {
            result.add(names[i]);
            ++i;
        }
    }

    private static String getBaseNameFromExpression(IJavaScriptProject project, Expression assignedExpression, int variableKind) {
        String name = null;
        if (assignedExpression instanceof Name) {
            Name simpleNode = (Name)assignedExpression;
            IBinding binding = simpleNode.resolveBinding();
            if (binding instanceof IVariableBinding) {
                return StubUtility.removePrefixAndSuffixForVariable(project, (IVariableBinding)binding);
            }
            return ASTNodes.getSimpleNameIdentifier(simpleNode);
        }
        if (assignedExpression instanceof FunctionInvocation) {
            SimpleName name2 = ((FunctionInvocation)assignedExpression).getName();
            if (name2 != null) {
                name = name2.getIdentifier();
            }
        } else if (assignedExpression instanceof SuperMethodInvocation) {
            name = ((SuperMethodInvocation)assignedExpression).getName().getIdentifier();
        } else {
            if (assignedExpression instanceof FieldAccess) {
                return ((FieldAccess)assignedExpression).getName().getIdentifier();
            }
            if (variableKind == 3 && (assignedExpression instanceof StringLiteral || assignedExpression instanceof NumberLiteral)) {
                String string = assignedExpression instanceof StringLiteral ? ((StringLiteral)assignedExpression).getLiteralValue() : ((NumberLiteral)assignedExpression).getToken();
                StringBuffer res = new StringBuffer();
                boolean needsUnderscore = false;
                int i = 0;
                while (i < string.length()) {
                    char ch = string.charAt(i);
                    if (Character.isJavaIdentifierPart(ch)) {
                        if (res.length() == 0 && !Character.isJavaIdentifierStart(ch) || needsUnderscore) {
                            res.append('_');
                        }
                        res.append(ch);
                        needsUnderscore = false;
                    } else {
                        needsUnderscore = res.length() > 0;
                    }
                    ++i;
                }
                if (res.length() > 0) {
                    return res.toString();
                }
            }
        }
        if (name != null) {
            int i = 0;
            while (i < KNOWN_METHOD_NAME_PREFIXES.length) {
                String curr = KNOWN_METHOD_NAME_PREFIXES[i];
                if (name.startsWith(curr)) {
                    if (name.equals(curr)) {
                        return null;
                    }
                    if (Character.isUpperCase(name.charAt(curr.length()))) {
                        return name.substring(curr.length());
                    }
                }
                ++i;
            }
        }
        return name;
    }

    private static String getBaseNameFromLocationInParent(IJavaScriptProject project, Expression assignedExpression) {
        StructuralPropertyDescriptor location = assignedExpression.getLocationInParent();
        if (location == FunctionInvocation.ARGUMENTS_PROPERTY) {
            FunctionInvocation parent = (FunctionInvocation)assignedExpression.getParent();
            IFunctionBinding binding = parent.resolveMethodBinding();
            int index = parent.arguments().indexOf(assignedExpression);
            if (binding != null && index != -1) {
                return StubUtility.getParameterName(binding, index);
            }
        } else if (location == ClassInstanceCreation.ARGUMENTS_PROPERTY) {
            ClassInstanceCreation parent = (ClassInstanceCreation)assignedExpression.getParent();
            IFunctionBinding binding = parent.resolveConstructorBinding();
            int index = parent.arguments().indexOf(assignedExpression);
            if (binding != null && index != -1) {
                return StubUtility.getParameterName(binding, index);
            }
        } else if (location == SuperMethodInvocation.ARGUMENTS_PROPERTY) {
            SuperMethodInvocation parent = (SuperMethodInvocation)assignedExpression.getParent();
            IFunctionBinding binding = parent.resolveMethodBinding();
            int index = parent.arguments().indexOf(assignedExpression);
            if (binding != null && index != -1) {
                return StubUtility.getParameterName(binding, index);
            }
        } else if (location == ConstructorInvocation.ARGUMENTS_PROPERTY) {
            ConstructorInvocation parent = (ConstructorInvocation)assignedExpression.getParent();
            IFunctionBinding binding = parent.resolveConstructorBinding();
            int index = parent.arguments().indexOf(assignedExpression);
            if (binding != null && index != -1) {
                return StubUtility.getParameterName(binding, index);
            }
        } else if (location == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
            SuperConstructorInvocation parent = (SuperConstructorInvocation)assignedExpression.getParent();
            IFunctionBinding binding = parent.resolveConstructorBinding();
            int index = parent.arguments().indexOf(assignedExpression);
            if (binding != null && index != -1) {
                return StubUtility.getParameterName(binding, index);
            }
        }
        return null;
    }

    private static String getParameterName(IFunctionBinding binding, int index) {
        try {
            String[] parameterNames;
            IFunction method;
            IJavaScriptElement javaElement = binding.getJavaElement();
            if (javaElement instanceof IFunction && (method = (IFunction)javaElement).getOpenable().getBuffer() != null && index < (parameterNames = method.getParameterNames()).length) {
                return NamingConventions.removePrefixAndSuffixForArgumentName((IJavaScriptProject)method.getJavaScriptProject(), (String)parameterNames[index]);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return null;
    }

    public static String[] getArgumentNameSuggestions(IType type, IJavaScriptUnit compUnit, String[] excluded) {
        String baseName = type != null ? JavaModelUtil.getFullyQualifiedName(type) : compUnit.getElementName();
        return StubUtility.getVariableNameSuggestions(4, compUnit.getJavaScriptProject(), baseName, 0, new ExcludedCollection(excluded), true);
    }

    public static String[] getArgumentNameSuggestions(IType type, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(4, type.getJavaScriptProject(), JavaModelUtil.getFullyQualifiedName(type), 0, new ExcludedCollection(excluded), true);
    }

    public static String[] getArgumentNameSuggestions(IJavaScriptProject project, Type type, String[] excluded) {
        int dim = 0;
        if (type.isArrayType()) {
            ArrayType arrayType = (ArrayType)type;
            dim = arrayType.getDimensions();
            type = arrayType.getElementType();
        }
        return StubUtility.getVariableNameSuggestions(4, project, ASTNodes.asString((ASTNode)type), dim, new ExcludedCollection(excluded), true);
    }

    public static String[] getArgumentNameSuggestions(IJavaScriptProject project, ITypeBinding binding, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(4, project, binding, null, (Collection)new ExcludedCollection(excluded));
    }

    public static String[] getArgumentNameSuggestions(IJavaScriptProject project, String baseName, int dimensions, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(4, project, baseName, dimensions, new ExcludedCollection(excluded), true);
    }

    public static String[] getFieldNameSuggestions(IType type, int fieldModifiers, String[] excluded) {
        return StubUtility.getFieldNameSuggestions(type.getJavaScriptProject(), JavaModelUtil.getFullyQualifiedName(type), 0, fieldModifiers, excluded);
    }

    public static String[] getFieldNameSuggestions(IJavaScriptProject project, String baseName, int dimensions, int modifiers, String[] excluded) {
        if (Flags.isStatic((int)modifiers)) {
            return StubUtility.getVariableNameSuggestions(1, project, baseName, dimensions, new ExcludedCollection(excluded), true);
        }
        return StubUtility.getVariableNameSuggestions(2, project, baseName, dimensions, new ExcludedCollection(excluded), true);
    }

    private static String[] getConstantSuggestions(IJavaScriptProject project, String packageName, String typeName, int dimensions, Collection excluded) {
        String string = Signature.getSimpleName((String)typeName);
        StringBuffer buf = new StringBuffer();
        boolean wasUpperCase = true;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (!wasUpperCase) {
                    buf.append('_');
                }
                buf.append(ch);
            } else {
                buf.append(Character.toUpperCase(ch));
                wasUpperCase = ch == '_';
            }
            ++i;
        }
        ArrayList<String> res = new ArrayList<String>();
        String sourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String complianceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        boolean nameStarts = true;
        int i2 = 0;
        while (i2 < buf.length()) {
            char ch;
            String prop;
            if (nameStarts && !excluded.contains(prop = buf.substring(i2)) && JavaScriptConventions.validateFieldName((String)prop, (String)sourceLevel, (String)complianceLevel).isOK()) {
                res.add(prop);
            }
            nameStarts = (ch = buf.charAt(i2)) == '_';
            ++i2;
        }
        return res.toArray(new String[res.size()]);
    }

    private static String getCamelCaseFromUpper(String string) {
        StringBuffer result = new StringBuffer();
        boolean lastWasUnderscore = false;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (!lastWasUnderscore) {
                    ch = Character.toLowerCase(ch);
                }
                result.append(ch);
                lastWasUnderscore = false;
            } else if (ch == '_') {
                lastWasUnderscore = true;
            } else {
                return string;
            }
            ++i;
        }
        return result.toString();
    }

    public static String[] getLocalNameSuggestions(IJavaScriptProject project, String baseName, int dimensions, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(5, project, baseName, dimensions, new ExcludedCollection(excluded), true);
    }

    private static String[] sortByLength(String[] proposals) {
        Arrays.sort(proposals, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).length() - ((String)o1).length();
            }
        });
        return proposals;
    }

    private static String workaround38111(String baseName) {
        if (BASE_TYPES.contains(baseName)) {
            return baseName;
        }
        return String.valueOf(Character.toUpperCase(baseName.charAt(0))) + baseName.substring(1);
    }

    public static String suggestArgumentName(IJavaScriptProject project, String baseName, String[] excluded) {
        return StubUtility.suggestVariableName(4, project, baseName, 0, excluded);
    }

    private static String suggestVariableName(int varKind, IJavaScriptProject project, String baseName, int dimension, String[] excluded) {
        return StubUtility.getVariableNameSuggestions(varKind, project, baseName, dimension, new ExcludedCollection(excluded), true)[0];
    }

    public static String[][] suggestArgumentNamesWithProposals(IJavaScriptProject project, String[] paramNames) {
        String[][] newNames = new String[paramNames.length][];
        ArrayList<String> takenNames = new ArrayList<String>();
        int i = 0;
        while (i < paramNames.length) {
            String curr = paramNames[i];
            String baseName = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaScriptProject)project, (String)curr);
            String[] proposedNames = StubUtility.getVariableNameSuggestions(4, project, curr, 0, takenNames, true);
            if (!curr.equals(baseName)) {
                LinkedHashSet<String> updatedNames = new LinkedHashSet<String>();
                updatedNames.add(curr);
                int k = 0;
                while (k < proposedNames.length) {
                    updatedNames.add(proposedNames[k]);
                    ++k;
                }
                proposedNames = updatedNames.toArray(new String[updatedNames.size()]);
            }
            newNames[i] = proposedNames;
            takenNames.add(proposedNames[0]);
            ++i;
        }
        return newNames;
    }

    public static String[][] suggestArgumentNamesWithProposals(IJavaScriptProject project, IFunctionBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                IFunction method = (IFunction)binding.getMethodDeclaration().getJavaElement();
                if (method != null) {
                    return StubUtility.suggestArgumentNamesWithProposals(project, method.getParameterNames());
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        String[][] names = new String[nParams][];
        int i = 0;
        while (i < names.length) {
            names[i] = new String[]{"arg" + i};
            ++i;
        }
        return names;
    }

    public static String[] suggestArgumentNames(IJavaScriptProject project, IFunctionBinding binding) {
        int nParams = binding.getParameterTypes().length;
        if (nParams > 0) {
            try {
                IFunction method = (IFunction)binding.getMethodDeclaration().getJavaElement();
                if (method != null) {
                    String[] paramNames = method.getParameterNames();
                    String[] namesArray = new String[]{};
                    ArrayList<String> newNames = new ArrayList<String>(paramNames.length);
                    int i = 0;
                    while (i < paramNames.length) {
                        String curr = paramNames[i];
                        String baseName = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaScriptProject)project, (String)curr);
                        if (!curr.equals(baseName)) {
                            newNames.add(curr);
                        } else {
                            newNames.add(StubUtility.suggestArgumentName(project, curr, namesArray));
                        }
                        namesArray = newNames.toArray(new String[newNames.size()]);
                        ++i;
                    }
                    return namesArray;
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        String[] names = new String[nParams];
        int i = 0;
        while (i < names.length) {
            names[i] = "arg" + i;
            ++i;
        }
        return names;
    }

    public static String removePrefixAndSuffixForVariable(IJavaScriptProject project, IVariableBinding binding) {
        if (binding.isField()) {
            if (Modifier.isStatic(binding.getModifiers()) && Modifier.isFinal(binding.getModifiers())) {
                return StubUtility.getCamelCaseFromUpper(binding.getName());
            }
            return NamingConventions.removePrefixAndSuffixForFieldName((IJavaScriptProject)project, (String)binding.getName(), (int)binding.getModifiers());
        }
        if (binding.isParameter()) {
            return NamingConventions.removePrefixAndSuffixForArgumentName((IJavaScriptProject)project, (String)binding.getName());
        }
        return NamingConventions.removePrefixAndSuffixForLocalVariableName((IJavaScriptProject)project, (String)binding.getName());
    }

    public static boolean hasFieldName(IJavaScriptProject project, String name) {
        String prefixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.fieldPrefixes", true);
        String suffixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.fieldSuffixes", true);
        String staticPrefixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.staticFieldPrefixes", true);
        String staticSuffixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.staticFieldSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name) || StubUtility.hasPrefixOrSuffix(staticPrefixes, staticSuffixes, name);
    }

    public static boolean hasParameterName(IJavaScriptProject project, String name) {
        String prefixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.argumentPrefixes", true);
        String suffixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.argumentSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasLocalVariableName(IJavaScriptProject project, String name) {
        String prefixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.localPrefixes", true);
        String suffixes = project.getOption("org.eclipse.wst.jsdt.core.codeComplete.localSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasConstantName(String name) {
        return Character.isUpperCase(name.charAt(0));
    }

    private static boolean hasPrefixOrSuffix(String prefixes, String suffixes, String name) {
        String curr;
        StringTokenizer tok = new StringTokenizer(prefixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.startsWith(curr)) continue;
            return true;
        }
        tok = new StringTokenizer(suffixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.endsWith(curr)) continue;
            return true;
        }
        return false;
    }

    public static boolean useThisForFieldAccess(IJavaScriptProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.keywordthis", project));
    }

    public static boolean useIsForBooleanGetters(IJavaScriptProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.gettersetter.use.is", project));
    }

    public static String getExceptionVariableName(IJavaScriptProject project) {
        return PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.exception.name", project);
    }

    public static boolean doAddComments(IJavaScriptProject project) {
        return Boolean.valueOf(PreferenceConstants.getPreference("org.eclipse.wst.jsdt.ui.javadoc", project));
    }

    public static void setCodeTemplate(String templateId, String pattern, IJavaScriptProject project) {
        TemplateStore codeTemplateStore = JavaScriptPlugin.getDefault().getCodeTemplateStore();
        TemplatePersistenceData data = codeTemplateStore.getTemplateData(templateId);
        Template orig = data.getTemplate();
        Template copy = new Template(orig.getName(), orig.getDescription(), orig.getContextTypeId(), pattern, true);
        data.setTemplate(copy);
    }

    private static Template getCodeTemplate(String id, IJavaScriptProject project) {
        if (project == null) {
            return JavaScriptPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            JavaScriptPlugin.log(e);
        }
        return projectStore.findTemplateById(id);
    }

    public static ImportRewrite createImportRewrite(IJavaScriptUnit cu, boolean restoreExistingImports) throws JavaScriptModelException {
        return CodeStyleConfiguration.createImportRewrite(cu, restoreExistingImports);
    }

    public static ImportRewrite createImportRewrite(JavaScriptUnit astRoot, boolean restoreExistingImports) {
        return CodeStyleConfiguration.createImportRewrite(astRoot, restoreExistingImports);
    }

    private static class ExcludedCollection
    extends AbstractList {
        private String[] fExcluded;

        public ExcludedCollection(String[] excluded) {
            this.fExcluded = excluded;
        }

        public String[] getExcludedArray() {
            return this.fExcluded;
        }

        @Override
        public int size() {
            return this.fExcluded.length;
        }

        @Override
        public Object get(int index) {
            return this.fExcluded[index];
        }

        @Override
        public int indexOf(Object o) {
            if (o instanceof String) {
                int i = 0;
                while (i < this.fExcluded.length) {
                    if (o.equals(this.fExcluded[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }
    }
}

