/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CodeRefactoringUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class InlineTempRefactoring
extends ScriptableRefactoring {
    private int fSelectionStart;
    private int fSelectionLength;
    private IJavaScriptUnit fCu;
    private VariableDeclaration fVariableDeclaration;
    private SimpleName[] fReferences;
    private JavaScriptUnit fASTRoot;

    public InlineTempRefactoring(IJavaScriptUnit unit, JavaScriptUnit node, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fASTRoot = node;
        this.fVariableDeclaration = null;
    }

    public InlineTempRefactoring(IJavaScriptUnit unit, int selectionStart, int selectionLength) {
        this(unit, null, selectionStart, selectionLength);
    }

    public InlineTempRefactoring(VariableDeclaration decl) {
        this.fVariableDeclaration = decl;
        ASTNode astRoot = decl.getRoot();
        Assert.isTrue((boolean)(astRoot instanceof JavaScriptUnit));
        this.fASTRoot = (JavaScriptUnit)astRoot;
        Assert.isTrue((boolean)(this.fASTRoot.getJavaElement() instanceof IJavaScriptUnit));
        this.fSelectionStart = decl.getStartPosition();
        this.fSelectionLength = decl.getLength();
        this.fCu = (IJavaScriptUnit)this.fASTRoot.getJavaElement();
    }

    public RefactoringStatus checkIfTempSelected() {
        VariableDeclaration decl = this.getVariableDeclaration();
        if (decl == null) {
            return CodeRefactoringUtil.checkMethodSyntaxErrors(this.fSelectionStart, this.fSelectionLength, this.getASTRoot(), RefactoringCoreMessages.InlineTempRefactoring_select_temp);
        }
        if (decl.getParent() instanceof FieldDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_fieldsCannotBeInlined);
        }
        return new RefactoringStatus();
    }

    private JavaScriptUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, null);
        }
        return this.fASTRoot;
    }

    public VariableDeclaration getVariableDeclaration() {
        if (this.fVariableDeclaration == null) {
            this.fVariableDeclaration = TempDeclarationFinder.findTempDeclaration(this.getASTRoot(), this.fSelectionStart, this.fSelectionLength);
        }
        return this.fVariableDeclaration;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineTempRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new IJavaScriptUnit[]{this.fCu}), this.getValidationContext());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            VariableDeclaration declaration = this.getVariableDeclaration();
            result.merge(this.checkSelection(declaration));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.checkInitializer(declaration));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkInitializer(VariableDeclaration decl) {
        if (decl.getInitializer().getNodeType() == 33) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTemRefactoring_error_message_nulLiteralsCannotBeInlined);
        }
        return null;
    }

    private RefactoringStatus checkSelection(VariableDeclaration decl) {
        ASTNode parent = decl.getParent();
        if (parent instanceof FunctionDeclaration) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_method_parameter);
        }
        if (parent instanceof CatchClause) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_exceptions_declared);
        }
        if (parent instanceof VariableDeclarationExpression && parent.getLocationInParent() == ForStatement.INITIALIZERS_PROPERTY) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineTempRefactoring_for_initializers);
        }
        if (decl.getInitializer() == null) {
            String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_not_initialized, decl.getName().getIdentifier());
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        return this.checkAssignments(decl);
    }

    private RefactoringStatus checkAssignments(VariableDeclaration decl) {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(decl);
        this.getASTRoot().accept((ASTVisitor)assignmentFinder);
        if (!assignmentFinder.hasAssignments()) {
            return new RefactoringStatus();
        }
        ASTNode firstAssignment = assignmentFinder.getFirstAssignment();
        int start = firstAssignment.getStartPosition();
        int length = firstAssignment.getLength();
        SourceRange range = new SourceRange(start, length);
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fCu, range);
        String message = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_assigned_more_once, decl.getName().getIdentifier());
        return RefactoringStatus.createFatalErrorStatus((String)message, (RefactoringStatusContext)context);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.InlineTempRefactoring_preview, 2);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaScriptProject javaProject = this.fCu.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            IVariableBinding binding = this.getVariableDeclaration().resolveBinding();
            String text = null;
            IFunctionBinding method = binding.getDeclaringMethod();
            text = method != null ? BindingLabelProvider.getBindingLabel((IBinding)method, JavaScriptElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
            String description = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description_short, binding.getName());
            String header = Messages.format(RefactoringCoreMessages.InlineTempRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), text});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.InlineTempRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.inline.temp", project, description, comment.asString(), arguments, 0);
            arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fCu));
            arguments.put("selection", String.valueOf(String.valueOf(this.fSelectionStart)) + ' ' + String.valueOf(this.fSelectionLength));
            CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(this.fCu, this.fASTRoot);
            this.inlineTemp(cuRewrite);
            this.removeTemp(cuRewrite);
            CompilationUnitChange result = cuRewrite.createChange(RefactoringCoreMessages.InlineTempRefactoring_inline, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)descriptor));
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void inlineTemp(CompilationUnitRewrite cuRewrite) throws JavaScriptModelException {
        SimpleName[] references = this.getReferences();
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_inline_edit_name);
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        int i = 0;
        while (i < references.length) {
            SimpleName curr = references[i];
            Expression initializerCopy = this.getInitializerSource(cuRewrite, curr);
            rewrite.replace((ASTNode)curr, (ASTNode)initializerCopy, groupDesc);
            ++i;
        }
    }

    private boolean needsBrackets(SimpleName name, VariableDeclaration variableDeclaration) {
        Expression initializer = variableDeclaration.getInitializer();
        if (initializer instanceof Assignment) {
            return true;
        }
        return ASTNodes.substituteMustBeParenthesized(initializer, (Expression)name);
    }

    private void removeTemp(CompilationUnitRewrite cuRewrite) throws JavaScriptModelException {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration();
        TextEditGroup groupDesc = cuRewrite.createGroupDescription(RefactoringCoreMessages.InlineTempRefactoring_remove_edit_name);
        ASTNode parent = variableDeclaration.getParent();
        ASTRewrite rewrite = cuRewrite.getASTRewrite();
        if (parent instanceof VariableDeclarationStatement && ((VariableDeclarationStatement)parent).fragments().size() == 1) {
            rewrite.remove(parent, groupDesc);
        } else {
            rewrite.remove((ASTNode)variableDeclaration, groupDesc);
        }
    }

    private Expression getInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference) throws JavaScriptModelException {
        Expression copy = this.getModifiedInitializerSource(rewrite, reference);
        boolean brackets = this.needsBrackets(reference, this.getVariableDeclaration());
        if (brackets) {
            ParenthesizedExpression parentExpr = rewrite.getAST().newParenthesizedExpression();
            parentExpr.setExpression(copy);
            return parentExpr;
        }
        return copy;
    }

    private Expression getModifiedInitializerSource(CompilationUnitRewrite rewrite, SimpleName reference) throws JavaScriptModelException {
        VariableDeclaration varDecl = this.getVariableDeclaration();
        Expression initializer = varDecl.getInitializer();
        ASTNode referenceContext = reference.getParent();
        if (InlineTempRefactoring.isInvocation(initializer) && Invocations.isResolvedTypeInferredFromExpectedType(initializer) && !(referenceContext instanceof VariableDeclarationFragment) && !(referenceContext instanceof SingleVariableDeclaration) && !(referenceContext instanceof Assignment)) {
            Invocations.resolveBinding((ASTNode)initializer);
            String newSource = this.createParameterizedInvocation(initializer, new Type[0]);
            return (Expression)rewrite.getASTRewrite().createStringPlaceholder(newSource, initializer.getNodeType());
        }
        Expression copy = (Expression)rewrite.getASTRewrite().createCopyTarget((ASTNode)initializer);
        if (initializer instanceof ArrayInitializer && ASTNodes.getDimensions(varDecl) > 0) {
            ArrayType newType = (ArrayType)ASTNodeFactory.newType(rewrite.getAST(), varDecl);
            ArrayCreation newArrayCreation = rewrite.getAST().newArrayCreation();
            newArrayCreation.setType(newType);
            newArrayCreation.setInitializer((ArrayInitializer)copy);
            return newArrayCreation;
        }
        return copy;
    }

    private String createParameterizedInvocation(Expression invocation, Type[] typeArgumentNodes) throws JavaScriptModelException {
        ASTRewrite rewrite = ASTRewrite.create((AST)invocation.getAST());
        ListRewrite typeArgsRewrite = rewrite.getListRewrite((ASTNode)invocation, Invocations.getTypeArgumentsProperty(invocation));
        int i = 0;
        while (i < typeArgumentNodes.length) {
            typeArgsRewrite.insertLast((ASTNode)typeArgumentNodes[i], null);
            ++i;
        }
        Document document = new Document(this.fCu.getBuffer().getContents());
        RangeMarker marker = new RangeMarker(invocation.getStartPosition(), invocation.getLength());
        IJavaScriptProject project = this.fCu.getJavaScriptProject();
        TextEdit[] rewriteEdits = rewrite.rewriteAST((IDocument)document, project.getOptions(true)).removeChildren();
        marker.addChildren(rewriteEdits);
        try {
            marker.apply((IDocument)document, 2);
            String rewrittenInitializer = document.get(marker.getOffset(), marker.getLength());
            IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
            int oldIndent = Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project);
            return Strings.changeIndent(rewrittenInitializer, oldIndent, project, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
        }
        catch (MalformedTreeException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
        return this.fCu.getBuffer().getText(invocation.getStartPosition(), invocation.getLength());
    }

    private static boolean isInvocation(Expression node) {
        return node instanceof FunctionInvocation || node instanceof SuperMethodInvocation;
    }

    public SimpleName[] getReferences() {
        if (this.fReferences != null) {
            return this.fReferences;
        }
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.getVariableDeclaration(), false);
        analyzer.perform();
        this.fReferences = analyzer.getReferenceNodes();
        return this.fReferences;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
        String selection = extended.getAttribute("selection");
        if (selection == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        int offset = -1;
        int length = -1;
        StringTokenizer tokenizer = new StringTokenizer(selection);
        if (tokenizer.hasMoreTokens()) {
            offset = Integer.valueOf(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            length = Integer.valueOf(tokenizer.nextToken());
        }
        if (offset < 0 || length < 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = extended.getAttribute("input");
        if (handle == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.inline.temp");
        }
        this.fCu = (IJavaScriptUnit)element;
        if (!this.checkIfTempSelected().hasFatalError()) return new RefactoringStatus();
        return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.inline.temp");
    }
}

