/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class ObjectToolsTests
extends TestCase {
    public ObjectToolsTests(String name) {
        super(name);
    }

    public void testEquals1() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.equals(null, null));
    }

    public void testEquals2() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.equals(null, (Object)"foo"));
    }

    public void testEquals3() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.equals((Object)"foo", null));
    }

    public void testEquals4() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.equals((Object)"foo", (Object)"foo"));
    }

    public void testEquals5() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.equals((Object)"foo", (Object)"bar"));
    }

    public void testNotEquals1() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.notEquals(null, null));
    }

    public void testNotEquals2() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.notEquals(null, (Object)"foo"));
    }

    public void testNotEquals3() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.notEquals((Object)"foo", null));
    }

    public void testNotEquals4() {
        ObjectToolsTests.assertFalse((boolean)ObjectTools.notEquals((Object)"foo", (Object)"foo"));
    }

    public void testNotEquals5() {
        ObjectToolsTests.assertTrue((boolean)ObjectTools.notEquals((Object)"foo", (Object)"bar"));
    }

    public void testToStringName_anonymous() {
        Object o = new Object(){};
        ObjectToolsTests.assertEquals((String)"Object", (String)ClassTools.toStringName(o.getClass()));
    }

    public void testToStringName_member() {
        ObjectToolsTests.assertEquals((String)"Map.Entry", (String)ClassTools.toStringName(Map.Entry.class));
    }

    public void testToStringName_local() {
        class Foo {
            1Foo.Bar bar = new 1Foo.Bar();

            Foo() {
            }

            class 1Foo.Bar {
                1Foo.Bar() {
                }
            }
        }
        Foo foo = new Foo();
        ObjectToolsTests.assertEquals((String)"ObjectToolsTests.Foo", (String)ClassTools.toStringName(foo.getClass()));
        ObjectToolsTests.assertEquals((String)"ObjectToolsTests.Foo.Bar", (String)ClassTools.toStringName(foo.bar.getClass()));
    }

    public void testGet() {
        Object bogusFieldValue;
        boolean exCaught;
        block2: {
            int initialCapacity = 200;
            Vector v = new Vector(initialCapacity);
            Object[] elementData = (Object[])ObjectTools.get(v, (String)"elementData");
            ObjectToolsTests.assertEquals((int)initialCapacity, (int)elementData.length);
            Integer modCountInteger = (Integer)ObjectTools.get(v, (String)"modCount");
            int modCount = modCountInteger;
            ObjectToolsTests.assertEquals((int)0, (int)modCount);
            exCaught = false;
            bogusFieldValue = null;
            try {
                bogusFieldValue = ObjectTools.get(v, (String)"bogusField");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((String)("NoSuchFieldException not thrown: " + bogusFieldValue), (boolean)exCaught);
    }

    public void testExecuteObjectString() {
        Vector<String> v = new Vector<String>();
        int size = (Integer)ObjectTools.execute(v, (String)"size");
        ObjectToolsTests.assertEquals((int)0, (int)size);
        v.addElement("foo");
        size = (Integer)ObjectTools.execute(v, (String)"size");
        ObjectToolsTests.assertEquals((int)1, (int)size);
    }

    public void testExecuteObjectStringClassObject() {
        Vector v = new Vector();
        boolean booleanResult = (Boolean)ObjectTools.execute(v, (String)"add", Object.class, (Object)"foo");
        ObjectToolsTests.assertTrue((boolean)booleanResult);
        ObjectToolsTests.assertTrue((boolean)v.contains("foo"));
        Object voidResult = ObjectTools.execute(v, (String)"addElement", Object.class, (Object)"bar");
        ObjectToolsTests.assertNull((Object)voidResult);
    }

    public void testExecuteObjectStringClassArrayObjectArray() {
        Object bogusMethodReturnValue;
        boolean exCaught;
        block2: {
            Vector v = new Vector();
            Class[] parmTypes = new Class[]{Object.class};
            Object[] args = new Object[]{"foo"};
            boolean booleanResult = (Boolean)ObjectTools.execute(v, (String)"add", (Class[])parmTypes, (Object[])args);
            ObjectToolsTests.assertTrue((boolean)booleanResult);
            ObjectToolsTests.assertTrue((boolean)v.contains("foo"));
            exCaught = false;
            bogusMethodReturnValue = null;
            try {
                bogusMethodReturnValue = ObjectTools.execute(v, (String)"bogusMethod", (Class[])parmTypes, (Object[])args);
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchMethodException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((String)("NoSuchMethodException not thrown: " + bogusMethodReturnValue), (boolean)exCaught);
    }

    public void testSet() {
        boolean exCaught;
        block2: {
            Vector v = new Vector();
            Object[] newElementData = new Object[5];
            newElementData[0] = "foo";
            ObjectTools.set(v, (String)"elementData", (Object)newElementData);
            ObjectTools.set(v, (String)"elementCount", (Object)new Integer(1));
            ObjectTools.set(v, (String)"modCount", (Object)new Integer(1));
            ObjectToolsTests.assertTrue((boolean)v.contains("foo"));
            exCaught = false;
            try {
                ObjectTools.set(v, (String)"bogusField", (Object)"foo");
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof NoSuchFieldException)) break block2;
                exCaught = true;
            }
        }
        ObjectToolsTests.assertTrue((String)"NoSuchFieldException not thrown", (boolean)exCaught);
    }
}

