/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentFamilyType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacetType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitClassType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererClassType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererType;
import org.eclipse.jst.jsf.facesconfig.emf.RendererTypeType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteRenderKitTestCase
extends BaseWriteTestCase {
    protected static final String RENDER_KIT = "render-kit";
    private static final String RENDER_KIT_ID = CommonStructuresUtil.createPreficedString("render-kit", "id");
    private static final String RENDER_KIT_CLASS = CommonStructuresUtil.createPreficedString("render-kit", "class");
    private static final String RENDERER = "renderer";
    private static final String COMPONENT_FAMILY = "component-family";
    private static final String RENDERER_COMPONENT_FAMILY = CommonStructuresUtil.createPreficedString("renderer", "component-family");
    private static final String RENDERER_TYPE = CommonStructuresUtil.createPreficedString("renderer", "type");
    private static final String RENDERER_CLASS = CommonStructuresUtil.createPreficedString("renderer", "class");

    public WriteRenderKitTestCase(String name) {
        super(name);
    }

    public void testWriteRenderKit() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteRenderKitTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            RenderKitType renderKit = facesConfigFactory.createRenderKitType();
            renderKit.getDescription().add((Object)CommonStructuresUtil.createDescription(RENDER_KIT));
            renderKit.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(RENDER_KIT));
            renderKit.getIcon().add((Object)CommonStructuresUtil.createIcon(RENDER_KIT));
            RenderKitIdType renderKitIdType = facesConfigFactory.createRenderKitIdType();
            renderKitIdType.setTextContent(RENDER_KIT);
            renderKitIdType.setId(CommonStructuresUtil.createPreficedString(RENDER_KIT, "id"));
            renderKit.setRenderKitId(renderKitIdType);
            RenderKitClassType renderKitClassType = facesConfigFactory.createRenderKitClassType();
            renderKitClassType.setTextContent(RENDER_KIT_CLASS);
            renderKitClassType.setId(CommonStructuresUtil.createPreficedString(RENDER_KIT_CLASS, "id"));
            renderKit.setRenderKitClass(renderKitClassType);
            RendererType renderer = facesConfigFactory.createRendererType();
            renderer.getDescription().add((Object)CommonStructuresUtil.createDescription(RENDERER));
            renderer.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(RENDERER));
            renderer.getIcon().add((Object)CommonStructuresUtil.createIcon(RENDERER));
            ComponentFamilyType componentFamily = facesConfigFactory.createComponentFamilyType();
            componentFamily.setTextContent(RENDERER_COMPONENT_FAMILY);
            componentFamily.setId(CommonStructuresUtil.createPreficedString(RENDERER_COMPONENT_FAMILY, "id"));
            renderer.setComponentFamily(componentFamily);
            RendererTypeType rendererTypeType = facesConfigFactory.createRendererTypeType();
            rendererTypeType.setTextContent(RENDERER_TYPE);
            rendererTypeType.setId(CommonStructuresUtil.createPreficedString(RENDERER_TYPE, "id"));
            renderer.setRendererType(rendererTypeType);
            RendererClassType rendererClassType = facesConfigFactory.createRendererClassType();
            rendererClassType.setTextContent(RENDERER_CLASS);
            rendererClassType.setId(CommonStructuresUtil.createPreficedString(RENDERER_CLASS, "id"));
            renderer.setRendererClass(rendererClassType);
            renderer.getAttribute().add((Object)CommonStructuresUtil.createAttribute(RENDERER));
            renderer.getFacet().add((Object)CommonStructuresUtil.createFacet(RENDERER));
            renderer.setId(CommonStructuresUtil.createPreficedString(RENDERER, "id"));
            renderKit.getRenderer().add((Object)renderer);
            renderKit.setId(RENDER_KIT_ID);
            edit.getFacesConfig().getRenderKit().add((Object)renderKit);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteRenderKitTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteRenderKitTestCase.assertNotNull((Object)edit.getFacesConfig());
            RenderKitType renderKit = (RenderKitType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getRenderKit(), RENDER_KIT_ID);
            WriteRenderKitTestCase.assertNotNull((Object)renderKit);
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderKit.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription(RENDER_KIT, (DescriptionType)renderKit.getDescription().get(0));
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderKit.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName(RENDER_KIT, (DisplayNameType)renderKit.getDisplayName().get(0));
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderKit.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon(RENDER_KIT, (IconType)renderKit.getIcon().get(0));
            RenderKitIdType renderKitIdType = renderKit.getRenderKitId();
            WriteRenderKitTestCase.assertEquals((String)RENDER_KIT, (String)renderKitIdType.getTextContent());
            WriteRenderKitTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDER_KIT, "id"), (String)renderKitIdType.getId());
            RenderKitClassType renderKitClassType = renderKit.getRenderKitClass();
            WriteRenderKitTestCase.assertEquals((String)RENDER_KIT_CLASS, (String)renderKitClassType.getTextContent());
            WriteRenderKitTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDER_KIT_CLASS, "id"), (String)renderKitClassType.getId());
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderKit.getRenderer().size());
            RendererType renderer = (RendererType)renderKit.getRenderer().get(0);
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderer.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription(RENDERER, (DescriptionType)renderer.getDescription().get(0));
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderer.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName(RENDERER, (DisplayNameType)renderer.getDisplayName().get(0));
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderer.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon(RENDERER, (IconType)renderer.getIcon().get(0));
            ComponentFamilyType componentFamily = renderer.getComponentFamily();
            WriteRenderKitTestCase.assertEquals((String)RENDERER_COMPONENT_FAMILY, (String)componentFamily.getTextContent());
            WriteRenderKitTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDERER_COMPONENT_FAMILY, "id"), (String)componentFamily.getId());
            RendererTypeType rendererTypeType = renderer.getRendererType();
            WriteRenderKitTestCase.assertEquals((String)RENDERER_TYPE, (String)rendererTypeType.getTextContent());
            WriteRenderKitTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDERER_TYPE, "id"), (String)rendererTypeType.getId());
            RendererClassType rendererClassType = renderer.getRendererClass();
            WriteRenderKitTestCase.assertEquals((String)RENDERER_CLASS, (String)rendererClassType.getTextContent());
            WriteRenderKitTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDERER_CLASS, "id"), (String)rendererClassType.getId());
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderer.getAttribute().size());
            CommonStructuresUtil.assertMatchAttribute(RENDERER, (AttributeType)renderer.getAttribute().get(0));
            WriteRenderKitTestCase.assertEquals((int)1, (int)renderer.getFacet().size());
            CommonStructuresUtil.assertMatchFacet(RENDERER, (FacetType)renderer.getFacet().get(0));
            WriteRenderKitTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDERER, "id"), (String)renderer.getId());
            WriteRenderKitTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(RENDER_KIT, "id"), (String)renderKit.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

