/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.io;

import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.io.Pipe;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class PipeTests
extends TestCase {
    volatile Pipe pipe;
    volatile byte[] buffer;
    volatile int position;
    volatile String string;
    volatile boolean exCaught;

    public PipeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.pipe = new Pipe(10);
        this.buffer = new byte[1000];
        this.position = 0;
        this.string = "The quick brown fox jumps over the lazy dog. The quick brown fox jumps over the lazy dog.";
        this.exCaught = false;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testPipe() throws Exception {
        this.verifyPipe(this.buildWriteRunnable(), this.buildReadRunnable());
    }

    public void testPipeWrite1() throws Exception {
        this.verifyPipe(this.buildWriteRunnable1(), this.buildReadRunnable());
    }

    public void testPipeRead1() throws Exception {
        this.verifyPipe(this.buildWriteRunnable(), this.buildReadRunnable1());
    }

    public void testPipeWrite1Read1() throws Exception {
        this.verifyPipe(this.buildWriteRunnable1(), this.buildReadRunnable1());
    }

    private void verifyPipe(Runnable writer, Runnable reader) throws Exception {
        Thread readThread = new Thread(reader);
        readThread.start();
        writer.run();
        readThread.join();
        PipeTests.assertFalse((boolean)this.exCaught);
        PipeTests.assertEquals((String)this.string, (String)new String(this.buffer, 0, this.position));
    }

    public void testPipeTruncate() throws Exception {
        this.verifyPipeTruncate(this.buildWriteRunnable(), this.buildReadRunnable());
    }

    public void testPipeTruncateWrite1() throws Exception {
        this.verifyPipeTruncate(this.buildWriteRunnable1(), this.buildReadRunnable());
    }

    public void testPipeTruncateRead1() throws Exception {
        this.verifyPipeTruncate(this.buildWriteRunnable(), this.buildReadRunnable1());
    }

    public void testPipeTruncateWrite1Read1() throws Exception {
        this.verifyPipeTruncate(this.buildWriteRunnable1(), this.buildReadRunnable1());
    }

    private void verifyPipeTruncate(Runnable writer, Runnable reader) throws Exception {
        this.buffer = new byte[20];
        Thread readThread = new Thread(reader);
        readThread.start();
        writer.run();
        readThread.join();
        PipeTests.assertFalse((boolean)this.exCaught);
        PipeTests.assertEquals((String)this.string.substring(0, 20), (String)new String(this.buffer, 0, this.position));
    }

    private Runnable buildWriteRunnable() {
        return new Runnable(){

            public void run() {
                block2: {
                    OutputStream out = PipeTests.this.pipe.getOutputStream();
                    try {
                        out.write(PipeTests.this.string.getBytes());
                        out.close();
                    }
                    catch (Exception ex) {
                        if (ex.getMessage().equals("Pipe closed")) break block2;
                        PipeTests.this.exCaught = true;
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    private Runnable buildWriteRunnable1() {
        return new Runnable(){

            public void run() {
                block3: {
                    OutputStream out = PipeTests.this.pipe.getOutputStream();
                    try {
                        byte[] bytes;
                        byte[] byArray = bytes = PipeTests.this.string.getBytes();
                        int n = bytes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            out.write(b);
                            ++n2;
                        }
                        out.close();
                    }
                    catch (Exception ex) {
                        if (ex.getMessage().equals("Pipe closed")) break block3;
                        PipeTests.this.exCaught = true;
                        ex.printStackTrace();
                    }
                }
            }
        };
    }

    private Runnable buildReadRunnable() {
        return new Runnable(){

            public void run() {
                try {
                    InputStream in = PipeTests.this.pipe.getInputStream();
                    int len = PipeTests.this.buffer.length;
                    int bytesRead = 0;
                    do {
                        if (len <= 0) {
                            in.close();
                            return;
                        }
                        bytesRead = in.read(PipeTests.this.buffer, PipeTests.this.position, len);
                        if (bytesRead == -1) continue;
                        PipeTests.this.position += bytesRead;
                        len -= bytesRead;
                    } while (bytesRead != -1);
                    in.close();
                }
                catch (Exception ex) {
                    PipeTests.this.exCaught = true;
                    ex.printStackTrace();
                }
            }
        };
    }

    private Runnable buildReadRunnable1() {
        return new Runnable(){

            public void run() {
                try {
                    InputStream in = PipeTests.this.pipe.getInputStream();
                    int len = PipeTests.this.buffer.length;
                    int b = -1;
                    do {
                        if (len <= 0) {
                            in.close();
                            return;
                        }
                        b = in.read();
                        if (b == -1) continue;
                        PipeTests.this.buffer[PipeTests.this.position] = (byte)b;
                        ++PipeTests.this.position;
                        --len;
                    } while (b != -1);
                    in.close();
                }
                catch (Exception ex) {
                    PipeTests.this.exCaught = true;
                    ex.printStackTrace();
                }
            }
        };
    }

    public void testAvailable() throws Exception {
        this.pipe = new Pipe(5000);
        this.buildWriteRunnable().run();
        PipeTests.assertEquals((int)this.string.length(), (int)this.pipe.getInputStream().available());
        byte[] bytes = new byte[20];
        this.pipe.getInputStream().read(bytes);
        PipeTests.assertEquals((String)this.string.substring(0, 20), (String)new String(bytes));
        PipeTests.assertEquals((int)(this.string.length() - 20), (int)this.pipe.getInputStream().available());
    }

    public void testFullPipe() throws Exception {
        this.verifyFullPipe(this.buildWriteRunnable(), this.buildReadRunnable());
    }

    public void testFullPipe1() throws Exception {
        this.verifyFullPipe(this.buildWriteRunnable1(), this.buildReadRunnable1());
    }

    private void verifyFullPipe(Runnable writer, Runnable reader) throws Exception {
        this.pipe = new Pipe(5);
        this.string = "12345";
        int len = this.string.length();
        this.buffer = new byte[len];
        writer.run();
        reader.run();
        PipeTests.assertEquals((String)this.string, (String)new String(this.buffer, 0, len));
    }

    public void testPipeLaps() throws Exception {
        this.pipe = new Pipe(10);
        OutputStream out = this.pipe.getOutputStream();
        InputStream in = this.pipe.getInputStream();
        this.string = "0123456789";
        out.write(this.string.getBytes());
        PipeTests.assertEquals((int)10, (int)in.available());
        int bytesRead = in.read(this.buffer, 0, 5);
        PipeTests.assertEquals((int)5, (int)in.available());
        PipeTests.assertEquals((int)5, (int)bytesRead);
        PipeTests.assertEquals((String)"01234", (String)new String(this.buffer, 0, 5));
        this.string = "abcde";
        out.write(this.string.getBytes());
        PipeTests.assertEquals((int)10, (int)in.available());
        bytesRead = in.read(this.buffer, 0, 10);
        PipeTests.assertEquals((int)0, (int)in.available());
        PipeTests.assertEquals((int)10, (int)bytesRead);
        PipeTests.assertEquals((String)"56789abcde", (String)new String(this.buffer, 0, 10));
    }

    public void testPipeLaps1() throws Exception {
        byte b;
        byte[] bytes;
        this.pipe = new Pipe(10);
        OutputStream out = this.pipe.getOutputStream();
        InputStream in = this.pipe.getInputStream();
        this.string = "0123456789";
        byte[] byArray = bytes = this.string.getBytes();
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            b = byArray[n2];
            out.write(b);
            ++n2;
        }
        PipeTests.assertEquals((int)10, (int)in.available());
        int i = 0;
        while (i < 5) {
            this.buffer[i] = (byte)in.read();
            ++i;
        }
        PipeTests.assertEquals((int)5, (int)in.available());
        PipeTests.assertEquals((String)"01234", (String)new String(this.buffer, 0, 5));
        this.string = "abcde";
        byArray = bytes = this.string.getBytes();
        n = bytes.length;
        n2 = 0;
        while (n2 < n) {
            b = byArray[n2];
            out.write(b);
            ++n2;
        }
        PipeTests.assertEquals((int)10, (int)in.available());
        i = 0;
        while (i < 10) {
            this.buffer[i] = (byte)in.read();
            ++i;
        }
        PipeTests.assertEquals((int)0, (int)in.available());
        PipeTests.assertEquals((String)"56789abcde", (String)new String(this.buffer, 0, 10));
    }

    public void testTimeout() throws Exception {
        this.pipe = new Pipe(100, 100L);
        boolean timeout = false;
        try {
            this.pipe.getInputStream().read(new byte[50]);
        }
        catch (InterruptedIOException interruptedIOException) {
            timeout = true;
        }
        PipeTests.assertTrue((boolean)timeout);
    }

    public void testRecloseWriteStream() throws Exception {
        this.testPipe();
        boolean closeFailed = false;
        try {
            this.pipe.getOutputStream().close();
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage().equals("OutputStream already closed")) {
                closeFailed = true;
            }
            throw ex;
        }
        PipeTests.assertTrue((boolean)closeFailed);
    }

    public void testRecloseReadStream() throws Exception {
        this.testPipe();
        boolean closeFailed = false;
        try {
            this.pipe.getInputStream().close();
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage().equals("InputStream already closed")) {
                closeFailed = true;
            }
            throw ex;
        }
        PipeTests.assertTrue((boolean)closeFailed);
    }

    public void testMultipleThreads() throws Exception {
        Thread rt1 = new Thread(this.buildReadRunnable(2));
        rt1.start();
        Thread rt2 = new Thread(this.buildReadRunnable(2));
        rt2.start();
        String string1 = "abcdefghijklmnopqrstuvwxyz";
        Thread wt1 = new Thread(this.buildWriteRunnable(string1.getBytes(), 3));
        wt1.start();
        String string2 = "01234567890123456789";
        Thread wt2 = new Thread(this.buildWriteRunnable(string2.getBytes(), 3));
        wt2.start();
        wt2.join();
        wt1.join();
        this.pipe.getOutputStream().close();
        rt2.join();
        rt1.join();
        PipeTests.assertFalse((boolean)this.exCaught);
    }

    private Runnable buildReadRunnable(final int chunkSize) {
        return new Runnable(){

            public void run() {
                try {
                    InputStream in = PipeTests.this.pipe.getInputStream();
                    byte[] bytes = new byte[chunkSize];
                    boolean moreBytes = true;
                    while (moreBytes) {
                        int totalBytesRead = 0;
                        while (totalBytesRead < chunkSize) {
                            int bytesRead = in.read(bytes, totalBytesRead, bytes.length - totalBytesRead);
                            if (bytesRead == -1) {
                                moreBytes = false;
                                break;
                            }
                            totalBytesRead += bytesRead;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (Exception ex) {
                    PipeTests.this.exCaught = true;
                    ex.printStackTrace();
                }
            }
        };
    }

    private Runnable buildWriteRunnable(final byte[] bytes, final int chunkSize) {
        return new Runnable(){

            public void run() {
                try {
                    OutputStream out = PipeTests.this.pipe.getOutputStream();
                    int totalBytesWritten = 0;
                    int remainingBytes = bytes.length;
                    while (remainingBytes > 0) {
                        int bytesWritten = Math.min(chunkSize, remainingBytes);
                        out.write(bytes, totalBytesWritten, bytesWritten);
                        totalBytesWritten += bytesWritten;
                        remainingBytes -= bytesWritten;
                        Thread.sleep(100L);
                    }
                }
                catch (Exception ex) {
                    PipeTests.this.exCaught = true;
                    ex.printStackTrace();
                }
            }
        };
    }
}

