/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationIterator;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.ArrayToolsTests;
import org.eclipse.jpt.common.utility.tests.internal.collection.MapToolsTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorToolsTests
extends TestCase {
    public IteratorToolsTests(String name) {
        super(name);
    }

    public void testContainsIteratorObject_Object() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        IteratorToolsTests.assertTrue((boolean)IteratorTools.contains(c.iterator(), (Object)one));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.contains(c.iterator(), null));
        c.add(null);
        IteratorToolsTests.assertTrue((boolean)IteratorTools.contains(c.iterator(), null));
    }

    public void testContainsIteratorObject_String() {
        List<String> c = this.buildStringList1();
        IteratorToolsTests.assertTrue((boolean)IteratorTools.contains(c.iterator(), (Object)"one"));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.contains(c.iterator(), null));
        c.add(null);
        IteratorToolsTests.assertTrue((boolean)IteratorTools.contains(c.iterator(), null));
    }

    public void testCountIteratorObject() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.count(c.iterator(), (Object)one));
        c.add("one");
        IteratorToolsTests.assertEquals((int)2, (int)IteratorTools.count(c.iterator(), (Object)one));
        IteratorToolsTests.assertEquals((int)0, (int)IteratorTools.count(c.iterator(), null));
        c.add(null);
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.count(c.iterator(), null));
        c.add(null);
        IteratorToolsTests.assertEquals((int)2, (int)IteratorTools.count(c.iterator(), null));
    }

    public void testCountFalseIteratorPredicate() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        IteratorToolsTests.assertEquals((int)4, (int)IteratorTools.countFalse(c.iterator(), (Predicate)new MapToolsTests.StringLengthPredicate(0)));
        IteratorToolsTests.assertEquals((int)2, (int)IteratorTools.countFalse(c.iterator(), (Predicate)new MapToolsTests.StringLengthPredicate(3)));
        c.add("foo");
        IteratorToolsTests.assertEquals((int)2, (int)IteratorTools.countFalse(c.iterator(), (Predicate)new MapToolsTests.StringLengthPredicate(3)));
    }

    public void testCountTrueIteratorPredicate() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        IteratorToolsTests.assertEquals((int)0, (int)IteratorTools.countTrue(c.iterator(), (Predicate)new MapToolsTests.StringLengthPredicate(0)));
        IteratorToolsTests.assertEquals((int)2, (int)IteratorTools.countTrue(c.iterator(), (Predicate)new MapToolsTests.StringLengthPredicate(3)));
        c.add("foo");
        IteratorToolsTests.assertEquals((int)3, (int)IteratorTools.countTrue(c.iterator(), (Predicate)new MapToolsTests.StringLengthPredicate(3)));
    }

    public void testContainsAllIteratorCollection_StringString() {
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), this.buildStringList2()));
    }

    public void testContainsAllIteratorIntCollection() {
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)5, this.buildStringList1()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)5, this.buildStringList2()));
    }

    public void testContainsAllIteratorIntIterable() {
        List<String> iterable = this.buildStringList1();
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)3, iterable));
        iterable = this.buildStringList2();
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)3, iterable));
    }

    public void testContainsAllIteratorIntIterator() {
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)3, this.buildStringList1().iterator()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)3, this.buildStringList2().iterator()));
    }

    public void testContainsAllIteratorIntObjectArray() {
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)3, (Object[])this.buildObjectArray1()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (int)3, (Object[])this.buildObjectArray2()));
    }

    public void testContainsAllIteratorIterable() {
        List<String> iterable = this.buildStringList1();
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), iterable));
        iterable = this.buildStringList2();
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), iterable));
    }

    public void testContainsAllIteratorIterator_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(c1.iterator(), c2.iterator()));
    }

    public void testContainsAllIteratorIterator_StringString() {
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1().iterator()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), this.buildStringList2().iterator()));
    }

    public void testContainsAllIteratorObjectArray() {
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (Object[])this.buildObjectArray1()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.containsAll(this.buildStringList1().iterator(), (Object[])this.buildObjectArray2()));
    }

    public void testContainsAllIteratorCollection_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        IteratorToolsTests.assertTrue((boolean)IteratorTools.containsAll(c1.iterator(), c2));
    }

    public void testElementsAreDifferentIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList list2 = new ArrayList();
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreDifferent(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertFalse((boolean)IterableTools.elementsAreEqual(list1, list2));
    }

    public void testElementsAreEqualIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList<String> list2 = new ArrayList<String>();
        int i = 0;
        while (i < list1.size()) {
            list2.add(String.valueOf((i + 1) * 1000));
            ++i;
        }
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreDifferent(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreIdenticalIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreIdenticalIteratorIterator_Not() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(0);
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreIdenticalIteratorIterator_DifferentSizes() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(3);
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreNotIdenticalIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreNotIdentical(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreNotIdenticalIteratorIterator_Not() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(0);
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreNotIdentical(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreNotIdenticalIteratorIterator_DifferentSizes() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(3);
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreNotIdentical(list1.iterator(), list2.iterator()));
        IteratorToolsTests.assertFalse((boolean)IteratorTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testExecuteParmCommand() {
        List<String> list = this.buildStringList1();
        ArrayToolsTests.ConcatenateClosure closure = new ArrayToolsTests.ConcatenateClosure();
        IteratorTools.execute(list.iterator(), (Closure)closure);
        IteratorToolsTests.assertEquals((String)"zeroonetwo", (String)closure.string);
    }

    public void testExecuteInterruptibleParmCommand() throws Exception {
        List<String> list = this.buildStringList1();
        ArrayToolsTests.InterruptibleConcatenateClosure closure = new ArrayToolsTests.InterruptibleConcatenateClosure();
        IteratorTools.execute(list.iterator(), (InterruptibleClosure)closure);
        IteratorToolsTests.assertEquals((String)"zeroonetwo", (String)closure.string);
    }

    public void testGetIteratorInt1() {
        List<String> list = this.buildStringList1();
        String o = (String)IteratorTools.get(list.iterator(), (int)1);
        IteratorToolsTests.assertEquals((String)"one", (String)o);
        list.add(null);
        o = (String)IteratorTools.get(list.iterator(), (int)(list.size() - 1));
        IteratorToolsTests.assertNull((Object)o);
    }

    public void testGetIteratorInt2() {
        List<String> list = this.buildStringList1();
        boolean exCaught = false;
        try {
            IteratorTools.get(list.iterator(), (int)list.size());
            IteratorToolsTests.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        IteratorToolsTests.assertTrue((boolean)exCaught);
    }

    public void testIndexOfIteratorObject_String() {
        List<String> list = this.buildStringList1();
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.indexOf(list.iterator(), (Object)"one"));
    }

    public void testIndexOfIteratorObjectInt() {
        List<String> list = this.buildStringList1();
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.indexOf(list.iterator(), (Object)"one", (int)-1));
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.indexOf(list.iterator(), (Object)"one", (int)1));
        IteratorToolsTests.assertEquals((int)2, (int)IteratorTools.indexOf(list.iterator(), (Object)"two", (int)1));
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.indexOf(list.iterator(), (Object)"one", (int)2));
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.indexOf(list.iterator(), (Object)"one", (int)22));
    }

    public void testIndexOfIteratorObject_String_Not() {
        List<String> list = this.buildStringList1();
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.indexOf(list.iterator(), null));
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.indexOf(list.iterator(), (Object)"shazam"));
    }

    public void testIndexOfIteratorObject_Null() {
        List<String> list = this.buildStringList1();
        list.add(null);
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.indexOf(list.iterator(), null));
    }

    public void testIndexOfIteratorObjectInt_Null() {
        List<String> list = this.buildStringList1();
        list.add(null);
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.indexOf(list.iterator(), null, (int)-1));
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.indexOf(list.iterator(), null, (int)2));
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.indexOf(list.iterator(), null, (int)(list.size() - 1)));
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.indexOf(list.iterator(), null, (int)22));
    }

    public void testIndexOfIteratorObject_Object() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        String one = "1";
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.indexOf(list.iterator(), (Object)one));
        list.add(null);
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.indexOf(list.iterator(), null));
    }

    public void testIsEmptyIterator() {
        IteratorToolsTests.assertFalse((boolean)IteratorTools.isEmpty(this.buildObjectList1().iterator()));
        IteratorToolsTests.assertTrue((boolean)IteratorTools.isEmpty((Iterator)EmptyIterator.instance()));
    }

    public void testIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        ArrayIterator stream = IteratorTools.iterator((Object[])a);
        while (stream.hasNext()) {
            IteratorToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testFirstIterator1() {
        List<String> list = this.buildStringList1();
        IteratorToolsTests.assertEquals((String)"zero", (String)((String)IteratorTools.first(list.iterator())));
        list.add(0, null);
        IteratorToolsTests.assertEquals(null, (String)((String)IteratorTools.first(list.iterator())));
    }

    public void testFirstIterator2() {
        ArrayList list = new ArrayList();
        boolean exCaught = false;
        try {
            IteratorTools.first(list.iterator());
            IteratorToolsTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IteratorToolsTests.assertTrue((boolean)exCaught);
    }

    public void testLastIterator1() {
        List<String> list = this.buildStringList1();
        IteratorToolsTests.assertEquals((String)"two", (String)((String)IteratorTools.last(list.iterator())));
        list.add(null);
        IteratorToolsTests.assertEquals(null, (String)((String)IteratorTools.last(list.iterator())));
    }

    public void testLastIterator2() {
        ArrayList list = new ArrayList();
        boolean exCaught = false;
        try {
            IteratorTools.last(list.iterator());
            IteratorToolsTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IteratorToolsTests.assertTrue((boolean)exCaught);
    }

    public void testLastIndexOfIteratorObject() {
        List<String> list = this.buildStringList1();
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.lastIndexOf(list.iterator(), (Object)"one"));
        list.add(null);
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.lastIndexOf(list.iterator(), null));
    }

    public void testLastIndexOfIteratorObjectInt() {
        List<String> list = this.buildStringList1();
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.lastIndexOf(list.iterator(), (Object)"one", (int)-1));
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.lastIndexOf(list.iterator(), (Object)"one", (int)1));
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.lastIndexOf(list.iterator(), (Object)"two", (int)1));
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.lastIndexOf(list.iterator(), (Object)"one", (int)2));
        IteratorToolsTests.assertEquals((int)1, (int)IteratorTools.lastIndexOf(list.iterator(), (Object)"one", (int)22));
    }

    public void testLastIndexOfIteratorObject_Empty() {
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.lastIndexOf((Iterator)EmptyIterator.instance(), (Object)"foo"));
    }

    public void testLastIndexOfIteratorObjectInt_Null() {
        List<String> list = this.buildStringList1();
        list.add(null);
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.lastIndexOf(list.iterator(), null, (int)-1));
        IteratorToolsTests.assertEquals((int)-1, (int)IteratorTools.lastIndexOf(list.iterator(), null, (int)2));
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.lastIndexOf(list.iterator(), null, (int)(list.size() - 1)));
        IteratorToolsTests.assertEquals((int)(list.size() - 1), (int)IteratorTools.lastIndexOf(list.iterator(), null, (int)22));
    }

    public void testListIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        ArrayListIterator stream = IteratorTools.listIterator((Object[])a);
        while (stream.hasNext()) {
            IteratorToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testListIteratorObjectArrayInt() {
        Object[] a = this.buildStringArray1();
        int i = 1;
        ArrayListIterator stream = IteratorTools.listIterator((Object[])a, (int)1);
        while (stream.hasNext()) {
            IteratorToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testSingletonIterator_String() {
        SingleElementIterator stream = IteratorTools.singletonIterator((Object)"foo");
        IteratorToolsTests.assertTrue((boolean)stream.hasNext());
        IteratorToolsTests.assertEquals((String)"foo", (String)((String)stream.next()));
    }

    public void testSingletonIterator_Object() {
        SingleElementIterator stream = IteratorTools.singletonIterator((Object)"foo");
        IteratorToolsTests.assertTrue((boolean)stream.hasNext());
        IteratorToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSingletonIterator_Cast() {
        SingleElementIterator stream = IteratorTools.singletonIterator((Object)"foo");
        IteratorToolsTests.assertTrue((boolean)stream.hasNext());
        IteratorToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSingletonListIterator_String() {
        SingleElementListIterator stream = IteratorTools.singletonListIterator((Object)"foo");
        IteratorToolsTests.assertTrue((boolean)stream.hasNext());
        IteratorToolsTests.assertEquals((String)"foo", (String)((String)stream.next()));
        IteratorToolsTests.assertFalse((boolean)stream.hasNext());
        IteratorToolsTests.assertTrue((boolean)stream.hasPrevious());
        IteratorToolsTests.assertEquals((String)"foo", (String)((String)stream.previous()));
    }

    public void testSizeIterator() {
        IteratorToolsTests.assertEquals((int)3, (int)IteratorTools.size(this.buildObjectList1().iterator()));
    }

    public void testSortIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = IteratorTools.sort(iterator1);
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testSortIteratorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = IteratorTools.sort(iterator1, (int)77);
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testSortIteratorComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>(ComparatorTools.reverseComparator());
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = IteratorTools.sort(iterator1, (Comparator)ComparatorTools.reverseComparator());
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testSortIteratorComparatorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>(ComparatorTools.reverseComparator());
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = IteratorTools.sort(iterator1, (Comparator)ComparatorTools.reverseComparator(), (int)77);
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ClassTools.newInstance(IteratorTools.class);
                IteratorToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        IteratorToolsTests.assertTrue((boolean)exCaught);
    }

    public void testTransformIteratorTransformer() {
        List<String> list = Arrays.asList("zero", "one", "two");
        TransformationIterator actual = IteratorTools.transform(list.iterator(), ArrayToolsTests.UPPER_CASE_TRANSFORMER);
        Iterator<Object> expected = Arrays.asList("ZERO", "ONE", "TWO").iterator();
        IteratorToolsTests.assertTrue((boolean)IteratorTools.elementsAreEqual(expected, (Iterator)actual));
    }

    private Object[] buildObjectArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private Object[] buildObjectArray2() {
        return new Object[]{"three", "four", "five"};
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private List<Object> buildObjectList1() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private List<String> buildStringList2() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection2(Collection<? super String> c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }
}

