/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.exception.RuntimeExceptionHandler;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.tests.internal.model.value.CoordinatedBag;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCollectionValueModelTests
extends TestCase {
    private Neighborhood neighborhood;
    private ModifiablePropertyValueModel<Neighborhood> neighborhoodHolder;

    public CompositeCollectionValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.neighborhood = new Neighborhood("Hanna-Barbera");
        this.neighborhoodHolder = new SimplePropertyValueModel((Object)this.neighborhood);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSynch() {
        this.verifySynch((CollectionValueModel<Member>)this.buildAllMembersComposite((PropertyValueModel<Neighborhood>)this.neighborhoodHolder));
    }

    private void verifySynch(CollectionValueModel<Member> compositeCVM) {
        CompositeCollectionValueModelTests.assertEquals((int)0, (int)IteratorTools.size((Iterator)compositeCVM.iterator()));
        CoordinatedBag<Family> familiesSynch = new CoordinatedBag<Family>(this.buildFamiliesAspectAdapter((PropertyValueModel<Neighborhood>)this.neighborhoodHolder));
        CoordinatedBag<Member> membersSynch = new CoordinatedBag<Member>(compositeCVM);
        this.populateNeighborhood(this.neighborhood);
        Family jetsons = this.neighborhood.familyNamed("Jetson");
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)12, (int)IteratorTools.size(this.neighborhood.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)12, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(this.neighborhood.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
        jetsons.removeMember(jetsons.memberNamed("Astro"));
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)11, (int)IteratorTools.size(this.neighborhood.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)11, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(this.neighborhood.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
        jetsons.removeMember(jetsons.memberNamed("Judy"));
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)10, (int)IteratorTools.size(this.neighborhood.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)10, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(this.neighborhood.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
        jetsons.addMember("Fido");
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)11, (int)IteratorTools.size(this.neighborhood.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)11, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(this.neighborhood.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
        this.neighborhood.removeFamily(jetsons);
        CompositeCollectionValueModelTests.assertEquals((int)2, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)7, (int)IteratorTools.size(this.neighborhood.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)7, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(this.neighborhood.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
        Family bears = this.neighborhood.addFamily("Bear");
        bears.addMember("Yogi");
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)8, (int)IteratorTools.size(this.neighborhood.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)8, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(this.neighborhood.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
        bears.addMember("Boo-Boo");
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)9, (int)IteratorTools.size(this.neighborhood.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)9, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(this.neighborhood.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
        Neighborhood n2 = new Neighborhood("Hanna-Barbera 2");
        this.neighborhoodHolder.setValue((Object)n2);
        this.populateNeighborhood(n2);
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)familiesSynch.size());
        CompositeCollectionValueModelTests.assertEquals((int)12, (int)IteratorTools.size(n2.allMembers()));
        CompositeCollectionValueModelTests.assertEquals((int)12, (int)membersSynch.size());
        CompositeCollectionValueModelTests.assertEquals((Object)CollectionTools.bag(n2.allMembers()), membersSynch);
        CompositeCollectionValueModelTests.assertEquals(membersSynch, (Object)CollectionTools.bag((Iterator)compositeCVM.iterator()));
    }

    public void testNoTransformer() {
        SimpleCollectionValueModel subCVM1 = new SimpleCollectionValueModel();
        SimpleCollectionValueModel subCVM2 = new SimpleCollectionValueModel();
        ArrayList<SimpleCollectionValueModel> collection = new ArrayList<SimpleCollectionValueModel>();
        collection.add(subCVM1);
        collection.add(subCVM2);
        CoordinatedBag synchBag = new CoordinatedBag(CompositeCollectionValueModel.forModels(collection));
        CompositeCollectionValueModelTests.assertEquals((int)0, (int)synchBag.size());
        subCVM1.add((Object)"foo");
        subCVM1.add((Object)"bar");
        subCVM1.add((Object)"baz");
        CompositeCollectionValueModelTests.assertEquals((int)3, (int)synchBag.size());
        CompositeCollectionValueModelTests.assertTrue((boolean)synchBag.contains("foo"));
        subCVM2.add((Object)"joo");
        subCVM2.add((Object)"jar");
        subCVM2.add((Object)"jaz");
        CompositeCollectionValueModelTests.assertEquals((int)6, (int)synchBag.size());
        CompositeCollectionValueModelTests.assertTrue((boolean)synchBag.contains("foo"));
        CompositeCollectionValueModelTests.assertTrue((boolean)synchBag.contains("jaz"));
        subCVM1.remove((Object)"baz");
        CompositeCollectionValueModelTests.assertEquals((int)5, (int)synchBag.size());
        CompositeCollectionValueModelTests.assertFalse((boolean)synchBag.contains("baz"));
    }

    public void testDuplicateItem() {
        boolean exCaught;
        CoordinatedBag synchBag;
        block2: {
            synchBag = new CoordinatedBag(this.buildAllMembersComposite((PropertyValueModel<Neighborhood>)this.neighborhoodHolder));
            this.populateNeighborhood(this.neighborhood);
            exCaught = false;
            try {
                this.neighborhood.addFamily(this.neighborhood.familyNamed("Jetson"));
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().indexOf("duplicate component") == -1) break block2;
                exCaught = true;
            }
        }
        CompositeCollectionValueModelTests.assertTrue((boolean)exCaught);
        CompositeCollectionValueModelTests.assertEquals((int)12, (int)synchBag.size());
    }

    public void testHasListeners() {
        CompositeCollectionValueModel<Family, Member> compositeCVM = this.buildAllMembersComposite((PropertyValueModel<Neighborhood>)this.neighborhoodHolder);
        CoordinatedBag synchBag = new CoordinatedBag(compositeCVM);
        this.populateNeighborhood(this.neighborhood);
        Family jetsons = this.neighborhood.familyNamed("Jetson");
        CompositeCollectionValueModelTests.assertTrue((boolean)compositeCVM.hasAnyCollectionChangeListeners("values"));
        CompositeCollectionValueModelTests.assertTrue((boolean)jetsons.hasAnyCollectionChangeListeners("members"));
        compositeCVM.removeCollectionChangeListener("values", synchBag);
        CompositeCollectionValueModelTests.assertFalse((boolean)compositeCVM.hasAnyCollectionChangeListeners("values"));
        CompositeCollectionValueModelTests.assertFalse((boolean)jetsons.hasAnyCollectionChangeListeners("members"));
        compositeCVM.addCollectionChangeListener("values", synchBag);
        CompositeCollectionValueModelTests.assertTrue((boolean)compositeCVM.hasAnyCollectionChangeListeners("values"));
        CompositeCollectionValueModelTests.assertTrue((boolean)jetsons.hasAnyCollectionChangeListeners("members"));
    }

    private void populateNeighborhood(Neighborhood n) {
        Family family1 = n.addFamily("Flintstone");
        family1.addMember("Fred");
        family1.addMember("Wilma");
        family1.addMember("Pebbles");
        family1.addMember("Dino");
        Family family2 = n.addFamily("Rubble");
        family2.addMember("Barney");
        family2.addMember("Betty");
        family2.addMember("Bamm-Bamm");
        Family family3 = n.addFamily("Jetson");
        family3.addMember("George");
        family3.addMember("Jane");
        family3.addMember("Judy");
        family3.addMember("Elroy");
        family3.addMember("Astro");
    }

    private CollectionValueModel<Family> buildFamiliesAspectAdapter(PropertyValueModel<Neighborhood> communeHolder) {
        return new CollectionAspectAdapter<Neighborhood, Family>(communeHolder, new String[]{"families"}){

            protected Iterator<Family> iterator_() {
                return ((Neighborhood)((Object)this.subject)).families();
            }

            protected ChangeSupport buildChangeSupport() {
                return new AspectAdapter.LocalChangeSupport((AspectAdapter)this, (AspectAdapter)this, this.getListenerClass(), this.getListenerAspectName(), RuntimeExceptionHandler.instance());
            }
        };
    }

    CollectionValueModel<Member> buildMembersAdapter(Family family) {
        return new CollectionAspectAdapter<Family, Member>("members", family){

            protected Iterator<Member> iterator_() {
                return ((Family)((Object)this.subject)).members();
            }
        };
    }

    private CompositeCollectionValueModel<Family, Member> buildAllMembersComposite(PropertyValueModel<Neighborhood> communeHolder) {
        return new CompositeCollectionValueModel(this.buildFamiliesAspectAdapter(communeHolder), this.buildTransformer());
    }

    private Transformer<Family, CollectionValueModel<Member>> buildTransformer() {
        return new FamilyTransformer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Family
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";
        private Collection<Member> members = new ArrayList<Member>();
        public static final String MEMBERS_COLLECTION = "members";
        public static final Transformer<Family, Iterator<Member>> MEMBERS_TRANSFORMER = new MembersTransformer();

        public Family(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public Iterator<Member> members() {
            return this.members.iterator();
        }

        public Member addMember(String memberName) {
            Member member = new Member(memberName);
            this.addItemToCollection((Object)member, this.members, MEMBERS_COLLECTION);
            return member;
        }

        public void removeMember(Member member) {
            this.removeItemFromCollection((Object)member, this.members, MEMBERS_COLLECTION);
        }

        public Member memberNamed(String memberName) {
            for (Member member : this.members) {
                if (!member.getName().equals(memberName)) continue;
                return member;
            }
            throw new IllegalArgumentException(memberName);
        }

        public void toString(StringBuilder sb) {
            sb.append(this.name);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class MembersTransformer
        extends TransformerAdapter<Family, Iterator<Member>> {
            public Iterator<Member> transform(Family family) {
                return family.members();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FamilyTransformer
    extends TransformerAdapter<Family, CollectionValueModel<Member>> {
        public CollectionValueModel<Member> transform(Family family) {
            return CompositeCollectionValueModelTests.this.buildMembersAdapter(family);
        }
    }

    public static class Member
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";

        public Member(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public void toString(StringBuilder sb) {
            sb.append(this.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Neighborhood
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";
        private Collection<Family> families = new ArrayList<Family>();
        public static final String FAMILIES_COLLECTION = "families";

        public Neighborhood(String name) {
            this.name = name;
        }

        protected ChangeSupport buildChangeSupport() {
            return new ChangeSupport((Model)this, RuntimeExceptionHandler.instance());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public Iterator<Family> families() {
            return this.families.iterator();
        }

        public Family addFamily(String familyName) {
            return this.addFamily(new Family(familyName));
        }

        public Family addFamily(Family family) {
            this.addItemToCollection((Object)family, this.families, FAMILIES_COLLECTION);
            return family;
        }

        public void removeFamily(Family family) {
            this.removeItemFromCollection((Object)family, this.families, FAMILIES_COLLECTION);
        }

        public Family familyNamed(String familyName) {
            for (Family family : this.families) {
                if (!family.getName().equals(familyName)) continue;
                return family;
            }
            throw new IllegalArgumentException(familyName);
        }

        public Iterator<Member> allMembers() {
            return new CompositeIterator(this.membersIterators());
        }

        private Iterator<Iterator<Member>> membersIterators() {
            return new TransformationIterator(this.families(), Family.MEMBERS_TRANSFORMER);
        }

        public Member memberNamed(String familyName, String memberName) {
            return this.familyNamed(familyName).memberNamed(memberName);
        }

        public void toString(StringBuilder sb) {
            sb.append(this.name);
        }
    }
}

