/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class GlobalObjectLiteralsTests
extends TestCase {
    private static final String TEST_NAME = "Test JavaScript Content Assist for Global Object Literals";
    private static TestProjectSetup fTestProjectSetup;

    public GlobalObjectLiteralsTests() {
        super(TEST_NAME);
    }

    public GlobalObjectLiteralsTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(GlobalObjectLiteralsTests.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false);
        return fTestProjectSetup;
    }

    public void testFindGlobalObjectLiteral_OtherFile_BeforeOpen_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 0, 0, expectedProposals);
    }

    public void testFindGlobalObjectLiteral_OtherFile_BeforeOpen_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 2, 1, expectedProposals);
    }

    public void testFindFieldOnGlobalObjectLiteral_OtherFile_BeforeOpen_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 4, 4, expectedProposals);
    }

    public void testFindFieldOnGlobalObjectLiteral_OtherFile_BeforeOpen_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 4, 5, expectedProposals);
    }

    public void testFindFunctionOnFieldOnGlobalObjectLiteral_OtherFile_BeforeOpen_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"fun() - {}", "crazy() - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 6, 12, expectedProposals);
    }

    public void testFindGlobalObjectLiteral_SameFile_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 6, 0, expectedProposals);
    }

    public void testFindGlobalObjectLiteral_SameFile_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 8, 1, expectedProposals);
    }

    public void testFindFieldOnGlobalObjectLiteral_SameFile_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 10, 4, expectedProposals);
    }

    public void testFindFieldOnGlobalObjectLiteral_SameFile_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 10, 5, expectedProposals);
    }

    public void testFindFunctionOnFieldOnGlobalObjectLiteral_SameFile_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"fun() - {}", "crazy() - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 12, 12, expectedProposals);
    }

    public void testFindGlobalObjectLiteral_OtherFile_AfterOpen_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 0, 0, expectedProposals);
    }

    public void testFindGlobalObjectLiteral_OtherFile_AfterOpen_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"org : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 2, 1, expectedProposals);
    }

    public void testFindFieldOnGlobalObjectLiteral_OtherFile_AfterOpen_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 4, 4, expectedProposals);
    }

    public void testFindFieldOnGlobalObjectLiteral_OtherFile_AfterOpen_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"eclipse : {} - {}", "eclipse2 : {} - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 4, 5, expectedProposals);
    }

    public void testFindFunctionOnFieldOnGlobalObjectLiteral_OtherFile_AfterOpen_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"fun() - {}", "crazy() - {}"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 6, 12, expectedProposals);
    }

    public void testFindDuplicateGlobalObjectLiteral_OtherFile_1() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 2, 1);
    }

    public void testFindDuplicateFieldOnGlobalObjectLiteral_OtherFile_0() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 4, 4);
    }

    public void testFindDuplicateFieldOnGlobalObjectLiteral_OtherFile_1() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 4, 5);
    }

    public void testFindDuplicateFunctionOnFieldOnGlobalObjectLiteral_OtherFile_0() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 6, 12);
    }

    public void testFindDuplicateGlobalObjectLiteral_SameFile_1() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 8, 1);
    }

    public void testFindDuplicateFieldOnGlobalObjectLiteral_SameFile_0() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 10, 4);
    }

    public void testFindDuplicateFieldOnGlobalObjectLiteral_SameFile_1() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 10, 5);
    }

    public void testFindDuplicateFunctionOnFieldOnGlobalObjectLiteral_SameFile_0() throws Exception {
        ContentAssistTestUtilities.verifyNoDuplicates(fTestProjectSetup, "TestGlobalObjectLiterals_0.js", 12, 12);
    }

    public void testNoLeakedGlobal_OtherFile() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalObjLitTestVar"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestGlobalObjectLiterals_1.js", 8, 19, expectedProposals, true, false);
    }
}

