/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.tests.internal.resource.java;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryTypeCache;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.resource.java.DeprecatedAnnotationDefinition;
import org.eclipse.jpt.common.core.tests.internal.resource.java.JavaResourceModelTestCase;

public class BinaryTypeTests
extends JavaResourceModelTestCase {
    private static URL JAR_URL = BinaryTypeTests.class.getResource("binmodel.jar");
    private static String SUPERCLASS_CLASS_NAME = String.valueOf(BinaryTypeTests.class.getPackage().getName()) + ".binmodel.GenericSuperclass";
    private static String SUBCLASS_CLASS_NAME = String.valueOf(BinaryTypeTests.class.getPackage().getName()) + ".binmodel.GenericSubclass";

    public BinaryTypeTests(String name) {
        super(name);
    }

    protected AnnotationDefinition[] annotationDefinitions() {
        return new AnnotationDefinition[]{DeprecatedAnnotationDefinition.instance()};
    }

    protected NestableAnnotationDefinition[] nestableAnnotationDefinitions() {
        return new NestableAnnotationDefinition[0];
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getJavaProjectTestHarness().addJar(new File(FileLocator.resolve((URL)JAR_URL).toURI()).getAbsolutePath());
    }

    public void testInheritedAttributeTypes() throws Exception {
        BinaryTypeCache typeCache = new BinaryTypeCache(this.buildAnnotationProvider());
        JavaResourceType superclassType = (JavaResourceType)typeCache.addType(this.getJavaProject().findType(SUPERCLASS_CLASS_NAME));
        JavaResourceType subclassType = (JavaResourceType)typeCache.addType(this.getJavaProject().findType(SUBCLASS_CLASS_NAME));
        JavaResourceField genericField1 = superclassType.getField("genericField1");
        BinaryTypeTests.assertEquals((String)"java.lang.Object", (String)superclassType.getAttributeTypeBinding((JavaResourceAttribute)genericField1).getQualifiedName());
        BinaryTypeTests.assertEquals((String)"java.lang.String", (String)subclassType.getAttributeTypeBinding((JavaResourceAttribute)genericField1).getQualifiedName());
        JavaResourceField genericField2 = superclassType.getField("genericField2");
        BinaryTypeTests.assertEquals((String)"java.lang.Object", (String)superclassType.getAttributeTypeBinding((JavaResourceAttribute)genericField2).getQualifiedName());
        BinaryTypeTests.assertEquals((String)"java.lang.Number", (String)subclassType.getAttributeTypeBinding((JavaResourceAttribute)genericField2).getQualifiedName());
        JavaResourceMethod genericMethod1 = superclassType.getMethod("genericMethod1");
        BinaryTypeTests.assertEquals((String)"java.lang.Object", (String)superclassType.getAttributeTypeBinding((JavaResourceAttribute)genericMethod1).getQualifiedName());
        BinaryTypeTests.assertEquals((String)"java.lang.String", (String)subclassType.getAttributeTypeBinding((JavaResourceAttribute)genericMethod1).getQualifiedName());
        JavaResourceMethod genericMethod2 = superclassType.getMethod("genericMethod2");
        BinaryTypeTests.assertEquals((String)"java.lang.Object", (String)superclassType.getAttributeTypeBinding((JavaResourceAttribute)genericMethod2).getQualifiedName());
        BinaryTypeTests.assertEquals((String)"java.lang.Number", (String)subclassType.getAttributeTypeBinding((JavaResourceAttribute)genericMethod2).getQualifiedName());
    }

    public void testGeneralTypeAPI() throws Exception {
        BinaryTypeCache typeCache = new BinaryTypeCache(this.buildAnnotationProvider());
        JavaResourceType superclassType = (JavaResourceType)typeCache.addType(this.getJavaProject().findType(SUPERCLASS_CLASS_NAME));
        JavaResourceType subclassType = (JavaResourceType)typeCache.addType(this.getJavaProject().findType(SUBCLASS_CLASS_NAME));
        BinaryTypeTests.assertEquals((String)"java.lang.Object", (String)superclassType.getSuperclassQualifiedName());
        BinaryTypeTests.assertEquals((String)SUPERCLASS_CLASS_NAME, (String)subclassType.getSuperclassQualifiedName());
        BinaryTypeTests.assertFalse((boolean)superclassType.hasAnyAnnotatedFields());
        BinaryTypeTests.assertFalse((boolean)superclassType.hasAnyAnnotatedMethods());
        BinaryTypeTests.assertTrue((boolean)subclassType.hasAnyAnnotatedFields());
        BinaryTypeTests.assertTrue((boolean)subclassType.hasAnyAnnotatedMethods());
        BinaryTypeTests.assertFalse((boolean)superclassType.hasEqualsMethod());
        BinaryTypeTests.assertFalse((boolean)superclassType.hasHashCodeMethod());
        BinaryTypeTests.assertTrue((boolean)subclassType.hasEqualsMethod());
        BinaryTypeTests.assertTrue((boolean)subclassType.hasHashCodeMethod());
        BinaryTypeTests.assertTrue((boolean)superclassType.hasNoArgConstructor());
        BinaryTypeTests.assertFalse((boolean)superclassType.hasPrivateNoArgConstructor());
        BinaryTypeTests.assertTrue((boolean)superclassType.hasPublicNoArgConstructor());
        BinaryTypeTests.assertTrue((boolean)superclassType.hasPublicOrProtectedNoArgConstructor());
        BinaryTypeTests.assertTrue((boolean)subclassType.hasNoArgConstructor());
        BinaryTypeTests.assertTrue((boolean)subclassType.hasPrivateNoArgConstructor());
        BinaryTypeTests.assertFalse((boolean)subclassType.hasPublicNoArgConstructor());
        BinaryTypeTests.assertFalse((boolean)subclassType.hasPublicOrProtectedNoArgConstructor());
        BinaryTypeTests.assertTrue((boolean)superclassType.isAbstract());
        BinaryTypeTests.assertFalse((boolean)subclassType.isAbstract());
    }
}

