/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Comment;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.tests.dom.SampleASTs;
import org.eclipse.wst.jsdt.core.tests.junit.extension.TestCase;

public class ASTTest
extends TestCase {
    AST ast;
    int API_LEVEL;

    public static Test suite() {
        TestSuite suite = new TestSuite(ASTTest.class.getName());
        Class<ASTTest> c = ASTTest.class;
        Method[] methods = c.getMethods();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            if (methods[i].getName().startsWith("test")) {
                suite.addTest((Test)new ASTTest(methods[i].getName(), 2));
            }
            ++i;
        }
        return suite;
    }

    public ASTTest(String name, int apiLevel) {
        super(name);
        this.API_LEVEL = apiLevel;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ast = AST.newAST((int)this.API_LEVEL);
    }

    protected void tearDown() throws Exception {
        this.ast = null;
        super.tearDown();
    }

    public String getName() {
        String name = super.getName();
        switch (this.API_LEVEL) {
            case 2: {
                name = "JLS2 - " + name;
                break;
            }
            case 3: {
                name = "JLS3 - " + name;
            }
        }
        return name;
    }

    public void testExampleSnippets() {
        AST localAst = AST.newAST((int)this.ast.apiLevel());
        JavaScriptUnit cu = localAst.newJavaScriptUnit();
        PackageDeclaration pd = localAst.newPackageDeclaration();
        pd.setName(localAst.newName(new String[]{"com", "example"}));
        cu.setPackage(pd);
        ASTTest.assertTrue((pd.getRoot() == cu ? 1 : 0) != 0);
        ImportDeclaration im1 = localAst.newImportDeclaration();
        im1.setName(localAst.newName(new String[]{"java", "io"}));
        im1.setOnDemand(true);
        cu.imports().add(im1);
        ASTTest.assertTrue((im1.getRoot() == cu ? 1 : 0) != 0);
        ImportDeclaration im2 = localAst.newImportDeclaration();
        im2.setName(localAst.newName(new String[]{"java", "util", "List"}));
        im2.setOnDemand(false);
        cu.imports().add(im2);
        ASTTest.assertTrue((im2.getRoot() == cu ? 1 : 0) != 0);
        TypeDeclaration td = localAst.newTypeDeclaration();
        if (this.ast.apiLevel() == 2) {
            td.setModifiers(1);
        } else {
            td.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        td.setName(localAst.newSimpleName("MyClass"));
        JSdoc jd = localAst.newJSdoc();
        TagElement tg0 = localAst.newTagElement();
        jd.tags().add(tg0);
        TextElement tx1 = localAst.newTextElement();
        tx1.setText("Spec.");
        tg0.fragments().add(tx1);
        TagElement tg1 = localAst.newTagElement();
        tg1.setTagName("@deprecated");
        jd.tags().add(tg1);
        TextElement tx2 = localAst.newTextElement();
        tx2.setText("Use ");
        tg1.fragments().add(tx2);
        TagElement tg2 = localAst.newTagElement();
        tg2.setTagName("@link");
        tg1.fragments().add(tg2);
        FunctionRef mr1 = localAst.newFunctionRef();
        mr1.setName(localAst.newSimpleName("foo"));
        tg2.fragments().add(mr1);
        TextElement tx3 = localAst.newTextElement();
        tx3.setText("bar");
        tg2.fragments().add(tx3);
        TextElement tx4 = localAst.newTextElement();
        tx2.setText(" instead.");
        tg1.fragments().add(tx4);
        cu.types().add(td);
        ASTTest.assertTrue((td.getRoot() == cu ? 1 : 0) != 0);
        VariableDeclarationFragment f1 = localAst.newVariableDeclarationFragment();
        f1.setName(localAst.newSimpleName("DEBUG"));
        f1.setInitializer((Expression)localAst.newBooleanLiteral(true));
        FieldDeclaration fd = localAst.newFieldDeclaration(f1);
        fd.setType((Type)localAst.newPrimitiveType(PrimitiveType.BOOLEAN));
        if (this.ast.apiLevel() == 2) {
            fd.setModifiers(18);
        } else {
            fd.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
            fd.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        td.bodyDeclarations().add(fd);
        ASTTest.assertTrue((fd.getRoot() == cu ? 1 : 0) != 0);
        FunctionDeclaration md = localAst.newFunctionDeclaration();
        if (this.ast.apiLevel() == 2) {
            md.setModifiers(9);
            md.setReturnType((Type)localAst.newPrimitiveType(PrimitiveType.VOID));
        } else {
            md.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            md.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
            md.setReturnType2((Type)localAst.newPrimitiveType(PrimitiveType.VOID));
        }
        md.setConstructor(false);
        md.setName(localAst.newSimpleName("main"));
        td.bodyDeclarations().add(md);
        ASTTest.assertTrue((md.getRoot() == cu ? 1 : 0) != 0);
        SingleVariableDeclaration a1 = localAst.newSingleVariableDeclaration();
        a1.setType((Type)localAst.newArrayType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("String"))));
        a1.setName(localAst.newSimpleName("args"));
        md.parameters().add(a1);
        ASTTest.assertTrue((a1.getRoot() == cu ? 1 : 0) != 0);
        Block b = localAst.newBlock();
        md.setBody(b);
        ASTTest.assertTrue((b.getRoot() == cu ? 1 : 0) != 0);
        FunctionInvocation e = localAst.newFunctionInvocation();
        e.setExpression((Expression)localAst.newName(new String[]{"System", "out"}));
        e.setName(localAst.newSimpleName("println"));
        StringLiteral h = localAst.newStringLiteral();
        h.setLiteralValue("hello world");
        e.arguments().add(h);
        b.statements().add(localAst.newExpressionStatement((Expression)e));
        ASTTest.assertTrue((e.getRoot() == cu ? 1 : 0) != 0);
        ASTTest.assertTrue((h.getRoot() == cu ? 1 : 0) != 0);
        ArrayCreation ac1 = localAst.newArrayCreation();
        ac1.setType(localAst.newArrayType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("String"))));
        ac1.dimensions().add(localAst.newSimpleName("len"));
        b.statements().add(localAst.newExpressionStatement((Expression)ac1));
        ASTTest.assertTrue((ac1.getRoot() == cu ? 1 : 0) != 0);
        ArrayCreation ac2 = localAst.newArrayCreation();
        ac2.setType(localAst.newArrayType((Type)localAst.newPrimitiveType(PrimitiveType.DOUBLE), 3));
        ac2.dimensions().add(localAst.newNumberLiteral("7"));
        ac2.dimensions().add(localAst.newNumberLiteral("24"));
        b.statements().add(localAst.newExpressionStatement((Expression)ac2));
        ASTTest.assertTrue((ac2.getRoot() == cu ? 1 : 0) != 0);
        ArrayCreation ac3 = localAst.newArrayCreation();
        ac3.setType(localAst.newArrayType((Type)localAst.newPrimitiveType(PrimitiveType.INT)));
        ArrayInitializer ai = localAst.newArrayInitializer();
        ac3.setInitializer(ai);
        ai.expressions().add(localAst.newNumberLiteral("1"));
        ai.expressions().add(localAst.newNumberLiteral("2"));
        b.statements().add(localAst.newExpressionStatement((Expression)ac3));
        ASTTest.assertTrue((ac3.getRoot() == cu ? 1 : 0) != 0);
        ASTTest.assertTrue((ai.getRoot() == cu ? 1 : 0) != 0);
        ClassInstanceCreation cr1 = localAst.newClassInstanceCreation();
        if (this.ast.apiLevel() == 2) {
            cr1.setName((Name)localAst.newSimpleName("String"));
        } else {
            cr1.setType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("String")));
        }
        cr1.arguments().add(localAst.newNumberLiteral("10"));
        b.statements().add(localAst.newExpressionStatement((Expression)cr1));
        ASTTest.assertTrue((cr1.getRoot() == cu ? 1 : 0) != 0);
        ClassInstanceCreation cr2 = localAst.newClassInstanceCreation();
        AnonymousClassDeclaration ad1 = localAst.newAnonymousClassDeclaration();
        cr2.setAnonymousClassDeclaration(ad1);
        if (this.ast.apiLevel() == 2) {
            cr2.setName((Name)localAst.newSimpleName("Listener"));
        } else {
            cr2.setType((Type)localAst.newSimpleType((Name)localAst.newSimpleName("Listener")));
        }
        FunctionDeclaration md0 = localAst.newFunctionDeclaration();
        if (this.ast.apiLevel() == 2) {
            md0.setModifiers(1);
        } else {
            md0.modifiers().add(localAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        md0.setName(localAst.newSimpleName("handleEvent"));
        md0.setBody(localAst.newBlock());
        ad1.bodyDeclarations().add(md0);
        b.statements().add(localAst.newExpressionStatement((Expression)cr2));
        ASTTest.assertTrue((cr2.getRoot() == cu ? 1 : 0) != 0);
        ASTTest.assertTrue((md0.getRoot() == cu ? 1 : 0) != 0);
        ASTTest.assertTrue((ad1.getRoot() == cu ? 1 : 0) != 0);
    }

    void genericPropertyTest(ASTNode node, Property prop) {
        block20: {
            ASTNode x1 = prop.sample(node.getAST(), false);
            prop.set(x1);
            ASTTest.assertTrue((prop.get() == x1 ? 1 : 0) != 0);
            ASTTest.assertTrue((x1.getParent() == node ? 1 : 0) != 0);
            if (prop.isCompulsory()) {
                try {
                    prop.set(null);
                }
                catch (RuntimeException runtimeException) {}
            } else {
                long previousCount = node.getAST().modificationCount();
                prop.set(null);
                ASTTest.assertTrue((prop.get() == null ? 1 : 0) != 0);
                ASTTest.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            }
            try {
                AST newAST = AST.newAST((int)node.getAST().apiLevel());
                prop.set(prop.sample(newAST, false));
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            try {
                ASTNode b1 = prop.sample(node.getAST(), true);
                prop.set(b1);
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            ASTNode s1 = null;
            try {
                try {
                    s1 = prop.wrap();
                    if (s1 != null) {
                        prop.set(s1);
                        ASTTest.assertTrue((boolean)false);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (s1 != null) {
                        prop.unwrap();
                        ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (s1 != null) {
                    prop.unwrap();
                    ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                }
                throw throwable;
            }
            if (s1 != null) {
                prop.unwrap();
                ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            }
        }
        ASTNode[] b1 = prop.counterExamples(node.getAST());
        int i = 0;
        while (i < b1.length) {
            try {
                prop.set(b1[i]);
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
    }

    void genericPropertyListTest(ASTNode node, List children, Property prop) {
        block18: {
            children.clear();
            ASTTest.assertTrue((children.size() == 0 ? 1 : 0) != 0);
            ASTNode x1 = prop.sample(node.getAST(), false);
            long previousCount = node.getAST().modificationCount();
            children.add(x1);
            ASTTest.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((children.size() == 1 ? 1 : 0) != 0);
            ASTTest.assertTrue((children.get(0) == x1 ? 1 : 0) != 0);
            ASTTest.assertTrue((x1.getParent() == node ? 1 : 0) != 0);
            ASTNode x2 = prop.sample(node.getAST(), false);
            previousCount = node.getAST().modificationCount();
            children.add(x2);
            ASTTest.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((children.size() == 2 ? 1 : 0) != 0);
            ASTTest.assertTrue((children.get(0) == x1 ? 1 : 0) != 0);
            ASTTest.assertTrue((children.get(1) == x2 ? 1 : 0) != 0);
            ASTTest.assertTrue((x1.getParent() == node ? 1 : 0) != 0);
            ASTTest.assertTrue((x2.getParent() == node ? 1 : 0) != 0);
            previousCount = node.getAST().modificationCount();
            children.remove(0);
            ASTTest.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((children.size() == 1 ? 1 : 0) != 0);
            ASTTest.assertTrue((children.get(0) == x2 ? 1 : 0) != 0);
            ASTTest.assertTrue((x1.getParent() == null ? 1 : 0) != 0);
            ASTTest.assertTrue((x2.getParent() == node ? 1 : 0) != 0);
            previousCount = node.getAST().modificationCount();
            children.remove(x2);
            ASTTest.assertTrue((node.getAST().modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((children.size() == 0 ? 1 : 0) != 0);
            ASTTest.assertTrue((x1.getParent() == null ? 1 : 0) != 0);
            ASTTest.assertTrue((x2.getParent() == null ? 1 : 0) != 0);
            try {
                children.add(null);
            }
            catch (RuntimeException runtimeException) {}
            try {
                AST newAST = AST.newAST((int)node.getAST().apiLevel());
                children.add(prop.sample(newAST, false));
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            try {
                ASTNode b1 = prop.sample(node.getAST(), true);
                children.add(b1);
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            ASTNode s1 = null;
            try {
                try {
                    s1 = prop.wrap();
                    if (s1 != null) {
                        children.add(s1);
                        ASTTest.assertTrue((boolean)false);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (s1 != null) {
                        prop.unwrap();
                        ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (s1 != null) {
                    prop.unwrap();
                    ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
                }
                throw throwable;
            }
            if (s1 != null) {
                prop.unwrap();
                ASTTest.assertTrue((node.getParent() == null ? 1 : 0) != 0);
            }
        }
        ASTNode[] b1 = prop.counterExamples(node.getAST());
        int i = 0;
        while (i < b1.length) {
            try {
                children.add(b1[i]);
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
    }

    public void testAST() {
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        AST a0 = new AST();
        ASTTest.assertTrue((a0.apiLevel() == 2 ? 1 : 0) != 0);
        AST a1 = new AST(new HashMap());
        ASTTest.assertTrue((a1.apiLevel() == 2 ? 1 : 0) != 0);
        AST a2 = AST.newAST((int)2);
        ASTTest.assertTrue((a2.apiLevel() == 2 ? 1 : 0) != 0);
        AST a3 = AST.newAST((int)3);
        ASTTest.assertTrue((a3.apiLevel() == 3 ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() >= 0L ? 1 : 0) != 0);
        long previousCount = this.ast.modificationCount();
        SimpleName x = this.ast.newSimpleName("first");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.getIdentifier();
        x.getParent();
        x.getRoot();
        x.getAST();
        x.getFlags();
        x.getStartPosition();
        x.getLength();
        x.equals((Object)x);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.getProperty("any");
        x.setProperty("any", (Object)"value");
        x.properties();
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setIdentifier("second");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setFlags(0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setSourceRange(-1, 0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
    }

    public void testWellKnownBindings() {
        String[] wkbs = new String[]{"byte", "char", "short", "int", "long", "boolean", "float", "double", "void", "java.lang.Class", "java.lang.Cloneable", "java.lang.Error", "java.lang.Exception", "java.lang.Object", "java.lang.RuntimeException", "java.lang.String", "java.lang.StringBuffer", "java.lang.Throwable", "java.io.Serializable", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Void"};
        String[] nwkbs = new String[]{"verylong", "java.lang.Math", "com.example.MyCode"};
        int i = 0;
        while (i < wkbs.length) {
            ASTTest.assertTrue((this.ast.resolveWellKnownType(wkbs[i]) == null ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < nwkbs.length) {
            ASTTest.assertTrue((this.ast.resolveWellKnownType(nwkbs[i]) == null ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testSimpleName() {
        long previousCount = this.ast.modificationCount();
        SimpleName x = this.ast.newSimpleName("foo");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"foo".equals(x.getIdentifier()));
        ASTTest.assertTrue((boolean)"foo".equals(x.getFullyQualifiedName()));
        ASTTest.assertTrue((x.getNodeType() == 42 ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SimpleName.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setIdentifier("bar");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"bar".equals(x.getIdentifier()));
        ASTTest.assertTrue((boolean)"bar".equals(x.getFullyQualifiedName()));
        try {
            x.setIdentifier(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        String[] reserved = new String[]{"true", "false", "null", "abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized"};
        int i = 0;
        while (i < reserved.length) {
            try {
                x.setIdentifier(reserved[i]);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
        String[] bogus = new String[]{"a b", "a ", " a", "a-b", "a[]", "a<T>", "", " ", "a.b"};
        int i2 = 0;
        while (i2 < bogus.length) {
            try {
                x.setIdentifier(bogus[i2]);
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i2;
        }
        x.setIdentifier("assert");
        x.setIdentifier("enum");
        QualifiedName y = this.ast.newQualifiedName((Name)this.ast.newSimpleName("a"), x);
        ASTTest.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        y.setName(this.ast.newSimpleName("b"));
        ASTTest.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        TypeDeclaration td = this.ast.newTypeDeclaration();
        td.setName(x);
        ASTTest.assertTrue((boolean)x.isDeclaration());
        td.setName(this.ast.newSimpleName("b"));
        ASTTest.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        FunctionDeclaration md = this.ast.newFunctionDeclaration();
        md.setName(x);
        ASTTest.assertTrue((boolean)x.isDeclaration());
        md.setName(this.ast.newSimpleName("b"));
        ASTTest.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        SingleVariableDeclaration vd = this.ast.newSingleVariableDeclaration();
        vd.setName(x);
        ASTTest.assertTrue((boolean)x.isDeclaration());
        vd.setName(this.ast.newSimpleName("b"));
        ASTTest.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
        VariableDeclarationFragment fd = this.ast.newVariableDeclarationFragment();
        fd.setName(x);
        ASTTest.assertTrue((boolean)x.isDeclaration());
        fd.setName(this.ast.newSimpleName("b"));
        ASTTest.assertTrue((!x.isDeclaration() ? 1 : 0) != 0);
    }

    public void testQualifiedName() {
        long previousCount = this.ast.modificationCount();
        final QualifiedName x = this.ast.newQualifiedName((Name)this.ast.newSimpleName("q"), this.ast.newSimpleName("i"));
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getQualifier().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.getName().isDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 40 ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"q.i".equals(x.getFullyQualifiedName()));
        ASTTest.assertTrue((x.structuralPropertiesForType() == QualifiedName.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                QualifiedName s1 = ast.newQualifiedName((Name)x, ast.newSimpleName("z"));
                return s1;
            }

            @Override
            public void unwrap() {
                QualifiedName s1 = (QualifiedName)x.getParent();
                s1.setQualifier((Name)ast.newSimpleName("z"));
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        Name q0 = this.ast.newName(new String[]{"a", "bb", "ccc", "dddd", "eeeee", "ffffff"});
        ASTTest.assertTrue((boolean)"a.bb.ccc.dddd.eeeee.ffffff".equals(q0.getFullyQualifiedName()));
    }

    public void testNameFactories() {
        long previousCount = this.ast.modificationCount();
        Name x = this.ast.newName("foo");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"foo".equals(x.getFullyQualifiedName()));
        ASTTest.assertTrue((x.getNodeType() == 42 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x = this.ast.newName("foo.bar");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"foo.bar".equals(x.getFullyQualifiedName()));
        ASTTest.assertTrue((x.getNodeType() == 40 ? 1 : 0) != 0);
        QualifiedName q = (QualifiedName)x;
        ASTTest.assertTrue((boolean)"bar".equals(q.getName().getFullyQualifiedName()));
        ASTTest.assertTrue((boolean)"foo".equals(q.getQualifier().getFullyQualifiedName()));
        String[] legal = new String[]{"a", "abcdef", "XYZZY", "a.b", "java.lang.Object", "a.b.c.d.e"};
        int i = 0;
        while (i < legal.length) {
            try {
                x = this.ast.newName(legal[i]);
                ASTTest.assertTrue((boolean)legal[i].equals(x.getFullyQualifiedName()));
            }
            catch (RuntimeException runtimeException) {
                ASTTest.assertTrue((boolean)false);
            }
            ++i;
        }
        String[] bogus = new String[]{"", ".", ".a", "a.", "a..b", "..a"};
        int i2 = 0;
        while (i2 < bogus.length) {
            try {
                x = this.ast.newName(bogus[i2]);
                ASTTest.assertTrue((boolean)false);
            }
            catch (RuntimeException runtimeException) {}
            ++i2;
        }
    }

    public void testNullLiteral() {
        long previousCount = this.ast.modificationCount();
        NullLiteral x = this.ast.newNullLiteral();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 33 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == NullLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
    }

    public void testBooleanLiteral() {
        long previousCount = this.ast.modificationCount();
        BooleanLiteral x = this.ast.newBooleanLiteral(true);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.booleanValue());
        ASTTest.assertTrue((x.getNodeType() == 9 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == BooleanLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setBooleanValue(false);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.booleanValue() ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setBooleanValue(true);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.booleanValue());
    }

    public void testStringLiteral() {
        long previousCount = this.ast.modificationCount();
        StringLiteral x = this.ast.newStringLiteral();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"\"\"".equals(x.getEscapedValue()));
        ASTTest.assertTrue((boolean)"".equals(x.getLiteralValue()));
        ASTTest.assertTrue((x.getNodeType() == 45 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == StringLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setEscapedValue("\"bye\"");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"\"bye\"".equals(x.getEscapedValue()));
        ASTTest.assertTrue((boolean)"bye".equals(x.getLiteralValue()));
        previousCount = this.ast.modificationCount();
        x.setLiteralValue("hi");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"\"hi\"".equals(x.getEscapedValue()));
        ASTTest.assertTrue((boolean)"hi".equals(x.getLiteralValue()));
        previousCount = this.ast.modificationCount();
        x.setLiteralValue("\\012\\015");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertEquals((String)"different", (String)"\"\\\\012\\\\015\"", (String)x.getEscapedValue());
        ASTTest.assertTrue((boolean)"\\012\\015".equals(x.getLiteralValue()));
        previousCount = this.ast.modificationCount();
        x.setLiteralValue("\n\r");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"\n\r".equals(x.getLiteralValue()));
        ASTTest.assertEquals((String)"different", (String)"\"\\n\\r\"", (String)x.getEscapedValue());
        try {
            x.setEscapedValue(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        try {
            x.setLiteralValue(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testStringLiteralUnicode() {
        AST localAst = AST.newAST((int)this.ast.apiLevel());
        StringLiteral literal = localAst.newStringLiteral();
        literal.setEscapedValue("\"hello\\u0026\\u0050worl\\u0064\"");
        ASTTest.assertTrue((boolean)literal.getLiteralValue().equals("hello&Pworld"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setEscapedValue("\"hello\\nworld\"");
        ASTTest.assertTrue((boolean)literal.getLiteralValue().equals("hello\nworld"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("hello\nworld");
        ASTTest.assertTrue((boolean)literal.getLiteralValue().equals("hello\nworld"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("\n");
        ASTTest.assertTrue((boolean)literal.getEscapedValue().equals("\"\\n\""));
        ASTTest.assertTrue((boolean)literal.getLiteralValue().equals("\n"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setEscapedValue("\"hello\\\"world\"");
        ASTTest.assertTrue((boolean)literal.getLiteralValue().equals("hello\"world"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("hello\\u0026world");
        ASTTest.assertTrue((boolean)literal.getLiteralValue().equals("hello\\u0026world"));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("hello\\u0026world");
        ASTTest.assertTrue((boolean)literal.getEscapedValue().equals("\"hello\\\\u0026world\""));
        localAst = AST.newAST((int)this.ast.apiLevel());
        literal = localAst.newStringLiteral();
        literal.setLiteralValue("\\u0001");
        ASTTest.assertTrue((boolean)literal.getEscapedValue().equals("\"\\\\u0001\""));
    }

    public void testCharacterLiteral() {
        long previousCount = this.ast.modificationCount();
        CharacterLiteral x = this.ast.newCharacterLiteral();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getEscapedValue().startsWith("'"));
        ASTTest.assertTrue((boolean)x.getEscapedValue().endsWith("'"));
        ASTTest.assertTrue((x.getNodeType() == 13 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == CharacterLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setEscapedValue("'z'");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"'z'".equals(x.getEscapedValue()));
        ASTTest.assertTrue((x.charValue() == 'z' ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        CharacterLiteral y = this.ast.newCharacterLiteral();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((y.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((y.getParent() == null ? 1 : 0) != 0);
        String v = y.getEscapedValue();
        ASTTest.assertTrue((v.length() >= 3 && v.charAt(0) == '\'' & v.charAt(v.length() - 1) == '\'' ? 1 : 0) != 0);
        try {
            x.setEscapedValue(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        try {
            x.setEscapedValue("'\\b'");
            x.setEscapedValue("'\\t'");
            x.setEscapedValue("'\\n'");
            x.setEscapedValue("'\\f'");
            x.setEscapedValue("'\\\"'");
            x.setEscapedValue("'\\''");
            x.setEscapedValue("'\\\\'");
            x.setEscapedValue("'\\0'");
            x.setEscapedValue("'\\1'");
            x.setEscapedValue("'\\2'");
            x.setEscapedValue("'\\3'");
            x.setEscapedValue("'\\4'");
            x.setEscapedValue("'\\5'");
            x.setEscapedValue("'\\6'");
            x.setEscapedValue("'\\7'");
            x.setEscapedValue("'\\u0041'");
            ASTTest.assertTrue((x.charValue() == 'A' ? 1 : 0) != 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ASTTest.assertTrue((boolean)false);
        }
        x.setCharValue('A');
        ASTTest.assertTrue((boolean)x.getEscapedValue().equals("'A'"));
        x.setCharValue('\t');
        ASTTest.assertTrue((boolean)x.getEscapedValue().equals("'\\t'"));
        x.setEscapedValue("'\\\\'");
        ASTTest.assertTrue((boolean)x.getEscapedValue().equals("'\\\\'"));
        ASTTest.assertTrue((x.charValue() == '\\' ? 1 : 0) != 0);
        x.setEscapedValue("'\\''");
        ASTTest.assertTrue((boolean)x.getEscapedValue().equals("'\\''"));
        ASTTest.assertTrue((x.charValue() == '\'' ? 1 : 0) != 0);
        x.setCharValue('\'');
        ASTTest.assertTrue((boolean)x.getEscapedValue().equals("'\\''"));
        ASTTest.assertTrue((x.charValue() == '\'' ? 1 : 0) != 0);
        x.setCharValue('\\');
        ASTTest.assertTrue((boolean)x.getEscapedValue().equals("'\\\\'"));
        ASTTest.assertTrue((x.charValue() == '\\' ? 1 : 0) != 0);
    }

    public void testNumberLiteral() {
        long previousCount = this.ast.modificationCount();
        NumberLiteral x = this.ast.newNumberLiteral("1234");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"1234".equals(x.getToken()));
        ASTTest.assertTrue((x.getNodeType() == 34 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == NumberLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        NumberLiteral y = this.ast.newNumberLiteral();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((y.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((y.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"0".equals(y.getToken()));
        String[] samples = new String[]{"0", "1", "1234567890", "0L", "1L", "1234567890L", "0l", "1l", "1234567890l", "077", "0177", "012345670", "077L", "0177L", "012345670L", "077l", "0177l", "012345670l", "0x00", "0x1", "0x0123456789ABCDEF", "0x00L", "0x1L", "0x0123456789ABCDEFL", "0x00l", "0x1l", "0x0123456789ABCDEFl", "1e1f", "2.f", ".3f", "0f", "3.14f", "6.022137e+23f", "1e1", "2.", ".3", "0.0", "3.14", "1e-9d", "1e137"};
        int i = 0;
        while (i < samples.length) {
            previousCount = this.ast.modificationCount();
            x.setToken(samples[i]);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)samples[i].equals(x.getToken()));
            ++i;
        }
        try {
            x.setToken(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testSimpleType() {
        long previousCount = this.ast.modificationCount();
        final SimpleType x = this.ast.newSimpleType((Name)this.ast.newSimpleName("String"));
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isSimpleType());
        ASTTest.assertTrue((!x.isArrayType() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isPrimitiveType() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isQualifiedType() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 43 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SimpleType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("a");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((Name)value);
            }
        });
    }

    public void testPrimitiveType() {
        long previousCount = this.ast.modificationCount();
        PrimitiveType x = this.ast.newPrimitiveType(PrimitiveType.INT);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getPrimitiveTypeCode().equals(PrimitiveType.INT));
        ASTTest.assertTrue((!x.isSimpleType() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isArrayType() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isPrimitiveType());
        ASTTest.assertTrue((!x.isQualifiedType() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 39 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == PrimitiveType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)PrimitiveType.BYTE.toString().equals("byte"));
        ASTTest.assertTrue((boolean)PrimitiveType.INT.toString().equals("int"));
        ASTTest.assertTrue((boolean)PrimitiveType.BOOLEAN.toString().equals("boolean"));
        ASTTest.assertTrue((boolean)PrimitiveType.CHAR.toString().equals("char"));
        ASTTest.assertTrue((boolean)PrimitiveType.SHORT.toString().equals("short"));
        ASTTest.assertTrue((boolean)PrimitiveType.LONG.toString().equals("long"));
        ASTTest.assertTrue((boolean)PrimitiveType.FLOAT.toString().equals("float"));
        ASTTest.assertTrue((boolean)PrimitiveType.DOUBLE.toString().equals("double"));
        ASTTest.assertTrue((boolean)PrimitiveType.VOID.toString().equals("void"));
        PrimitiveType.Code[] known = new PrimitiveType.Code[]{PrimitiveType.BOOLEAN, PrimitiveType.BYTE, PrimitiveType.CHAR, PrimitiveType.INT, PrimitiveType.SHORT, PrimitiveType.LONG, PrimitiveType.FLOAT, PrimitiveType.DOUBLE, PrimitiveType.VOID};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                ASTTest.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setPrimitiveTypeCode(known[i]);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getPrimitiveTypeCode().equals(known[i]));
            ++i;
        }
        try {
            x.setPrimitiveTypeCode(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            ASTTest.assertTrue((boolean)PrimitiveType.toCode((String)name).equals(known[i]));
            ++i;
        }
        ASTTest.assertTrue((PrimitiveType.toCode((String)"not-a-type") == null ? 1 : 0) != 0);
    }

    public void testArrayType() {
        SimpleName x1 = this.ast.newSimpleName("String");
        SimpleType x2 = this.ast.newSimpleType((Name)x1);
        long previousCount = this.ast.modificationCount();
        final ArrayType x = this.ast.newArrayType((Type)x2);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getComponentType().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isSimpleType() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isArrayType());
        ASTTest.assertTrue((!x.isPrimitiveType() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isQualifiedType() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 5 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ArrayType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getDimensions() == 1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getElementType() == x2 ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "ComponentType", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("a"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ArrayType result = ast.newArrayType((Type)x);
                return result;
            }

            @Override
            public void unwrap() {
                ArrayType a = (ArrayType)x.getParent();
                a.setComponentType((Type)ast.newPrimitiveType(PrimitiveType.INT));
            }

            @Override
            public ASTNode get() {
                return x.getComponentType();
            }

            @Override
            public void set(ASTNode value) {
                x.setComponentType((Type)value);
            }
        });
        x.setComponentType((Type)this.ast.newArrayType((Type)this.ast.newPrimitiveType(PrimitiveType.INT), 4));
        ASTTest.assertTrue((x.getDimensions() == 5 ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getElementType().isPrimitiveType());
    }

    public void testQualifiedType() {
        if (this.ast.apiLevel() == 2) {
            try {
                this.ast.newQualifiedType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("q")), this.ast.newSimpleName("i"));
                ASTTest.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return;
        }
        long previousCount = this.ast.modificationCount();
        final QualifiedType x = this.ast.newQualifiedType((Type)this.ast.newSimpleType((Name)this.ast.newSimpleName("q")), this.ast.newSimpleName("i"));
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getQualifier().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.getName().isDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 75 ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isSimpleType() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isArrayType() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isPrimitiveType() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isQualifiedType());
        ASTTest.assertTrue((x.structuralPropertiesForType() == QualifiedType.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("a"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                QualifiedType s1 = ast.newQualifiedType((Type)x, ast.newSimpleName("z"));
                return s1;
            }

            @Override
            public void unwrap() {
                QualifiedType s1 = (QualifiedType)x.getParent();
                s1.setQualifier((Type)ast.newSimpleType((Name)ast.newSimpleName("z")));
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Type)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    public void testPackageDeclaration() {
        long previousCount = this.ast.modificationCount();
        final PackageDeclaration x = this.ast.newPackageDeclaration();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            ASTTest.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.annotations().isEmpty());
        }
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 35 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == PackageDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Javadoc", false, JSdoc.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    JSdoc result = targetAst.newJSdoc();
                    if (parented) {
                        targetAst.newInitializer().setJavadoc(result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getJavadoc();
                }

                @Override
                public void set(ASTNode value) {
                    x.setJavadoc((JSdoc)value);
                }
            });
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("a");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((Name)value);
            }
        });
    }

    public void testImportDeclaration() {
        long previousCount = this.ast.modificationCount();
        final ImportDeclaration x = this.ast.newImportDeclaration();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isOnDemand() ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            ASTTest.assertTrue((!x.isStatic() ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 26 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ImportDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("a");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((Name)value);
            }
        });
        previousCount = this.ast.modificationCount();
        x.setOnDemand(false);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isOnDemand() ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setOnDemand(true);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isOnDemand());
        if (this.ast.apiLevel() >= 3) {
            x.setStatic(true);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.isStatic());
        }
    }

    public void testCompilationUnit() {
        long previousCount = this.ast.modificationCount();
        final JavaScriptUnit x = this.ast.newJavaScriptUnit();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getPackage() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.imports().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.types().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 15 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == JavaScriptUnit.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tClientProperties((ASTNode)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Package", false, PackageDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                PackageDeclaration result = targetAst.newPackageDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.setPackage(result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getPackage();
            }

            @Override
            public void set(ASTNode value) {
                x.setPackage((PackageDeclaration)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.imports(), new Property(this, "Imports", true, ImportDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                ImportDeclaration result = targetAst.newImportDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.imports().add(result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.types(), new Property(this, "Types", true, AbstractTypeDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TypeDeclaration result = targetAst.newTypeDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.types().add(result);
                }
                return result;
            }
        });
        TypeDeclaration t1 = this.ast.newTypeDeclaration();
        x.types().add(t1);
        ASTTest.assertTrue((!t1.isLocalTypeDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((!t1.isMemberTypeDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)t1.isPackageMemberTypeDeclaration());
    }

    public void testCompilationUnitLineNumberTable() {
    }

    public void testTypeDeclaration() {
        long previousCount = this.ast.modificationCount();
        final TypeDeclaration x = this.ast.newTypeDeclaration();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getSuperclass() == null ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getSuperclassType() == null ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getName().isDeclaration());
        ASTTest.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.bodyDeclarations().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 55 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == TypeDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        if (this.ast.apiLevel() == 2) {
            int legal = 3103;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.tJavadocComment((BodyDeclaration)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Superclass", false, Name.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleName result = targetAst.newSimpleName("foo");
                    if (parented) {
                        targetAst.newExpressionStatement((Expression)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getSuperclass();
                }

                @Override
                public void set(ASTNode value) {
                    x.setSuperclass((Name)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "SuperclassType", false, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getSuperclassType();
                }

                @Override
                public void set(ASTNode value) {
                    x.setSuperclassType((Type)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, null, new Property(this, "SuperInterfaceTypes", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.bodyDeclarations(), new Property(this, "BodyDeclarations", true, BodyDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TypeDeclaration result = targetAst.newTypeDeclaration();
                if (parented) {
                    JavaScriptUnit cu = targetAst.newJavaScriptUnit();
                    cu.types().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                TypeDeclaration s1 = x.getAST().newTypeDeclaration();
                s1.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TypeDeclaration s1 = (TypeDeclaration)x.getParent();
                s1.bodyDeclarations().remove(x);
            }
        });
        x.bodyDeclarations().clear();
        FieldDeclaration f1 = this.ast.newFieldDeclaration(this.ast.newVariableDeclarationFragment());
        FieldDeclaration f2 = this.ast.newFieldDeclaration(this.ast.newVariableDeclarationFragment());
        FunctionDeclaration m1 = this.ast.newFunctionDeclaration();
        FunctionDeclaration m2 = this.ast.newFunctionDeclaration();
        TypeDeclaration t1 = this.ast.newTypeDeclaration();
        TypeDeclaration t2 = this.ast.newTypeDeclaration();
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(f1);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(f2);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(t1);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(m1);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(m2);
        x.bodyDeclarations().add(this.ast.newInitializer());
        x.bodyDeclarations().add(t2);
        x.bodyDeclarations().add(this.ast.newInitializer());
        List<FieldDeclaration> fs = Arrays.asList(x.getFields());
        ASTTest.assertTrue((fs.size() == 2 ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)fs.contains(f1));
        ASTTest.assertTrue((boolean)fs.contains(f2));
        List<FunctionDeclaration> ms = Arrays.asList(x.getMethods());
        ASTTest.assertTrue((ms.size() == 2 ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)ms.contains(m1));
        ASTTest.assertTrue((boolean)ms.contains(m2));
        List<TypeDeclaration> ts = Arrays.asList(x.getTypes());
        ASTTest.assertTrue((ts.size() == 2 ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)ts.contains(t1));
        ASTTest.assertTrue((boolean)ts.contains(t2));
        ASTTest.assertTrue((!t1.isLocalTypeDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)t1.isMemberTypeDeclaration());
        ASTTest.assertTrue((!t1.isPackageMemberTypeDeclaration() ? 1 : 0) != 0);
    }

    public void testSingleVariableDeclaration() {
        long previousCount = this.ast.modificationCount();
        final SingleVariableDeclaration x = this.ast.newSingleVariableDeclaration();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getName().isDeclaration());
        ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getInitializer() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 44 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SingleVariableDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            int legal = 223;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            previousCount = this.ast.modificationCount();
            x.setVarargs(true);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.isVarargs());
            previousCount = this.ast.modificationCount();
            x.setVarargs(false);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Initializer", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                CatchClause s1 = ast.newCatchClause();
                s1.setException(x);
                return s1;
            }

            @Override
            public void unwrap() {
                CatchClause s1 = (CatchClause)x.getParent();
                s1.setException(ast.newSingleVariableDeclaration());
            }

            @Override
            public ASTNode get() {
                return x.getInitializer();
            }

            @Override
            public void set(ASTNode value) {
                x.setInitializer((Expression)value);
            }
        });
    }

    public void testVariableDeclarationFragment() {
        long previousCount = this.ast.modificationCount();
        final VariableDeclarationFragment x = this.ast.newVariableDeclarationFragment();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getName().isDeclaration());
        ASTTest.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getInitializer() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 59 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == VariableDeclarationFragment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        try {
            x.setExtraDimensions(-1);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Initializer", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationExpression s1 = ast.newVariableDeclarationExpression(x);
                return s1;
            }

            @Override
            public void unwrap() {
                VariableDeclarationExpression s1 = (VariableDeclarationExpression)x.getParent();
                s1.fragments().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getInitializer();
            }

            @Override
            public void set(ASTNode value) {
                x.setInitializer((Expression)value);
            }
        });
    }

    public void testMethodDeclaration() {
        long previousCount = this.ast.modificationCount();
        final FunctionDeclaration x = this.ast.newFunctionDeclaration();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getReturnType().getParent() == x ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getReturnType().isPrimitiveType());
            ASTTest.assertTrue((((PrimitiveType)x.getReturnType()).getPrimitiveTypeCode() == PrimitiveType.VOID ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getReturnType2().getParent() == x ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getReturnType2().isPrimitiveType());
            ASTTest.assertTrue((((PrimitiveType)x.getReturnType2()).getPrimitiveTypeCode() == PrimitiveType.VOID ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((!x.isConstructor() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.parameters().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.thrownExceptions().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 31 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == FunctionDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setConstructor(true);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isConstructor());
        previousCount = this.ast.modificationCount();
        x.setConstructor(false);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isConstructor() ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            previousCount = this.ast.modificationCount();
            int legal = 3391;
            x.setModifiers(legal);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setExtraDimensions(0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExtraDimensions() == 0 ? 1 : 0) != 0);
        this.tJavadocComment((BodyDeclaration)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "ReturnType", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getReturnType();
                }

                @Override
                public void set(ASTNode value) {
                    x.setReturnType((Type)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "ReturnType2", false, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getReturnType2();
                }

                @Override
                public void set(ASTNode value) {
                    x.setReturnType2((Type)value);
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.parameters(), new Property(this, "Parameters", true, SingleVariableDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SingleVariableDeclaration result = targetAst.newSingleVariableDeclaration();
                if (parented) {
                    targetAst.newCatchClause().setException(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                SingleVariableDeclaration s1 = ast.newSingleVariableDeclaration();
                ClassInstanceCreation s2 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s2.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s2);
                a1.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                AnonymousClassDeclaration a1 = (AnonymousClassDeclaration)x.getParent();
                a1.bodyDeclarations().remove(x);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.thrownExceptions(), new Property(this, "ThrownExceptions", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", false, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                TypeDeclaration s2 = ast.newTypeDeclaration();
                s1.statements().add(ast.newTypeDeclarationStatement(s2));
                s2.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TypeDeclaration s2 = (TypeDeclaration)x.getParent();
                s2.bodyDeclarations().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            x.parameters().clear();
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
            x.parameters().add(this.ast.newSingleVariableDeclaration());
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
            SingleVariableDeclaration v = this.ast.newSingleVariableDeclaration();
            x.parameters().add(v);
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
            v.setVarargs(true);
            ASTTest.assertTrue((boolean)x.isVarargs());
            x.parameters().add(this.ast.newSingleVariableDeclaration());
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
    }

    public void testInitializer() {
        long previousCount = this.ast.modificationCount();
        final Initializer x = this.ast.newInitializer();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody().statements().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 28 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == Initializer.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tJavadocComment((BodyDeclaration)x);
        if (this.ast.apiLevel() == 2) {
            int legal = 8;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                TypeDeclaration s2 = ast.newTypeDeclaration();
                s1.statements().add(ast.newTypeDeclarationStatement(s2));
                s2.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TypeDeclaration s2 = (TypeDeclaration)x.getParent();
                s2.bodyDeclarations().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
    }

    public void testJavadoc() {
        long previousCount = this.ast.modificationCount();
        JSdoc x = this.ast.newJSdoc();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((boolean)x.getComment().startsWith("/**"));
            ASTTest.assertTrue((boolean)x.getComment().endsWith("*/"));
        }
        ASTTest.assertTrue((x.getNodeType() == 29 ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isBlockComment() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isLineComment() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isDocComment());
        ASTTest.assertTrue((boolean)x.tags().isEmpty());
        ASTTest.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == JSdoc.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)"@author".equals("@author"));
        ASTTest.assertTrue((boolean)"@deprecated".equals("@deprecated"));
        ASTTest.assertTrue((boolean)"@docRoot".equals("@docRoot"));
        ASTTest.assertTrue((boolean)"@exception".equals("@exception"));
        ASTTest.assertTrue((boolean)"@inheritDoc".equals("@inheritDoc"));
        ASTTest.assertTrue((boolean)"@link".equals("@link"));
        ASTTest.assertTrue((boolean)"@linkplain".equals("@linkplain"));
        ASTTest.assertTrue((boolean)"@param".equals("@param"));
        ASTTest.assertTrue((boolean)"@return".equals("@return"));
        ASTTest.assertTrue((boolean)"@see".equals("@see"));
        ASTTest.assertTrue((boolean)"@serial".equals("@serial"));
        ASTTest.assertTrue((boolean)"@serialData".equals("@serialData"));
        ASTTest.assertTrue((boolean)"@serialField".equals("@serialField"));
        ASTTest.assertTrue((boolean)"@since".equals("@since"));
        ASTTest.assertTrue((boolean)"@throws".equals("@throws"));
        ASTTest.assertTrue((boolean)"@value".equals("@value"));
        ASTTest.assertTrue((boolean)"@version".equals("@version"));
        if (this.ast.apiLevel() == 2) {
            String[] samples = new String[]{"/** Hello there */", "/**\n * Line 1\n * Line 2\n */", "/***/"};
            int i = 0;
            while (i < samples.length) {
                previousCount = this.ast.modificationCount();
                x.setComment(samples[i]);
                ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
                ASTTest.assertTrue((boolean)samples[i].equals(x.getComment()));
                ++i;
            }
            String[] stringArray = new String[5];
            stringArray[1] = "";
            stringArray[2] = "/* */";
            stringArray[3] = "/**";
            stringArray[4] = "*/";
            String[] badSamples = stringArray;
            int i2 = 0;
            while (i2 < badSamples.length) {
                try {
                    x.setComment(badSamples[i2]);
                    ASTTest.assertTrue((boolean)false);
                }
                catch (RuntimeException runtimeException) {}
                ++i2;
            }
        }
        this.tAlternateRoot((Comment)x);
        this.genericPropertyListTest((ASTNode)x, x.tags(), new Property(this, "Tags", true, TagElement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TagElement result = targetAst.newTagElement();
                if (parented) {
                    JSdoc parent = targetAst.newJSdoc();
                    parent.tags().add(result);
                }
                return result;
            }

            @Override
            public ASTNode[] counterExamples(AST targetAst) {
                return new ASTNode[]{targetAst.newEmptyStatement(), targetAst.newJavaScriptUnit(), targetAst.newTypeDeclaration(), targetAst.newJSdoc(), targetAst.newTextElement(), targetAst.newFunctionRef()};
            }
        });
    }

    public void testBlockComment() {
        long previousCount = this.ast.modificationCount();
        BlockComment x = this.ast.newBlockComment();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 64 ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isBlockComment());
        ASTTest.assertTrue((!x.isLineComment() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isDocComment() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == BlockComment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tAlternateRoot((Comment)x);
    }

    public void testLineComment() {
        long previousCount = this.ast.modificationCount();
        LineComment x = this.ast.newLineComment();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 63 ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isBlockComment() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.isLineComment());
        ASTTest.assertTrue((!x.isDocComment() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == LineComment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tAlternateRoot((Comment)x);
    }

    public void testTagElement() {
        long previousCount = this.ast.modificationCount();
        final TagElement x = this.ast.newTagElement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 65 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getTagName() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.fragments().isEmpty());
        ASTTest.assertTrue((x.structuralPropertiesForType() == TagElement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s1 = new String("hello");
        x.setTagName(s1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getTagName() == s1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s2 = new String("bye");
        x.setTagName(s2);
        ASTTest.assertTrue((x.getTagName() == s2 ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        x.setTagName(null);
        ASTTest.assertTrue((x.getTagName() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, TagElement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TagElement result = targetAst.newTagElement();
                if (parented) {
                    JSdoc parent = targetAst.newJSdoc();
                    parent.tags().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                TagElement tagElement = ast.newTagElement();
                tagElement.fragments().add(x);
                return tagElement;
            }

            @Override
            public void unwrap() {
                TagElement tagElement = (TagElement)x.getParent();
                tagElement.fragments().remove(x);
            }

            @Override
            public ASTNode[] counterExamples(AST targetAst) {
                return new ASTNode[]{targetAst.newEmptyStatement(), targetAst.newJavaScriptUnit(), targetAst.newTypeDeclaration(), targetAst.newJSdoc()};
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, TextElement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TextElement result = targetAst.newTextElement();
                if (parented) {
                    TagElement parent = targetAst.newTagElement();
                    parent.fragments().add(result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, FunctionRef.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                FunctionRef result = targetAst.newFunctionRef();
                if (parented) {
                    TagElement parent = targetAst.newTagElement();
                    parent.fragments().add(result);
                }
                return result;
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "Fragments", true, MemberRef.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                MemberRef result = targetAst.newMemberRef();
                if (parented) {
                    TagElement parent = targetAst.newTagElement();
                    parent.fragments().add(result);
                }
                return result;
            }
        });
    }

    public void testTextElement() {
        long previousCount = this.ast.modificationCount();
        TextElement x = this.ast.newTextElement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 66 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getText().length() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == TextElement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s1 = new String("hello");
        x.setText(s1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getText() == s1 ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        String s2 = new String("");
        x.setText(s2);
        ASTTest.assertTrue((x.getText() == s2 ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        try {
            x.setText(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        try {
            x.setText("this would be the */ end of it");
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
    }

    public void testMemberRef() {
        long previousCount = this.ast.modificationCount();
        final MemberRef x = this.ast.newMemberRef();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 67 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == MemberRef.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    public void testMethodRef() {
        long previousCount = this.ast.modificationCount();
        final FunctionRef x = this.ast.newFunctionRef();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 68 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.parameters().isEmpty());
        ASTTest.assertTrue((x.structuralPropertiesForType() == FunctionRef.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.parameters(), new Property(this, "Parameters", true, FunctionRefParameter.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                FunctionRefParameter result = targetAst.newFunctionRefParameter();
                if (parented) {
                    FunctionRef parent = targetAst.newFunctionRef();
                    parent.parameters().add(result);
                }
                return result;
            }
        });
    }

    public void testMethodRefParameter() {
        long previousCount = this.ast.modificationCount();
        final FunctionRefParameter x = this.ast.newFunctionRefParameter();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 69 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getName() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == FunctionRefParameter.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            previousCount = this.ast.modificationCount();
            x.setVarargs(true);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.isVarargs());
            previousCount = this.ast.modificationCount();
            x.setVarargs(false);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((!x.isVarargs() ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", false, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    public void testBlock() {
        long previousCount = this.ast.modificationCount();
        final Block x = this.ast.newBlock();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.statements().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 8 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == Block.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyListTest((ASTNode)x, x.statements(), new Property(this, "Statements", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }
        });
    }

    public void testMethodInvocation() {
        long previousCount = this.ast.modificationCount();
        final FunctionInvocation x = this.ast.newFunctionInvocation();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            ASTTest.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        ASTTest.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.arguments().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 32 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == FunctionInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    public void testExpressionStatement() {
        long previousCount = this.ast.modificationCount();
        SimpleName x1 = this.ast.newSimpleName("foo");
        final ExpressionStatement x = this.ast.newExpressionStatement((Expression)x1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression() == x1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 21 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ExpressionStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    public void testVariableDeclarationStatement() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        long previousCount = this.ast.modificationCount();
        final VariableDeclarationStatement x = this.ast.newVariableDeclarationStatement(x1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getType() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.fragments().size() == 1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.fragments().get(0) == x1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 60 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == VariableDeclarationStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        if (this.ast.apiLevel() == 2) {
            int legal = 16;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "VariableSpecifiers", true, VariableDeclarationFragment.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                VariableDeclarationFragment result = targetAst.newVariableDeclarationFragment();
                if (parented) {
                    targetAst.newVariableDeclarationExpression(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s1 = ast.newVariableDeclarationFragment();
                ClassInstanceCreation s0 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s0.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s0);
                Initializer s2 = ast.newInitializer();
                a1.bodyDeclarations().add(s2);
                s2.getBody().statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
    }

    public void testTypeDeclarationStatement() {
        TypeDeclaration x1 = this.ast.newTypeDeclaration();
        long previousCount = this.ast.modificationCount();
        final TypeDeclarationStatement x = this.ast.newTypeDeclarationStatement((AbstractTypeDeclaration)x1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getTypeDeclaration() == x1 ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.getDeclaration() == x1 ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 56 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == TypeDeclarationStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x1.isLocalTypeDeclaration());
        ASTTest.assertTrue((!x1.isMemberTypeDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((!x1.isPackageMemberTypeDeclaration() ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "TypeDeclaration", true, TypeDeclaration.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    TypeDeclaration result = targetAst.newTypeDeclaration();
                    if (parented) {
                        targetAst.newTypeDeclarationStatement(result);
                    }
                    return result;
                }

                @Override
                public ASTNode wrap() {
                    TypeDeclaration s1 = ast.newTypeDeclaration();
                    FunctionDeclaration s2 = ast.newFunctionDeclaration();
                    s1.bodyDeclarations().add(s2);
                    Block s3 = ast.newBlock();
                    s2.setBody(s3);
                    s3.statements().add(x);
                    return s1;
                }

                @Override
                public void unwrap() {
                    Block s3 = (Block)x.getParent();
                    s3.statements().remove(x);
                }

                @Override
                public ASTNode get() {
                    return x.getTypeDeclaration();
                }

                @Override
                public void set(ASTNode value) {
                    x.setTypeDeclaration((TypeDeclaration)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Declaration", true, AbstractTypeDeclaration.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    TypeDeclaration result = targetAst.newTypeDeclaration();
                    if (parented) {
                        targetAst.newTypeDeclarationStatement((AbstractTypeDeclaration)result);
                    }
                    return result;
                }

                @Override
                public ASTNode wrap() {
                    TypeDeclaration s1 = ast.newTypeDeclaration();
                    FunctionDeclaration s2 = ast.newFunctionDeclaration();
                    s1.bodyDeclarations().add(s2);
                    Block s3 = ast.newBlock();
                    s2.setBody(s3);
                    s3.statements().add(x);
                    return s1;
                }

                @Override
                public void unwrap() {
                    Block s3 = (Block)x.getParent();
                    s3.statements().remove(x);
                }

                @Override
                public ASTNode get() {
                    return x.getDeclaration();
                }

                @Override
                public void set(ASTNode value) {
                    x.setDeclaration((AbstractTypeDeclaration)value);
                }
            });
        }
    }

    public void testVariableDeclarationExpression() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        long previousCount = this.ast.modificationCount();
        final VariableDeclarationExpression x = this.ast.newVariableDeclarationExpression(x1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getType() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.fragments().size() == 1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.fragments().get(0) == x1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 58 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == VariableDeclarationExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            int legal = 16;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "VariableSpecifiers", true, VariableDeclarationFragment.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                VariableDeclarationFragment result = targetAst.newVariableDeclarationFragment();
                if (parented) {
                    targetAst.newVariableDeclarationExpression(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s1 = ast.newVariableDeclarationFragment();
                ClassInstanceCreation s0 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s0.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s0);
                ForStatement s2 = ast.newForStatement();
                s2.initializers().add(x);
                Initializer s3 = ast.newInitializer();
                a1.bodyDeclarations().add(s3);
                s3.getBody().statements().add(s2);
                return s1;
            }

            @Override
            public void unwrap() {
                ForStatement s2 = (ForStatement)x.getParent();
                s2.initializers().remove(x);
            }
        });
    }

    public void testFieldDeclaration() {
        VariableDeclarationFragment x1 = this.ast.newVariableDeclarationFragment();
        long previousCount = this.ast.modificationCount();
        final FieldDeclaration x = this.ast.newFieldDeclaration(x1);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getJavadoc() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((x.modifiers().size() == 0 ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((x.getType() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.fragments().size() == 1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.fragments().get(0) == x1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x1.getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 23 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == FieldDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            int legal = 223;
            previousCount = this.ast.modificationCount();
            x.setModifiers(legal);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == legal ? 1 : 0) != 0);
            previousCount = this.ast.modificationCount();
            x.setModifiers(0);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((x.getModifiers() == 0 ? 1 : 0) != 0);
        }
        this.tJavadocComment((BodyDeclaration)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.fragments(), new Property(this, "VariableSpecifiers", true, VariableDeclarationFragment.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                VariableDeclarationFragment result = targetAst.newVariableDeclarationFragment();
                if (parented) {
                    targetAst.newVariableDeclarationStatement(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s1 = ast.newVariableDeclarationFragment();
                ClassInstanceCreation s2 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s2.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s2);
                a1.bodyDeclarations().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                AnonymousClassDeclaration a1 = (AnonymousClassDeclaration)x.getParent();
                a1.bodyDeclarations().remove(x);
            }
        });
    }

    public void testAssignment() {
        long previousCount = this.ast.modificationCount();
        final Assignment x = this.ast.newAssignment();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getOperator() == Assignment.Operator.ASSIGN ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeftHandSide().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getRightHandSide().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 7 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == Assignment.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setOperator(Assignment.Operator.PLUS_ASSIGN);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getOperator() == Assignment.Operator.PLUS_ASSIGN ? 1 : 0) != 0);
        ASTTest.assertTrue((Assignment.Operator.PLUS_ASSIGN != Assignment.Operator.ASSIGN ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)Assignment.Operator.ASSIGN.toString().equals("="));
        ASTTest.assertTrue((boolean)Assignment.Operator.PLUS_ASSIGN.toString().equals("+="));
        ASTTest.assertTrue((boolean)Assignment.Operator.MINUS_ASSIGN.toString().equals("-="));
        ASTTest.assertTrue((boolean)Assignment.Operator.TIMES_ASSIGN.toString().equals("*="));
        ASTTest.assertTrue((boolean)Assignment.Operator.DIVIDE_ASSIGN.toString().equals("/="));
        ASTTest.assertTrue((boolean)Assignment.Operator.REMAINDER_ASSIGN.toString().equals("%="));
        ASTTest.assertTrue((boolean)Assignment.Operator.LEFT_SHIFT_ASSIGN.toString().equals("<<="));
        ASTTest.assertTrue((boolean)Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN.toString().equals(">>="));
        ASTTest.assertTrue((boolean)Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN.toString().equals(">>>="));
        ASTTest.assertTrue((boolean)Assignment.Operator.BIT_AND_ASSIGN.toString().equals("&="));
        ASTTest.assertTrue((boolean)Assignment.Operator.BIT_OR_ASSIGN.toString().equals("|="));
        ASTTest.assertTrue((boolean)Assignment.Operator.BIT_XOR_ASSIGN.toString().equals("^="));
        Assignment.Operator[] known = new Assignment.Operator[]{Assignment.Operator.ASSIGN, Assignment.Operator.PLUS_ASSIGN, Assignment.Operator.MINUS_ASSIGN, Assignment.Operator.TIMES_ASSIGN, Assignment.Operator.DIVIDE_ASSIGN, Assignment.Operator.REMAINDER_ASSIGN, Assignment.Operator.LEFT_SHIFT_ASSIGN, Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN, Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN, Assignment.Operator.BIT_AND_ASSIGN, Assignment.Operator.BIT_OR_ASSIGN, Assignment.Operator.BIT_XOR_ASSIGN};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                ASTTest.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            ASTTest.assertTrue((boolean)Assignment.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        ASTTest.assertTrue((Assignment.Operator.toOperator((String)"not-an-op") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "LeftHandSide", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getLeftHandSide();
            }

            @Override
            public void set(ASTNode value) {
                x.setLeftHandSide((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "RightHandSide", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getRightHandSide();
            }

            @Override
            public void set(ASTNode value) {
                x.setRightHandSide((Expression)value);
            }
        });
    }

    public void testBreakStatement() {
        long previousCount = this.ast.modificationCount();
        final BreakStatement x = this.ast.newBreakStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLabel() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 10 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == BreakStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Label", false, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getLabel();
            }

            @Override
            public void set(ASTNode value) {
                x.setLabel((SimpleName)value);
            }
        });
    }

    public void testContinueStatement() {
        long previousCount = this.ast.modificationCount();
        final ContinueStatement x = this.ast.newContinueStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLabel() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 18 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ContinueStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Label", false, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getLabel();
            }

            @Override
            public void set(ASTNode value) {
                x.setLabel((SimpleName)value);
            }
        });
    }

    public void testIfStatement() {
        long previousCount = this.ast.modificationCount();
        final IfStatement x = this.ast.newIfStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getThenStatement().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)(x.getThenStatement() instanceof Block));
        ASTTest.assertTrue((boolean)((Block)x.getThenStatement()).statements().isEmpty());
        ASTTest.assertTrue((x.getElseStatement() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 25 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == IfStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ThenStatement", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getThenStatement();
            }

            @Override
            public void set(ASTNode value) {
                x.setThenStatement((Statement)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ElseStatement", false, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getElseStatement();
            }

            @Override
            public void set(ASTNode value) {
                x.setElseStatement((Statement)value);
            }
        });
    }

    public void testWhileStatement() {
        long previousCount = this.ast.modificationCount();
        final WhileStatement x = this.ast.newWhileStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)(x.getBody() instanceof Block));
        ASTTest.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 61 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == WhileStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    public void testDoStatement() {
        long previousCount = this.ast.modificationCount();
        final DoStatement x = this.ast.newDoStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)(x.getBody() instanceof Block));
        ASTTest.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 19 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == DoStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    public void testTryStatement() {
        long previousCount = this.ast.modificationCount();
        final TryStatement x = this.ast.newTryStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getBody().statements().isEmpty());
        ASTTest.assertTrue((x.getFinally() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.catchClauses().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 54 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == TryStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.catchClauses(), new Property(this, "CatchClauses", true, CatchClause.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                CatchClause result = targetAst.newCatchClause();
                if (parented) {
                    TryStatement s1 = targetAst.newTryStatement();
                    s1.catchClauses().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                CatchClause s1 = ast.newCatchClause();
                Block s2 = ast.newBlock();
                s1.setBody(s2);
                s2.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Finally", false, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getFinally();
            }

            @Override
            public void set(ASTNode value) {
                x.setFinally((Block)value);
            }
        });
    }

    public void testCatchClause() {
        long previousCount = this.ast.modificationCount();
        final CatchClause x = this.ast.newCatchClause();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.getBody().statements().isEmpty());
        ASTTest.assertTrue((x.getException().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 12 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == CatchClause.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Exception", true, SingleVariableDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SingleVariableDeclaration result = targetAst.newSingleVariableDeclaration();
                if (parented) {
                    targetAst.newCatchClause().setException(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                SingleVariableDeclaration s1 = ast.newSingleVariableDeclaration();
                ClassInstanceCreation s2 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s2.setAnonymousClassDeclaration(a1);
                s1.setInitializer((Expression)s2);
                FunctionDeclaration s3 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s3);
                Block s4 = ast.newBlock();
                s3.setBody(s4);
                TryStatement s5 = ast.newTryStatement();
                s4.statements().add(s5);
                s5.catchClauses().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TryStatement s5 = (TryStatement)x.getParent();
                s5.catchClauses().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getException();
            }

            @Override
            public void set(ASTNode value) {
                x.setException((SingleVariableDeclaration)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Block.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                TryStatement s2 = ast.newTryStatement();
                s1.statements().add(s2);
                s2.catchClauses().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                TryStatement s2 = (TryStatement)x.getParent();
                s2.catchClauses().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Block)value);
            }
        });
    }

    public void testEmptyStatement() {
        long previousCount = this.ast.modificationCount();
        EmptyStatement x = this.ast.newEmptyStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 20 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == EmptyStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
    }

    void tLeadingComment(Statement x) {
        long previousCount = this.ast.modificationCount();
        x.setLeadingComment(null);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("/* X */");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == "/* X */" ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("/* X\n *Y\n */");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == "/* X\n *Y\n */" ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("// X\n");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == "// X\n" ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setLeadingComment("// X");
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == "// X" ? 1 : 0) != 0);
        try {
            x.setLeadingComment("// X\n extra");
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
    }

    void tJavadocComment(final BodyDeclaration x) {
        this.genericPropertyTest((ASTNode)x, new Property(this, "Javadoc", false, JSdoc.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                JSdoc result = targetAst.newJSdoc();
                if (parented) {
                    targetAst.newInitializer().setJavadoc(result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getJavadoc();
            }

            @Override
            public void set(ASTNode value) {
                x.setJavadoc((JSdoc)value);
            }
        });
    }

    Modifier[] allModifiers() {
        Modifier[] allMods = new Modifier[]{this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD), this.ast.newModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD)};
        return allMods;
    }

    void tAlternateRoot(Comment x) {
        JavaScriptUnit cu = this.ast.newJavaScriptUnit();
        long previousCount = this.ast.modificationCount();
        x.setAlternateRoot((ASTNode)cu);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getAlternateRoot() == cu ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        x.setAlternateRoot(null);
        ASTTest.assertTrue((x.getAlternateRoot() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
    }

    void tClientProperties(ASTNode x) {
        long previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.properties().size() == 0 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        x.setProperty("1", null);
        ASTTest.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 0 ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a1");
        ASTTest.assertTrue((x.getProperty("1") == "a1" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 1 ? 1 : 0) != 0);
        Map.Entry[] m = x.properties().entrySet().toArray(new Map.Entry[1]);
        ASTTest.assertTrue((m[0].getKey() == "1" ? 1 : 0) != 0);
        ASTTest.assertTrue((m[0].getValue() == "a1" ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a2");
        ASTTest.assertTrue((x.getProperty("1") == "a2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 1 ? 1 : 0) != 0);
        m = x.properties().entrySet().toArray(new Map.Entry[1]);
        ASTTest.assertTrue((m[0].getKey() == "1" ? 1 : 0) != 0);
        ASTTest.assertTrue((m[0].getValue() == "a2" ? 1 : 0) != 0);
        x.setProperty("1", null);
        ASTTest.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 0 ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a1");
        x.setProperty("2", (Object)"b1");
        x.setProperty("3", (Object)"c1");
        ASTTest.assertTrue((x.getProperty("1") == "a1" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("2") == "b1" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("3") == "c1" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 3 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("1") == "a1" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("2") == "b1" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("3") == "c1" ? 1 : 0) != 0);
        x.setProperty("1", (Object)"a2");
        x.setProperty("2", (Object)"b2");
        x.setProperty("3", (Object)"c2");
        ASTTest.assertTrue((x.getProperty("1") == "a2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("2") == "b2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("3") == "c2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 3 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("1") == "a2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("2") == "b2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("3") == "c2" ? 1 : 0) != 0);
        x.setProperty("2", null);
        ASTTest.assertTrue((x.getProperty("1") == "a2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("2") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("3") == "c2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 2 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("1") == "a2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("2") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("3") == "c2" ? 1 : 0) != 0);
        x.setProperty("1", null);
        ASTTest.assertTrue((x.getProperty("1") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("2") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getProperty("3") == "c2" ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().size() == 1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("1") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("2") == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.properties().get("3") == "c2" ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
    }

    public void testReturnStatement() {
        long previousCount = this.ast.modificationCount();
        final ReturnStatement x = this.ast.newReturnStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 41 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ReturnStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    public void testThrowStatement() {
        long previousCount = this.ast.modificationCount();
        final ThrowStatement x = this.ast.newThrowStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 53 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ThrowStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    public void testSwitchStatement() {
        long previousCount = this.ast.modificationCount();
        final SwitchStatement x = this.ast.newSwitchStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.statements().isEmpty());
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 50 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SwitchStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.statements(), new Property(this, "Statements", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }
        });
    }

    public void testSwitchCase() {
        long previousCount = this.ast.modificationCount();
        final SwitchCase x = this.ast.newSwitchCase();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((!x.isDefault() ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 49 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SwitchCase.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                SwitchStatement s4 = ast.newSwitchStatement();
                s3.statements().add(s4);
                s4.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                SwitchStatement s4 = (SwitchStatement)x.getParent();
                s4.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    public void testLabeledStatement() {
        long previousCount = this.ast.modificationCount();
        final LabeledStatement x = this.ast.newLabeledStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLabel().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 30 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == LabeledStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Label", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getLabel();
            }

            @Override
            public void set(ASTNode value) {
                x.setLabel((SimpleName)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    void assignSourceRanges(ASTNode target) {
        StringBuffer buffer = new StringBuffer();
        ArrayList stack = new ArrayList();
        class PositionAssigner
        extends ASTVisitor {
            private final /* synthetic */ StringBuffer val$buffer;
            private final /* synthetic */ List val$stack;

            PositionAssigner(StringBuffer stringBuffer, List list) {
                this.val$buffer = stringBuffer;
                this.val$stack = list;
                super(true);
            }

            public void preVisit(ASTNode node) {
                int start = this.val$buffer.length();
                this.val$buffer.append("(");
                this.val$stack.add(new Integer(start));
            }

            public void postVisit(ASTNode node) {
                int start = (Integer)this.val$stack.remove(this.val$stack.size() - 1);
                this.val$buffer.append(")");
                int length = this.val$buffer.length() - start;
                node.setSourceRange(start, length);
            }
        }
        target.accept((ASTVisitor)new PositionAssigner(buffer, stack));
    }

    public void testClone() {
        ASTNode x = SampleASTs.oneOfEach(this.ast);
        this.assignSourceRanges(x);
        ASTTest.assertTrue((boolean)x.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)x));
        ASTNode y = ASTNode.copySubtree((AST)this.ast, (ASTNode)x);
        ASTTest.assertTrue((boolean)x.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)y));
        ASTTest.assertTrue((boolean)y.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)x));
        AST newAST = AST.newAST((int)this.ast.apiLevel());
        ASTNode z = ASTNode.copySubtree((AST)newAST, (ASTNode)x);
        ASTTest.assertTrue((boolean)x.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)z));
        ASTTest.assertTrue((boolean)z.subtreeMatch((ASTMatcher)new CheckPositionsMatcher(), (Object)x));
    }

    public void testNullResolve() {
        ASTNode x = SampleASTs.oneOfEach(this.ast);
        ASTVisitor v = new ASTVisitor(true){

            public boolean visit(SimpleName node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(QualifiedName node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(SimpleType node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ArrayType node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(PrimitiveType node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(QualifiedType node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(Assignment node) {
                ASTTest.assertTrue((node.resolveTypeBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ClassInstanceCreation node) {
                ASTTest.assertTrue((node.resolveConstructorBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ConstructorInvocation node) {
                ASTTest.assertTrue((node.resolveConstructorBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(SuperConstructorInvocation node) {
                ASTTest.assertTrue((node.resolveConstructorBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(PackageDeclaration node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(ImportDeclaration node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(FunctionDeclaration node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(TypeDeclaration node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(TypeDeclarationStatement node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(SingleVariableDeclaration node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }

            public boolean visit(VariableDeclarationFragment node) {
                ASTTest.assertTrue((node.resolveBinding() == null ? 1 : 0) != 0);
                return true;
            }
        };
        x.accept(v);
    }

    public void testForStatement() {
        long previousCount = this.ast.modificationCount();
        final ForStatement x = this.ast.newForStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.initializers().isEmpty());
        ASTTest.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.updaters().isEmpty());
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)(x.getBody() instanceof Block));
        ASTTest.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 24 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ForStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyListTest((ASTNode)x, x.initializers(), new Property(this, "Initializers", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.updaters(), new Property(this, "Updaters", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Body", true, Statement.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                Block result = targetAst.newBlock();
                if (parented) {
                    Block b2 = targetAst.newBlock();
                    b2.statements().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                Block s1 = ast.newBlock();
                s1.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s2 = (Block)x.getParent();
                s2.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getBody();
            }

            @Override
            public void set(ASTNode value) {
                x.setBody((Statement)value);
            }
        });
    }

    public void testEnhancedForStatement() {
        if (this.ast.apiLevel() == 2) {
            try {
                this.ast.newEnhancedForStatement();
                ASTTest.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return;
        }
        long previousCount = this.ast.modificationCount();
        final EnhancedForStatement x = this.ast.newEnhancedForStatement();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParameter() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParameter().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getBody().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)(x.getBody() instanceof Block));
        ASTTest.assertTrue((boolean)((Block)x.getBody()).statements().isEmpty());
        ASTTest.assertTrue((x.getLeadingComment() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 70 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == EnhancedForStatement.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.tLeadingComment((Statement)x);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Parameter", true, SingleVariableDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SingleVariableDeclaration result = targetAst.newSingleVariableDeclaration();
                if (parented) {
                    CatchClause parent = targetAst.newCatchClause();
                    parent.setException(result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getParameter();
            }

            @Override
            public void set(ASTNode value) {
                x.setParameter((SingleVariableDeclaration)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST target, boolean parented) {
                SimpleName result = target.newSimpleName("foo");
                if (parented) {
                    target.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    public void testConstructorInvocation() {
        long previousCount = this.ast.modificationCount();
        final ConstructorInvocation x = this.ast.newConstructorInvocation();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            ASTTest.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        ASTTest.assertTrue((boolean)x.arguments().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 17 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ConstructorInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
    }

    public void testSuperConstructorInvocation() {
        long previousCount = this.ast.modificationCount();
        final SuperConstructorInvocation x = this.ast.newSuperConstructorInvocation();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            ASTTest.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        ASTTest.assertTrue((boolean)x.arguments().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 46 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SuperConstructorInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ClassInstanceCreation s1 = ast.newClassInstanceCreation();
                AnonymousClassDeclaration a1 = ast.newAnonymousClassDeclaration();
                s1.setAnonymousClassDeclaration(a1);
                FunctionDeclaration s2 = ast.newFunctionDeclaration();
                a1.bodyDeclarations().add(s2);
                Block s3 = ast.newBlock();
                s2.setBody(s3);
                s3.statements().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                Block s3 = (Block)x.getParent();
                s3.statements().remove(x);
            }
        });
    }

    public void testThisExpression() {
        long previousCount = this.ast.modificationCount();
        final ThisExpression x = this.ast.newThisExpression();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 52 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ThisExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
    }

    public void testFieldAccess() {
        long previousCount = this.ast.modificationCount();
        final FieldAccess x = this.ast.newFieldAccess();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 22 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == FieldAccess.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    public void testSuperFieldAccess() {
        long previousCount = this.ast.modificationCount();
        final SuperFieldAccess x = this.ast.newSuperFieldAccess();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 47 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SuperFieldAccess.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
    }

    public void testSuperMethodInvocation() {
        long previousCount = this.ast.modificationCount();
        final SuperMethodInvocation x = this.ast.newSuperMethodInvocation();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() >= 3) {
            ASTTest.assertTrue((boolean)x.typeArguments().isEmpty());
        }
        ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getQualifier() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.arguments().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 48 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == SuperMethodInvocation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Qualifier", false, Name.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                QualifiedName result = targetAst.newQualifiedName((Name)targetAst.newSimpleName("a"), targetAst.newSimpleName("b"));
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getQualifier();
            }

            @Override
            public void set(ASTNode value) {
                x.setQualifier((Name)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, SimpleName.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getName();
            }

            @Override
            public void set(ASTNode value) {
                x.setName((SimpleName)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    public void testTypeLiteral() {
        long previousCount = this.ast.modificationCount();
        final TypeLiteral x = this.ast.newTypeLiteral();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 57 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == TypeLiteral.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("a"));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((Type)value);
            }
        });
    }

    public void testPrefixExpression() {
        long previousCount = this.ast.modificationCount();
        final PrefixExpression x = this.ast.newPrefixExpression();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getOperand().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getOperator() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 38 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == PrefixExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)PrefixExpression.Operator.INCREMENT.toString().equals("++"));
        ASTTest.assertTrue((boolean)PrefixExpression.Operator.DECREMENT.toString().equals("--"));
        ASTTest.assertTrue((boolean)PrefixExpression.Operator.PLUS.toString().equals("+"));
        ASTTest.assertTrue((boolean)PrefixExpression.Operator.MINUS.toString().equals("-"));
        ASTTest.assertTrue((boolean)PrefixExpression.Operator.COMPLEMENT.toString().equals("~"));
        ASTTest.assertTrue((boolean)PrefixExpression.Operator.NOT.toString().equals("!"));
        PrefixExpression.Operator[] known = new PrefixExpression.Operator[]{PrefixExpression.Operator.INCREMENT, PrefixExpression.Operator.DECREMENT, PrefixExpression.Operator.PLUS, PrefixExpression.Operator.MINUS, PrefixExpression.Operator.COMPLEMENT, PrefixExpression.Operator.NOT};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                ASTTest.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            ASTTest.assertTrue((boolean)PrefixExpression.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        ASTTest.assertTrue((PrefixExpression.Operator.toOperator((String)"huh") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Operand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setOperand((Expression)value);
            }
        });
    }

    public void testPostfixExpression() {
        long previousCount = this.ast.modificationCount();
        final PostfixExpression x = this.ast.newPostfixExpression();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getOperand().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getOperator() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 37 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == PostfixExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)PostfixExpression.Operator.INCREMENT.toString().equals("++"));
        ASTTest.assertTrue((boolean)PostfixExpression.Operator.DECREMENT.toString().equals("--"));
        PostfixExpression.Operator[] known = new PostfixExpression.Operator[]{PostfixExpression.Operator.INCREMENT, PostfixExpression.Operator.DECREMENT};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                ASTTest.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            ASTTest.assertTrue((boolean)PostfixExpression.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        ASTTest.assertTrue((PostfixExpression.Operator.toOperator((String)"huh") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Operand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setOperand((Expression)value);
            }
        });
    }

    public void testInfixExpression() {
        long previousCount = this.ast.modificationCount();
        final InfixExpression x = this.ast.newInfixExpression();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeftOperand().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getOperator() != null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getRightOperand().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.extendedOperands().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 27 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == InfixExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)InfixExpression.Operator.TIMES.toString().equals("*"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.DIVIDE.toString().equals("/"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.REMAINDER.toString().equals("%"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.PLUS.toString().equals("+"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.MINUS.toString().equals("-"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.LEFT_SHIFT.toString().equals("<<"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.RIGHT_SHIFT_SIGNED.toString().equals(">>"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED.toString().equals(">>>"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.LESS.toString().equals("<"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.GREATER.toString().equals(">"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.LESS_EQUALS.toString().equals("<="));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.GREATER_EQUALS.toString().equals(">="));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.EQUALS.toString().equals("=="));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.NOT_EQUALS.toString().equals("!="));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.XOR.toString().equals("^"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.OR.toString().equals("|"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.AND.toString().equals("&"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.CONDITIONAL_OR.toString().equals("||"));
        ASTTest.assertTrue((boolean)InfixExpression.Operator.CONDITIONAL_AND.toString().equals("&&"));
        InfixExpression.Operator[] known = new InfixExpression.Operator[]{InfixExpression.Operator.TIMES, InfixExpression.Operator.DIVIDE, InfixExpression.Operator.REMAINDER, InfixExpression.Operator.PLUS, InfixExpression.Operator.MINUS, InfixExpression.Operator.LEFT_SHIFT, InfixExpression.Operator.RIGHT_SHIFT_SIGNED, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, InfixExpression.Operator.LESS, InfixExpression.Operator.GREATER, InfixExpression.Operator.LESS_EQUALS, InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.XOR, InfixExpression.Operator.OR, InfixExpression.Operator.AND, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.CONDITIONAL_AND};
        int i = 0;
        while (i < known.length) {
            int j = 0;
            while (j < known.length) {
                ASTTest.assertTrue((i == j || !known[i].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < known.length) {
            previousCount = this.ast.modificationCount();
            x.setOperator(known[i]);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getOperator().equals(known[i]));
            ++i;
        }
        try {
            x.setOperator(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i = 0;
        while (i < known.length) {
            String name = known[i].toString();
            ASTTest.assertTrue((boolean)InfixExpression.Operator.toOperator((String)name).equals(known[i]));
            ++i;
        }
        ASTTest.assertTrue((InfixExpression.Operator.toOperator((String)"huh") == null ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "LeftOperand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getLeftOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setLeftOperand((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "RightOperand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getRightOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setRightOperand((Expression)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.extendedOperands(), new Property(this, "ExtendedOperands", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    public void testInstanceofExpression() {
        long previousCount = this.ast.modificationCount();
        final InstanceofExpression x = this.ast.newInstanceofExpression();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getLeftOperand().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getRightOperand().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 62 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == InstanceofExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "LeftOperand", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getLeftOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setLeftOperand((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "RightOperand", true, Type.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleType result = localAst.newSimpleType((Name)localAst.newSimpleName("Object"));
                if (parented) {
                    localAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getRightOperand();
            }

            @Override
            public void set(ASTNode value) {
                x.setRightOperand((Type)value);
            }
        });
    }

    public void testConditionalExpression() {
        long previousCount = this.ast.modificationCount();
        final ConditionalExpression x = this.ast.newConditionalExpression();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getThenExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getElseExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 16 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ConditionalExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ThenExpression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getThenExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setThenExpression((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "ElseExpression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getElseExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setElseExpression((Expression)value);
            }
        });
    }

    public void testArrayAccess() {
        long previousCount = this.ast.modificationCount();
        final ArrayAccess x = this.ast.newArrayAccess();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getArray().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getIndex().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 2 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ArrayAccess.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Array", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getArray();
            }

            @Override
            public void set(ASTNode value) {
                x.setArray((Expression)value);
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Index", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getIndex();
            }

            @Override
            public void set(ASTNode value) {
                x.setIndex((Expression)value);
            }
        });
    }

    public void testArrayInitializer() {
        long previousCount = this.ast.modificationCount();
        final ArrayInitializer x = this.ast.newArrayInitializer();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.expressions().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 4 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ArrayInitializer.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyListTest((ASTNode)x, x.expressions(), new Property(this, "Expressions", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
    }

    public void testClassInstanceCreation() {
        long previousCount = this.ast.modificationCount();
        final ClassInstanceCreation x = this.ast.newClassInstanceCreation();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression() == null ? 1 : 0) != 0);
        if (this.ast.apiLevel() == 2) {
            ASTTest.assertTrue((x.getName().getParent() == x ? 1 : 0) != 0);
        } else {
            ASTTest.assertTrue((boolean)x.typeArguments().isEmpty());
            ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        }
        ASTTest.assertTrue((boolean)x.arguments().isEmpty());
        ASTTest.assertTrue((x.getAnonymousClassDeclaration() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 14 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ClassInstanceCreation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", false, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyListTest((ASTNode)x, x.typeArguments(), new Property(this, "TypeArguments", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("X"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }
            });
        }
        if (this.ast.apiLevel() == 2) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Name", true, Name.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleName result = targetAst.newSimpleName("a");
                    if (parented) {
                        targetAst.newExpressionStatement((Expression)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getName();
                }

                @Override
                public void set(ASTNode value) {
                    x.setName((Name)value);
                }
            });
        }
        if (this.ast.apiLevel() >= 3) {
            this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, Type.class){

                @Override
                public ASTNode sample(AST targetAst, boolean parented) {
                    SimpleType result = targetAst.newSimpleType((Name)targetAst.newSimpleName("foo"));
                    if (parented) {
                        targetAst.newArrayType((Type)result);
                    }
                    return result;
                }

                @Override
                public ASTNode get() {
                    return x.getType();
                }

                @Override
                public void set(ASTNode value) {
                    x.setType((Type)value);
                }
            });
        }
        this.genericPropertyListTest((ASTNode)x, x.arguments(), new Property(this, "Arguments", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "AnonymousClassDeclaration", false, AnonymousClassDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                AnonymousClassDeclaration result = targetAst.newAnonymousClassDeclaration();
                if (parented) {
                    targetAst.newClassInstanceCreation().setAnonymousClassDeclaration(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                AnonymousClassDeclaration s0 = x.getAST().newAnonymousClassDeclaration();
                VariableDeclarationFragment s1 = x.getAST().newVariableDeclarationFragment();
                FieldDeclaration s2 = x.getAST().newFieldDeclaration(s1);
                s0.bodyDeclarations().add(s2);
                s1.setInitializer((Expression)x);
                return s0;
            }

            @Override
            public void unwrap() {
                VariableDeclarationFragment s1 = (VariableDeclarationFragment)x.getParent();
                s1.setInitializer(null);
            }

            @Override
            public ASTNode get() {
                return x.getAnonymousClassDeclaration();
            }

            @Override
            public void set(ASTNode value) {
                x.setAnonymousClassDeclaration((AnonymousClassDeclaration)value);
            }
        });
    }

    public void testAnonymousClassDeclaration() {
        long previousCount = this.ast.modificationCount();
        final AnonymousClassDeclaration x = this.ast.newAnonymousClassDeclaration();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.bodyDeclarations().isEmpty());
        ASTTest.assertTrue((x.getNodeType() == 1 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == AnonymousClassDeclaration.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyListTest((ASTNode)x, x.bodyDeclarations(), new Property(this, "BodyDeclarations", true, BodyDeclaration.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                TypeDeclaration result = targetAst.newTypeDeclaration();
                if (parented) {
                    JavaScriptUnit compilationUnit = targetAst.newJavaScriptUnit();
                    compilationUnit.types().add(result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                VariableDeclarationFragment s0 = x.getAST().newVariableDeclarationFragment();
                FieldDeclaration s1 = x.getAST().newFieldDeclaration(s0);
                ClassInstanceCreation s2 = x.getAST().newClassInstanceCreation();
                s0.setInitializer((Expression)s2);
                s2.setAnonymousClassDeclaration(x);
                return s1;
            }

            @Override
            public void unwrap() {
                ClassInstanceCreation s2 = (ClassInstanceCreation)x.getParent();
                s2.setAnonymousClassDeclaration(null);
            }
        });
        TypeDeclaration t1 = this.ast.newTypeDeclaration();
        x.bodyDeclarations().add(t1);
        ASTTest.assertTrue((!t1.isLocalTypeDeclaration() ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)t1.isMemberTypeDeclaration());
        ASTTest.assertTrue((!t1.isPackageMemberTypeDeclaration() ? 1 : 0) != 0);
    }

    public void testArrayCreation() {
        long previousCount = this.ast.modificationCount();
        final ArrayCreation x = this.ast.newArrayCreation();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getType().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)x.dimensions().isEmpty());
        ASTTest.assertTrue((x.getInitializer() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 3 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ArrayCreation.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Type", true, ArrayType.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                ArrayType result = targetAst.newArrayType((Type)targetAst.newSimpleType((Name)targetAst.newSimpleName("a")));
                if (parented) {
                    targetAst.newArrayType((Type)result);
                }
                return result;
            }

            @Override
            public ASTNode get() {
                return x.getType();
            }

            @Override
            public void set(ASTNode value) {
                x.setType((ArrayType)value);
            }
        });
        this.genericPropertyListTest((ASTNode)x, x.dimensions(), new Property(this, "Dimensions", true, Expression.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                SimpleName result = targetAst.newSimpleName("foo");
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("x"));
            }
        });
        this.genericPropertyTest((ASTNode)x, new Property(this, "Initializer", false, ArrayInitializer.class){

            @Override
            public ASTNode sample(AST targetAst, boolean parented) {
                ArrayInitializer result = targetAst.newArrayInitializer();
                if (parented) {
                    targetAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ArrayInitializer s1 = ast.newArrayInitializer();
                s1.expressions().add(x);
                return s1;
            }

            @Override
            public void unwrap() {
                ArrayInitializer s1 = (ArrayInitializer)x.getParent();
                s1.expressions().remove(x);
            }

            @Override
            public ASTNode get() {
                return x.getInitializer();
            }

            @Override
            public void set(ASTNode value) {
                x.setInitializer((ArrayInitializer)value);
            }
        });
    }

    public void testParenthesizedExpression() {
        long previousCount = this.ast.modificationCount();
        final ParenthesizedExpression x = this.ast.newParenthesizedExpression();
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getExpression().getParent() == x ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 36 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == ParenthesizedExpression.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        this.genericPropertyTest((ASTNode)x, new Property(this, "Expression", true, Expression.class){

            @Override
            public ASTNode sample(AST localAst, boolean parented) {
                SimpleName result = localAst.newSimpleName("foo");
                if (parented) {
                    localAst.newExpressionStatement((Expression)result);
                }
                return result;
            }

            @Override
            public ASTNode wrap() {
                ParenthesizedExpression s1 = ast.newParenthesizedExpression();
                s1.setExpression((Expression)x);
                return s1;
            }

            @Override
            public void unwrap() {
                ParenthesizedExpression s1 = (ParenthesizedExpression)x.getParent();
                s1.setExpression((Expression)ast.newSimpleName("fie"));
            }

            @Override
            public ASTNode get() {
                return x.getExpression();
            }

            @Override
            public void set(ASTNode value) {
                x.setExpression((Expression)value);
            }
        });
    }

    public void testModifiers() {
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        int[] mods = new int[]{1024, 16, 256, 2, 4, 1, 8, 2048, 32, 128, 64};
        int i = 0;
        while (i < mods.length) {
            int m = mods[i];
            ASTTest.assertTrue((Modifier.isAbstract((int)m) == (m == 1024) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isFinal((int)m) == (m == 16) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isNative((int)m) == (m == 256) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isPrivate((int)m) == (m == 2) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isProtected((int)m) == (m == 4) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isPublic((int)m) == (m == 1) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isStatic((int)m) == (m == 8) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isStrictfp((int)m) == (m == 2048) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isSynchronized((int)m) == (m == 32) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isTransient((int)m) == (m == 128) ? 1 : 0) != 0);
            ASTTest.assertTrue((Modifier.isVolatile((int)m) == (m == 64) ? 1 : 0) != 0);
            ++i;
        }
        if (this.ast.apiLevel() == 2) {
            try {
                this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
                ASTTest.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            try {
                this.ast.newModifiers(0);
                ASTTest.assertTrue((boolean)false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            return;
        }
        long previousCount = this.ast.modificationCount();
        Modifier x = this.ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
        previousCount = this.ast.modificationCount();
        ASTTest.assertTrue((x.getAST() == this.ast ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getParent() == null ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getKeyword() == Modifier.ModifierKeyword.PUBLIC_KEYWORD ? 1 : 0) != 0);
        ASTTest.assertTrue((x.getNodeType() == 100 ? 1 : 0) != 0);
        ASTTest.assertTrue((x.structuralPropertiesForType() == Modifier.propertyDescriptors((int)this.ast.apiLevel()) ? 1 : 0) != 0);
        ASTTest.assertTrue((this.ast.modificationCount() == previousCount ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.PUBLIC_KEYWORD.toString().equals("public"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.PROTECTED_KEYWORD.toString().equals("protected"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.PRIVATE_KEYWORD.toString().equals("private"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.STATIC_KEYWORD.toString().equals("static"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.ABSTRACT_KEYWORD.toString().equals("abstract"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.FINAL_KEYWORD.toString().equals("final"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD.toString().equals("synchronized"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.NATIVE_KEYWORD.toString().equals("native"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.TRANSIENT_KEYWORD.toString().equals("transient"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.VOLATILE_KEYWORD.toString().equals("volatile"));
        ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.STRICTFP_KEYWORD.toString().equals("strictfp"));
        Modifier.ModifierKeyword[] known = new Modifier.ModifierKeyword[]{Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.PROTECTED_KEYWORD, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, Modifier.ModifierKeyword.NATIVE_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD, Modifier.ModifierKeyword.VOLATILE_KEYWORD, Modifier.ModifierKeyword.STRICTFP_KEYWORD};
        int i2 = 0;
        while (i2 < known.length) {
            int j = 0;
            while (j < known.length) {
                ASTTest.assertTrue((i2 == j || !known[i2].equals(known[j]) ? 1 : 0) != 0);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < known.length) {
            previousCount = this.ast.modificationCount();
            x.setKeyword(known[i2]);
            ASTTest.assertTrue((this.ast.modificationCount() > previousCount ? 1 : 0) != 0);
            ASTTest.assertTrue((boolean)x.getKeyword().equals(known[i2]));
            ++i2;
        }
        try {
            x.setKeyword(null);
            ASTTest.assertTrue((boolean)false);
        }
        catch (RuntimeException runtimeException) {}
        i2 = 0;
        while (i2 < known.length) {
            String name = known[i2].toString();
            ASTTest.assertTrue((boolean)Modifier.ModifierKeyword.toKeyword((String)name).equals(known[i2]));
            ++i2;
        }
        ASTTest.assertTrue((Modifier.ModifierKeyword.toKeyword((String)"huh") == null ? 1 : 0) != 0);
        i2 = 0;
        while (i2 < mods.length) {
            int m = mods[i2];
            List result = this.ast.newModifiers(m);
            ASTTest.assertEquals((int)1, (int)result.size());
            Modifier modNode = (Modifier)result.get(0);
            ASTTest.assertEquals((int)m, (int)modNode.getKeyword().toFlagValue());
            ++i2;
        }
        Modifier.ModifierKeyword[] expectedOrder = new Modifier.ModifierKeyword[]{Modifier.ModifierKeyword.PUBLIC_KEYWORD, Modifier.ModifierKeyword.PROTECTED_KEYWORD, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.ABSTRACT_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, Modifier.ModifierKeyword.NATIVE_KEYWORD, Modifier.ModifierKeyword.STRICTFP_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD, Modifier.ModifierKeyword.VOLATILE_KEYWORD};
        int all = 0;
        int i3 = 0;
        while (i3 < mods.length) {
            all |= mods[i3];
            ++i3;
        }
        List result = this.ast.newModifiers(all);
        ASTTest.assertEquals((int)expectedOrder.length, (int)result.size());
        int i4 = 0;
        while (i4 < expectedOrder.length) {
            Modifier modifier = (Modifier)result.get(i4);
            ASTTest.assertEquals((Object)expectedOrder[i4], (Object)modifier.getKeyword());
            if (modifier.isAbstract()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.ABSTRACT_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isFinal()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.FINAL_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isNative()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.NATIVE_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isPrivate()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.PRIVATE_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isProtected()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.PROTECTED_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isPublic()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.PUBLIC_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isStatic()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.STATIC_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isStrictfp()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.STRICTFP_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isSynchronized()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD, (Object)modifier.getKeyword());
            } else if (modifier.isTransient()) {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.TRANSIENT_KEYWORD, (Object)modifier.getKeyword());
            } else {
                ASTTest.assertEquals((Object)Modifier.ModifierKeyword.VOLATILE_KEYWORD, (Object)modifier.getKeyword());
            }
            ++i4;
        }
    }

    public void testSubtreeBytes() {
        ASTNode x = SampleASTs.oneOfEach(this.ast);
        int subtreeBytes = x.subtreeBytes();
        ASTTest.assertTrue((subtreeBytes > 0 ? 1 : 0) != 0);
    }

    public void testNodeTypeConstants() {
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        ASTTest.assertTrue((boolean)true);
        int[] all = new int[]{1, 2, 3, 4, 5, 7, 8, 64, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 70, 21, 22, 23, 24, 25, 26, 27, 62, 28, 29, 30, 63, 67, 31, 32, 68, 69, 100, 33, 34, 35, 36, 37, 38, 39, 40, 75, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 65, 66, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61};
        int MIN = 1;
        int MAX = 100;
        HashSet<Integer> s = new HashSet<Integer>();
        int i = 0;
        while (i < all.length) {
            ASTTest.assertTrue((MIN <= all[i] && all[i] <= MAX ? 1 : 0) != 0);
            s.add(new Integer(all[i]));
            ++i;
        }
        ASTTest.assertTrue((s.size() == all.length ? 1 : 0) != 0);
        ASTTest.assertTrue((boolean)new Integer(1).equals(new Integer(1)));
    }

    class CheckPositionsMatcher
    extends ASTMatcher {
        public CheckPositionsMatcher() {
            super(true);
        }

        private void checkPositions(Object source, Object destination) {
            int length;
            ASTTest.assertTrue((boolean)(source instanceof ASTNode));
            ASTTest.assertTrue((boolean)(destination instanceof ASTNode));
            int startPosition = ((ASTNode)source).getStartPosition();
            if (startPosition != -1) {
                ASTTest.assertTrue((startPosition == ((ASTNode)destination).getStartPosition() ? 1 : 0) != 0);
            }
            if ((length = ((ASTNode)source).getLength()) != 0) {
                ASTTest.assertTrue((length == ((ASTNode)destination).getLength() ? 1 : 0) != 0);
            }
        }

        public boolean match(AnonymousClassDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayAccess node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayCreation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayInitializer node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ArrayType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Assignment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Block node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(BlockComment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(BooleanLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(BreakStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(CatchClause node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(CharacterLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ClassInstanceCreation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(JavaScriptUnit node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ConditionalExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ConstructorInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ContinueStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(DoStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(EmptyStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(EnhancedForStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ExpressionStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FieldAccess node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FieldDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ForStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(IfStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ImportDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(InfixExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Initializer node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(InstanceofExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(JSdoc node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(LabeledStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(LineComment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(MemberRef node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionRef node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(FunctionRefParameter node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(Modifier node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(NullLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(NumberLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PackageDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ParenthesizedExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PostfixExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PrefixExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(PrimitiveType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(QualifiedName node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(QualifiedType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ReturnStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SimpleName node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SimpleType node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SingleVariableDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(StringLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SuperConstructorInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SuperFieldAccess node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SuperMethodInvocation node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SwitchCase node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(SwitchStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TagElement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TextElement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ThisExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(ThrowStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TryStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TypeDeclaration node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TypeDeclarationStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(TypeLiteral node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(VariableDeclarationExpression node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(VariableDeclarationFragment node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(VariableDeclarationStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }

        public boolean match(WhileStatement node, Object other) {
            this.checkPositions(node, other);
            return super.match(node, other);
        }
    }

    abstract class Property {
        private boolean compulsory;
        private Class nodeType;
        private String propertyName;

        Property(String propertyName, boolean compulsory, Class nodeType) {
            this.propertyName = propertyName;
            this.compulsory = compulsory;
            this.nodeType = nodeType;
        }

        public abstract ASTNode sample(AST var1, boolean var2);

        public ASTNode[] counterExamples(AST targetAST) {
            return new ASTNode[0];
        }

        public ASTNode wrap() {
            return null;
        }

        public void unwrap() {
        }

        public final boolean isCompulsory() {
            return this.compulsory;
        }

        public ASTNode get() {
            throw new RuntimeException("get not implemented");
        }

        public void set(ASTNode value) {
            throw new RuntimeException("get(" + value + ") not implemented");
        }

        public String toString() {
            return "Property(" + this.propertyName + ", " + this.compulsory + ", " + this.nodeType + ")";
        }
    }
}

