/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.search;

import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.tests.search.AbstractSearchTest;

public class TestVarSearch
extends AbstractSearchTest {
    public void testVarDeclarationSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName(), new String[]{"X.js"}, new String[]{"var " + this.getName() + " = {\n" + "\tsearchVar: 5,\n" + "};\n"}, 12, 0, 0);
        TestVarSearch.assertEquals((String)"wrong number of files containing references found", (int)1, (int)results.length);
    }

    public void testVarDeclarationSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName().toUpperCase(), new String[]{"X.js", "Y.js"}, new String[]{"var " + this.getName().toUpperCase() + " = {\n" + "\tsearchVar: 5,\n" + "};\n", "var " + this.getName() + "XYZ = function() {};"}, 12, 0, 8);
        TestVarSearch.assertEquals((String)"wrong number of files containing references found", (int)1, (int)results.length);
    }

    public void testVarDeclarationSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testVar*", new String[]{"X.js", "Y.js"}, new String[]{"var " + this.getName() + " = {\n" + "\tsearchVar: 5,\n" + "};\n", "var " + this.getName() + "XYZ = function() {};"}, 12, 0, 2);
        TestVarSearch.assertEquals((String)"wrong number of files containing references found", (int)2, (int)results.length);
    }

    public void testVarReferenceSearch01() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"var searchVar = {};\nsearchVar." + this.getName() + " = 5;\n", "var x = searchVar." + this.getName() + ";\n"}, 12, 2, 0);
        TestVarSearch.assertEquals((String)"wrong number of files containing references found", (int)0, (int)results.length);
    }

    public void testVarReferenceSearch02() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), this.getName(), new String[]{"X.js", "Y.js"}, new String[]{"var " + this.getName() + " = {\n" + "\tx: 5,\n" + "};\n", "var searchVar = " + this.getName() + ".x;\n"}, 12, 2, 0);
        TestVarSearch.assertEquals((String)"wrong number of files containing references found", (int)1, (int)results.length);
    }

    public void testVarReferenceSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testvar*", new String[]{"X.js", "Y.js"}, new String[]{"var " + this.getName() + " = {\n" + "\tx: 5,\n" + "};\n", "var " + this.getName() + "XYZ = " + this.getName() + ".x;\n" + "var searchVar = " + this.getName() + "XYZ;\n"}, 12, 2, 2);
        TestVarSearch.assertEquals((String)"wrong number of files containing references found", (int)2, (int)results.length);
    }

    public void testVarOccurrencesSearch03() throws Exception {
        SearchMatch[] results = this.runSearchTest(this.getName(), "testvar*", new String[]{"X.js", "Y.js"}, new String[]{"var " + this.getName() + " = {\n" + "\tx: 5,\n" + "};\n", "var " + this.getName() + "XYZ = " + this.getName() + ".x;\n" + "var searchVar = " + this.getName() + "XYZ;\n"}, 12, 3, 2);
        TestVarSearch.assertEquals((String)"wrong number of files containing references found", (int)4, (int)results.length);
    }
}

