/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.common.WSDLParserFactory;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.TimedWSDLSelectionConditionCommand;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.common.HTTPUtility;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IMerger;
import org.eclipse.wst.ws.internal.wsrt.ISelection;
import org.eclipse.wst.ws.internal.wsrt.IWebService;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.wsrt.SimpleContext;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;
import org.eclipse.wst.ws.internal.wsrt.WebServiceScenario;
import org.eclipse.wst.ws.internal.wsrt.WebServiceState;

public class PreServiceDevelopCommand
extends AbstractDataModelOperation {
    private TypeRuntimeServer typeRuntimeServer_;
    private String serviceRuntimeId_;
    private IContext context_;
    private ISelection selection_;
    private String project_;
    private String module_;
    private String moduleType_;
    private String earProject_;
    private String ear_;
    private IProject initialProject_;
    private IWebService webService_;
    private String j2eeLevel_;
    private ResourceContext resourceContext_;
    private boolean develop_;
    private boolean assemble_;
    private boolean deploy_;
    private boolean install_;
    private boolean run_;
    private boolean client_;
    private boolean test_;
    private boolean publish_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status = Status.OK_STATUS;
        if (this.develop_) {
            int earIndex;
            IEnvironment environment = this.getEnvironment();
            int index = this.module_.indexOf("/");
            if (index != -1) {
                this.project_ = this.module_.substring(0, index);
                this.module_ = this.module_.substring(index + 1);
            }
            if (this.ear_ != null && this.ear_.length() > 0 && (earIndex = this.ear_.indexOf("/")) != -1) {
                this.earProject_ = this.ear_.substring(0, earIndex);
                this.ear_ = this.ear_.substring(earIndex + 1);
            }
            IWebServiceRuntime wsrt = WebServiceRuntimeExtensionUtils2.getServiceRuntime((String)this.serviceRuntimeId_);
            WebServiceInfo wsInfo = new WebServiceInfo();
            wsInfo.setServerFactoryId(this.typeRuntimeServer_.getServerId());
            wsInfo.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
            wsInfo.setState(WebServiceState.UNKNOWN_LITERAL);
            wsInfo.setWebServiceRuntimeId(this.typeRuntimeServer_.getRuntimeId());
            environment.getLog().log(1, "ws_framework", 5107, (Object)this, "PreServiceDevelopCommand", (Object)("serviceRuntimeId_ = " + this.serviceRuntimeId_));
            ServiceRuntimeDescriptor serviceRuntimeDescriptor = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_);
            IMerger merger = serviceRuntimeDescriptor.getServiceImplementationType().getMergerClass();
            wsInfo.setMerger(merger);
            this.webService_ = wsrt.getWebService(wsInfo);
            WebServiceScenario scenario = null;
            int scenarioInt = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId((String)this.typeRuntimeServer_.getTypeId());
            if (scenarioInt == 0) {
                scenario = WebServiceScenario.BOTTOMUP_LITERAL;
                if (this.selection_.getSelection() != null) {
                    String impl = (String)this.selection_.getSelection()[0];
                    wsInfo.setImplURL(impl);
                }
            } else if (scenarioInt == 1) {
                scenario = WebServiceScenario.TOPDOWN_LITERAL;
                String wsdlURL = (String)this.selection_.getSelection()[0];
                HTTPUtility httpUtil = new HTTPUtility();
                String newWsdlURL = httpUtil.handleRedirect(wsdlURL);
                wsInfo.setWsdlURL(newWsdlURL);
                TimedWSDLSelectionConditionCommand timedCmd = new TimedWSDLSelectionConditionCommand();
                WebServicesParser parser = WSDLParserFactory.getWSDLParser();
                timedCmd.setWebServicesParser(parser);
                timedCmd.setWebServiceURI(newWsdlURL);
                timedCmd.execute(null, null);
                WebServiceEntity entity = parser.getWebServiceEntityByURI(newWsdlURL);
                if (entity == null || entity.getType() != 2) {
                    status = StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_SELECTION_MUST_BE_WSDL);
                    environment.getStatusHandler().reportError(status);
                    return status;
                }
            }
            this.context_ = new SimpleContext(this.develop_, this.assemble_, this.deploy_, this.install_, this.run_, this.client_, this.test_, this.publish_, scenario, this.resourceContext_.isOverwriteFilesEnabled(), this.resourceContext_.isCreateFoldersEnabled(), this.resourceContext_.isCheckoutFilesEnabled());
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.project_);
            RequiredFacetVersion[] rfv = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById((String)this.serviceRuntimeId_).getRequiredFacetVersions();
            if (!project.exists()) {
                boolean matches = WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportTemplate((String)this.serviceRuntimeId_, (String)this.moduleType_);
                if (matches) {
                    CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
                    command.setProjectName(this.project_);
                    command.setTemplateId(this.moduleType_);
                    command.setRequiredFacetVersions(rfv);
                    command.setServerFactoryId(this.typeRuntimeServer_.getServerId());
                    command.setServerInstanceId(this.typeRuntimeServer_.getServerInstanceId());
                    command.setEarProjectName(this.earProject_);
                    status = command.execute(monitor, adaptable);
                    if (status.getSeverity() == 4) {
                        environment.getStatusHandler().reportError(status);
                        return status;
                    }
                }
            } else if (rfv.length != 0 && (status = FacetUtils.addRequiredFacetsToProject((IProject)project, (RequiredFacetVersion[])rfv, (IProgressMonitor)monitor)).getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            if (this.initialProject_ != null && FacetUtils.isJavaProject((IProject)this.initialProject_) && scenarioInt == 0) {
                IStatus errorStatus;
                try {
                    this.addJavaProjectAsUtilityInModalCtx(this.initialProject_, project, monitor);
                }
                catch (CoreException coreException) {
                    String errorMessage = NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_MODULE_DEPENDENCY, (Object[])new String[]{project.getName(), this.initialProject_.getName()});
                    errorStatus = StatusUtils.errorStatus((String)errorMessage);
                    environment.getStatusHandler().reportError(errorStatus);
                }
                catch (IOException iOException) {
                    String errorMessage = NLS.bind((String)ConsumptionUIMessages.MSG_ERROR_MODULE_DEPENDENCY, (Object[])new String[]{project.getName(), this.initialProject_.getName()});
                    errorStatus = StatusUtils.errorStatus((String)errorMessage);
                    environment.getStatusHandler().reportError(errorStatus);
                }
            }
        }
        return status;
    }

    private void addJavaProjectAsUtilityInModalCtx(final IProject projectToAdd, final IProject earProject, IProgressMonitor monitor) throws IOException, CoreException {
        IRunnableWithProgress addRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                J2EEUtils.addJavaProjectAsUtilityJar((IProject)projectToAdd, (IProject)earProject, (IProgressMonitor)monitor);
                try {
                    String uri = String.valueOf(projectToAdd.getName()) + ".jar";
                    J2EEUtils.addJAROrModuleDependency((IProject)earProject, (String)uri);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            ModalContext.run((IRunnableWithProgress)addRunnable, (boolean)true, (IProgressMonitor)monitor, (Display)PlatformUI.getWorkbench().getDisplay());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof CoreException) {
                throw (CoreException)cause;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        this.typeRuntimeServer_ = typeRuntimeServer;
    }

    public void setServiceRuntimeId(String id) {
        this.serviceRuntimeId_ = id;
    }

    public void setServiceJ2EEVersion(String j2eeLevel) {
        this.j2eeLevel_ = j2eeLevel;
    }

    public String getJ2eeLevel() {
        return this.j2eeLevel_;
    }

    public IWebService getWebService() {
        return this.webService_;
    }

    public IContext getContext() {
        return this.context_;
    }

    public void setResourceContext(ResourceContext resourceContext) {
        this.resourceContext_ = resourceContext;
    }

    public ISelection getSelection() {
        return this.selection_;
    }

    public void setSelection(ISelection selection) {
        this.selection_ = selection;
    }

    public String getProject() {
        return this.project_;
    }

    public String getModule() {
        return this.module_;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setModuleType(String type) {
        this.moduleType_ = type;
    }

    public String getEarProject() {
        return this.earProject_;
    }

    public String getEar() {
        return this.ear_;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setInstallService(boolean installService) {
        this.install_ = installService;
    }

    public void setDevelopService(boolean developService) {
        this.develop_ = developService;
    }

    public void setAssembleService(boolean assembleService) {
        this.assemble_ = assembleService;
    }

    public void setDeployService(boolean deployService) {
        this.deploy_ = deployService;
    }

    public void setStartService(boolean startService) {
        this.run_ = startService;
    }

    public void setTestService(boolean testService) {
        this.test_ = testService;
    }

    public void setPublishService(boolean publishService) {
        this.publish_ = publishService;
    }

    public void setGenerateProxy(boolean genProxy) {
        this.client_ = genProxy;
    }

    public void setInitialProject(IProject initialProject) {
        this.initialProject_ = initialProject;
    }

    public IProject getInitialProject() {
        return this.initialProject_;
    }
}

