/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxrs.ui.internal.project.facet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryFacetPropertyPage;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.ws.jaxrs.core.internal.Messages;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.IJAXRSFacetInstallDataModelProperties;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSFacetDelegateUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSJ2EEUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSJEEUtils;
import org.eclipse.jst.ws.jaxrs.core.internal.project.facet.JAXRSUtils;
import org.eclipse.jst.ws.jaxrs.ui.internal.JAXRSUIPlugin;
import org.eclipse.jst.ws.jaxrs.ui.internal.project.facet.ServletInformationGroup;
import org.eclipse.jst.ws.jaxrs.ui.internal.project.facet.UpdateWebXMLForJ2EE;
import org.eclipse.jst.ws.jaxrs.ui.internal.project.facet.UpdateWebXMLForJavaEE;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class JAXRSLibraryPropertyPage
extends LibraryFacetPropertyPage
implements IJAXRSFacetInstallDataModelProperties {
    private static final String SETTINGS_SERVLET = "servletName";
    private static final String SETTINGS_SERVLET_CLASSNAME = "servletClassname";
    private static final String SETTINGS_URL_MAPPINGS = "urlMappings";
    private static final String SETTINGS_URL_PATTERN = "pattern";
    private ServletInformationGroup servletInfoGroup;
    private IPath webXMLPath;
    private IModelProvider provider;
    private Object webAppObj;
    private Servlet j2eeServlet = null;
    private org.eclipse.jst.j2ee.webapplication.ServletMapping j2eeServletMapping = null;
    private String initialInstallDelegateLibraryProviderID = "";

    protected Control createPageContents(Composite parent) {
        ILibraryProvider initialLibraryProvider;
        Control c = super.createPageContents(parent);
        LibraryInstallDelegate initialInstallDelegate = super.getLibraryInstallDelegate();
        if (initialInstallDelegate != null && (initialLibraryProvider = initialInstallDelegate.getLibraryProvider()) != null) {
            String initID = initialLibraryProvider.getId();
            this.initialInstallDelegateLibraryProviderID = initID == null ? this.initialInstallDelegateLibraryProviderID : initID;
        }
        this.webXMLPath = new Path("WEB-INF").append("web.xml");
        try {
            if (JAXRSFacetDelegateUtils.isDynamicWebProject((IProject)this.getProject())) {
                this.provider = JAXRSUtils.getModelProvider((IProject)this.getProject());
                if (this.provider != null) {
                    this.webAppObj = this.provider.getModelObject();
                }
                if (this.doesDDFileExist(this.getProject(), this.webXMLPath)) {
                    this.servletInfoGroup = new ServletInformationGroup((Composite)c, 0);
                    this.servletInfoGroup.txtJAXRSServletName.addListener(24, new Listener(){

                        public void handleEvent(Event arg0) {
                            JAXRSLibraryPropertyPage.this.updateValidation();
                        }
                    });
                    this.servletInfoGroup.txtJAXRSServletClassName.addListener(24, new Listener(){

                        public void handleEvent(Event arg0) {
                            JAXRSLibraryPropertyPage.this.updateValidation();
                        }
                    });
                    this.initializeValues();
                }
            }
        }
        catch (CoreException e) {
            JAXRSUIPlugin.log(4, NLS.bind((String)Messages.JAXRSFacetUninstallDelegate_ConfigErr, (Object)this.getProject().getName()), e);
        }
        return c;
    }

    public IProjectFacetVersion getProjectFacetVersion() {
        IProjectFacet jaxrsFacet = ProjectFacetsManager.getProjectFacet((String)"jst.jaxrs");
        IFacetedProject fproj = this.getFacetedProject();
        return fproj.getInstalledVersion(jaxrsFacet);
    }

    protected void initializeValues() {
        block13: {
            org.eclipse.jst.javaee.web.Servlet servlet;
            WebApp webApp;
            EList servletMappings = new ArrayList();
            if (this.webAppObj == null) break block13;
            this.servletInfoGroup.lstJAXRSServletURLPatterns.removeAll();
            String servletName = "JAX-RS Servlet";
            String servletClass = "";
            LibraryInstallDelegate installDelegate = super.getLibraryInstallDelegate();
            ILibraryProvider libraryProvider = installDelegate.getLibraryProvider();
            String id = "";
            if (libraryProvider != null) {
                id = libraryProvider.getId();
            }
            if (JAXRSJEEUtils.isWebApp25orHigher((Object)this.webAppObj)) {
                webApp = (WebApp)this.webAppObj;
                servlet = JAXRSJEEUtils.findJAXRSServlet((WebApp)webApp, (String)id);
                if (servlet != null) {
                    servletMappings = webApp.getServletMappings();
                    servletName = servlet.getServletName() == null ? servletName : servlet.getServletName();
                    servletClass = servlet.getServletClass() == null ? servletClass : servlet.getServletClass();
                } else {
                    this.servletInfoGroup.lstJAXRSServletURLPatterns.add("/jaxrs/*");
                }
            } else {
                webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)this.webAppObj;
                servlet = JAXRSJ2EEUtils.findJAXRSServlet((Object)webApp, (String)id);
                if (servlet != null) {
                    this.j2eeServlet = servlet;
                    servletMappings = webApp.getServletMappings();
                    String string = servletName = servlet.getServletName() == null ? servletName : servlet.getServletName();
                    if (servlet.getServletClass() != null) {
                        servletClass = servlet.getServletClass().getQualifiedName() == null ? servletClass : servlet.getServletClass().getQualifiedName();
                    }
                } else {
                    this.servletInfoGroup.lstJAXRSServletURLPatterns.add("/jaxrs/*");
                }
            }
            this.servletInfoGroup.txtJAXRSServletName.setText(servletName);
            this.servletInfoGroup.txtJAXRSServletClassName.setText(servletClass);
            if (JAXRSJEEUtils.isWebApp25orHigher((Object)this.webAppObj)) {
                for (Object o : servletMappings) {
                    ServletMapping next;
                    if (!(o instanceof ServletMapping) || !servletName.equals((next = (ServletMapping)o).getServletName())) continue;
                    for (UrlPatternType pattern : next.getUrlPatterns()) {
                        this.servletInfoGroup.lstJAXRSServletURLPatterns.add(pattern.getValue());
                    }
                }
            } else {
                for (Object o : servletMappings) {
                    org.eclipse.jst.j2ee.webapplication.ServletMapping next;
                    Servlet aServlet;
                    if (!(o instanceof org.eclipse.jst.j2ee.webapplication.ServletMapping) || (aServlet = (next = (org.eclipse.jst.j2ee.webapplication.ServletMapping)o).getServlet()) == null || !servletName.equals(aServlet.getServletName())) continue;
                    this.j2eeServletMapping = next;
                    String pattern = next.getUrlPattern();
                    this.servletInfoGroup.lstJAXRSServletURLPatterns.add(new String(pattern));
                }
            }
        }
    }

    public boolean performOk() {
        String id;
        LibraryInstallDelegate installDelegate = super.getLibraryInstallDelegate();
        if (installDelegate == null) {
            return true;
        }
        ILibraryProvider libraryProvider = installDelegate.getLibraryProvider();
        if (libraryProvider != null && (!this.initialInstallDelegateLibraryProviderID.equals(id = libraryProvider.getId()) || "jaxrs-user-library-provider".equals(id))) {
            super.performOk();
        }
        try {
            if (JAXRSFacetDelegateUtils.isDynamicWebProject((IProject)this.getProject()) && this.doesDDFileExist(this.getProject(), this.webXMLPath)) {
                this.createServletAndModifyWebXML(this.getProject(), null, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            JAXRSUIPlugin.log(4, NLS.bind((String)Messages.JAXRSFacetUninstallDelegate_ConfigErr, (Object)this.getProject().getName()), e);
        }
        return true;
    }

    private void createServletAndModifyWebXML(IProject project, IDataModel config, IProgressMonitor monitor) {
        List<String> listOfMappings = Arrays.asList(this.servletInfoGroup.lstJAXRSServletURLPatterns.getItems());
        if (JAXRSJEEUtils.isWebApp25orHigher((Object)this.webAppObj)) {
            this.provider.modify((Runnable)new UpdateWebXMLForJavaEE(project, this.initialInstallDelegateLibraryProviderID, this.servletInfoGroup.txtJAXRSServletName.getText(), this.servletInfoGroup.txtJAXRSServletClassName.getText(), listOfMappings), IModelProvider.FORCESAVE);
        } else {
            this.provider.modify((Runnable)new UpdateWebXMLForJ2EE(project, this.j2eeServlet, this.j2eeServletMapping, this.servletInfoGroup.txtJAXRSServletName.getText(), this.servletInfoGroup.txtJAXRSServletClassName.getText(), listOfMappings), this.webXMLPath);
        }
    }

    private boolean doesDDFileExist(IProject project, IPath webXMLPath) {
        return this.getWebContentPath(project) == null ? false : project.getLocation().append(this.getWebContentPath(project).lastSegment()).append(webXMLPath).toFile().exists();
    }

    private IPath getWebContentPath(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IPath modulePath = component.getRootFolder().getWorkspaceRelativePath();
        return modulePath;
    }

    private IStatus validateServletInfo(String servletName, String ServletClassName) {
        if (servletName == null || servletName.trim().length() == 0) {
            String errorMessage = Messages.JAXRSFacetInstallDataModelProvider_ValidateServletName;
            return this.createErrorStatus(errorMessage);
        }
        if (ServletClassName == null || ServletClassName.trim().length() == 0) {
            String errorMessage = Messages.JAXRSFacetInstallDataModelProvider_ValidateServletClassName;
            return this.createErrorStatus(errorMessage);
        }
        return Status.OK_STATUS;
    }

    private IStatus createErrorStatus(String msg) {
        return new Status(4, "org.eclipse.jst.ws.jaxrs.ui", msg);
    }

    protected IStatus performValidation() {
        IStatus superValidation = super.performValidation();
        if (superValidation.isOK()) {
            try {
                if (JAXRSFacetDelegateUtils.isDynamicWebProject((IProject)this.getProject()) && this.doesDDFileExist(this.getProject(), this.webXMLPath)) {
                    if (this.servletInfoGroup != null && !this.servletInfoGroup.isDisposed()) {
                        return this.validateServletInfo(this.servletInfoGroup.txtJAXRSServletName.getText(), this.servletInfoGroup.txtJAXRSServletClassName.getText());
                    }
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }
            catch (CoreException coreException) {
                String errorMessage = NLS.bind((String)Messages.JAXRSFacetUninstallDelegate_ProjectErr, (Object)this.getProject().getName());
                return this.createErrorStatus(errorMessage);
            }
        }
        return superValidation;
    }
}

