/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneIteratorTests
extends MultiThreadedTestCase {
    Collection<String> originalCollection;
    private Collection<String> concurrentCollection;

    public CloneIteratorTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.originalCollection = this.buildCollection();
    }

    public void testHasNext() {
        int originalSize = this.originalCollection.size();
        int i = 0;
        Iterator<String> stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            stream.next();
            this.originalCollection.add("foo");
            ++i;
        }
        CloneIteratorTests.assertTrue((originalSize != this.originalCollection.size() ? 1 : 0) != 0);
        CloneIteratorTests.assertEquals((int)originalSize, (int)i);
    }

    public void testNext() {
        Iterator<String> nestedIterator = this.originalCollection.iterator();
        Iterator<String> stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            CloneIteratorTests.assertEquals((String)"bogus element", (String)nestedIterator.next(), (String)stream.next());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildCloneIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CloneIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testRemoveDefault() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testRemoveRemover() {
        Closure<String> remover = new Closure<String>(){

            public void execute(String element) {
                CloneIteratorTests.this.originalCollection.remove(element);
            }
        };
        this.verifyRemove((Iterator<?>)IteratorTools.clone(this.originalCollection, (Closure)remover));
    }

    public void testRemoveRemover_super() {
        Closure<Object> remover = new Closure<Object>(){

            public void execute(Object element) {
                CloneIteratorTests.this.originalCollection.remove(element);
            }
        };
        this.verifyRemove((Iterator<?>)IteratorTools.clone(this.originalCollection, (Closure)remover));
    }

    public void testConcurrentAccess() throws Exception {
        SlowCollection<String> slow = new SlowCollection<String>();
        this.populateCollection(slow);
        this.originalCollection = Collections.synchronizedCollection(slow);
        this.concurrentCollection = new ArrayList<String>();
        Thread thread = this.buildThread(this.buildRunnable());
        thread.start();
        while (!slow.hasStartedClone()) {
            Thread.yield();
        }
        this.originalCollection.add("seventeen");
        thread.join();
        ArrayList<String> expected = new ArrayList<String>();
        this.populateCollection(expected);
        CloneIteratorTests.assertEquals(expected, this.concurrentCollection);
    }

    private Runnable buildRunnable() {
        return new MultiThreadedTestCase.TestRunnable(this){

            protected void run_() throws Throwable {
                CloneIteratorTests.this.loopWithCloneIterator();
            }
        };
    }

    void loopWithCloneIterator() {
        Iterator<String> stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            this.concurrentCollection.add(stream.next());
        }
    }

    private void verifyRemove(Iterator<?> iterator) {
        String removed = "three";
        CloneIteratorTests.assertTrue((boolean)this.originalCollection.contains(removed));
        boolean exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        CloneIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        while (iterator.hasNext()) {
            if (!iterator.next().equals(removed)) continue;
            iterator.remove();
            exCaught = false;
            try {
                iterator.remove();
            }
            catch (IllegalStateException illegalStateException) {
                exCaught = true;
            }
            CloneIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        }
        CloneIteratorTests.assertFalse((boolean)this.originalCollection.contains(removed));
    }

    private Iterator<String> buildCloneIterator() {
        return this.buildCloneIterator(this.originalCollection);
    }

    private Iterator<String> buildCloneIterator(Collection<String> c) {
        return IteratorTools.clone(c);
    }

    private Collection<String> buildCollection() {
        Collection<String> c = this.buildEmptyCollection();
        this.populateCollection(c);
        return c;
    }

    protected Collection<String> buildEmptyCollection() {
        return new ArrayList<String>();
    }

    private void populateCollection(Collection<String> c) {
        c.add("one");
        c.add("two");
        c.add("three");
        c.add("four");
        c.add("five");
        c.add("six");
        c.add("seven");
        c.add("eight");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SlowCollection<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean hasStartedClone = false;

        @Override
        public Object[] toArray() {
            this.setHasStartedClone(true);
            TestTools.sleep(100L);
            return super.toArray();
        }

        synchronized void setHasStartedClone(boolean hasStartedClone) {
            this.hasStartedClone = hasStartedClone;
        }

        synchronized boolean hasStartedClone() {
            return this.hasStartedClone;
        }
    }
}

