/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.jsp;

import java.util.List;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryProvider;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.validation.MockValidationReporter;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.SingleJSPTestCase;

public class BracketOperatorTestCase
extends SingleJSPTestCase {
    public BracketOperatorTestCase() {
        super("/testdata/jsps/bracketOperator.jsp.data", "/bracketOperator.jsp", JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider((ITagRegistryFactoryProvider)JSFCoreUtilHelper.createSimpleRegistryFactory());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JSFCoreUtilHelper.injectTestTagRegistryFactoryProvider(null);
    }

    public void testSanity() {
        super.testSanity();
        BracketOperatorTestCase.assertEquals((String)"bundle['x.y']", (String)ELAssert.getELText(this._structuredDocument, 816));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['integerProperty']", (String)ELAssert.getELText(this._structuredDocument, 862));
        BracketOperatorTestCase.assertEquals((String)"bundle['x']", (String)ELAssert.getELText(this._structuredDocument, 940));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties.treeMap", (String)ELAssert.getELText(this._structuredDocument, 991));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties.treeMap.foo", (String)ELAssert.getELText(this._structuredDocument, 1059));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['treeMap'].foo", (String)ELAssert.getELText(this._structuredDocument, 1125));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['treeMap']['foo']", (String)ELAssert.getELText(this._structuredDocument, 1195));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties.treeMap['foo']", (String)ELAssert.getELText(this._structuredDocument, 1267));
        BracketOperatorTestCase.assertEquals((String)"mapBean['foo']", (String)ELAssert.getELText(this._structuredDocument, 1343));
        BracketOperatorTestCase.assertEquals((String)"mapBean['foo.x']", (String)ELAssert.getELText(this._structuredDocument, 1390));
        BracketOperatorTestCase.assertEquals((String)"mapBean['getIgnoredIntProperty']", (String)ELAssert.getELText(this._structuredDocument, 1439));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['actionProperty']", (String)ELAssert.getELText(this._structuredDocument, 1508));
        BracketOperatorTestCase.assertEquals((String)"myBean.stringArrayProperty[0]", (String)ELAssert.getELText(this._structuredDocument, 1578));
        BracketOperatorTestCase.assertEquals((String)"myBean.stringArrayProperty[myBean.integerProperty]", (String)ELAssert.getELText(this._structuredDocument, 1637));
        BracketOperatorTestCase.assertEquals((String)"myBean.stringArrayProperty['0']", (String)ELAssert.getELText(this._structuredDocument, 1717));
        BracketOperatorTestCase.assertEquals((String)"myBean.intArrayProperty[1]", (String)ELAssert.getELText(this._structuredDocument, 1778));
        BracketOperatorTestCase.assertEquals((String)"myBean.intArrayProperty[1] > 0", (String)ELAssert.getELText(this._structuredDocument, 1834));
        BracketOperatorTestCase.assertEquals((String)"empty myBean.arrayOfArrayOfStringProperty", (String)ELAssert.getELText(this._structuredDocument, 1894));
        BracketOperatorTestCase.assertEquals((String)"empty myBean.arrayOfArrayOfStringProperty[1]", (String)ELAssert.getELText(this._structuredDocument, 1965));
        BracketOperatorTestCase.assertEquals((String)"myBean.arrayOfArrayOfStringProperty[0][1]", (String)ELAssert.getELText(this._structuredDocument, 2039));
        BracketOperatorTestCase.assertEquals((String)"myBean.arrayOfArrayOfStringProperty[myBean.intArrayProperty[0]][myBean.intArrayProperty[1]]", (String)ELAssert.getELText(this._structuredDocument, 2110));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.listProperty[0]", (String)ELAssert.getELText(this._structuredDocument, 2232));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.listProperty[myBean.integerProperty]", (String)ELAssert.getELText(this._structuredDocument, 2300));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.listProperty['0']", (String)ELAssert.getELText(this._structuredDocument, 2389));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.listProperty['0'].someValue", (String)ELAssert.getELText(this._structuredDocument, 2459));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty[0]", (String)ELAssert.getELText(this._structuredDocument, 2539));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty[myBean.integerProperty]", (String)ELAssert.getELText(this._structuredDocument, 2612));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty['0']", (String)ELAssert.getELText(this._structuredDocument, 2706));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty['0'].someValue", (String)ELAssert.getELText(this._structuredDocument, 2781));
        BracketOperatorTestCase.assertEquals((String)"listBean[0]", (String)ELAssert.getELText(this._structuredDocument, 2869));
        BracketOperatorTestCase.assertEquals((String)"listBean[myBean.integerProperty]", (String)ELAssert.getELText(this._structuredDocument, 2910));
        BracketOperatorTestCase.assertEquals((String)"listBean['0']", (String)ELAssert.getELText(this._structuredDocument, 2972));
        BracketOperatorTestCase.assertEquals((String)"listBean['0'].someValue", (String)ELAssert.getELText(this._structuredDocument, 3015));
        BracketOperatorTestCase.assertEquals((String)"bundle['y']", (String)ELAssert.getELText(this._structuredDocument, 3093));
        BracketOperatorTestCase.assertEquals((String)"bundle['x.z']", (String)ELAssert.getELText(this._structuredDocument, 3137));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['actionProperty.foo']", (String)ELAssert.getELText(this._structuredDocument, 3183));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['treeMap.foo']", (String)ELAssert.getELText(this._structuredDocument, 3259));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['mapProperty.foo']", (String)ELAssert.getELText(this._structuredDocument, 3328));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['mapProperty.foo.x']", (String)ELAssert.getELText(this._structuredDocument, 3401));
        BracketOperatorTestCase.assertEquals((String)"beanWithMapProperties['treeMap.foo.x']", (String)ELAssert.getELText(this._structuredDocument, 3476));
        BracketOperatorTestCase.assertEquals((String)"myBean.stringArrayProperty[myBean.stringProperty]", (String)ELAssert.getELText(this._structuredDocument, 3547));
        BracketOperatorTestCase.assertEquals((String)"myBean.stringArrayProperty[-1]", (String)ELAssert.getELText(this._structuredDocument, 3628));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.listProperty.someProperty", (String)ELAssert.getELText(this._structuredDocument, 3689));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty.someProperty", (String)ELAssert.getELText(this._structuredDocument, 3767));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty[-1]", (String)ELAssert.getELText(this._structuredDocument, 3850));
        BracketOperatorTestCase.assertEquals((String)"listBean[-1]", (String)ELAssert.getELText(this._structuredDocument, 3924));
        BracketOperatorTestCase.assertEquals((String)"bundle['y']", (String)ELAssert.getELText(this._structuredDocument, 3969));
        BracketOperatorTestCase.assertEquals((String)"bundle[null]", (String)ELAssert.getELText(this._structuredDocument, 4013));
        BracketOperatorTestCase.assertEquals((String)"listBean.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 4121));
        BracketOperatorTestCase.assertEquals((String)"listBean['stringProperty']", (String)ELAssert.getELText(this._structuredDocument, 4175));
        BracketOperatorTestCase.assertEquals((String)"myBean.stringArrayProperty['a']", (String)ELAssert.getELText(this._structuredDocument, 4256));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty['a']", (String)ELAssert.getELText(this._structuredDocument, 4317));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty[true]", (String)ELAssert.getELText(this._structuredDocument, 4392));
        BracketOperatorTestCase.assertEquals((String)"listBean['a']", (String)ELAssert.getELText(this._structuredDocument, 4468));
        BracketOperatorTestCase.assertEquals((String)"listBean[true]", (String)ELAssert.getELText(this._structuredDocument, 4511));
    }

    public void testNoErrorExprs() {
        this.assertNoError(816, "Ljava.lang.String;");
        this.assertNoError(862, "I");
        this.assertNoError(991, "Ljava.util.TreeMap;");
        this.assertNoError(1059, "Ljava.lang.Object;");
        this.assertNoError(1125, "Ljava.lang.Object;");
        this.assertNoError(1195, "Ljava.lang.Object;");
        this.assertNoError(1267, "Ljava.lang.Object;");
        this.assertNoError(1343, "Ljava.lang.Object;");
        this.assertNoError(1390, "Ljava.lang.Object;");
        this.assertNoError(1439, "Ljava.lang.Object;");
        this.assertNoError(1508, Signature.createMethodSignature((String[])new String[0], (String)"Ljava.lang.String;"));
        this.assertNoError(1578, "Ljava.lang.String;");
        this.assertNoError(1637, "Ljava.lang.String;");
        this.assertNoError(1717, "Ljava.lang.String;");
        this.assertNoError(1778, "I");
        this.assertNoError(1834, "Z");
        this.assertNoError(1894, "Z");
        this.assertNoError(1965, "Z");
        this.assertNoError(2039, "Ljava.lang.String;");
        this.assertNoError(2110, "Ljava.lang.String;");
        this.assertNoError(2232, "Ljava.lang.Object;");
        this.assertNoError(2300, "Ljava.lang.Object;");
        this.assertNoError(2389, "Ljava.lang.Object;");
        this.assertNoError(2459, "Ljava.lang.Object;");
        this.assertNoError(2539, "Ljava.lang.Object;");
        this.assertNoError(2612, "Ljava.lang.Object;");
        this.assertNoError(2706, "Ljava.lang.Object;");
        this.assertNoError(2781, "Ljava.lang.Object;");
        this.assertNoError(2869, "Ljava.lang.Object;");
        this.assertNoError(2910, "Ljava.lang.Object;");
        this.assertNoError(2972, "Ljava.lang.Object;");
        this.assertNoError(3015, "Ljava.lang.Object;");
    }

    public void testWarningExprs() {
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticWarning(3093, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3137, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3183, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3259, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3328, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3401, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3476, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3547, null, 1);
        ELAssert.assertContainsProblem(list, 17);
        list = this.assertSemanticWarning(3628, null, 1);
        ELAssert.assertContainsProblem(list, 26);
        list = this.assertSemanticWarning(3689, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3767, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(3850, null, 1);
        ELAssert.assertContainsProblem(list, 26);
        list = this.assertSemanticWarning(3924, null, 1);
        ELAssert.assertContainsProblem(list, 26);
        list = this.assertSemanticWarning(3969, null, 1);
        ELAssert.assertContainsProblem(list, 19);
        list = this.assertSemanticWarning(4013, null, 1);
        ELAssert.assertContainsProblem(list, 24);
        list = this.assertSemanticWarning(4121, null, 1);
        ELAssert.assertContainsProblem(list, 19);
    }

    public void testErrorExprs() {
        BracketOperatorTestCase.assertEquals((String)"listBean['stringProperty']", (String)ELAssert.getELText(this._structuredDocument, 4175));
        BracketOperatorTestCase.assertEquals((String)"myBean.stringArrayProperty['a']", (String)ELAssert.getELText(this._structuredDocument, 4256));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty['a']", (String)ELAssert.getELText(this._structuredDocument, 4317));
        BracketOperatorTestCase.assertEquals((String)"beanWithListProperties.arrayListProperty[true]", (String)ELAssert.getELText(this._structuredDocument, 4392));
        BracketOperatorTestCase.assertEquals((String)"listBean['a']", (String)ELAssert.getELText(this._structuredDocument, 4468));
        BracketOperatorTestCase.assertEquals((String)"listBean[true]", (String)ELAssert.getELText(this._structuredDocument, 4511));
        List<MockValidationReporter.ReportedProblem> list = this.assertSemanticError(4175, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(4256, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(4317, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(4392, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(4468, null, 1);
        ELAssert.assertContainsProblem(list, 2);
        list = this.assertSemanticError(4511, null, 1);
        ELAssert.assertContainsProblem(list, 2);
    }
}

