/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.PipedTransportService;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.RhinoRequest;
import org.eclipse.wst.jsdt.debug.rhino.tests.ConnectionHelper;
import org.eclipse.wst.jsdt.debug.rhino.tests.TestEventHandler;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;
import org.eclipse.wst.jsdt.debug.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.transport.TransportService;
import org.eclipse.wst.jsdt.debug.transport.exception.DisconnectedException;
import org.eclipse.wst.jsdt.debug.transport.exception.TimeoutException;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;
import org.eclipse.wst.jsdt.debug.transport.packet.Response;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class RequestTest
extends TestCase {
    protected RhinoDebuggerImpl debugger;
    protected DebugSession debugSession;
    protected TestEventHandler eventHandler;
    protected ContextFactory contextFactory;
    private static boolean tracing = false;

    protected void useTracing() {
        tracing = true;
    }

    protected void disableTracing() {
        tracing = false;
    }

    public static boolean isTracing() {
        return tracing;
    }

    protected void evalScript(String script) {
        ScriptableObject scope = null;
        Context context = this.contextFactory.enterContext();
        try {
            scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, script, "script", 0, null);
        }
        finally {
            Context.exit();
        }
    }

    protected void evalScript(String script, int eventcount) {
        this.evalScript(script);
        this.waitForEvents(eventcount);
    }

    protected void evalScript(String script, EventPacket[] events) {
        this.evalScript(script);
        this.waitForEvents(events);
    }

    protected void setUp() throws Exception {
        PipedTransportService pipedTransport = new PipedTransportService();
        ConnectionHelper helper = new ConnectionHelper((TransportService)pipedTransport, null);
        this.debugger = new RhinoDebuggerImpl((TransportService)pipedTransport, null, false, false);
        this.debugger.start();
        this.debugSession = new DebugSession(helper.getClientConnection());
        this.eventHandler = new TestEventHandler(this.debugSession, this.getName());
        this.eventHandler.start();
        RequestTest.assertTrue((boolean)this.suspendForRuntime(this.debugger, 100L));
        this.contextFactory = new ContextFactory();
        this.contextFactory.addListener((ContextFactory.Listener)this.debugger);
        super.setUp();
    }

    public synchronized boolean suspendForRuntime(RhinoDebuggerImpl debug, long timeout) {
        while (!debug.isConnected()) {
            try {
                ((Object)((Object)this)).wait(timeout);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return debug.isConnected();
    }

    protected void tearDown() throws Exception {
        this.disableTracing();
        super.tearDown();
        this.contextFactory.removeListener((ContextFactory.Listener)this.debugger);
        this.eventHandler.stop();
        this.debugger.stop();
        this.debugSession.dispose();
    }

    synchronized void waitForEvents(int count) {
        this.eventHandler.waitForEvents(count);
    }

    synchronized void setExpectedEvents(EventPacket[] events) {
        this.eventHandler.setExpectedEvents(events);
    }

    synchronized void waitForEvents(EventPacket[] events) {
        this.eventHandler.waitForEvents(events);
    }

    protected Map findVar(List props, String varname) {
        if (props != null && varname != null) {
            Map prop2 = null;
            for (Map prop2 : props) {
                if (!varname.equals(prop2.get("name"))) continue;
                return prop2;
            }
        }
        return null;
    }

    protected Response doLookup(DebugSession session, Number threadid, Number contextid, Number frameid, Number refid) throws Exception {
        RhinoRequest request = new RhinoRequest("lookup");
        request.getArguments().put("threadId", threadid);
        request.getArguments().put("contextId", contextid);
        request.getArguments().put("frameId", frameid);
        request.getArguments().put("ref", refid);
        this.debugSession.send((Packet)request);
        return this.debugSession.receiveResponse(request.getSequence(), 30000);
    }

    final class ClearBreakpointsHandler
    extends SubHandler {
        public ClearBreakpointsHandler() {
            super(RequestTest.this.getName());
        }

        @Override
        public boolean handleEvent(DebugSession debugSession, EventPacket event) {
            if (event.getEvent().equals("break")) {
                Number bid = (Number)event.getBody().get("breakpoint");
                if (bid == null && "out".equals(event.getBody().get("step"))) {
                    return false;
                }
                RhinoRequest request = new RhinoRequest("clearbreakpoint");
                request.getArguments().put("breakpointId", bid);
                try {
                    debugSession.send((Packet)request);
                    Response response = debugSession.receiveResponse(request.getSequence(), 30000);
                    RequestTest.assertTrue((String)(String.valueOf(this.testName()) + ": the request to clear breakpoint [" + bid + "] should have succeeded"), (boolean)response.isSuccess());
                    return true;
                }
                catch (DisconnectedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    final class FrameCheckHandler
    extends SubHandler {
        public FrameCheckHandler() {
            super(RequestTest.this.getName());
        }

        @Override
        public boolean handleEvent(DebugSession debugSession, EventPacket event) {
            if (event.getEvent().equals("break")) {
                Number threadId = (Number)event.getBody().get("threadId");
                Number contextId = (Number)event.getBody().get("contextId");
                RhinoRequest request = new RhinoRequest("frames");
                request.getArguments().put("threadId", threadId);
                try {
                    debugSession.send((Packet)request);
                    Response response = debugSession.receiveResponse(request.getSequence(), 30000);
                    RequestTest.assertTrue((String)(String.valueOf(this.testName()) + ": the request for frames from thread [" + threadId.intValue() + "] was not successful"), (boolean)response.isSuccess());
                    Collection frames = (Collection)response.getBody().get("frames");
                    for (Number frameId : frames) {
                        request = new RhinoRequest("frame");
                        request.getArguments().put("threadId", threadId);
                        request.getArguments().put("contextId", contextId);
                        request.getArguments().put("frameId", frameId);
                        debugSession.send((Packet)request);
                        response = debugSession.receiveResponse(request.getSequence(), 30000);
                        RequestTest.assertTrue((String)(String.valueOf(this.testName()) + ": the request for frame [" + frameId.intValue() + "] frmo thread [" + threadId.intValue() + "] was not successful"), (boolean)response.isSuccess());
                    }
                }
                catch (DisconnectedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }
    }

    final class SetBreakpointHandler
    extends SubHandler {
        int[] adds;

        public SetBreakpointHandler(int[] lines) {
            super(RequestTest.this.getName());
            this.adds = null;
            RequestTest.assertNotNull((String)(String.valueOf(this.testName()) + ": no line numbers have been specified to set breakpoints on"), (Object)lines);
            RequestTest.assertTrue((String)(String.valueOf(this.testName()) + ": no line numbers have been specified to set breakpoints on"), (lines.length > 0 ? 1 : 0) != 0);
            this.adds = lines;
        }

        @Override
        public boolean handleEvent(DebugSession debugSession, EventPacket event) {
            if (event.getEvent().equals("script")) {
                Number scriptId = (Number)event.getBody().get("scriptId");
                RhinoRequest request = new RhinoRequest("script");
                request.getArguments().put("scriptId", scriptId);
                try {
                    debugSession.send((Packet)request);
                    Response response = debugSession.receiveResponse(request.getSequence(), 30000);
                    RequestTest.assertTrue((boolean)response.isSuccess());
                    Map script = (Map)response.getBody().get("script");
                    RequestTest.assertNotNull((String)(String.valueOf(this.testName()) + ": the response body cannot be null"), (Object)script);
                    int i = 0;
                    while (i < this.adds.length) {
                        request = new RhinoRequest("setbreakpoint");
                        request.getArguments().put("scriptId", scriptId);
                        request.getArguments().put("line", new Integer(this.adds[i]));
                        debugSession.send((Packet)request);
                        response = debugSession.receiveResponse(request.getSequence(), 30000);
                        RequestTest.assertTrue((String)(String.valueOf(this.testName()) + ": the request to set a breakpoint on line [" + this.adds[i] + "] was not successful"), (boolean)response.isSuccess());
                        ++i;
                    }
                }
                catch (DisconnectedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }
    }

    final class SetBreakpointsHandler
    extends SubHandler {
        public SetBreakpointsHandler() {
            super(RequestTest.this.getName());
        }

        @Override
        public boolean handleEvent(DebugSession debugSession, EventPacket event) {
            if (event.getEvent().equals("script")) {
                Number scriptId = (Number)event.getBody().get("scriptId");
                RhinoRequest request = new RhinoRequest("script");
                request.getArguments().put("scriptId", scriptId);
                try {
                    debugSession.send((Packet)request);
                    Response response = debugSession.receiveResponse(request.getSequence(), 30000);
                    RequestTest.assertTrue((boolean)response.isSuccess());
                    Map result = (Map)response.getBody().get("script");
                    List lineNumbers = (List)result.get("lines");
                    for (Number lineNumber : lineNumbers) {
                        request = new RhinoRequest("setbreakpoint");
                        request.getArguments().put("scriptId", scriptId);
                        request.getArguments().put("line", lineNumber);
                        request.getArguments().put("condition", "1===1");
                        debugSession.send((Packet)request);
                        response = debugSession.receiveResponse(request.getSequence(), 30000);
                        RequestTest.assertTrue((String)(String.valueOf(this.testName()) + ": the request to set a breakpoint on line [" + lineNumber + "] was not successful"), (boolean)response.isSuccess());
                        Map breakpoint = (Map)response.getBody().get("breakpoint");
                        Number breakpointId = (Number)breakpoint.get("breakpointId");
                        request = new RhinoRequest("breakpoint");
                        request.getArguments().put("breakpointId", breakpointId);
                        debugSession.send((Packet)request);
                        response = debugSession.receiveResponse(request.getSequence(), 30000);
                        RequestTest.assertTrue((boolean)response.isSuccess());
                        breakpoint = (Map)response.getBody().get("breakpoint");
                        RequestTest.assertEquals((int)breakpointId.intValue(), (int)Util.numberAsInt(breakpoint.get("breakpointId")));
                        RequestTest.assertEquals((int)scriptId.intValue(), (int)Util.numberAsInt(breakpoint.get("scriptId")));
                        RequestTest.assertEquals((int)lineNumber.intValue(), (int)Util.numberAsInt(breakpoint.get("line")));
                        RequestTest.assertEquals((Object)"1===1", breakpoint.get("condition"));
                    }
                }
                catch (DisconnectedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }
    }

    abstract class SubHandler
    implements TestEventHandler.Subhandler {
        private String testname = null;

        public SubHandler(String testname) {
            RequestTest.assertNotNull((String)"The test name cannot be null", (Object)testname);
            this.testname = testname;
        }

        @Override
        public String testName() {
            return this.testname;
        }
    }

    final class ThreadCheckHandler
    extends SubHandler {
        public ThreadCheckHandler() {
            super(RequestTest.this.getName());
        }

        @Override
        public boolean handleEvent(DebugSession debugSession, EventPacket event) {
            if (event.getEvent().equals("break")) {
                Number threadId = (Number)event.getBody().get("threadId");
                RhinoRequest request = new RhinoRequest("threads");
                try {
                    debugSession.send((Packet)request);
                    Response response = debugSession.receiveResponse(request.getSequence(), 10000);
                    RequestTest.assertTrue((boolean)response.isSuccess());
                    List threads = (List)response.getBody().get("threads");
                    RequestTest.assertTrue((String)(String.valueOf(this.testName()) + ": the listing of threads must not be empty"), (threads.size() > 0 ? 1 : 0) != 0);
                    RequestTest.assertEquals((String)(String.valueOf(this.testName()) + ": the thread ids do not match"), (int)threadId.intValue(), (int)Util.numberAsInt(threads.get(0)));
                }
                catch (DisconnectedException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }
    }
}

