/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaScriptRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.UseSupertypeDescriptor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ISourceConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public final class UseSuperTypeProcessor
extends SuperTypeRefactoringProcessor {
    private static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.useSuperTypeProcessor";
    private TextEditBasedChangeManager fChangeManager = null;
    private int fChanges = 0;
    private IType fSubType;
    private IType fSuperType = null;

    protected static ITypeBinding findTypeInHierarchy(ITypeBinding type, String name) {
        ITypeBinding result;
        if (type.isArray() || type.isPrimitive()) {
            return null;
        }
        if (name.equals(type.getTypeDeclaration().getQualifiedName())) {
            return type;
        }
        ITypeBinding binding = type.getSuperclass();
        if (binding != null && (result = UseSuperTypeProcessor.findTypeInHierarchy(binding, name)) != null) {
            return result;
        }
        return null;
    }

    public UseSuperTypeProcessor(IType subType) {
        super(null);
        this.fReplace = true;
        this.fSubType = subType;
    }

    public UseSuperTypeProcessor(IType subType, IType superType) {
        super(null);
        this.fReplace = true;
        this.fSubType = subType;
        this.fSuperType = superType;
    }

    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)context);
        RefactoringStatus status = new RefactoringStatus();
        this.fChangeManager = new TextEditBasedChangeManager();
        try {
            RefactoringStatus validation;
            monitor.beginTask("", 200);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_checking);
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 200), status);
            if (!status.hasFatalError() && !(validation = Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getRefactoring().getValidationContext())).isOK()) {
                RefactoringStatus refactoringStatus = validation;
                return refactoringStatus;
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_checking);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        try {
            this.fChanges = 0;
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            TextEditBasedChange[] changes = this.fChangeManager.getAllChanges();
            if (changes != null && changes.length != 0) {
                this.fChanges = changes.length;
                IJavaScriptProject project = null;
                if (!this.fSubType.isBinary()) {
                    project = this.fSubType.getJavaScriptProject();
                }
                int flags = 589830;
                try {
                    if (this.fSubType.isLocal() || this.fSubType.isAnonymous()) {
                        flags |= 0x40000;
                    }
                }
                catch (JavaScriptModelException exception) {
                    JavaScriptPlugin.log(exception);
                }
                String name = project != null ? project.getElementName() : null;
                String description = Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_descriptor_description_short, this.fSuperType.getElementName());
                String header = Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fSuperType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED), JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fSubType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)});
                JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(name, this, header);
                comment.addSetting(Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_refactored_element_pattern, JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fSuperType, JavaScriptElementLabels.ALL_FULLY_QUALIFIED)));
                this.addSuperTypeSettings(comment, false);
                UseSupertypeDescriptor descriptor = new UseSupertypeDescriptor();
                descriptor.setProject(name);
                descriptor.setDescription(description);
                descriptor.setComment(comment.asString());
                descriptor.setFlags(flags);
                descriptor.setSubtype(this.getSubType());
                descriptor.setSupertype(this.getSuperType());
                descriptor.setReplaceInstanceof(this.fInstanceOf);
                DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaScriptRefactoringDescriptor)descriptor, RefactoringCoreMessages.UseSupertypeWherePossibleRefactoring_name, (Change[])this.fChangeManager.getAllChanges());
                return dynamicValidationRefactoringChange;
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return null;
    }

    protected final TextEditBasedChangeManager createChangeManager(final IProgressMonitor monitor, final RefactoringStatus status) throws JavaScriptModelException, CoreException {
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_creating);
            final TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            IJavaScriptProject project = this.fSubType.getJavaScriptProject();
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setWorkingCopyOwner(this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaScriptElement)project));
            if (this.fSubType.isBinary() || this.fSubType.isReadOnly()) {
                IBinding[] bindings = parser.createBindings(new IJavaScriptElement[]{this.fSubType, this.fSuperType}, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                if (bindings != null && bindings.length == 2 && bindings[0] instanceof ITypeBinding && bindings[1] instanceof ITypeBinding) {
                    this.solveSuperTypeConstraints(null, null, this.fSubType, (ITypeBinding)bindings[0], (ITypeBinding)bindings[1], (IProgressMonitor)new SubProgressMonitor(monitor, 100), status);
                    if (!status.hasFatalError()) {
                        this.rewriteTypeOccurrences(manager, null, null, null, null, new HashSet(), status, (IProgressMonitor)new SubProgressMonitor(monitor, 150));
                    }
                }
            } else {
                parser.createASTs(new IJavaScriptUnit[]{this.fSubType.getJavaScriptUnit()}, new String[0], new ASTRequestor(){

                    public final void acceptAST(IJavaScriptUnit unit, JavaScriptUnit node) {
                        try {
                            ITypeBinding superBinding;
                            ITypeBinding subBinding;
                            CompilationUnitRewrite subRewrite = new CompilationUnitRewrite(UseSuperTypeProcessor.this.fOwner, unit, node);
                            AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(UseSuperTypeProcessor.this.fSubType, subRewrite.getRoot());
                            if (subDeclaration != null && (subBinding = subDeclaration.resolveBinding()) != null && (superBinding = UseSuperTypeProcessor.findTypeInHierarchy(subBinding, UseSuperTypeProcessor.this.fSuperType.getFullyQualifiedName('.'))) != null) {
                                UseSuperTypeProcessor.this.solveSuperTypeConstraints(subRewrite.getCu(), subRewrite.getRoot(), UseSuperTypeProcessor.this.fSubType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 100), status);
                                if (!status.hasFatalError()) {
                                    UseSuperTypeProcessor.this.rewriteTypeOccurrences(manager, this, subRewrite, subRewrite.getCu(), subRewrite.getRoot(), new HashSet(), status, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                                    CompilationUnitChange change = subRewrite.createChange();
                                    if (change != null) {
                                        manager.manage(subRewrite.getCu(), (TextEditBasedChange)change);
                                    }
                                }
                            }
                        }
                        catch (CoreException exception) {
                            JavaScriptPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.UseSuperTypeProcessor_internal_error));
                        }
                    }

                    public final void acceptBinding(String key, IBinding binding) {
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            TextEditBasedChangeManager textEditBasedChangeManager = manager;
            return textEditBasedChangeManager;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected final SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new SuperTypeConstraintsSolver(model);
    }

    public final int getChanges() {
        return this.fChanges;
    }

    public final Object[] getElements() {
        return new Object[]{this.fSubType};
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final String getProcessorName() {
        return RefactoringCoreMessages.UseSuperTypeProcessor_name;
    }

    public final IType getSubType() {
        return this.fSubType;
    }

    public final IType getSuperType() {
        return this.fSuperType;
    }

    @Override
    public final RefactoringStatus initialize(RefactoringArguments arguments) {
        String instance;
        if (arguments instanceof JavaRefactoringArguments) {
            IJavaScriptElement element;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.use.supertype");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fSubType = (IType)element;
            handle = extended.getAttribute("element1");
            if (handle != null) {
                element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(element, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.use.supertype");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "element1"));
            }
            this.fSuperType = (IType)element;
            instance = extended.getAttribute("instanceof");
            if (instance == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fInstanceOf = Boolean.valueOf(instance);
        return new RefactoringStatus();
    }

    public final boolean isApplicable() throws CoreException {
        return Checks.isAvailable((IJavaScriptElement)this.fSubType) && Checks.isAvailable((IJavaScriptElement)this.fSuperType) && !this.fSubType.isAnonymous() && !this.fSuperType.isAnonymous();
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    @Override
    protected final void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, IJavaScriptUnit unit, JavaScriptUnit node, Set replacements, IProgressMonitor monitor) throws CoreException {
        block9: {
            try {
                monitor.beginTask("", 100);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                Collection collection = (Collection)this.fTypeOccurrences.get(unit);
                if (collection == null || collection.isEmpty()) break block9;
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                try {
                    CompilationUnitChange change;
                    subMonitor.beginTask("", collection.size() * 10);
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                    TType estimate = null;
                    ISourceConstraintVariable variable2 = null;
                    CompilationUnitRewrite currentRewrite = null;
                    IJavaScriptUnit sourceUnit = rewrite.getCu();
                    currentRewrite = sourceUnit.equals(unit) ? rewrite : new CompilationUnitRewrite(this.fOwner, unit, node);
                    for (ISourceConstraintVariable variable2 : collection) {
                        ASTNode result;
                        estimate = (TType)variable2.getData("te");
                        if (estimate != null && variable2 instanceof ITypeConstraintVariable && (result = NodeFinder.perform((ASTNode)node, ((ITypeConstraintVariable)variable2).getRange().getSourceRange())) != null) {
                            this.rewriteTypeOccurrence(estimate, currentRewrite, result, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                        }
                        subMonitor.worked(10);
                    }
                    if (!sourceUnit.equals(unit) && (change = currentRewrite.createChange()) != null) {
                        manager.manage(unit, (TextEditBasedChange)change);
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public final void setSuperType(IType type) {
        Assert.isNotNull((Object)type);
        this.fSuperType = type;
    }
}

