/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class DoublyNestedFunctionTests_Edited
extends TestCase {
    private static final String TEST_NAME = "Test Doubly Nested Functions JavaScript Content Assist after Edit";
    private static TestProjectSetup fTestProjectSetup;

    public DoublyNestedFunctionTests_Edited() {
        super(TEST_NAME);
    }

    public DoublyNestedFunctionTests_Edited(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(DoublyNestedFunctionTests_Edited.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false){

            @Override
            public void additionalSetUp() throws Exception {
                DoublyNestedFunctionTests_Edited.editFile_test13_0();
            }
        };
        return fTestProjectSetup;
    }

    public static void editFile_test13_0() throws Exception {
        fTestProjectSetup.editFile("test13_0.js", 8, 11, 6, "edited");
        fTestProjectSetup.editFile("test13_0.js", 0, 9, 9, "editedFunc");
    }

    public void testFindInnerFunctions2_ThisFile_AfterEdit_Expression2() throws Exception {
        String[][] expectedProposals = new String[][]{{"editedFunc() - Global", "editedInnerFunc()", "innerFunc()"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 7, 0, expectedProposals);
    }

    public void testMustFail_InnerFunctions2_ThisFile_AfterEdit_Expression1() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"editedInnerFunc()", "localInnerFunc", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_0.js", 2, 0, unexpectedProposals, true, false);
    }

    public void testFindInnerFunctions2_OtherFile_AfterEdit_ExpressionNotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"editedFunc() - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 0, 0, expectedProposals);
    }

    public void testMustFail_FindInnerFunctions2_OtherFile_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] unexpectedProposals = new String[][]{{"innerFunc()", "editedInnerFunc()", "localInnerFunc : Function", "localInnerFunc(param1)"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "test13_1.js", 4, 1, unexpectedProposals, true, false);
    }
}

