/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.impl.AbstractDirectEditingFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IBidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class DirectEditAttributeFeature
extends AbstractDirectEditingFeature {
    private boolean isMethodAnnotated = false;

    public DirectEditAttributeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public int getEditingType() {
        return 1;
    }

    public boolean canDirectEdit(IDirectEditingContext context) {
        return true;
    }

    public String getInitialValue(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        PersistentAttribute jpa = (PersistentAttribute)this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        this.isMethodAnnotated = JpaArtifactFactory.instance().isMethodAnnotated(jpa);
        Text txt = (Text)pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        String value = txt.getValue();
        if (this.isMethodAnnotated) {
            value = JPAEditorUtil.produceValidAttributeName(value);
        }
        return value;
    }

    public String checkValueValid(String value, IDirectEditingContext context) {
        IStatus status;
        if (this.isMethodAnnotated) {
            value = JPAEditorUtil.produceValidAttributeName(value);
        }
        if (!(status = JavaConventions.validateFieldName((String)value, (String)"1.5", (String)"1.5")).isOK()) {
            return status.getMessage();
        }
        status = this.checkDuplicateAttribute(value, context);
        if (!status.isOK()) {
            return status.getMessage();
        }
        return null;
    }

    private IStatus checkDuplicateAttribute(String value, IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        PersistentAttribute oldAt = (PersistentAttribute)this.getBusinessObjectForPictogramElement(pe);
        PersistentAttribute newAl = ((PersistentType)oldAt.getParent()).getAttributeNamed(value);
        if (newAl != null && !newAl.equals(oldAt)) {
            String message = MessageFormat.format(JPAEditorMessages.DirectEditAttributeFeature_attributeExists, value);
            return new Status(4, "org.eclipse.jpt.jpadiagrameditor.ui", message);
        }
        return Status.OK_STATUS;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void setValue(String value, IDirectEditingContext context) {
        if (this.isMethodAnnotated) {
            value = JPAEditorUtil.produceValidAttributeName(value);
        }
        PictogramElement pe = context.getPictogramElement();
        PersistentAttribute oldAt = (PersistentAttribute)this.getBusinessObjectForPictogramElement(pe);
        Set<IRelation> rels = this.getFeatureProvider().getRelationRelatedToAttribute(oldAt, JpaArtifactFactory.instance().getRelTypeName(oldAt));
        if (!rels.isEmpty()) {
            for (IRelation rel : rels) {
                String inverseJPTName = null;
                if (IBidirectionalRelation.class.isInstance(rel)) {
                    inverseJPTName = rel.getInverse().getName();
                }
                if (oldAt.getName().equals(value)) {
                    return;
                }
                try {
                    JpaArtifactFactory.instance().renameAttribute((PersistentType)oldAt.getParent(), oldAt.getName(), value, inverseJPTName, this.getFeatureProvider());
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        } else {
            try {
                JpaArtifactFactory.instance().renameAttribute((PersistentType)oldAt.getParent(), oldAt.getName(), value, null, this.getFeatureProvider());
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (pe.getGraphicsAlgorithm() == null) {
            return;
        }
        final GraphicsAlgorithm alg = (GraphicsAlgorithm)pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
        final String newValue = value;
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)alg);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                ((Text)alg).setValue(newValue);
            }
        });
    }
}

