/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.IncludeEntry;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Messages;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Refactoring;

public abstract class RhinoChange
extends Change {
    protected String oldname = null;
    protected String newname = null;
    protected ILaunchConfiguration configuration = null;

    public RhinoChange(ILaunchConfiguration configuration, String oldname, String newname) {
        this.configuration = configuration;
        this.oldname = oldname;
        this.newname = newname;
    }

    public String getName() {
        return NLS.bind((String)Messages.update_attributes, (Object[])new String[]{this.configuration.getName(), this.newname});
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.configuration.exists()) {
            return RefactoringStatus.createErrorStatus((String)NLS.bind((String)Messages.config_no_longer_exists, (Object)this.configuration.getName()));
        }
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.configuration;
    }

    protected String computeNewContainerName(ILaunchConfiguration configuration) {
        IFile file = configuration.getFile();
        if (file != null) {
            return file.getParent().getProjectRelativePath().toString();
        }
        return null;
    }

    protected String computeNewConfigurationName(ILaunchConfiguration configuration) {
        Path old;
        String nametofind;
        String name = configuration.getName();
        int idx = name.indexOf(nametofind = (old = new Path(this.oldname)).segmentCount() > 1 ? old.lastSegment() : this.oldname);
        if (idx > -1) {
            Path neww = new Path(this.newname);
            String replacement = neww.segmentCount() > 1 ? neww.lastSegment() : this.newname;
            return name.replaceAll(nametofind, replacement);
        }
        return null;
    }

    protected String computeNewScriptName(ILaunchConfiguration configuration) {
        try {
            String attr = configuration.getAttribute("script", "");
            return this.computeNewName(attr);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void updateIncludeEntries(ILaunchConfigurationWorkingCopy copy) throws CoreException {
        List includes = copy.getAttribute("includepath", null);
        if (includes != null) {
            IncludeEntry[] entries = Refactoring.findIncludeEntries(includes, this.oldname);
            String sname = null;
            int i = 0;
            while (i < entries.length) {
                int idx;
                sname = this.computeNewName(entries[i].getPath());
                if (sname != null && !this.oldname.equals(sname) && (idx = includes.indexOf(entries[i].string())) > -1) {
                    includes.remove(idx);
                    includes.add(idx, new IncludeEntry(entries[i].getKind(), sname).string());
                }
                ++i;
            }
            copy.setAttribute("includepath", includes);
        }
    }

    protected String computeNewName(String name) {
        Path old = new Path(this.oldname);
        Path path = new Path(name);
        if (old.isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(old.segmentCount());
            path = new Path(this.newname).append((IPath)path);
            return path.makeAbsolute().toString();
        }
        return path.toString().replaceAll(this.oldname, this.newname);
    }
}

