/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.ExtensionUtility;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUpdateSite {
    private static final List<String> EMPTY_LIST = new ArrayList<String>(0);
    public static final String SERVER_ADAPTER_ID = "org.eclipse.wst.server.core.serverAdapter";
    private String url;
    private String featureId;
    private List<String> categories;

    public ExtensionUpdateSite() {
    }

    public ExtensionUpdateSite(String url, String featureId, List<String> categories) {
        this.url = url;
        this.featureId = featureId;
        this.categories = categories;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public List<String> getCategories() {
        if (this.categories == null) {
            return EMPTY_LIST;
        }
        return this.categories;
    }

    public List<Extension> getExtensions(IProgressMonitor monitor) throws CoreException {
        try {
            IMetadataRepository repo;
            IMetadataRepositoryManager manager;
            IQuery query;
            BundleContext bd = Activator.getDefault().getBundle().getBundleContext();
            IProvisioningAgent agent = ExtensionUtility.getAgent(bd);
            URI url2 = new URI(this.url);
            UpdateSiteMetadataRepositoryFactory mrf = new UpdateSiteMetadataRepositoryFactory();
            mrf.setAgent(ExtensionUtility.getAgent(bd));
            List<Extension> list = new ArrayList<Extension>();
            try {
                IMetadataRepository repo2 = mrf.load(url2, 0, monitor);
                query = QueryUtil.createMatchQuery((String)"id ~=/*org.eclipse.wst.server.core.serverAdapter/", (Object[])new Object[0]);
                list = this.getInstallableUnits(repo2, (IQuery<IInstallableUnit>)query, url2, monitor);
            }
            catch (ProvisionException pe) {
                Trace.trace((byte)2, "Error getting update site information", pe);
            }
            if (list.isEmpty()) {
                manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                manager.addRepository(url2);
                query = QueryUtil.createIUAnyQuery();
                repo = manager.loadRepository(url2, monitor);
                List<Extension> list2 = this.getInstallableUnits(repo, (IQuery<IInstallableUnit>)query, url2, monitor);
                int size = list2.size();
                int i = 0;
                while (i < size) {
                    Extension e = list2.get(i);
                    IInstallableUnit[] iuArr = e.getIUs();
                    if (iuArr != null && iuArr.length > 0 && iuArr[0] != null && iuArr[0].getProperty(SERVER_ADAPTER_ID) != null) {
                        list.add(e);
                    }
                    ++i;
                }
            }
            if (list.isEmpty()) {
                manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                manager.addRepository(url2);
                query = QueryUtil.createMatchQuery((String)"id ~=/*org.eclipse.wst.server.core.serverAdapter/", (Object[])new Object[0]);
                repo = manager.loadRepository(url2, monitor);
                list = this.getInstallableUnits(repo, (IQuery<IInstallableUnit>)query, url2, monitor);
            }
            return list;
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting update info", e);
            return new ArrayList<Extension>(0);
        }
    }

    protected List<Extension> getInstallableUnits(IMetadataRepository repo, IQuery<IInstallableUnit> query, URI url, IProgressMonitor monitor) {
        ArrayList<Extension> list = new ArrayList<Extension>();
        IQueryResult collector = repo.query(query, monitor);
        for (IInstallableUnit iu : collector.toUnmodifiableSet()) {
            Collection req = iu.getRequirements();
            if (req == null) continue;
            for (IRequirement requirement : req) {
                IMatchExpression matches = requirement.getMatches();
                query = new ExpressionMatchQuery(IInstallableUnit.class, (IExpression)matches, new Object[0]);
                IQueryResult collector2 = repo.query((IQuery)query, monitor);
                for (IInstallableUnit iu2 : collector2) {
                    if (list.contains(iu2)) continue;
                    Extension ext = new Extension(iu2, url);
                    list.add(ext);
                }
            }
        }
        return list;
    }
}

