/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;

public class TypeTests
extends TestCase {
    private static final String TEST_NAME = "Test JavaScript Type Content Assist";
    private static TestProjectSetup fTestProjectSetup;

    public TypeTests() {
        super(TEST_NAME);
    }

    public TypeTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(TypeTests.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "ContentAssist", "root", false);
        return fTestProjectSetup;
    }

    public void testCamelCase_OtherFile_BeforeOpen_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 0, 2, expectedProposals);
    }

    public void testCamelCase_OtherFile_BeforeOpen_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.CeleronXSeries - Computer.proc", "Installed.CorelXSoftware - Installed"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 2, 2, expectedProposals);
    }

    public void testCamelCase_OtherFile_BeforeOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 4, 3, expectedProposals);
    }

    public void testClassProperties_OtherFile_BeforeOpen_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 6, 4, expectedProposals);
    }

    public void testClassProperties_OtherFile_BeforeOpen_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"Installed : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 8, 3, expectedProposals);
    }

    public void testTypes_OtherFile_BeforeOpen_ExpressionStarted_NegativeTest() throws Exception {
        String[][] proposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc", "Computer.proc.IntelQuadCore - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 10, 10, proposals, true, false);
    }

    public void testCamelCase_ThisFile_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1", "Computer.proc.IntelDualCore2"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_0.js", 27, 2, expectedProposals);
    }

    public void testCamelCase_ThisFile_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.CeleronXSeries", "Installed.CorelXSoftware"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_0.js", 29, 2, expectedProposals);
    }

    public void testCamelCase_ThisFile_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1", "Computer.proc.IntelDualCore2"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_0.js", 31, 3, expectedProposals);
    }

    public void testClassProperties_ThisFile_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer : {} - Global", "Computer.proc.IntelDualCore1", "Computer.proc.IntelDualCore2", "Computer.proc.CeleronXSeries"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_0.js", 33, 4, expectedProposals);
    }

    public void testClassProperties_ThisFile_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"Installed.CorelXSoftware", "Installed : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_0.js", 35, 3, expectedProposals);
    }

    public void testCamelCase_OtherFile_AfterOpen_ExpressionStarted_0() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 0, 2, expectedProposals);
    }

    public void testCamelCase_OtherFile_AfterOpen_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.CeleronXSeries - Computer.proc", "Installed.CorelXSoftware - Installed"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 2, 2, expectedProposals);
    }

    public void testCamelCase_OtherFile_AfterOpen_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 4, 3, expectedProposals);
    }

    public void testClassProperties_OtherFile_AfterOpen_ExpressionStarted_3() throws Exception {
        String[][] expectedProposals = new String[][]{{"Computer : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 6, 4, expectedProposals);
    }

    public void testClassProperties_OtherFile_AfterOpen_ExpressionStarted_4() throws Exception {
        String[][] expectedProposals = new String[][]{{"Installed : {} - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 8, 3, expectedProposals);
    }

    public void testTypes_OtherFile_AfterOpen_ExpressionStarted_NegativeTest() throws Exception {
        String[][] proposals = new String[][]{{"Computer.proc.IntelDualCore1 - Computer.proc", "Computer.proc.IntelDualCore2 - Computer.proc", "Computer.proc.IntelQuadCore - Computer.proc"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "TestJSClasses_1.js", 10, 10, proposals, true, false);
    }
}

