/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class EnumComboViewer<T extends Model, V>
extends Pane<T> {
    private ComboViewer comboViewer;
    public static final String NULL_VALUE = "null";

    EnumComboViewer(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    EnumComboViewer(Pane<? extends T> parentPane, Composite parent, PropertyValueModel<Boolean> enabledModel) {
        super(parentPane, parent, enabledModel);
    }

    EnumComboViewer(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    EnumComboViewer(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent) {
        super(parentPane, subjectHolder, enabledModel, parent);
    }

    @Override
    protected boolean addsComposite() {
        return false;
    }

    public Combo getControl() {
        return this.comboViewer.getCombo();
    }

    @Override
    protected final void initializeLayout(Composite container) {
        this.comboViewer = this.addComboViewer(container);
        this.comboViewer.addSelectionChangedListener(this.buildSelectionChangedListener());
    }

    private Object[] buildChoices() {
        V[] choices = this.getChoices();
        if (this.sortChoices()) {
            Arrays.sort(choices, this.buildComparator());
        }
        Object[] extendedChoices = new Object[choices.length + 1];
        System.arraycopy(choices, 0, extendedChoices, 1, choices.length);
        extendedChoices[0] = NULL_VALUE;
        return extendedChoices;
    }

    protected boolean sortChoices() {
        return true;
    }

    protected ComboViewer addComboViewer(Composite container) {
        return this.addComboViewer(container, (IBaseLabelProvider)this.buildLabelProvider(), this.getHelpId());
    }

    private Comparator<Object> buildComparator() {
        return new Comparator<Object>(){
            final LabelProvider labelProvider;
            {
                this.labelProvider = EnumComboViewer.this.buildLabelProvider();
            }

            @Override
            public int compare(Object value1, Object value2) {
                String displayString1 = this.labelProvider.getText(value1);
                String displayString2 = this.labelProvider.getText(value2);
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private String buildDisplayString(Object value) {
        if (value == NULL_VALUE) {
            V defaultValue;
            V v = defaultValue = this.getSubject() != null ? (V)this.getDefaultValue() : null;
            if (defaultValue != null) {
                String displayString = this.displayString(defaultValue);
                return NLS.bind((String)JptCommonUiMessages.ENUM_COMBO_VIEWER__DEFAULT_WITH_DEFAULT, (Object)displayString);
            }
            return this.nullDisplayString();
        }
        return this.displayString(value);
    }

    final LabelProvider buildLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return EnumComboViewer.this.buildDisplayString(element);
            }
        };
    }

    private ISelection buildSelection() {
        String value;
        String string = value = this.getSubject() != null ? (String)this.getValue() : null;
        if (value == null) {
            value = NULL_VALUE;
        }
        return new StructuredSelection((Object)value);
    }

    private ISelectionChangedListener buildSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (!EnumComboViewer.this.isPopulating()) {
                    StructuredSelection selection = (StructuredSelection)e.getSelection();
                    EnumComboViewer.this.valueChanged(selection.getFirstElement());
                }
            }
        };
    }

    protected abstract V[] getChoices();

    protected abstract V getDefaultValue();

    protected abstract String displayString(V var1);

    protected String getHelpId() {
        return null;
    }

    protected String nullDisplayString() {
        return null;
    }

    @Override
    protected void doPopulate() {
        super.doPopulate();
        this.populateCombo();
    }

    final ComboViewer getComboViewer() {
        return this.comboViewer;
    }

    protected abstract V getValue();

    private void populateCombo() {
        this.removeAll();
        this.comboViewer.add(this.buildChoices());
        this.updateSelection();
    }

    @Override
    protected void propertyChanged(String propertyName) {
        super.propertyChanged(propertyName);
        this.populateCombo();
    }

    abstract void removeAll();

    protected abstract void setValue(V var1);

    abstract void updateCursor();

    private void updateSelection() {
        this.comboViewer.setSelection(this.buildSelection());
        this.updateCursor();
    }

    private void valueChanged(Object value) {
        if (value == NULL_VALUE) {
            value = null;
        }
        this.setPopulating(true);
        try {
            this.setValue(value);
        }
        finally {
            this.setPopulating(false);
        }
    }
}

