/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchClosure<A>
implements Closure<A> {
    private final Iterable<Association<Predicate<? super A>, Closure<? super A>>> closures;
    private final Closure<? super A> defaultClosure;

    public SwitchClosure(Iterable<Association<Predicate<? super A>, Closure<? super A>>> closures, Closure<? super A> defaultClosure) {
        if (IterableTools.isOrContainsNull(closures) || defaultClosure == null) {
            throw new NullPointerException();
        }
        this.closures = closures;
        this.defaultClosure = defaultClosure;
    }

    @Override
    public void execute(A argument) {
        for (Association<Predicate<A>, Closure<A>> association : this.closures) {
            if (!association.getKey().evaluate(argument)) continue;
            association.getValue().execute(argument);
            return;
        }
        this.defaultClosure.execute(argument);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.closures);
    }
}

