/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public final class ClipboardOperationAction
extends TextEditorAction {
    private static final ClipboardTransfer fgTransferInstance = new ClipboardTransfer();
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;

    public ClipboardOperationAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
        super(bundle, prefix, editor);
        this.fOperationCode = operationCode;
        if (operationCode == 3) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        } else if (operationCode == 4) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        } else if (operationCode == 5) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid operation code");
        }
        this.update();
    }

    private boolean isReadOnlyOperation() {
        return this.fOperationCode == 4;
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.isReadOnlyOperation() && !this.validateEditorInputState()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ClipboardOperationAction.this.internalDoOperation();
            }
        });
    }

    private Shell getShell() {
        IWorkbenchPartSite site;
        Shell shell;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (shell = (site = editor.getSite()).getShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return null;
    }

    protected final void internalDoOperation() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("importsOnPaste")) {
            if (this.fOperationCode == 5) {
                this.doPasteWithImportsOperation();
            } else {
                this.doCutCopyWithImportsOperation();
            }
        } else {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public void update() {
        super.update();
        if (!this.isReadOnlyOperation() && !this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    private void doCutCopyWithImportsOperation() {
        ITextSelection textSelection;
        ITextEditor editor = this.getTextEditor();
        IJavaScriptElement inputElement = (IJavaScriptElement)editor.getEditorInput().getAdapter(IJavaScriptElement.class);
        ISelection selection = editor.getSelectionProvider().getSelection();
        ClipboardData clipboardData = null;
        if (inputElement != null && selection instanceof ITextSelection && !selection.isEmpty() && this.isNonTrivialSelection(textSelection = (ITextSelection)selection)) {
            clipboardData = this.getClipboardData(inputElement, textSelection.getOffset(), textSelection.getLength());
        }
        this.fOperationTarget.doOperation(this.fOperationCode);
        if (clipboardData != null) {
            Clipboard clipboard = new Clipboard(this.getDisplay());
            try {
                Object textData = clipboard.getContents((Transfer)TextTransfer.getInstance());
                Object rtfData = clipboard.getContents((Transfer)RTFTransfer.getInstance());
                ArrayList<Object> datas = new ArrayList<Object>(3);
                ArrayList<Object> transfers = new ArrayList<Object>(3);
                if (textData != null) {
                    datas.add(textData);
                    transfers.add(TextTransfer.getInstance());
                }
                if (rtfData != null) {
                    datas.add(rtfData);
                    transfers.add(RTFTransfer.getInstance());
                }
                if (datas.isEmpty()) {
                    return;
                }
                datas.add(clipboardData);
                transfers.add((Object)fgTransferInstance);
                Transfer[] dataTypes = transfers.toArray(new Transfer[transfers.size()]);
                Object[] data = datas.toArray();
                this.setClipboardContents(clipboard, data, dataTypes);
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    private void setClipboardContents(Clipboard clipboard, Object[] datas, Transfer[] transfers) {
        block2: {
            try {
                clipboard.setContents(datas, transfers);
            }
            catch (SWTError e) {
                if (e.code == 2002) break block2;
                throw e;
            }
        }
    }

    private boolean isNonTrivialSelection(ITextSelection selection) {
        if (selection.getLength() < 30) {
            String text = selection.getText();
            if (text != null) {
                int i = 0;
                while (i < text.length()) {
                    if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return true;
    }

    private ClipboardData getClipboardData(IJavaScriptElement inputElement, int offset, int length) {
        JavaScriptUnit astRoot = JavaScriptPlugin.getDefault().getASTProvider().getAST(inputElement, ASTProvider.WAIT_ACTIVE_ONLY, null);
        if (astRoot == null) {
            return null;
        }
        List list = astRoot.imports();
        if (!list.isEmpty() ? offset < ((ASTNode)list.get(list.size() - 1)).getStartPosition() : astRoot.getPackage() != null && offset < astRoot.getPackage().getStartPosition()) {
            return null;
        }
        ArrayList typeImportsRefs = new ArrayList();
        ArrayList staticImportsRefs = new ArrayList();
        ImportReferencesCollector.collect((ASTNode)astRoot, inputElement.getJavaScriptProject(), new Region(offset, length), typeImportsRefs, staticImportsRefs);
        if (typeImportsRefs.isEmpty() && staticImportsRefs.isEmpty()) {
            return null;
        }
        HashSet<String> namesToImport = new HashSet<String>(typeImportsRefs.size());
        int i = 0;
        while (i < typeImportsRefs.size()) {
            Name curr = (Name)typeImportsRefs.get(i);
            IBinding binding = curr.resolveBinding();
            if (binding != null && binding.getKind() == 2) {
                String name;
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getElementType();
                }
                if ((typeBinding.isMember() || typeBinding.isTopLevel()) && (name = Bindings.getRawQualifiedName(typeBinding)).length() > 0) {
                    namesToImport.add(name);
                }
            }
            ++i;
        }
        HashSet<String> staticsToImport = new HashSet<String>(staticImportsRefs.size());
        int i2 = 0;
        while (i2 < staticImportsRefs.size()) {
            Name curr = (Name)staticImportsRefs.get(i2);
            IBinding binding = curr.resolveBinding();
            if (binding != null) {
                StringBuffer buf = new StringBuffer(Bindings.getImportName(binding));
                if (binding.getKind() == 4) {
                    buf.append("()");
                }
                staticsToImport.add(buf.toString());
            }
            ++i2;
        }
        if (namesToImport.isEmpty() && staticsToImport.isEmpty()) {
            return null;
        }
        String[] typeImports = namesToImport.toArray(new String[namesToImport.size()]);
        String[] staticImports = staticsToImport.toArray(new String[staticsToImport.size()]);
        return new ClipboardData(inputElement, typeImports, staticImports);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doPasteWithImportsOperation() {
        ITextEditor editor = this.getTextEditor();
        IJavaScriptElement inputElement = (IJavaScriptElement)editor.getEditorInput().getAdapter(IJavaScriptElement.class);
        Clipboard clipboard = new Clipboard(this.getDisplay());
        ClipboardData importsData = (ClipboardData)clipboard.getContents((Transfer)fgTransferInstance);
        if (importsData != null && inputElement instanceof IJavaScriptUnit && !importsData.isFromSame(inputElement)) {
            IRewriteTarget target;
            IRewriteTarget iRewriteTarget = target = editor != null ? (IRewriteTarget)editor.getAdapter(IRewriteTarget.class) : null;
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                try {
                    this.fOperationTarget.doOperation(this.fOperationCode);
                    this.addImports((IJavaScriptUnit)inputElement, importsData);
                    return;
                }
                catch (CoreException e) {
                    JavaScriptPlugin.log(e);
                    if (target == null) return;
                    target.endCompoundChange();
                }
                return;
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        } else {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    private void addImports(IJavaScriptUnit unit, ClipboardData data) throws CoreException {
        ImportRewrite rewrite = StubUtility.createImportRewrite(unit, true);
        String[] imports = data.getTypeImports();
        int i = 0;
        while (i < imports.length) {
            rewrite.addImport(imports[i]);
            ++i;
        }
        String[] staticImports = data.getStaticImports();
        int i2 = 0;
        while (i2 < staticImports.length) {
            boolean isField;
            String name = Signature.getSimpleName((String)staticImports[i2]);
            boolean bl = isField = !name.endsWith("()");
            if (!isField) {
                name = name.substring(0, name.length() - 2);
            }
            String qualifier = Signature.getQualifier((String)staticImports[i2]);
            rewrite.addStaticImport(qualifier, name, isField);
            ++i2;
        }
        JavaModelUtil.applyEdit(unit, rewrite.rewriteImports(null), false, null);
    }

    public static class ClipboardData {
        private String fOriginHandle;
        private String[] fTypeImports;
        private String[] fStaticImports;

        public ClipboardData(IJavaScriptElement origin, String[] typeImports, String[] staticImports) {
            Assert.isNotNull((Object)origin);
            Assert.isNotNull((Object)typeImports);
            Assert.isNotNull((Object)staticImports);
            this.fTypeImports = typeImports;
            this.fStaticImports = staticImports;
            this.fOriginHandle = origin.getHandleIdentifier();
        }

        public ClipboardData(byte[] bytes) throws IOException {
            DataInputStream dataIn = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                this.fOriginHandle = dataIn.readUTF();
                this.fTypeImports = ClipboardData.readArray(dataIn);
                this.fStaticImports = ClipboardData.readArray(dataIn);
            }
            finally {
                dataIn.close();
            }
        }

        private static String[] readArray(DataInputStream dataIn) throws IOException {
            int count = dataIn.readInt();
            String[] array = new String[count];
            int i = 0;
            while (i < count) {
                array[i] = dataIn.readUTF();
                ++i;
            }
            return array;
        }

        private static void writeArray(DataOutputStream dataOut, String[] array) throws IOException {
            dataOut.writeInt(array.length);
            int i = 0;
            while (i < array.length) {
                dataOut.writeUTF(array[i]);
                ++i;
            }
        }

        public String[] getTypeImports() {
            return this.fTypeImports;
        }

        public String[] getStaticImports() {
            return this.fStaticImports;
        }

        public boolean isFromSame(IJavaScriptElement elem) {
            return this.fOriginHandle.equals(elem.getHandleIdentifier());
        }

        public byte[] serialize() throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            try {
                dataOut.writeUTF(this.fOriginHandle);
                ClipboardData.writeArray(dataOut, this.fTypeImports);
                ClipboardData.writeArray(dataOut, this.fStaticImports);
            }
            finally {
                dataOut.close();
                out.close();
            }
            return out.toByteArray();
        }
    }

    private static class ClipboardTransfer
    extends ByteArrayTransfer {
        private static final String TYPE_NAME = "source-with-imports-transfer-format" + System.currentTimeMillis();
        private static final int TYPEID = ClipboardTransfer.registerType((String)TYPE_NAME);

        private ClipboardTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        protected void javaToNative(Object data, TransferData transferData) {
            if (data instanceof ClipboardData) {
                try {
                    super.javaToNative((Object)((ClipboardData)data).serialize(), transferData);
                }
                catch (IOException iOException) {}
            }
        }

        protected Object nativeToJava(TransferData transferData) {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes != null) {
                try {
                    return new ClipboardData(bytes);
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

