/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUIPreferences {
    private static final String PREF_IMPORT_LOCATION = "import-location";
    private static final String PREF_SAVE_EDITORS = "save-editors";
    private static final String PREF_HOST_NAMES = "host-names";
    private static final String PREF_SHOW_ON_ACTIVITY = "show-on-activity";
    private static final String PREF_LAUNCH_MODE = "launch-mode";
    private static final String PREF_LAUNCH_MODE2 = "launch-mode2";
    private static final String PREF_ENABLE_BREAKPOINTS = "enable-breakpoints";
    private static final String PREF_RESTART = "restart";
    private static final String PREF_CREATE_SERVER_WITH_RUNTIME = "create-server";
    private static final String PREF_PUBLISH_ON_ADD_REMOVE = "publish-on-add-remove";
    private static final String PREF_EXT_ADAPTER = "external-adapter";
    public static final byte SAVE_EDITORS_ALWAYS = 2;
    public static final byte SAVE_EDITORS_NEVER = 0;
    public static final byte SAVE_EDITORS_PROMPT = 1;
    public static final byte LAUNCH_MODE_PROMPT = 0;
    public static final byte LAUNCH_MODE_CONTINUE = 1;
    public static final byte LAUNCH_MODE_RESTART = 2;
    public static final byte LAUNCH_MODE2_PROMPT = 0;
    public static final byte LAUNCH_MODE2_CONTINUE = 1;
    public static final byte LAUNCH_MODE2_RESTART = 2;
    public static final byte LAUNCH_MODE2_DISABLE_BREAKPOINTS = 3;
    public static final byte ENABLE_BREAKPOINTS_PROMPT = 0;
    public static final byte ENABLE_BREAKPOINTS_ALWAYS = 1;
    public static final byte ENABLE_BREAKPOINTS_NEVER = 2;
    public static final byte RESTART_PROMPT = 0;
    public static final byte RESTART_ALWAYS = 1;
    public static final byte RESTART_NEVER = 2;
    private static final int MAX_HOSTNAMES = 10;
    private Preferences preferences = ServerUIPlugin.getInstance().getPluginPreferences();
    private static ServerUIPreferences instance;

    private ServerUIPreferences() {
        this.setDefaults();
    }

    public static ServerUIPreferences getInstance() {
        if (instance == null) {
            instance = new ServerUIPreferences();
        }
        return instance;
    }

    private void setDefaults() {
        this.preferences.setDefault(PREF_LAUNCH_MODE, (int)this.getDefaultLaunchMode());
        this.preferences.setDefault(PREF_LAUNCH_MODE2, (int)this.getDefaultLaunchMode2());
        this.preferences.setDefault(PREF_ENABLE_BREAKPOINTS, (int)this.getDefaultEnableBreakpoints());
        this.preferences.setDefault(PREF_RESTART, (int)this.getDefaultRestart());
        this.preferences.setDefault(PREF_SAVE_EDITORS, (int)this.getDefaultSaveEditors());
        this.preferences.setDefault(PREF_HOST_NAMES, "localhost");
        this.preferences.setDefault(PREF_SHOW_ON_ACTIVITY, true);
        this.preferences.setDefault(PREF_CREATE_SERVER_WITH_RUNTIME, false);
        this.preferences.setDefault(PREF_PUBLISH_ON_ADD_REMOVE, true);
        this.preferences.setDefault(PREF_EXT_ADAPTER, true);
    }

    public byte getDefaultLaunchMode() {
        return 0;
    }

    public int getLaunchMode() {
        return this.preferences.getInt(PREF_LAUNCH_MODE);
    }

    public void setLaunchMode(int b) {
        this.preferences.setValue(PREF_LAUNCH_MODE, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public byte getDefaultLaunchMode2() {
        return 0;
    }

    public int getLaunchMode2() {
        return this.preferences.getInt(PREF_LAUNCH_MODE2);
    }

    public void setLaunchMode2(int b) {
        this.preferences.setValue(PREF_LAUNCH_MODE2, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public byte getDefaultEnableBreakpoints() {
        return 0;
    }

    public int getEnableBreakpoints() {
        return this.preferences.getInt(PREF_ENABLE_BREAKPOINTS);
    }

    public void setEnableBreakpoints(int b) {
        this.preferences.setValue(PREF_ENABLE_BREAKPOINTS, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public byte getDefaultRestart() {
        return 0;
    }

    public int getRestart() {
        return this.preferences.getInt(PREF_RESTART);
    }

    public void setRestart(int b) {
        this.preferences.setValue(PREF_RESTART, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public String getImportLocation() {
        return this.preferences.getString(PREF_IMPORT_LOCATION);
    }

    public void setImportLocation(String s) {
        this.preferences.setValue(PREF_IMPORT_LOCATION, s);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public byte getDefaultSaveEditors() {
        return 1;
    }

    public byte getSaveEditors() {
        return (byte)this.preferences.getInt(PREF_SAVE_EDITORS);
    }

    public void setSaveEditors(byte b) {
        this.preferences.setValue(PREF_SAVE_EDITORS, (int)b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public boolean getDefaultShowOnActivity() {
        return true;
    }

    public boolean getShowOnActivity() {
        return this.preferences.getBoolean(PREF_SHOW_ON_ACTIVITY);
    }

    public void setShowOnActivity(boolean b) {
        this.preferences.setValue(PREF_SHOW_ON_ACTIVITY, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public List<String> getHostnames() {
        String s = this.preferences.getString(PREF_HOST_NAMES);
        StringTokenizer st = new StringTokenizer(s, "|*|");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    public void addHostname(String hostname) {
        if ("localhost".equals(hostname)) {
            return;
        }
        List<String> list = this.getHostnames();
        if (list.contains(hostname)) {
            list.remove(hostname);
        }
        list.add(1, hostname);
        if (list.size() > 10) {
            list.remove(list.size() - 1);
        }
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s);
            sb.append("|*|");
        }
        this.preferences.setValue(PREF_HOST_NAMES, sb.toString());
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public boolean getCreateServerWithRuntime() {
        return this.preferences.getBoolean(PREF_CREATE_SERVER_WITH_RUNTIME);
    }

    public void setCreateServerWithRuntime(boolean b) {
        this.preferences.setValue(PREF_CREATE_SERVER_WITH_RUNTIME, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public boolean getPublishOnAddRemoveModule() {
        return this.preferences.getBoolean(PREF_PUBLISH_ON_ADD_REMOVE);
    }

    public void setPublishOnAddRemoveModule(boolean b) {
        this.preferences.setValue(PREF_PUBLISH_ON_ADD_REMOVE, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }

    public boolean getExtAdapter() {
        return this.preferences.getBoolean(PREF_EXT_ADAPTER);
    }

    public void setExtAdapter(boolean b) {
        this.preferences.setValue(PREF_EXT_ADAPTER, b);
        ServerUIPlugin.getInstance().savePluginPreferences();
    }
}

