/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.closure;

import org.eclipse.jpt.common.utility.closure.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalClosure<A>
implements Closure<A> {
    private final ThreadLocal<Closure<? super A>> threadLocal;
    private final Closure<? super A> defaultClosure;

    public ThreadLocalClosure(Closure<? super A> defaultClosure) {
        if (defaultClosure == null) {
            throw new NullPointerException();
        }
        this.defaultClosure = defaultClosure;
        this.threadLocal = this.buildThreadLocal();
    }

    private ThreadLocal<Closure<? super A>> buildThreadLocal() {
        return new ThreadLocal<Closure<? super A>>();
    }

    @Override
    public void execute(A argument) {
        this.get().execute(argument);
    }

    private Closure<? super A> get() {
        Closure<? super A> closure = this.threadLocal.get();
        if (closure != null) {
            return closure;
        }
        return this.defaultClosure;
    }

    public void set(Closure<? super A> closure) {
        this.threadLocal.set(closure);
    }

    public String toString() {
        return this.get().toString();
    }
}

